#!/bin/sh

# Build script template [20060202]

### Configurations (edit below):

PREFIX=/usr
DOCPREFIX=${DOCPREFIX:-/usr/share/doc}

SHORTNAME=firefox
ORIGVER=1.5.0.2
PKGVER=P1
PACKAGE=$SHORTNAME-${ORIGVER/-/_}-i386-$PKGVER.tgz
SRCPKG=$SHORTNAME-${ORIGVER/-/_}-i386-$PKGVER-Plamosrc.tar.gz

SRCURL1=http://ftp.mozilla-japan.org/pub/mozilla.org/firefox/releases/1.5.0.2/source/firefox-1.5.0.2-source.tar.bz2
SRC1=firefox-$ORIGVER-source.tar.bz2
SRCDIR1=firefox-$ORIGVER

#LOCALEVER=1.5.0.2
SRC11=firefox-${LOCALEVER:-$ORIGVER}-locales.tar.bz2
SRC11_LOCALES=ja
SRC11_COOPT=${LOCALEVER:+LOCALES_CO_TAG=FIREFOX_${LOCALEVER/./_}_RELEASE}

PATCH11=patches/mozilla-0.9.9-fontfix.patch
PATCH12=patches/firefox-1.0.4-startscript.patch
PATCH13=patches/firefox-1.5-software-update.patch
PATCH14=patches/firefox-1.5-no-default-search.patch
PATCH15=patches/firefox-1.5-libdir.patch
## Patches imported from FC develop
PATCH101=patches/firefox-0.7.3-default-plugin-less-annoying.patch
PATCH102=patches/firefox-0.7.3-psfonts.patch
PATCH103=patches/firefox-1.1-default-applications.patch
PATCH104=patches/firefox-nopangoxft.patch

PATCH111=patches/firefox-1.5-jplocale-customsearch.patch

SRCURL1111=http://mycroft.mozdev.org/nowrapper/submit-install.php/v/2299/wikipedia-ja.src
SRC1111=wikipedia-ja.src
SRCURL1112=http://mycroft.mozdev.org/nowrapper/submit-install.php/i/2299/wikipedia-ja.png
SRC1112=wikipedia-ja.png

SRCURL1121=http://hirohirotest.hp.infoseek.co.jp/Plugin/googlemaps.src
SRC1121=googlemaps.src
SRCURL1122=http://hirohirotest.hp.infoseek.co.jp/Plugin/googlemaps.gif
SRC1122=googlemaps.gif

SRC12=patches/mozconfig-plamobuild
SRC13=patches/unix.js

SRCURL2=http://fredrik.hubbe.net/plugger/plugger-5.1.3.tar.gz
SRC2=plugger-5.1.3.tar.gz
SRCDIR2=plugger-5.1.3
PATCH21=patches/plugger-5.1.3-plamobuild-fx.patch
PATCH22=patches/plugger-5.1.3-plamodefault.patch

INITSCRIPTS=

if [ ! -f $SRC1 ]; then
    wget -O $SRC1 $SRCURL1
fi
if [ ! -f $SRC1111 ]; then
    wget -O $SRC1111 $SRCURL1111
fi
if [ ! -f $SRC1112 ]; then
    wget -O $SRC1112 $SRCURL1112
fi
if [ ! -f $SRC1121 ]; then
    wget -O $SRC1121 $SRCURL1121
fi
if [ ! -f $SRC1122 ]; then
    wget -O $SRC1122 $SRCURL1122
fi
if [ ! -f $SRC2 ]; then
    wget -O $SRC2 $SRCURL2
fi

### Common preparations:

TMPDIR=`pwd`
SRCROOT=`pwd`
BUILDROOT=$TMPDIR/.work
PKGROOT=$BUILDROOT/pkgroot
mkdir -p $BUILDROOT
chown 0.0 $BUILDROOT
chmod 0755 $BUILDROOT

### Build and install (edit below):

cd $BUILDROOT
tar jxf $SRCROOT/$SRC1

if [ -f $SRCROOT/$SRC11 ]; then
    tar jxf $SRCROOT/$SRC11
else
    (
	cd mozilla
	export MOZ_CO_PROJECT=browser
	export MOZ_CO_LOCALES="$SRC11_LOCALES"
	make -f client.mk checkout $SRC11_COOPT
    )
    test -d l10n || exit 1
    tar jcf $SRCROOT/$SRC11 l10n
fi

cd mozilla
cat $SRCROOT/$PATCH11 | (cd gfx/src/gtk; patch)
cat $SRCROOT/$PATCH12 | (cd browser/app; patch)
cat $SRCROOT/$PATCH13 | patch -p1
cat $SRCROOT/$PATCH14 | patch -p1
cat $SRCROOT/$PATCH15 | patch -p1
cat $SRCROOT/$PATCH101 | patch -p1
cat $SRCROOT/$PATCH102 | patch -p1
cat $SRCROOT/$PATCH103 | patch -p0
cat $SRCROOT/$PATCH104 | patch -p1
(
    cd ../l10n
    cat $SRCROOT/$PATCH111 | patch -p1
    cp $SRCROOT/$SRC1111 $SRCROOT/$SRC1112 $SRCROOT/$SRC1121 $SRCROOT/$SRC1122 ja/browser/searchplugins
)
export PKG_CONFIG_PATH=/usr/X11R6/lib/pkgconfig
export MOZCONFIG=$SRCROOT/$SRC12
make -f client.mk build prefix=$PREFIX || exit 1
make -f client.mk install DESTDIR=$PKGROOT prefix=$PREFIX || exit 1

ln -s firefox-$ORIGVER $PKGROOT$PREFIX/lib/firefox

install -c -o0 -g0 -m0644 $SRCROOT/$SRC13 $PKGROOT$PREFIX/lib/firefox/defaults/pref

mkdir $PKGROOT$PREFIX/include/$SRCDIR1/nss
cp -f dist/public/nss/*.h $PKGROOT$PREFIX/include/$SRCDIR1/nss
#mkdir $PKGROOT$PREFIX/include/$SRCDIR1/seccmd
#cp -f dist/public/seccmd/*.h $PKGROOT$PREFIX/include/$SRCDIR1/seccmd

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/$SRCDIR1-doc
cp LEGAL LICENSE README.txt $PKGROOT$DOCPREFIX/$SRCDIR1/$SRCDIR1-doc

(
    cd $PKGROOT$PREFIX/lib/firefox
    LD_LIBRARY_PATH=. ./regxpcom
)

cd $BUILDROOT
tar zxf $SRCROOT/$SRC2

cd $SRCDIR2
cat $SRCROOT/$PATCH21 | patch -sp1
cat $SRCROOT/$PATCH22 | patch -sp1
./configure --prefix=$PREFIX || exit 1
make || exit 1
make install root=$PKGROOT || exit 1

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/$SRCDIR2-doc
cp COPYING README $PKGROOT$DOCPREFIX/$SRCDIR1/$SRCDIR2-doc

mv $PKGROOT$PREFIX/man/man7/man7 $PKGROOT$PREFIX/man/man7/plugger.7	# xxx

gzip $PKGROOT$DOCPREFIX/$SRCDIR1/$SRCDIR1-doc/*
gzip $PKGROOT$DOCPREFIX/$SRCDIR1/$SRCDIR2-doc/*

strip $PKGROOT$PREFIX/lib/firefox/*

## Common packaging sequence:

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build
cp $SRCROOT/$0 $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build
if [ -d $SRCROOT/patches ]; then
    mkdir $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build/patches
    cp $SRCROOT/patches/* $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build/patches
fi

if [ -d $PKGROOT$PREFIX/bin ]; then
    strip $PKGROOT$PREFIX/bin/*
fi
if [ -d $PKGROOT$PREFIX/sbin ]; then
    strip $PKGROOT$PREFIX/sbin/*
fi
if [ -d $PKGROOT$PREFIX/libexec ]; then
    find $PKGROOT$PREFIX/libexec -type f -exec strip {} ';'
fi
if [ -d $PKGROOT$PREFIX/lib ]; then
    find $PKGROOT$PREFIX/lib -type f -name '*.so*' -exec strip -g {} ';'
    find $PKGROOT$PREFIX/lib -mindepth 2 '(' -name '*.a' -o -name '*.la' ')' -exec rm {} ';'
fi
#for docdir in $PKGROOT$DOCPREFIX/*; do
#    if [ -d $docdir ]; then
#	gzip $docdir/*
#    fi
#done
if [ -d $PKGROOT$PREFIX/man ]; then
    if [ ! -d $PKGROOT$PREFIX/share ]; then
	mkdir $PKGROOT$PREFIX/share
    fi
    ( cd $PKGROOT$PREFIX; tar cf - man ) | ( cd $PKGROOT$PREFIX/share; tar xfp - )
    rm -rf $PKGROOT$PREFIX/man
fi
if [ -d $PKGROOT$PREFIX/share/man ]; then
    symlinks=
    for l in `find $PKGROOT$PREFIX/share/man -type l -print`; do
	symlinks="$symlinks $l:`perl -e "print readlink '$l';"`"
	rm -f $l
    done
    gzip $PKGROOT$PREFIX/share/man/man?/*
    for l in $symlinks; do
	ln -s ${l#*:}.gz ${l%%:*}.gz
    done
fi

if [ -r $PKGROOT$PREFIX/info/dir ]; then
    rm -f $PKGROOT$PREFIX/info/dir
    echo "if [ -x /usr/bin/install-info ]; then" >> $BUILDROOT/initpkg
    echo "  ( cd $PREFIX/info" >> $BUILDROOT/initpkg
    for infofile in $PKGROOT$PREFIX/info/*.info; do
	echo "    /usr/bin/install-info ${infofile##*/} dir" >> $BUILDROOT/initpkg
    done
    echo "  )" >> $BUILDROOT/initpkg
    echo "fi" >> $BUILDROOT/initpkg
fi
for i in $INITSCRIPTS; do
    cat $SRCROOT/$i >> $BUILDROOT/initpkg
done
if [ -s $BUILDROOT/initpkg ]; then
    mkdir $PKGROOT/install
    mv -f $BUILDROOT/initpkg $PKGROOT/install
fi

cd $PKGROOT
echo y | makepkg $PACKAGE
cp -f $PACKAGE $SRCROOT

cd $PKGROOT$DOCPREFIX/$SRCDIR1
tar zcf $SRCPKG $SHORTNAME-build
cp -f $SRCPKG $SRCROOT

cd $SRCROOT
rm -rf $BUILDROOT
