/* cpufreq tools
 *  Copyright (C) 2005 Yuuki Harano
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: log.h 310 2005-06-30 14:18:05Z masm $
 */

#ifndef CPUFREQ__LOG_H__INCLUDED
#define CPUFREQ__LOG_H__INCLUDED

#include <cpufreq/common.h>

enum xlog_dest_t {
    XLOG_DEST_NULL,
    XLOG_DEST_SYSLOG,
    XLOG_DEST_STDERR,
    XLOG_DEST_FILE,
};

void xlog_init(const char *prog);
void xlog_set_debug_level(int level);
void xlog_set_dest(enum xlog_dest_t d);

void xlog_fatal(const char *fmt, ...);
void xlog_error(const char *fmt, ...);
void xlog_warn(const char *fmt, ...);
void xlog_info(const char *fmt, ...);
void xlog_debug(int level, const char *fmt, ...);

#endif	/* ifndef CPUFREQ__LOG_H__INCLUDED */
