/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.dgc;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;

public final class VMID
implements Serializable {
    static final long serialVersionUID = -538642295484486218L;
    static final boolean areWeUnique;
    static byte[] localAddr;
    private byte[] addr = localAddr;
    private UID uid = new UID();

    public static boolean isUnique() {
        return areWeUnique;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VMID)) {
            return false;
        }
        VMID other = (VMID)obj;
        if (this.addr.length != other.addr.length) {
            return false;
        }
        for (int i = this.addr.length - 1; i >= 0; --i) {
            if (this.addr[i] == other.addr[i]) continue;
            return false;
        }
        return this.uid.equals(other.uid);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[VMID: ");
        for (int i = 0; i < this.addr.length; ++i) {
            if (i > 0) {
                buf.append(".");
            }
            buf.append(Integer.toString(this.addr[i]));
        }
        buf.append(" ");
        buf.append(this.uid.toString());
        buf.append("]");
        return buf.toString();
    }

    static {
        byte[] addr;
        boolean awu = true;
        try {
            addr = InetAddress.getLocalHost().getAddress();
            if (addr[0] == 127 && addr[1] == 0 && addr[2] == 0 && addr[3] == 1) {
                awu = false;
            }
        }
        catch (UnknownHostException _) {
            addr = new byte[]{127, 0, 0, 1};
            awu = false;
        }
        localAddr = addr;
        areWeUnique = awu;
    }
}

