/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class InetSocketAddress
extends SocketAddress {
    private static final long serialVersionUID = 5076001401234631237L;
    String hostname;
    InetAddress addr;
    int port;

    public InetSocketAddress(InetAddress addr, int port) throws IllegalArgumentException {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException();
        }
        this.addr = addr;
        this.port = port;
        this.hostname = addr.getHostName();
    }

    public InetSocketAddress(int port) throws IllegalArgumentException {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException();
        }
        this.port = port;
        try {
            byte[] any = new byte[]{0, 0, 0, 0};
            this.addr = InetAddress.getByAddress(any);
            this.hostname = "0.0.0.0";
        }
        catch (UnknownHostException e) {
            this.addr = null;
            this.hostname = "";
        }
    }

    public InetSocketAddress(String hostname, int port) throws IllegalArgumentException {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException();
        }
        this.port = port;
        this.hostname = hostname;
        try {
            this.addr = InetAddress.getByName(hostname);
        }
        catch (Exception e) {
            this.addr = null;
        }
    }

    public final boolean equals(Object obj) {
        if (obj instanceof InetSocketAddress) {
            InetSocketAddress a = (InetSocketAddress)obj;
            return this.addr.equals(a.addr) && a.port == this.port;
        }
        return false;
    }

    public final InetAddress getAddress() {
        return this.addr;
    }

    public final String getHostName() {
        return this.hostname;
    }

    public final int getPort() {
        return this.port;
    }

    public final int hashCode() {
        return this.port + this.addr.hashCode();
    }

    public final boolean isUnresolved() {
        return this.addr == null;
    }

    public String toString() {
        return this.addr + ":" + this.port;
    }
}

