/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public class StackTraceElement
implements Serializable {
    private static final long serialVersionUID = 6992337162326171013L;
    private final String fileName;
    private final int lineNumber;
    private final String className;
    private final String methodName;
    private final transient boolean isNative;

    StackTraceElement(String fileName, int lineNumber, String className, String methodName, boolean isNative) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.className = className;
        this.methodName = methodName;
        this.isNative = isNative;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.isNative;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.className != null) {
            sb.append(this.className);
            if (this.methodName != null) {
                sb.append('.');
            }
        }
        if (this.methodName != null) {
            sb.append(this.methodName);
        }
        sb.append(" (");
        if (this.fileName != null) {
            sb.append(this.fileName);
        } else {
            sb.append(this.isNative ? "Native Method" : "Unknown Source");
        }
        if (this.lineNumber >= 0) {
            sb.append(':').append(this.lineNumber);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement e = (StackTraceElement)o;
        return StackTraceElement.equals(this.fileName, e.fileName) && this.lineNumber == e.lineNumber && StackTraceElement.equals(this.className, e.className) && StackTraceElement.equals(this.methodName, e.methodName);
    }

    public int hashCode() {
        return StackTraceElement.hashCode(this.fileName) ^ this.lineNumber ^ StackTraceElement.hashCode(this.className) ^ StackTraceElement.hashCode(this.methodName);
    }

    private static final boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private static final int hashCode(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }
}

