/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Float
extends Number
implements Comparable {
    private static final long serialVersionUID = -2671257302660747028L;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('F');
    private final float value;

    public Float(float value) {
        this.value = value;
    }

    public Float(double value) {
        this.value = (float)value;
    }

    public Float(String s) {
        this.value = Float.parseFloat(s);
    }

    public static String toString(float f) {
        return Double.toString(f, true);
    }

    public static Float valueOf(String s) {
        return new Float(Float.parseFloat(s));
    }

    public static float parseFloat(String s) {
        return (float)Double.parseDouble(s);
    }

    public static boolean isNaN(float v) {
        return v != v;
    }

    public static boolean isInfinite(float v) {
        return v == Float.POSITIVE_INFINITY || v == Float.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Float)) {
            return false;
        }
        float f = ((Float)obj).value;
        if (this.value == f) {
            return this.value != 0.0f || 1.0f / this.value == 1.0f / f;
        }
        return Float.isNaN(this.value) && Float.isNaN(f);
    }

    public static native int floatToIntBits(float var0);

    public static native int floatToRawIntBits(float var0);

    public static native float intBitsToFloat(int var0);

    public int compareTo(Float f) {
        return Float.compare(this.value, f.value);
    }

    public int compareTo(Object o) {
        return Float.compare(this.value, ((Float)o).value);
    }

    public static int compare(float x, float y) {
        if (Float.isNaN(x)) {
            if (Float.isNaN(y)) {
                return 0;
            }
            return 1;
        }
        if (Float.isNaN(y)) {
            return -1;
        }
        if (x == 0.0f && y == 0.0f) {
            return (int)(1.0f / x - 1.0f / y);
        }
        if (x == y) {
            return 0;
        }
        if (x > y) {
            return 1;
        }
        return -1;
    }
}

