/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Byte
extends Number
implements Comparable {
    private static final long serialVersionUID = -7183698231559129828L;
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('B');
    private final byte value;

    public Byte(byte value) {
        this.value = value;
    }

    public Byte(String s) {
        this.value = Byte.parseByte(s, 10);
    }

    public static String toString(byte b) {
        return String.valueOf(b);
    }

    public static byte parseByte(String s) {
        return Byte.parseByte(s, 10);
    }

    public static byte parseByte(String s, int radix) {
        int i = Integer.parseInt(s, radix, false);
        if ((byte)i != i) {
            throw new NumberFormatException();
        }
        return (byte)i;
    }

    public static Byte valueOf(String s, int radix) {
        return new Byte(Byte.parseByte(s, radix));
    }

    public static Byte valueOf(String s) {
        return new Byte(Byte.parseByte(s, 10));
    }

    public static Byte decode(String s) {
        int i = Integer.parseInt(s, 10, true);
        if ((byte)i != i) {
            throw new NumberFormatException();
        }
        return new Byte((byte)i);
    }

    public byte byteValue() {
        return this.value;
    }

    public short shortValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Byte && this.value == ((Byte)obj).value;
    }

    public int compareTo(Byte b) {
        return this.value - b.value;
    }

    public int compareTo(Object o) {
        return this.compareTo((Byte)o);
    }
}

