/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.NullOutputStream;
import gnu.java.lang.reflect.TypeSignature;
import gnu.java.security.provider.Gnu;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterfaceComparator;
import java.io.InvalidClassException;
import java.io.MemberComparator;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.VMObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;

public class ObjectStreamClass
implements Serializable {
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static Hashtable classLookupTable = new Hashtable();
    private static final NullOutputStream nullOutputStream = new NullOutputStream();
    private static final Comparator interfaceComparator = new InterfaceComparator();
    private static final Comparator memberComparator = new MemberComparator();
    private static final Class[] writeMethodArgTypes = new Class[]{ObjectStreamClass.class$("java.io.ObjectOutputStream")};
    private ObjectStreamClass superClass;
    private Class clazz;
    private String name;
    private long uid;
    private byte flags;
    ObjectStreamField[] fields;
    int primFieldSize;
    int objectFieldCount;
    boolean isProxyClass;
    private static final long serialVersionUID = -6120832682080437368L;

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    private /* synthetic */ void finit$() {
        this.primFieldSize = -1;
        this.isProxyClass = false;
    }

    public static ObjectStreamClass lookup(Class cl) {
        if (cl == null) {
            return null;
        }
        if (!ObjectStreamClass.class$("java.io.Serializable").isAssignableFrom(cl)) {
            return null;
        }
        return ObjectStreamClass.lookupForClassObject(cl);
    }

    static ObjectStreamClass lookupForClassObject(Class cl) {
        if (cl == null) {
            return null;
        }
        ObjectStreamClass osc = (ObjectStreamClass)classLookupTable.get(cl);
        if (osc != null) {
            return osc;
        }
        osc = new ObjectStreamClass(cl);
        classLookupTable.put(cl, osc);
        return osc;
    }

    public String getName() {
        return this.name;
    }

    public Class forClass() {
        return this.clazz;
    }

    public long getSerialVersionUID() {
        return this.uid;
    }

    public ObjectStreamField[] getFields() {
        ObjectStreamField[] copy = new ObjectStreamField[this.fields.length];
        System.arraycopy(this.fields, 0, copy, 0, this.fields.length);
        return copy;
    }

    public ObjectStreamField getField(String name) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].getName().equals(name)) continue;
            return this.fields[i];
        }
        return null;
    }

    public String toString() {
        return "java.io.ObjectStreamClass< " + this.name + ", " + this.uid + " >";
    }

    boolean hasWriteMethod() {
        return (this.flags & 1) != 0;
    }

    boolean hasReadMethod() {
        try {
            Class[] readObjectParams = new Class[]{ObjectStreamClass.class$("java.io.ObjectInputStream")};
            this.forClass().getDeclaredMethod("readObject", readObjectParams);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    boolean isSerializable() {
        return (this.flags & 2) != 0;
    }

    boolean isExternalizable() {
        return (this.flags & 4) != 0;
    }

    ObjectStreamClass getSuper() {
        return this.superClass;
    }

    static ObjectStreamClass[] getObjectStreamClasses(Class clazz) {
        ObjectStreamClass osc = ObjectStreamClass.lookup(clazz);
        if (osc == null) {
            return new ObjectStreamClass[0];
        }
        Vector oscs = new Vector();
        while (osc != null) {
            oscs.addElement(osc);
            osc = osc.getSuper();
        }
        int count = oscs.size();
        ObjectStreamClass[] sorted_oscs = new ObjectStreamClass[count];
        for (int i = count - 1; i >= 0; --i) {
            sorted_oscs[count - i - 1] = (ObjectStreamClass)oscs.elementAt(i);
        }
        return sorted_oscs;
    }

    int getFlags() {
        return this.flags;
    }

    ObjectStreamClass(String name, long uid, byte flags, ObjectStreamField[] fields) {
        this.finit$();
        this.name = name;
        this.uid = uid;
        this.flags = flags;
        this.fields = fields;
    }

    void setClass(Class cl) throws InvalidClassException {
        this.clazz = cl;
        long class_uid = this.getClassUID(cl);
        if (this.uid == 0L) {
            this.uid = class_uid;
        } else if (this.uid != class_uid) {
            String msg = cl + ": Local class not compatible: stream serialVersionUID=" + this.uid + ", local serialVersionUID=" + class_uid;
            throw new InvalidClassException(msg);
        }
        this.isProxyClass = this.clazz != null && Proxy.isProxyClass(this.clazz);
        ObjectStreamClass osc = (ObjectStreamClass)classLookupTable.get(this.clazz);
        if (osc == null) {
            classLookupTable.put(this.clazz, this);
        }
        this.superClass = ObjectStreamClass.lookupForClassObject(this.clazz.getSuperclass());
        this.calculateOffsets();
    }

    void setSuperclass(ObjectStreamClass osc) {
        this.superClass = osc;
    }

    void calculateOffsets() {
        ObjectStreamField field;
        int i;
        this.primFieldSize = 0;
        int fcount = this.fields.length;
        block6: for (i = 0; i < fcount && (field = this.fields[i]).isPrimitive(); ++i) {
            field.setOffset(this.primFieldSize);
            switch (field.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primFieldSize;
                    continue block6;
                }
                case 'C': 
                case 'S': {
                    this.primFieldSize += 2;
                    continue block6;
                }
                case 'F': 
                case 'I': {
                    this.primFieldSize += 4;
                    continue block6;
                }
                case 'D': 
                case 'J': {
                    this.primFieldSize += 8;
                }
            }
        }
        this.objectFieldCount = 0;
        while (i < fcount) {
            this.fields[i].setOffset(this.objectFieldCount++);
            ++i;
        }
    }

    private ObjectStreamClass(Class cl) {
        this.finit$();
        this.uid = 0L;
        this.flags = 0;
        this.isProxyClass = Proxy.isProxyClass(cl);
        this.clazz = cl;
        this.name = cl.getName();
        this.setFlags(cl);
        this.setFields(cl);
        if (ObjectStreamClass.class$("java.io.Serializable").isAssignableFrom(cl) && !this.isProxyClass) {
            this.uid = this.getClassUID(cl);
        }
        this.superClass = ObjectStreamClass.lookup(cl.getSuperclass());
    }

    private void setFlags(Class cl) {
        if (ObjectStreamClass.class$("java.io.Externalizable").isAssignableFrom(cl)) {
            this.flags = (byte)(this.flags | 4);
        } else if (ObjectStreamClass.class$("java.io.Serializable").isAssignableFrom(cl)) {
            this.flags = (byte)(this.flags | 2);
        }
        try {
            Method writeMethod = cl.getDeclaredMethod("writeObject", writeMethodArgTypes);
            int modifiers = writeMethod.getModifiers();
            if (writeMethod.getReturnType() == Void.TYPE && Modifier.isPrivate(modifiers) && !Modifier.isStatic(modifiers)) {
                this.flags = (byte)(this.flags | 1);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void setFields(Class cl) {
        if (!this.isSerializable() || this.isExternalizable()) {
            this.fields = NO_FIELDS;
            return;
        }
        try {
            Field serialPersistentFields = cl.getDeclaredField("serialPersistentFields");
            serialPersistentFields.setAccessible(true);
            int modifiers = serialPersistentFields.getModifiers();
            if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && Modifier.isPrivate(modifiers)) {
                this.fields = this.getSerialPersistentFields(cl);
                Arrays.sort(this.fields);
                this.calculateOffsets();
                return;
            }
        }
        catch (NoSuchFieldException num_good_fields) {
            // empty catch block
        }
        int num_good_fields = 0;
        Field[] all_fields = cl.getDeclaredFields();
        for (int i = 0; i < all_fields.length; ++i) {
            int modifiers = all_fields[i].getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) {
                all_fields[i] = null;
                continue;
            }
            ++num_good_fields;
        }
        this.fields = new ObjectStreamField[num_good_fields];
        int to = 0;
        for (int from = 0; from < all_fields.length; ++from) {
            if (all_fields[from] == null) continue;
            Field f = all_fields[from];
            this.fields[to] = new ObjectStreamField(f.getName(), f.getType());
            ++to;
        }
        Arrays.sort(this.fields);
        this.calculateOffsets();
    }

    private long getClassUID(Class cl) {
        try {
            Field suid = cl.getDeclaredField("serialVersionUID");
            suid.setAccessible(true);
            int modifiers = suid.getModifiers();
            if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && suid.getType() == Long.TYPE) {
                return suid.getLong(null);
            }
        }
        catch (NoSuchFieldException ignore) {
        }
        catch (IllegalAccessException md) {
            // empty catch block
        }
        try {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException e) {
                Gnu gnuProvider = new Gnu();
                Security.addProvider(gnuProvider);
                md = MessageDigest.getInstance("SHA");
            }
            DigestOutputStream digest_out = new DigestOutputStream(nullOutputStream, md);
            DataOutputStream data_out = new DataOutputStream(digest_out);
            data_out.writeUTF(cl.getName());
            int modifiers = cl.getModifiers();
            data_out.writeInt(modifiers &= 0x611);
            if (!cl.isArray()) {
                Object[] interfaces = cl.getInterfaces();
                Arrays.sort(interfaces, interfaceComparator);
                for (int i = 0; i < interfaces.length; ++i) {
                    data_out.writeUTF(((Class)interfaces[i]).getName());
                }
            }
            Object[] fields = cl.getDeclaredFields();
            Arrays.sort(fields, memberComparator);
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                modifiers = ((Field)field).getModifiers();
                if (Modifier.isPrivate(modifiers) && (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers))) continue;
                data_out.writeUTF(((Field)field).getName());
                data_out.writeInt(modifiers);
                data_out.writeUTF(TypeSignature.getEncodingOfClass(((Field)field).getType()));
            }
            if (VMObjectStreamClass.hasClassInitializer(cl)) {
                data_out.writeUTF("<clinit>");
                data_out.writeInt(8);
                data_out.writeUTF("()V");
            }
            Object[] constructors = cl.getDeclaredConstructors();
            Arrays.sort(constructors, memberComparator);
            for (int i = 0; i < constructors.length; ++i) {
                Object constructor = constructors[i];
                modifiers = ((Constructor)constructor).getModifiers();
                if (Modifier.isPrivate(modifiers)) continue;
                data_out.writeUTF("<init>");
                data_out.writeInt(modifiers);
                data_out.writeUTF(TypeSignature.getEncodingOfConstructor((Constructor)constructor).replace('/', '.'));
            }
            Object[] methods = cl.getDeclaredMethods();
            Arrays.sort(methods, memberComparator);
            for (int i = 0; i < methods.length; ++i) {
                Object method = methods[i];
                modifiers = ((Method)method).getModifiers();
                if (Modifier.isPrivate(modifiers)) continue;
                data_out.writeUTF(((Method)method).getName());
                data_out.writeInt(modifiers);
                data_out.writeUTF(TypeSignature.getEncodingOfMethod((Method)method).replace('/', '.'));
            }
            data_out.close();
            byte[] sha = md.digest();
            long result = 0L;
            int len = sha.length < 8 ? sha.length : 8;
            for (int i = 0; i < len; ++i) {
                result += ((long)sha[i] & (long)255) << (8 * i & 0x3F);
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("The SHA algorithm was not found to use in computing the Serial Version UID for class " + cl.getName(), e);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private ObjectStreamField[] getSerialPersistentFields(Class clazz) {
        ObjectStreamField[] o = null;
        try {
            Field f = clazz.getDeclaredField("getSerialPersistentFields");
            f.setAccessible(true);
            o = (ObjectStreamField[])f.get(null);
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return o;
    }
}

