/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class BufferedWriter
extends Writer {
    private Writer out;
    char[] buffer;
    int count;
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    public BufferedWriter(Writer out) {
        this(out, 8192);
    }

    public BufferedWriter(Writer ox, int size) {
        super(ox);
        this.out = ox;
        this.buffer = new char[size];
        this.count = 0;
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.localFlush();
                this.out.close();
                this.buffer = null;
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buffer == null) {
                    throw new IOException("Stream closed");
                }
                this.localFlush();
                this.out.flush();
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void newLine() throws IOException {
        this.write(System.getProperty("line.separator"));
    }

    public void write(int oneChar) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                try {
                    if (this.buffer == null) {
                        throw new IOException("Stream closed");
                    }
                    this.buffer[this.count++] = (char)oneChar;
                    if (this.count != this.buffer.length) break block4;
                    this.localFlush();
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
            Object var3_3 = null;
        }
    }

    public void write(char[] buf, int offset, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                try {
                    if (this.buffer == null) {
                        throw new IOException("Stream closed");
                    }
                    if (this.count + len > this.buffer.length) {
                        this.localFlush();
                        this.out.write(buf, offset, len);
                        break block5;
                    }
                    System.arraycopy(buf, offset, this.buffer, this.count, len);
                    this.count += len;
                    if (this.count != this.buffer.length) break block5;
                    this.localFlush();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
            Object var5_5 = null;
        }
    }

    public void write(String str, int offset, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                try {
                    if (this.buffer == null) {
                        throw new IOException("Stream closed");
                    }
                    if (this.count + len > this.buffer.length) {
                        this.localFlush();
                        this.out.write(str, offset, len);
                        break block5;
                    }
                    str.getChars(offset, offset + len, this.buffer, this.count);
                    this.count += len;
                    if (this.count != this.buffer.length) break block5;
                    this.localFlush();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
            Object var5_5 = null;
        }
    }

    private final void localFlush() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buffer, 0, this.count);
            this.count = 0;
        }
    }
}

