/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class RectangularShape
implements Shape,
Cloneable {
    protected RectangularShape() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract double getWidth();

    public abstract double getHeight();

    public double getMinX() {
        return this.getX();
    }

    public double getMinY() {
        return this.getY();
    }

    public double getMaxX() {
        return this.getX() + this.getWidth();
    }

    public double getMaxY() {
        return this.getY() + this.getHeight();
    }

    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    public Rectangle2D getFrame() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public abstract boolean isEmpty();

    public abstract void setFrame(double var1, double var3, double var5, double var7);

    public void setFrame(Point2D p, Dimension2D d) {
        this.setFrame(p.getX(), p.getY(), d.getWidth(), d.getHeight());
    }

    public void setFrame(Rectangle2D r) {
        this.setFrame(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public void setFrameFromDiagonal(double x1, double y1, double x2, double y2) {
        double t;
        if (x1 > x2) {
            t = x2;
            x2 = x1;
            x1 = t;
        }
        if (y1 > y2) {
            t = y2;
            y2 = y1;
            y1 = t;
        }
        this.setFrame(x1, y1, x2 - x1, y2 - y1);
    }

    public void setFrameFromDiagonal(Point2D p1, Point2D p2) {
        this.setFrameFromDiagonal(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void setFrameFromCenter(double centerX, double centerY, double cornerX, double cornerY) {
        double halfw = Math.abs(cornerX - centerX);
        double halfh = Math.abs(cornerY - centerY);
        this.setFrame(centerX - halfw, centerY - halfh, halfw + halfw, halfh + halfh);
    }

    public void setFrameFromCenter(Point2D center, Point2D corner) {
        this.setFrameFromCenter(center.getX(), center.getY(), corner.getX(), corner.getY());
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public Rectangle getBounds() {
        if (this.isEmpty()) {
            return new Rectangle();
        }
        double x = this.getX();
        double y = this.getY();
        double maxx = Math.ceil(x + this.getWidth());
        double maxy = Math.ceil(y + this.getHeight());
        x = Math.floor(x);
        y = Math.floor(y);
        return new Rectangle((int)x, (int)y, (int)(maxx - x), (int)(maxy - y));
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw (Error)new InternalError().initCause(e);
        }
    }
}

