#!/bin/sh

### Configurations (edit below):

PREFIX=/usr
DOCPREFIX=${DOCPREFIX:-/usr/share/doc}

ORIGVER=0.50
PKGVER=P1
PACKAGE=dbus-$ORIGVER-i386-$PKGVER.tgz

SRCURL1=http://dbus.freedesktop.org/releases/dbus-0.50.tar.gz
SRC1=dbus-$ORIGVER.tar.gz
SRCDIR1=dbus-$ORIGVER

SRC2=patches/rc.dbus

INITSCRIPTS=

if [ ! -f $SRC1 ]; then
    wget -O $SRC1 $SRCURL1
fi

### Common preparations:

TMPDIR=`pwd`
SRCROOT=`pwd`
BUILDROOT=$TMPDIR/.work
PKGROOT=$BUILDROOT/pkgroot
mkdir -p $BUILDROOT
chown 0.0 $BUILDROOT
chmod 0755 $BUILDROOT

### Build and install (edit below):

cd $BUILDROOT
tar zxf $SRCROOT/$SRC1

cd $SRCDIR1
PKG_CONFIG_PATH=/usr/X11R6/lib/pkgconfig CFLAGS='-I/usr/X11R6/include' LDFLAGS='-L/usr/X11R6/lib' ./configure --prefix=$PREFIX --localstatedir=/var --enable-gtk --enable-glib --disable-qt --enable-python --with-system-pid-file=/var/run/dbus.pid --with-dbus-user=nobody || exit 1
make || exit 1
make install DESTDIR=$PKGROOT || exit 1

mkdir -p $PKGROOT/etc/rc.d/init.d
install -c -o0 -g0 -m0755 $SRCROOT/$SRC2 $PKGROOT/etc/rc.d/init.d/dbus

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/html
cp AUTHORS COPYING ChangeLog HACKING INSTALL NEWS README $PKGROOT$DOCPREFIX/$SRCDIR1
cp doc/*.html $PKGROOT$DOCPREFIX/$SRCDIR1/html

## Common packaging sequence:

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/build
cp $SRCROOT/$0 $PKGROOT$DOCPREFIX/$SRCDIR1/build
if [ -d $SRCROOT/patches ]; then
    mkdir $PKGROOT$DOCPREFIX/$SRCDIR1/build/patches
    cp $SRCROOT/patches/* $PKGROOT$DOCPREFIX/$SRCDIR1/build/patches
fi

if [ -d $PKGROOT$PREFIX/bin ]; then
    strip $PKGROOT$PREFIX/bin/*
fi
if [ -d $PKGROOT$PREFIX/sbin ]; then
    strip $PKGROOT$PREFIX/sbin/*
fi
if [ -d $PKGROOT$PREFIX/libexec ]; then
    find $PKGROOT$PREFIX/libexec -type f -exec strip {} ';'
fi
if [ -d $PKGROOT$PREFIX/lib ]; then
    find $PKGROOT$PREFIX/lib -type f -name '*.so*' -exec strip -g {} ';'
    find $PKGROOT$PREFIX/lib -mindepth 2 '(' -name '*.a' -o -name '*.la' ')' -exec rm {} ';'
fi
for docdir in $PKGROOT$DOCPREFIX/*; do
    if [ -d $docdir ]; then
	gzip $docdir/*
    fi
done
if [ -d $PKGROOT$PREFIX/man ]; then
    if [ ! -d $PKGROOT$PREFIX/share ]; then
	mkdir $PKGROOT$PREFIX/share
    fi
    ( cd $PKGROOT$PREFIX; tar cf - man ) | ( cd $PKGROOT$PREFIX/share; tar xfp - )
    rm -rf $PKGROOT$PREFIX/man
fi
if [ -d $PKGROOT$PREFIX/share/man ]; then
    symlinks=
    for l in `find $PKGROOT$PREFIX/share/man -type l -print`; do
	symlinks="$symlinks $l:`perl -e "print readlink '$l';"`"
	rm -f $l
    done
    gzip $PKGROOT$PREFIX/share/man/man?/*
    for l in $symlinks; do
	ln -s ${l#*:}.gz ${l%%:*}.gz
    done
fi

if [ -r $PKGROOT$PREFIX/info/dir ]; then
    rm -f $PKGROOT$PREFIX/info/dir
    echo "if [ -x /usr/bin/install-info ]; then" >> $BUILDROOT/initpkg
    echo "  ( cd $PREFIX/info" >> $BUILDROOT/initpkg
    for infofile in $PKGROOT$PREFIX/info/*.info; do
	echo "    /usr/bin/install-info ${infofile##*/} dir" >> $BUILDROOT/initpkg
    done
    echo "  )" >> $BUILDROOT/initpkg
    echo "fi" >> $BUILDROOT/initpkg
fi
for i in $INITSCRIPTS; do
    cat $SRCROOT/$i >> $BUILDROOT/initpkg
done
if [ -s $BUILDROOT/initpkg ]; then
    mkdir $PKGROOT/install
    mv -f $BUILDROOT/initpkg $PKGROOT/install
fi

cd $PKGROOT
echo y | makepkg $PACKAGE

cp -f $PACKAGE $SRCROOT
cd $SRCROOT
rm -rf $BUILDROOT
