/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class CompoundEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = -6512679249930119683L;
    protected Vector edits = new Vector();
    private boolean inProgress = true;

    public void undo() throws CannotUndoException {
        super.undo();
        for (int i = this.edits.size() - 1; i >= 0; --i) {
            ((UndoableEdit)this.edits.elementAt(i)).undo();
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        for (int i = 0; i < this.edits.size(); ++i) {
            ((UndoableEdit)this.edits.elementAt(i)).redo();
        }
    }

    protected UndoableEdit lastEdit() {
        if (this.edits.size() == 0) {
            return null;
        }
        return (UndoableEdit)this.edits.elementAt(this.edits.size() - 1);
    }

    public void die() {
        for (int i = this.edits.size() - 1; i >= 0; --i) {
            ((UndoableEdit)this.edits.elementAt(i)).die();
        }
        super.die();
    }

    public boolean addEdit(UndoableEdit edit) {
        if (!this.inProgress) {
            return false;
        }
        UndoableEdit last = this.lastEdit();
        if (last == null) {
            this.edits.add(edit);
            return true;
        }
        if (last.addEdit(edit)) {
            return true;
        }
        if (edit.replaceEdit(last)) {
            this.edits.set(this.edits.size() - 1, edit);
            return true;
        }
        this.edits.add(edit);
        return true;
    }

    public void end() {
        this.inProgress = false;
    }

    public boolean canUndo() {
        return this.inProgress ^ true && super.canUndo();
    }

    public boolean canRedo() {
        return this.inProgress ^ true && super.canRedo();
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public boolean isSignificant() {
        for (int i = this.edits.size() - 1; i >= 0; --i) {
            if (!((UndoableEdit)this.edits.elementAt(i)).isSignificant()) continue;
            return true;
        }
        return false;
    }

    public String getPresentationName() {
        UndoableEdit last = this.lastEdit();
        if (last == null) {
            return super.getPresentationName();
        }
        return last.getPresentationName();
    }

    public String getUndoPresentationName() {
        UndoableEdit last = this.lastEdit();
        if (last == null) {
            return super.getUndoPresentationName();
        }
        return last.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        UndoableEdit last = this.lastEdit();
        if (last == null) {
            return super.getRedoPresentationName();
        }
        return last.getRedoPresentationName();
    }

    public String toString() {
        return super.toString() + " inProgress: " + this.inProgress + " edits: " + this.edits;
    }
}

