/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class TreeMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    private static final long serialVersionUID = 919286545866124006L;
    static final int RED = -1;
    static final int BLACK = 1;
    static final Node nil;
    private transient Node root;
    transient int size;
    private transient Set entries;
    transient int modCount;
    final Comparator comparator;

    private /* synthetic */ void finit$() {
        this.root = nil;
    }

    public TreeMap() {
        this((Comparator)null);
    }

    public TreeMap(Comparator c) {
        this.finit$();
        this.comparator = c;
    }

    public TreeMap(Map map) {
        this((Comparator)null);
        this.putAll(map);
    }

    public TreeMap(SortedMap sm) {
        this(sm.comparator());
        int pos = sm.size();
        Iterator itr = sm.entrySet().iterator();
        this.fabricateTree(pos);
        Node node = this.firstNode();
        while (--pos >= 0) {
            Map.Entry me = (Map.Entry)itr.next();
            node.key = me.getKey();
            node.value = me.getValue();
            node = this.successor(node);
        }
    }

    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            this.root = nil;
            this.size = 0;
        }
    }

    public Object clone() {
        TreeMap copy = null;
        try {
            copy = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException x) {
            // empty catch block
        }
        copy.entries = null;
        copy.fabricateTree(this.size);
        Node node = this.firstNode();
        Node cnode = copy.firstNode();
        while (node != nil) {
            cnode.key = node.key;
            cnode.value = node.value;
            node = this.successor(node);
            cnode = copy.successor(cnode);
        }
        return copy;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public boolean containsKey(Object key) {
        return this.getNode(key) != nil;
    }

    public boolean containsValue(Object value) {
        Node node = this.firstNode();
        while (node != nil) {
            if (AbstractMap.equals(value, node.value)) {
                return true;
            }
            node = this.successor(node);
        }
        return false;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(this){
                private /* synthetic */ TreeMap this$0;
                {
                    this.this$0 = this$0;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new TreeIterator(this.this$0, 2);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry me = (Map.Entry)o;
                    Node n = this.this$0.getNode(me.getKey());
                    return n != nil && AbstractCollection.equals(me.getValue(), n.value);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry me = (Map.Entry)o;
                    Node n = this.this$0.getNode(me.getKey());
                    if (n != nil && AbstractCollection.equals(me.getValue(), n.value)) {
                        this.this$0.removeNode(n);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    public Object firstKey() {
        if (this.root == nil) {
            throw new NoSuchElementException();
        }
        return this.firstNode().key;
    }

    public Object get(Object key) {
        return this.getNode((Object)key).value;
    }

    public SortedMap headMap(Object toKey) {
        return new SubMap(this, nil, toKey);
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(this){
                private /* synthetic */ TreeMap this$0;
                {
                    this.this$0 = this$0;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new TreeIterator(this.this$0, 0);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object o) {
                    return this.this$0.containsKey(o);
                }

                public boolean remove(Object key) {
                    Node n = this.this$0.getNode(key);
                    if (n == nil) {
                        return false;
                    }
                    this.this$0.removeNode(n);
                    return true;
                }
            };
        }
        return this.keys;
    }

    public Object lastKey() {
        if (this.root == nil) {
            throw new NoSuchElementException("empty");
        }
        return this.lastNode().key;
    }

    public Object put(Object key, Object value) {
        Node current = this.root;
        Node parent = nil;
        int comparison = 0;
        while (current != nil) {
            parent = current;
            comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return current.setValue(value);
        }
        Node n = new Node(key, value, -1);
        n.parent = parent;
        ++this.modCount;
        ++this.size;
        if (parent == nil) {
            this.root = n;
            return null;
        }
        if (comparison > 0) {
            parent.right = n;
        } else {
            parent.left = n;
        }
        this.insertFixup(n);
        return null;
    }

    public void putAll(Map m) {
        Iterator itr = m.entrySet().iterator();
        int pos = m.size();
        while (--pos >= 0) {
            Map.Entry e = (Map.Entry)itr.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        Node n = this.getNode(key);
        if (n == nil) {
            return null;
        }
        Object result = n.value;
        this.removeNode(n);
        return result;
    }

    public int size() {
        return this.size;
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        return new SubMap(this, fromKey, toKey);
    }

    public SortedMap tailMap(Object fromKey) {
        return new SubMap(this, fromKey, nil);
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(this){
                private /* synthetic */ TreeMap this$0;
                {
                    this.this$0 = this$0;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new TreeIterator(this.this$0, 1);
                }

                public void clear() {
                    this.this$0.clear();
                }
            };
        }
        return this.values;
    }

    final int compare(Object o1, Object o2) {
        if (this.comparator == null) {
            return ((Comparable)o1).compareTo(o2);
        }
        return this.comparator.compare(o1, o2);
    }

    private void deleteFixup(Node node, Node parent) {
        while (node != this.root && node.color == 1) {
            Node sibling;
            if (node == parent.left) {
                sibling = parent.right;
                if (sibling.color == -1) {
                    sibling.color = 1;
                    parent.color = -1;
                    this.rotateLeft(parent);
                    sibling = parent.right;
                }
                if (sibling.left.color == 1 && sibling.right.color == 1) {
                    sibling.color = -1;
                    node = parent;
                    parent = parent.parent;
                    continue;
                }
                if (sibling.right.color == 1) {
                    sibling.left.color = 1;
                    sibling.color = -1;
                    this.rotateRight(sibling);
                    sibling = parent.right;
                }
                sibling.color = parent.color;
                parent.color = 1;
                sibling.right.color = 1;
                this.rotateLeft(parent);
                node = this.root;
                continue;
            }
            sibling = parent.left;
            if (sibling.color == -1) {
                sibling.color = 1;
                parent.color = -1;
                this.rotateRight(parent);
                sibling = parent.left;
            }
            if (sibling.right.color == 1 && sibling.left.color == 1) {
                sibling.color = -1;
                node = parent;
                parent = parent.parent;
                continue;
            }
            if (sibling.left.color == 1) {
                sibling.right.color = 1;
                sibling.color = -1;
                this.rotateLeft(sibling);
                sibling = parent.left;
            }
            sibling.color = parent.color;
            parent.color = 1;
            sibling.left.color = 1;
            this.rotateRight(parent);
            node = this.root;
        }
        node.color = 1;
    }

    private void fabricateTree(int count) {
        Node next;
        Node right;
        Node left;
        int i;
        if (count == 0) {
            return;
        }
        this.root = new Node(null, null, 1);
        this.size = count;
        Node row = this.root;
        int rowsize = 2;
        while (true) {
            int n = rowsize;
            if (n + n > count) break;
            Node parent = row;
            Node last = null;
            for (i = 0; i < rowsize; i += 2) {
                left = new Node(null, null, 1);
                right = new Node(null, null, 1);
                left.parent = parent;
                left.right = right;
                right.parent = parent;
                parent.left = left;
                next = parent.right;
                parent.right = right;
                parent = next;
                if (last != null) {
                    last.right = left;
                }
                last = right;
            }
            row = row.left;
            rowsize <<= 1;
        }
        int overflow = count - rowsize;
        Node parent = row;
        for (i = 0; i < overflow; i += 2) {
            left = new Node(null, null, -1);
            right = new Node(null, null, -1);
            left.parent = parent;
            right.parent = parent;
            parent.left = left;
            next = parent.right;
            parent.right = right;
            parent = next;
        }
        if (i - overflow == 0) {
            left = new Node(null, null, -1);
            left.parent = parent;
            parent.left = left;
            parent = parent.right;
            left.parent.right = nil;
        }
        while (parent != nil) {
            Node next2 = parent.right;
            parent.right = nil;
            parent = next2;
        }
    }

    final Node firstNode() {
        Node node = this.root;
        while (node.left != nil) {
            node = node.left;
        }
        return node;
    }

    final Node getNode(Object key) {
        Node current = this.root;
        while (current != nil) {
            int comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return current;
        }
        return current;
    }

    final Node highestLessThan(Object key) {
        if (key == nil) {
            return this.lastNode();
        }
        Node last = nil;
        Node current = this.root;
        int comparison = 0;
        while (current != nil) {
            last = current;
            comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return this.predecessor(last);
        }
        if (comparison <= 0) {
            return this.predecessor(last);
        }
        return last;
    }

    private void insertFixup(Node n) {
        while (n.parent.color == -1 && n.parent.parent != nil) {
            Node uncle;
            if (n.parent == n.parent.parent.left) {
                uncle = n.parent.parent.right;
                if (uncle.color == -1) {
                    n.parent.color = 1;
                    uncle.color = 1;
                    uncle.parent.color = -1;
                    n = uncle.parent;
                    continue;
                }
                if (n == n.parent.right) {
                    n = n.parent;
                    this.rotateLeft(n);
                }
                n.parent.color = 1;
                n.parent.parent.color = -1;
                this.rotateRight(n.parent.parent);
                continue;
            }
            uncle = n.parent.parent.left;
            if (uncle.color == -1) {
                n.parent.color = 1;
                uncle.color = 1;
                uncle.parent.color = -1;
                n = uncle.parent;
                continue;
            }
            if (n == n.parent.left) {
                n = n.parent;
                this.rotateRight(n);
            }
            n.parent.color = 1;
            n.parent.parent.color = -1;
            this.rotateLeft(n.parent.parent);
        }
        this.root.color = 1;
    }

    private Node lastNode() {
        Node node = this.root;
        while (node.right != nil) {
            node = node.right;
        }
        return node;
    }

    final Node lowestGreaterThan(Object key, boolean first) {
        if (key == nil) {
            if (first) {
                return this.firstNode();
            }
            return nil;
        }
        Node last = nil;
        Node current = this.root;
        int comparison = 0;
        while (current != nil) {
            last = current;
            comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return current;
        }
        if (comparison > 0) {
            return this.successor(last);
        }
        return last;
    }

    private Node predecessor(Node node) {
        if (node.left != nil) {
            node = node.left;
            while (node.right != nil) {
                node = node.right;
            }
            return node;
        }
        Node parent = node.parent;
        while (node == parent.left) {
            node = parent;
            parent = node.parent;
        }
        return parent;
    }

    final void putFromObjStream(ObjectInputStream s, int count, boolean readValues) throws IOException, ClassNotFoundException {
        this.fabricateTree(count);
        Node node = this.firstNode();
        while (--count >= 0) {
            node.key = s.readObject();
            node.value = readValues ? s.readObject() : "";
            node = this.successor(node);
        }
    }

    final void putKeysLinear(Iterator keys, int count) {
        this.fabricateTree(count);
        Node node = this.firstNode();
        while (--count >= 0) {
            node.key = keys.next();
            node.value = "";
            node = this.successor(node);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.putFromObjStream(s, size, true);
    }

    final void removeNode(Node node) {
        Node child;
        Node splice;
        ++this.modCount;
        --this.size;
        if (node.left == nil) {
            splice = node;
            child = node.right;
        } else if (node.right == nil) {
            splice = node;
            child = node.left;
        } else {
            splice = node.left;
            while (splice.right != nil) {
                splice = splice.right;
            }
            child = splice.left;
            node.key = splice.key;
            node.value = splice.value;
        }
        Node parent = splice.parent;
        if (child != nil) {
            child.parent = parent;
        }
        if (parent == nil) {
            this.root = child;
            return;
        }
        if (splice == parent.left) {
            parent.left = child;
        } else {
            parent.right = child;
        }
        if (splice.color == 1) {
            this.deleteFixup(child, parent);
        }
    }

    private void rotateLeft(Node node) {
        Node child = node.right;
        node.right = child.left;
        if (child.left != nil) {
            child.left.parent = node;
        }
        child.parent = node.parent;
        if (node.parent != nil) {
            if (node == node.parent.left) {
                node.parent.left = child;
            } else {
                node.parent.right = child;
            }
        } else {
            this.root = child;
        }
        child.left = node;
        node.parent = child;
    }

    private void rotateRight(Node node) {
        Node child = node.left;
        node.left = child.right;
        if (child.right != nil) {
            child.right.parent = node;
        }
        child.parent = node.parent;
        if (node.parent != nil) {
            if (node == node.parent.right) {
                node.parent.right = child;
            } else {
                node.parent.left = child;
            }
        } else {
            this.root = child;
        }
        child.right = node;
        node.parent = child;
    }

    final Node successor(Node node) {
        if (node.right != nil) {
            node = node.right;
            while (node.left != nil) {
                node = node.left;
            }
            return node;
        }
        Node parent = node.parent;
        while (node == parent.right) {
            node = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node node = this.firstNode();
        s.writeInt(this.size);
        while (node != nil) {
            s.writeObject(node.key);
            s.writeObject(node.value);
            node = this.successor(node);
        }
    }

    static {
        TreeMap.nil.parent = nil = new Node(null, null, 1);
        TreeMap.nil.left = nil;
        TreeMap.nil.right = nil;
    }

    private final class SubMap
    extends AbstractMap
    implements SortedMap {
        private /* synthetic */ TreeMap this$0;
        final Object minKey;
        final Object maxKey;
        private Set entries;

        static /* synthetic */ TreeMap access$8(SubMap inst$, TreeMap write_parm_value$) {
            inst$.this$0 = write_parm_value$;
            return inst$.this$0;
        }

        static TreeMap access$0(SubMap inst$) {
            return inst$.this$0;
        }

        SubMap(TreeMap this$0, Object minKey, Object maxKey) {
            this.this$0 = this$0;
            if (minKey != nil && maxKey != nil && this$0.compare(minKey, maxKey) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.minKey = minKey;
            this.maxKey = maxKey;
        }

        final boolean keyInRange(Object key) {
            return !(this.minKey != nil && this.this$0.compare(key, this.minKey) < 0 || this.maxKey != nil && this.this$0.compare(key, this.maxKey) >= 0);
        }

        public void clear() {
            Node next = this.this$0.lowestGreaterThan(this.minKey, true);
            Node max = this.this$0.lowestGreaterThan(this.maxKey, false);
            while (next != max) {
                Node current = next;
                next = this.this$0.successor(current);
                this.this$0.removeNode(current);
            }
        }

        public Comparator comparator() {
            return this.this$0.comparator;
        }

        public boolean containsKey(Object key) {
            return this.keyInRange(key) && this.this$0.containsKey(key);
        }

        public boolean containsValue(Object value) {
            Node node = this.this$0.lowestGreaterThan(this.minKey, true);
            Node max = this.this$0.lowestGreaterThan(this.maxKey, false);
            while (node != max) {
                if (AbstractMap.equals(value, node.getValue())) {
                    return true;
                }
                node = this.this$0.successor(node);
            }
            return false;
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = new AbstractSet(this){
                    private /* synthetic */ SubMap this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int size() {
                        return this.this$1.size();
                    }

                    public Iterator iterator() {
                        Node first = this.this$1.this$0.lowestGreaterThan(this.this$1.minKey, true);
                        Node max = this.this$1.this$0.lowestGreaterThan(this.this$1.maxKey, false);
                        return new TreeIterator(SubMap.access$0(this.this$1), 2, first, max);
                    }

                    public void clear() {
                        this.this$1.clear();
                    }

                    public boolean contains(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry me = (Map.Entry)o;
                        Object key = me.getKey();
                        if (!this.this$1.keyInRange(key)) {
                            return false;
                        }
                        Node n = this.this$1.this$0.getNode(key);
                        return n != nil && AbstractCollection.equals(me.getValue(), n.value);
                    }

                    public boolean remove(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry me = (Map.Entry)o;
                        Object key = me.getKey();
                        if (!this.this$1.keyInRange(key)) {
                            return false;
                        }
                        Node n = this.this$1.this$0.getNode(key);
                        if (n != nil && AbstractCollection.equals(me.getValue(), n.value)) {
                            this.this$1.this$0.removeNode(n);
                            return true;
                        }
                        return false;
                    }
                };
            }
            return this.entries;
        }

        public Object firstKey() {
            Node node = this.this$0.lowestGreaterThan(this.minKey, true);
            if (node == nil || !this.keyInRange(node.key)) {
                throw new NoSuchElementException();
            }
            return node.key;
        }

        public Object get(Object key) {
            if (this.keyInRange(key)) {
                return this.this$0.get(key);
            }
            return null;
        }

        public SortedMap headMap(Object toKey) {
            if (!this.keyInRange(toKey)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(this.this$0, this.minKey, toKey);
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = new AbstractSet(this){
                    private /* synthetic */ SubMap this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int size() {
                        return this.this$1.size();
                    }

                    public Iterator iterator() {
                        Node first = this.this$1.this$0.lowestGreaterThan(this.this$1.minKey, true);
                        Node max = this.this$1.this$0.lowestGreaterThan(this.this$1.maxKey, false);
                        return new TreeIterator(SubMap.access$0(this.this$1), 0, first, max);
                    }

                    public void clear() {
                        this.this$1.clear();
                    }

                    public boolean contains(Object o) {
                        if (!this.this$1.keyInRange(o)) {
                            return false;
                        }
                        return this.this$1.this$0.getNode(o) != nil;
                    }

                    public boolean remove(Object o) {
                        if (!this.this$1.keyInRange(o)) {
                            return false;
                        }
                        Node n = this.this$1.this$0.getNode(o);
                        if (n != nil) {
                            this.this$1.this$0.removeNode(n);
                            return true;
                        }
                        return false;
                    }
                };
            }
            return this.keys;
        }

        public Object lastKey() {
            Node node = this.this$0.highestLessThan(this.maxKey);
            if (node == nil || !this.keyInRange(node.key)) {
                throw new NoSuchElementException();
            }
            return node.key;
        }

        public Object put(Object key, Object value) {
            if (!this.keyInRange(key)) {
                throw new IllegalArgumentException("Key outside range");
            }
            return this.this$0.put(key, value);
        }

        public Object remove(Object key) {
            if (this.keyInRange(key)) {
                return this.this$0.remove(key);
            }
            return null;
        }

        public int size() {
            Node node = this.this$0.lowestGreaterThan(this.minKey, true);
            Node max = this.this$0.lowestGreaterThan(this.maxKey, false);
            int count = 0;
            while (node != max) {
                ++count;
                node = this.this$0.successor(node);
            }
            return count;
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            if (!this.keyInRange(fromKey) || !this.keyInRange(toKey)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(this.this$0, fromKey, toKey);
        }

        public SortedMap tailMap(Object fromKey) {
            if (!this.keyInRange(fromKey)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(this.this$0, fromKey, this.maxKey);
        }

        public Collection values() {
            if (this.values == null) {
                this.values = new AbstractCollection(this){
                    private /* synthetic */ SubMap this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int size() {
                        return this.this$1.size();
                    }

                    public Iterator iterator() {
                        Node first = this.this$1.this$0.lowestGreaterThan(this.this$1.minKey, true);
                        Node max = this.this$1.this$0.lowestGreaterThan(this.this$1.maxKey, false);
                        return new TreeIterator(SubMap.access$0(this.this$1), 1, first, max);
                    }

                    public void clear() {
                        this.this$1.clear();
                    }
                };
            }
            return this.values;
        }
    }

    private final class TreeIterator
    implements Iterator {
        private /* synthetic */ TreeMap this$0;
        private final int type;
        private int knownMod;
        private Node last;
        private Node next;
        private final Node max;

        private /* synthetic */ void finit$() {
            this.knownMod = this.this$0.modCount;
        }

        TreeIterator(TreeMap this$0, int type) {
            this.this$0 = this$0;
            this.finit$();
            this.type = type;
            this.next = this$0.firstNode();
            this.max = nil;
        }

        TreeIterator(TreeMap this$0, int type, Node first, Node max) {
            this.this$0 = this$0;
            this.finit$();
            this.type = type;
            this.next = first;
            this.max = max;
        }

        public boolean hasNext() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != this.max;
        }

        public Object next() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next == this.max) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = this.this$0.successor(this.last);
            if (this.type == 1) {
                return this.last.value;
            }
            if (this.type == 0) {
                return this.last.key;
            }
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            this.this$0.removeNode(this.last);
            this.last = null;
            ++this.knownMod;
        }
    }

    private static final class Node
    extends AbstractMap.BasicMapEntry {
        int color;
        Node left;
        Node right;
        Node parent;

        private /* synthetic */ void finit$() {
            this.left = nil;
            this.right = nil;
            this.parent = nil;
        }

        Node(Object key, Object value, int color) {
            super(key, value);
            this.finit$();
            this.color = color;
        }
    }
}

