/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.gcj.RawData;
import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.CharBuffer;
import java.nio.CharViewBufferImpl;
import java.nio.DoubleBuffer;
import java.nio.DoubleViewBufferImpl;
import java.nio.FloatBuffer;
import java.nio.FloatViewBufferImpl;
import java.nio.IntBuffer;
import java.nio.IntViewBufferImpl;
import java.nio.LongBuffer;
import java.nio.LongViewBufferImpl;
import java.nio.ShortBuffer;
import java.nio.ShortViewBufferImpl;

class DirectByteBufferImpl
extends ByteBuffer {
    RawData address;
    private int offset;
    private boolean readOnly;

    public DirectByteBufferImpl(RawData address, long len) {
        this(address, 0, (int)len, (int)len, 0, -1, false);
    }

    public DirectByteBufferImpl(RawData address, int offset, int capacity, int limit, int position, int mark, boolean readOnly) {
        super(capacity, limit, position, mark);
        this.address = address;
        this.offset = offset;
        this.readOnly = readOnly;
    }

    private static native RawData allocateImpl(int var0);

    private static native void freeImpl(RawData var0);

    protected void finalize() throws Throwable {
        DirectByteBufferImpl.freeImpl(this.address);
    }

    public static ByteBuffer allocateDirect(int capacity) {
        RawData address = DirectByteBufferImpl.allocateImpl(capacity);
        if (address == null) {
            throw new InternalError("Not enough memory to create direct buffer");
        }
        return new DirectByteBufferImpl(address, 0, capacity, capacity, 0, -1, false);
    }

    private native byte getImpl(int var1);

    private native void putImpl(int var1, byte var2);

    public byte get() {
        byte result = this.getImpl(this.position() + this.offset);
        this.position(this.position() + 1);
        return result;
    }

    public byte get(int index) {
        return this.getImpl(index);
    }

    public ByteBuffer put(byte value) {
        this.putImpl(this.position(), value);
        this.position(this.position() + 1);
        return this;
    }

    public ByteBuffer put(int index, byte value) {
        this.putImpl(index, value);
        return this;
    }

    native void shiftDown(int var1, int var2, int var3);

    public ByteBuffer compact() {
        int pos = this.position();
        if (pos > 0) {
            int count = this.remaining();
            this.shiftDown(0, pos, count);
            this.position(count);
            this.limit(this.capacity());
        }
        return this;
    }

    public ByteBuffer duplicate() {
        return new DirectByteBufferImpl(this.address, this.offset, this.capacity(), this.limit(), this.position(), -1, this.isReadOnly());
    }

    public ByteBuffer slice() {
        return new DirectByteBufferImpl(this.address, this.position() + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public ByteBuffer asReadOnlyBuffer() {
        return new DirectByteBufferImpl(this.address, this.offset, this.capacity(), this.limit(), this.position(), -1, true);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDirect() {
        return true;
    }

    public CharBuffer asCharBuffer() {
        return new CharViewBufferImpl(this, this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly(), this.order());
    }

    public DoubleBuffer asDoubleBuffer() {
        return new DoubleViewBufferImpl(this, this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly(), this.order());
    }

    public FloatBuffer asFloatBuffer() {
        return new FloatViewBufferImpl(this, this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly(), this.order());
    }

    public IntBuffer asIntBuffer() {
        return new IntViewBufferImpl(this, this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly(), this.order());
    }

    public LongBuffer asLongBuffer() {
        return new LongViewBufferImpl(this, this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly(), this.order());
    }

    public ShortBuffer asShortBuffer() {
        return new ShortViewBufferImpl(this, this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly(), this.order());
    }

    public final char getChar() {
        return ByteBufferHelper.getChar(this, this.order());
    }

    public final ByteBuffer putChar(char value) {
        ByteBufferHelper.putChar(this, value, this.order());
        return this;
    }

    public final char getChar(int index) {
        return ByteBufferHelper.getChar(this, index, this.order());
    }

    public final ByteBuffer putChar(int index, char value) {
        ByteBufferHelper.putChar(this, index, value, this.order());
        return this;
    }

    public final short getShort() {
        return ByteBufferHelper.getShort(this, this.order());
    }

    public final ByteBuffer putShort(short value) {
        ByteBufferHelper.putShort(this, value, this.order());
        return this;
    }

    public final short getShort(int index) {
        return ByteBufferHelper.getShort(this, index, this.order());
    }

    public final ByteBuffer putShort(int index, short value) {
        ByteBufferHelper.putShort(this, index, value, this.order());
        return this;
    }

    public final int getInt() {
        return ByteBufferHelper.getInt(this, this.order());
    }

    public final ByteBuffer putInt(int value) {
        ByteBufferHelper.putInt(this, value, this.order());
        return this;
    }

    public final int getInt(int index) {
        return ByteBufferHelper.getInt(this, index, this.order());
    }

    public final ByteBuffer putInt(int index, int value) {
        ByteBufferHelper.putInt(this, index, value, this.order());
        return this;
    }

    public final long getLong() {
        return ByteBufferHelper.getLong(this, this.order());
    }

    public final ByteBuffer putLong(long value) {
        ByteBufferHelper.putLong(this, value, this.order());
        return this;
    }

    public final long getLong(int index) {
        return ByteBufferHelper.getLong(this, index, this.order());
    }

    public final ByteBuffer putLong(int index, long value) {
        ByteBufferHelper.putLong(this, index, value, this.order());
        return this;
    }

    public final float getFloat() {
        return ByteBufferHelper.getFloat(this, this.order());
    }

    public final ByteBuffer putFloat(float value) {
        ByteBufferHelper.putFloat(this, value, this.order());
        return this;
    }

    public final float getFloat(int index) {
        return ByteBufferHelper.getFloat(this, index, this.order());
    }

    public final ByteBuffer putFloat(int index, float value) {
        ByteBufferHelper.putFloat(this, index, value, this.order());
        return this;
    }

    public final double getDouble() {
        return ByteBufferHelper.getDouble(this, this.order());
    }

    public final ByteBuffer putDouble(double value) {
        ByteBufferHelper.putDouble(this, value, this.order());
        return this;
    }

    public final double getDouble(int index) {
        return ByteBufferHelper.getDouble(this, index, this.order());
    }

    public final ByteBuffer putDouble(int index, double value) {
        ByteBufferHelper.putDouble(this, index, value, this.order());
        return this;
    }
}

