/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.ObjectIdentityWrapper;
import gnu.java.lang.reflect.TypeSignature;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.SerializablePermission;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private static final int BUFFER_SIZE = 1024;
    private static int defaultProtocolVersion = 2;
    private DataOutputStream dataOutput;
    private boolean writeDataAsBlocks;
    private DataOutputStream realOutput;
    private DataOutputStream blockDataOutput;
    private byte[] blockData;
    private int blockDataCount;
    private Object currentObject;
    private ObjectStreamClass currentObjectStreamClass;
    private PutField currentPutField;
    private boolean fieldsAlreadyWritten;
    private boolean replacementEnabled;
    private boolean isSerializing;
    private int nextOID;
    private Hashtable OIDLookupTable;
    private int protocolVersion;
    private boolean useSubclassMethod;

    static /* synthetic */ ObjectStreamClass access$11(ObjectOutputStream inst$, ObjectStreamClass write_parm_value$) {
        inst$.currentObjectStreamClass = write_parm_value$;
        return inst$.currentObjectStreamClass;
    }

    public ObjectOutputStream(OutputStream out) throws IOException {
        this.realOutput = new DataOutputStream(out);
        this.blockData = new byte[1024];
        this.blockDataCount = 0;
        this.blockDataOutput = new DataOutputStream(this);
        this.setBlockDataMode(true);
        this.replacementEnabled = false;
        this.isSerializing = false;
        this.nextOID = 0x7E0000;
        this.OIDLookupTable = new Hashtable();
        this.protocolVersion = defaultProtocolVersion;
        this.useSubclassMethod = false;
        this.writeStreamHeader();
    }

    public final void writeObject(Object obj) throws IOException {
        if (this.useSubclassMethod) {
            this.writeObjectOverride(obj);
            return;
        }
        boolean was_serializing = this.isSerializing;
        boolean old_mode = this.setBlockDataMode(false);
        try {
            block33: {
                try {
                    ObjectStreamClass osc;
                    this.isSerializing = true;
                    boolean replaceDone = false;
                    Object replacedObject = null;
                    while (true) {
                        if (obj == null) {
                            this.realOutput.writeByte(112);
                            break block33;
                        }
                        Integer handle = this.findHandle(obj);
                        if (handle != null) {
                            this.realOutput.writeByte(113);
                            this.realOutput.writeInt(handle);
                            break block33;
                        }
                        if (obj instanceof Class) {
                            Class cl = (Class)obj;
                            osc = ObjectStreamClass.lookupForClassObject(cl);
                            this.assignNewHandle(obj);
                            this.realOutput.writeByte(118);
                            if (!osc.isProxyClass) {
                                this.writeObject(osc);
                            } else {
                                this.realOutput.writeByte(125);
                                Class[] intfs = cl.getInterfaces();
                                this.realOutput.writeInt(intfs.length);
                                for (int i = 0; i < intfs.length; ++i) {
                                    this.realOutput.writeUTF(intfs[i].getName());
                                }
                                boolean oldmode = this.setBlockDataMode(true);
                                this.annotateProxyClass(cl);
                                this.setBlockDataMode(oldmode);
                                this.realOutput.writeByte(120);
                                this.writeObject(osc.getSuper());
                            }
                            break block33;
                        }
                        if (obj instanceof ObjectStreamClass) {
                            this.writeClassDescriptor((ObjectStreamClass)obj);
                            break block33;
                        }
                        if (!this.replacementEnabled && !(obj instanceof Serializable) || replaceDone) break;
                        replacedObject = obj;
                        if (obj instanceof Serializable) {
                            Method m = null;
                            try {
                                Class[] classArgs = new Class[]{};
                                m = ObjectOutputStream.getMethod(obj.getClass(), "writeReplace", classArgs);
                                obj = m.invoke(obj, new Object[0]);
                            }
                            catch (NoSuchMethodException ignore) {
                            }
                            catch (IllegalAccessException ignore) {
                            }
                            catch (InvocationTargetException ignore) {
                                // empty catch block
                            }
                        }
                        if (this.replacementEnabled) {
                            obj = this.replaceObject(obj);
                        }
                        replaceDone = true;
                    }
                    if (obj instanceof String) {
                        this.realOutput.writeByte(116);
                        this.assignNewHandle(obj);
                        this.realOutput.writeUTF((String)obj);
                        break block33;
                    }
                    Class clazz = obj.getClass();
                    osc = ObjectStreamClass.lookupForClassObject(clazz);
                    if (osc == null) {
                        throw new NotSerializableException(clazz.getName());
                    }
                    if (clazz.isArray()) {
                        this.realOutput.writeByte(117);
                        this.writeObject(osc);
                        this.assignNewHandle(obj);
                        this.writeArraySizeAndElements(obj, clazz.getComponentType());
                        break block33;
                    }
                    this.realOutput.writeByte(115);
                    this.writeObject(osc);
                    if (replaceDone) {
                        this.assignNewHandle(replacedObject);
                    } else {
                        this.assignNewHandle(obj);
                    }
                    if (obj instanceof Externalizable) {
                        if (this.protocolVersion == 2) {
                            this.setBlockDataMode(true);
                        }
                        ((Externalizable)obj).writeExternal(this);
                        if (this.protocolVersion == 2) {
                            this.setBlockDataMode(false);
                            this.realOutput.writeByte(120);
                        }
                        break block33;
                    }
                    if (obj instanceof Serializable) {
                        this.currentObject = obj;
                        ObjectStreamClass[] hierarchy = ObjectStreamClass.getObjectStreamClasses(clazz);
                        for (int i = 0; i < hierarchy.length; ++i) {
                            this.currentObjectStreamClass = hierarchy[i];
                            this.fieldsAlreadyWritten = false;
                            if (this.currentObjectStreamClass.hasWriteMethod()) {
                                this.setBlockDataMode(true);
                                this.callWriteMethod(obj, this.currentObjectStreamClass);
                                this.setBlockDataMode(false);
                                this.realOutput.writeByte(120);
                                continue;
                            }
                            this.writeFields(obj, this.currentObjectStreamClass);
                        }
                        this.currentObject = null;
                        this.currentObjectStreamClass = null;
                        this.currentPutField = null;
                        break block33;
                    }
                    throw new NotSerializableException(clazz.getName());
                }
                catch (ObjectStreamException ose) {
                    throw ose;
                }
                catch (IOException e) {
                    this.realOutput.writeByte(123);
                    this.reset(true);
                    this.setBlockDataMode(false);
                    try {
                        this.writeObject(e);
                    }
                    catch (IOException ioe) {
                        throw new StreamCorruptedException("Exception " + ioe + " thrown while exception was being written to stream.");
                    }
                    this.reset(true);
                }
            }
            Object var4_7 = null;
            this.isSerializing = was_serializing;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.isSerializing = was_serializing;
            this.setBlockDataMode(old_mode);
            throw throwable;
        }
        this.setBlockDataMode(old_mode);
    }

    protected void writeClassDescriptor(ObjectStreamClass osc) throws IOException {
        this.realOutput.writeByte(114);
        this.realOutput.writeUTF(osc.getName());
        this.realOutput.writeLong(osc.getSerialVersionUID());
        this.assignNewHandle(osc);
        int flags = osc.getFlags();
        if (this.protocolVersion == 2 && osc.isExternalizable()) {
            flags |= 8;
        }
        this.realOutput.writeByte(flags);
        ObjectStreamField[] fields = osc.fields;
        this.realOutput.writeShort(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            ObjectStreamField field = fields[i];
            this.realOutput.writeByte(field.getTypeCode());
            this.realOutput.writeUTF(field.getName());
            if (field.isPrimitive()) continue;
            this.writeObject(field.getTypeString());
        }
        boolean oldmode = this.setBlockDataMode(true);
        this.annotateClass(osc.forClass());
        this.setBlockDataMode(oldmode);
        this.realOutput.writeByte(120);
        if (osc.isSerializable() || osc.isExternalizable()) {
            this.writeObject(osc.getSuper());
        } else {
            this.writeObject(null);
        }
    }

    public void defaultWriteObject() throws IOException, NotActiveException {
        this.markFieldsWritten();
        this.writeFields(this.currentObject, this.currentObjectStreamClass);
    }

    private void markFieldsWritten() throws IOException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("defaultWriteObject called by non-active class and/or object");
        }
        if (this.fieldsAlreadyWritten) {
            throw new IOException("Only one of writeFields and defaultWriteObject may be called, and it may only be called once");
        }
        this.fieldsAlreadyWritten = true;
    }

    public void reset() throws IOException {
        this.reset(false);
    }

    private void reset(boolean internal) throws IOException {
        if (!internal) {
            if (this.isSerializing) {
                throw new IOException("Reset called while serialization in progress");
            }
            this.realOutput.writeByte(121);
        }
        this.clearHandles();
    }

    public void useProtocolVersion(int version) throws IOException {
        if (version != 1 && version != 2) {
            throw new IOException("Invalid protocol version requested.");
        }
        this.protocolVersion = version;
    }

    public static void setDefaultProtocolVersion(int version) throws IOException {
        if (version != 1 && version != 2) {
            throw new IOException("Invalid protocol version requested.");
        }
        defaultProtocolVersion = version;
    }

    protected void annotateClass(Class cl) throws IOException {
    }

    protected void annotateProxyClass(Class cl) throws IOException {
    }

    protected Object replaceObject(Object obj) throws IOException {
        return obj;
    }

    protected boolean enableReplaceObject(boolean enable) throws SecurityException {
        SecurityManager sm;
        if (enable && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SerializablePermission("enableSubstitution"));
        }
        boolean old_val = this.replacementEnabled;
        this.replacementEnabled = enable;
        return old_val;
    }

    protected void writeStreamHeader() throws IOException {
        this.realOutput.writeShort(-21267);
        this.realOutput.writeShort(5);
    }

    protected ObjectOutputStream() throws IOException, SecurityException {
        SecurityManager sec_man = System.getSecurityManager();
        if (sec_man != null) {
            sec_man.checkPermission(ObjectStreamConstants.SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.useSubclassMethod = true;
    }

    protected void writeObjectOverride(Object obj) throws NotActiveException, IOException {
        throw new NotActiveException("Subclass of ObjectOutputStream must implement writeObjectOverride");
    }

    public void write(int data) throws IOException {
        if (this.writeDataAsBlocks) {
            if (this.blockDataCount == 1024) {
                this.drain();
            }
            this.blockData[this.blockDataCount++] = (byte)data;
        } else {
            this.realOutput.write(data);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.writeDataAsBlocks) {
            if (len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.blockDataCount + len < 1024) {
                System.arraycopy(b, off, this.blockData, this.blockDataCount, len);
                this.blockDataCount += len;
            } else {
                this.drain();
                this.writeBlockDataHeader(len);
                this.realOutput.write(b, off, len);
            }
        } else {
            this.realOutput.write(b, off, len);
        }
    }

    public void flush() throws IOException {
        this.drain();
        this.realOutput.flush();
    }

    protected void drain() throws IOException {
        if (this.blockDataCount == 0) {
            return;
        }
        if (this.writeDataAsBlocks) {
            this.writeBlockDataHeader(this.blockDataCount);
        }
        this.realOutput.write(this.blockData, 0, this.blockDataCount);
        this.blockDataCount = 0;
    }

    public void close() throws IOException {
        this.flush();
        this.realOutput.close();
    }

    public void writeBoolean(boolean data) throws IOException {
        this.blockDataOutput.writeBoolean(data);
    }

    public void writeByte(int data) throws IOException {
        this.blockDataOutput.writeByte(data);
    }

    public void writeShort(int data) throws IOException {
        this.blockDataOutput.writeShort(data);
    }

    public void writeChar(int data) throws IOException {
        this.blockDataOutput.writeChar(data);
    }

    public void writeInt(int data) throws IOException {
        this.blockDataOutput.writeInt(data);
    }

    public void writeLong(long data) throws IOException {
        this.blockDataOutput.writeLong(data);
    }

    public void writeFloat(float data) throws IOException {
        this.blockDataOutput.writeFloat(data);
    }

    public void writeDouble(double data) throws IOException {
        this.blockDataOutput.writeDouble(data);
    }

    public void writeBytes(String data) throws IOException {
        this.blockDataOutput.writeBytes(data);
    }

    public void writeChars(String data) throws IOException {
        this.dataOutput.writeChars(data);
    }

    public void writeUTF(String data) throws IOException {
        this.dataOutput.writeUTF(data);
    }

    public PutField putFields() throws IOException {
        if (this.currentPutField != null) {
            return this.currentPutField;
        }
        this.currentPutField = new PutField(this){
            private /* synthetic */ ObjectOutputStream this$0;
            private byte[] prim_field_data;
            private Object[] objs;
            {
                this.this$0 = this$0;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.prim_field_data = new byte[((ObjectOutputStream)this.this$0).currentObjectStreamClass.primFieldSize];
                this.objs = new Object[((ObjectOutputStream)this.this$0).currentObjectStreamClass.objectFieldCount];
            }

            private ObjectStreamField getField(String name) {
                ObjectStreamField field = this.this$0.currentObjectStreamClass.getField(name);
                if (field == null) {
                    throw new IllegalArgumentException("no such serializable field " + name);
                }
                return field;
            }

            public void put(String name, boolean value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'Z');
                this.prim_field_data[field.getOffset()] = value ? (byte)1 : 0;
            }

            public void put(String name, byte value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'B');
                this.prim_field_data[field.getOffset()] = value;
            }

            public void put(String name, char value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'C');
                int off = field.getOffset();
                this.prim_field_data[off++] = (byte)(value >>> 8);
                this.prim_field_data[off] = (byte)value;
            }

            public void put(String name, double value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'D');
                int off = field.getOffset();
                long l_value = Double.doubleToLongBits(value);
                this.prim_field_data[off++] = (byte)(l_value >>> 52);
                this.prim_field_data[off++] = (byte)(l_value >>> 48);
                this.prim_field_data[off++] = (byte)(l_value >>> 40);
                this.prim_field_data[off++] = (byte)(l_value >>> 32);
                this.prim_field_data[off++] = (byte)(l_value >>> 24);
                this.prim_field_data[off++] = (byte)(l_value >>> 16);
                this.prim_field_data[off++] = (byte)(l_value >>> 8);
                this.prim_field_data[off] = (byte)l_value;
            }

            public void put(String name, float value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'F');
                int off = field.getOffset();
                int i_value = Float.floatToIntBits(value);
                this.prim_field_data[off++] = (byte)(i_value >>> 24);
                this.prim_field_data[off++] = (byte)(i_value >>> 16);
                this.prim_field_data[off++] = (byte)(i_value >>> 8);
                this.prim_field_data[off] = (byte)i_value;
            }

            public void put(String name, int value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'I');
                int off = field.getOffset();
                this.prim_field_data[off++] = (byte)(value >>> 24);
                this.prim_field_data[off++] = (byte)(value >>> 16);
                this.prim_field_data[off++] = (byte)(value >>> 8);
                this.prim_field_data[off] = (byte)value;
            }

            public void put(String name, long value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'J');
                int off = field.getOffset();
                this.prim_field_data[off++] = (byte)(value >>> 52);
                this.prim_field_data[off++] = (byte)(value >>> 48);
                this.prim_field_data[off++] = (byte)(value >>> 40);
                this.prim_field_data[off++] = (byte)(value >>> 32);
                this.prim_field_data[off++] = (byte)(value >>> 24);
                this.prim_field_data[off++] = (byte)(value >>> 16);
                this.prim_field_data[off++] = (byte)(value >>> 8);
                this.prim_field_data[off] = (byte)value;
            }

            public void put(String name, short value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'S');
                int off = field.getOffset();
                this.prim_field_data[off++] = (byte)(value >>> 8);
                this.prim_field_data[off] = (byte)value;
            }

            public void put(String name, Object value) {
                ObjectStreamField field = this.getField(name);
                if (value != null && !field.getType().isAssignableFrom(value.getClass())) {
                    throw new IllegalArgumentException("Class " + value.getClass() + " cannot be cast to " + field.getType());
                }
                this.objs[field.getOffset()] = value;
            }

            public void write(ObjectOutput out) throws IOException {
                boolean oldmode = this.this$0.setBlockDataMode(false);
                out.write(this.prim_field_data);
                for (int i = 0; i < this.objs.length; ++i) {
                    out.writeObject(this.objs[i]);
                }
                this.this$0.setBlockDataMode(oldmode);
            }

            private void checkType(ObjectStreamField field, char type) throws IllegalArgumentException {
                if (TypeSignature.getEncodingOfClass(field.getType()).charAt(0) != type) {
                    throw new IllegalArgumentException();
                }
            }
        };
        return this.currentPutField;
    }

    public void writeFields() throws IOException {
        if (this.currentPutField == null) {
            throw new NotActiveException("writeFields can only be called after putFields has been called");
        }
        this.markFieldsWritten();
        this.currentPutField.write(this);
    }

    private void writeBlockDataHeader(int size) throws IOException {
        if (size < 256) {
            this.realOutput.writeByte(119);
            this.realOutput.write(size);
        } else {
            this.realOutput.writeByte(122);
            this.realOutput.writeInt(size);
        }
    }

    private Integer findHandle(Object obj) {
        return (Integer)this.OIDLookupTable.get(new ObjectIdentityWrapper(obj));
    }

    private int assignNewHandle(Object obj) {
        this.OIDLookupTable.put(new ObjectIdentityWrapper(obj), new Integer(this.nextOID));
        return this.nextOID++;
    }

    private void clearHandles() {
        this.nextOID = 0x7E0000;
        this.OIDLookupTable.clear();
    }

    private void writeArraySizeAndElements(Object array, Class clazz) throws IOException {
        int length = Array.getLength(array);
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                boolean[] cast_array = (boolean[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeBoolean(cast_array[i]);
                }
                return;
            }
            if (clazz == Byte.TYPE) {
                byte[] cast_array = (byte[])array;
                this.realOutput.writeInt(length);
                this.realOutput.write(cast_array, 0, length);
                return;
            }
            if (clazz == Character.TYPE) {
                char[] cast_array = (char[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeChar(cast_array[i]);
                }
                return;
            }
            if (clazz == Double.TYPE) {
                double[] cast_array = (double[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeDouble(cast_array[i]);
                }
                return;
            }
            if (clazz == Float.TYPE) {
                float[] cast_array = (float[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeFloat(cast_array[i]);
                }
                return;
            }
            if (clazz == Integer.TYPE) {
                int[] cast_array = (int[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeInt(cast_array[i]);
                }
                return;
            }
            if (clazz == Long.TYPE) {
                long[] cast_array = (long[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeLong(cast_array[i]);
                }
                return;
            }
            if (clazz == Short.TYPE) {
                short[] cast_array = (short[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeShort(cast_array[i]);
                }
                return;
            }
        } else {
            Object[] cast_array = (Object[])array;
            this.realOutput.writeInt(length);
            for (int i = 0; i < length; ++i) {
                this.writeObject(cast_array[i]);
            }
        }
    }

    private void writeFields(Object obj, ObjectStreamClass osc) throws IOException {
        ObjectStreamField[] fields = osc.fields;
        boolean oldmode = this.setBlockDataMode(false);
        for (int i = 0; i < fields.length; ++i) {
            String field_name = fields[i].getName();
            Class type = fields[i].getType();
            if (type == Boolean.TYPE) {
                this.realOutput.writeBoolean(this.getBooleanField(obj, osc.forClass(), field_name));
                continue;
            }
            if (type == Byte.TYPE) {
                this.realOutput.writeByte(this.getByteField(obj, osc.forClass(), field_name));
                continue;
            }
            if (type == Character.TYPE) {
                this.realOutput.writeChar(this.getCharField(obj, osc.forClass(), field_name));
                continue;
            }
            if (type == Double.TYPE) {
                this.realOutput.writeDouble(this.getDoubleField(obj, osc.forClass(), field_name));
                continue;
            }
            if (type == Float.TYPE) {
                this.realOutput.writeFloat(this.getFloatField(obj, osc.forClass(), field_name));
                continue;
            }
            if (type == Integer.TYPE) {
                this.realOutput.writeInt(this.getIntField(obj, osc.forClass(), field_name));
                continue;
            }
            if (type == Long.TYPE) {
                this.realOutput.writeLong(this.getLongField(obj, osc.forClass(), field_name));
                continue;
            }
            if (type == Short.TYPE) {
                this.realOutput.writeShort(this.getShortField(obj, osc.forClass(), field_name));
                continue;
            }
            this.writeObject(this.getObjectField(obj, osc.forClass(), field_name, fields[i].getTypeString()));
        }
        this.setBlockDataMode(oldmode);
    }

    private boolean setBlockDataMode(boolean on) throws IOException {
        if (on == this.writeDataAsBlocks) {
            return on;
        }
        this.drain();
        boolean oldmode = this.writeDataAsBlocks;
        this.writeDataAsBlocks = on;
        this.dataOutput = on ? this.blockDataOutput : this.realOutput;
        return oldmode;
    }

    private void callWriteMethod(Object obj, ObjectStreamClass osc) throws IOException {
        Class klass = osc.forClass();
        this.currentPutField = null;
        try {
            Class[] classArgs = new Class[]{ObjectOutputStream.class$("java.io.ObjectOutputStream")};
            Method m = ObjectOutputStream.getMethod(klass, "writeObject", classArgs);
            Object[] args = new Object[]{this};
            m.invoke(obj, args);
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (InvocationTargetException x) {
            Throwable exception = x.getTargetException();
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException ioe = new IOException("Exception thrown from writeObject() on " + klass + ": " + exception.getClass().getName());
            ioe.initCause(exception);
            throw ioe;
        }
        catch (Exception x) {
            IOException ioe = new IOException("Failure invoking writeObject() on " + klass + ": " + x.getClass().getName());
            ioe.initCause(x);
            throw ioe;
        }
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    private boolean getBooleanField(Object obj, Class klass, String field_name) throws IOException {
        try {
            Field f = ObjectOutputStream.getField(klass, field_name);
            boolean b = f.getBoolean(obj);
            return b;
        }
        catch (IllegalArgumentException _) {
            throw new InvalidClassException("invalid requested type for field " + field_name + " in class " + klass.getName());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception _) {
            throw new IOException("Unexpected exception " + _);
        }
    }

    private byte getByteField(Object obj, Class klass, String field_name) throws IOException {
        try {
            Field f = ObjectOutputStream.getField(klass, field_name);
            byte b = f.getByte(obj);
            return b;
        }
        catch (IllegalArgumentException _) {
            throw new InvalidClassException("invalid requested type for field " + field_name + " in class " + klass.getName());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception _) {
            throw new IOException("Unexpected exception " + _);
        }
    }

    private char getCharField(Object obj, Class klass, String field_name) throws IOException {
        try {
            Field f = ObjectOutputStream.getField(klass, field_name);
            char b = f.getChar(obj);
            return b;
        }
        catch (IllegalArgumentException _) {
            throw new InvalidClassException("invalid requested type for field " + field_name + " in class " + klass.getName());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception _) {
            throw new IOException("Unexpected exception " + _);
        }
    }

    private double getDoubleField(Object obj, Class klass, String field_name) throws IOException {
        try {
            Field f = ObjectOutputStream.getField(klass, field_name);
            double b = f.getDouble(obj);
            return b;
        }
        catch (IllegalArgumentException _) {
            throw new InvalidClassException("invalid requested type for field " + field_name + " in class " + klass.getName());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception _) {
            throw new IOException("Unexpected exception " + _);
        }
    }

    private float getFloatField(Object obj, Class klass, String field_name) throws IOException {
        try {
            Field f = ObjectOutputStream.getField(klass, field_name);
            float b = f.getFloat(obj);
            return b;
        }
        catch (IllegalArgumentException _) {
            throw new InvalidClassException("invalid requested type for field " + field_name + " in class " + klass.getName());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception _) {
            throw new IOException("Unexpected exception " + _);
        }
    }

    private int getIntField(Object obj, Class klass, String field_name) throws IOException {
        try {
            Field f = ObjectOutputStream.getField(klass, field_name);
            int b = f.getInt(obj);
            return b;
        }
        catch (IllegalArgumentException _) {
            throw new InvalidClassException("invalid requested type for field " + field_name + " in class " + klass.getName());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception _) {
            throw new IOException("Unexpected exception " + _);
        }
    }

    private long getLongField(Object obj, Class klass, String field_name) throws IOException {
        try {
            Field f = ObjectOutputStream.getField(klass, field_name);
            long b = f.getLong(obj);
            return b;
        }
        catch (IllegalArgumentException _) {
            throw new InvalidClassException("invalid requested type for field " + field_name + " in class " + klass.getName());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception _) {
            throw new IOException("Unexpected exception " + _);
        }
    }

    private short getShortField(Object obj, Class klass, String field_name) throws IOException {
        try {
            Field f = ObjectOutputStream.getField(klass, field_name);
            short b = f.getShort(obj);
            return b;
        }
        catch (IllegalArgumentException _) {
            throw new InvalidClassException("invalid requested type for field " + field_name + " in class " + klass.getName());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception _) {
            throw new IOException("Unexpected exception " + _);
        }
    }

    private Object getObjectField(Object obj, Class klass, String field_name, String type_code) throws IOException {
        try {
            Field f = ObjectOutputStream.getField(klass, field_name);
            ObjectStreamField of = new ObjectStreamField(f.getName(), f.getType());
            if (of.getTypeString() == null || !of.getTypeString().equals(type_code)) {
                throw new InvalidClassException("invalid type code for " + field_name + " in class " + klass.getName());
            }
            Object o = f.get(obj);
            return o;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Field getField(Class klass, String name) throws InvalidClassException {
        try {
            void e;
            Field f = klass.getDeclaredField(name);
            AccessController.doPrivileged(new PrivilegedAction(null, f){
                private /* synthetic */ ObjectOutputStream this$0;
                private /* synthetic */ Field val$f;
                {
                    this.this$0 = this$0;
                    this.finit$(parm$f);
                }

                private /* synthetic */ void finit$(Field parm$f) {
                    this.val$f = parm$f;
                }

                public Object run() {
                    this.val$f.setAccessible(true);
                    return null;
                }
            });
            return e;
        }
        catch (NoSuchFieldException e) {
            throw new InvalidClassException("no field called " + name + " in class " + klass.getName());
        }
    }

    private static Method getMethod(Class klass, String name, Class[] args) throws NoSuchMethodException {
        Method m = klass.getDeclaredMethod(name, args);
        AccessController.doPrivileged(new PrivilegedAction(null, m){
            private /* synthetic */ ObjectOutputStream this$0;
            private /* synthetic */ Method val$m;
            {
                this.this$0 = this$0;
                this.finit$(parm$m);
            }

            private /* synthetic */ void finit$(Method parm$m) {
                this.val$m = parm$m;
            }

            public Object run() {
                this.val$m.setAccessible(true);
                return null;
            }
        });
        return m;
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, Object var2);

        public abstract void write(ObjectOutput var1) throws IOException;
    }
}

