/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;

public class IndexColorModel
extends ColorModel {
    private int map_size;
    private boolean opaque;
    private int trans;
    private int[] rgb;

    private /* synthetic */ void finit$() {
        this.trans = -1;
    }

    public IndexColorModel(int bits, int size, byte[] reds, byte[] greens, byte[] blues) {
        this(bits, size, reds, greens, blues, null);
    }

    public IndexColorModel(int bits, int size, byte[] reds, byte[] greens, byte[] blues, int trans) {
        this(bits, size, reds, greens, blues, null);
        this.trans = trans;
    }

    public IndexColorModel(int bits, int size, byte[] reds, byte[] greens, byte[] blues, byte[] alphas) {
        super(bits);
        this.finit$();
        this.map_size = size;
        this.opaque = alphas == null;
        this.rgb = new int[size];
        if (alphas == null) {
            for (int i = 0; i < size; ++i) {
                this.rgb[i] = 0xFF000000 | (reds[i] & 0xFF) << 16 | (greens[i] & 0xFF) << 8 | blues[i] & 0xFF;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.rgb[i] = (alphas[i] & 0xFF) << 24 | (reds[i] & 0xFF) << 16 | (greens[i] & 0xFF) << 8 | blues[i] & 0xFF;
            }
        }
    }

    public IndexColorModel(int bits, int size, byte[] cmap, int start, boolean hasAlpha) {
        this(bits, size, cmap, start, hasAlpha, -1);
    }

    public IndexColorModel(int bits, int size, byte[] cmap, int start, boolean hasAlpha, int trans) {
        super(bits);
        this.finit$();
        this.map_size = size;
        this.opaque = hasAlpha ^ true;
        this.trans = trans;
    }

    public final int getMapSize() {
        return this.map_size;
    }

    public final int getTransparentPixel() {
        return this.trans;
    }

    public final void getReds(byte[] r) {
        this.getComponents(r, 2);
    }

    public final void getGreens(byte[] g) {
        this.getComponents(g, 1);
    }

    public final void getBlues(byte[] b) {
        this.getComponents(b, 0);
    }

    public final void getAlphas(byte[] a) {
        this.getComponents(a, 3);
    }

    private void getComponents(byte[] c, int ci) {
        int max = this.map_size < c.length ? this.map_size : c.length;
        for (int i = 0; i < max; ++i) {
            c[i] = (byte)((this.generateMask(ci) & this.rgb[i]) >> (ci * this.pixel_bits & 0x1F));
        }
    }

    public final int getRed(int pixel) {
        if (pixel < this.map_size) {
            return (this.generateMask(2) & this.rgb[pixel]) >> (2 * this.pixel_bits & 0x1F);
        }
        return 0;
    }

    public final int getGreen(int pixel) {
        if (pixel < this.map_size) {
            return (this.generateMask(1) & this.rgb[pixel]) >> (1 * this.pixel_bits & 0x1F);
        }
        return 0;
    }

    public final int getBlue(int pixel) {
        if (pixel < this.map_size) {
            return this.generateMask(0) & this.rgb[pixel];
        }
        return 0;
    }

    public final int getAlpha(int pixel) {
        if (pixel < this.map_size) {
            return (this.generateMask(3) & this.rgb[pixel]) >> (3 * this.pixel_bits & 0x1F);
        }
        return 0;
    }

    public final int getRGB(int pixel) {
        if (pixel < this.map_size) {
            return this.rgb[pixel];
        }
        return 0;
    }

    private int generateMask(int offset) {
        return (2 << (this.pixel_bits & 0x1F)) - 1 << (this.pixel_bits * offset & 0x1F);
    }
}

