/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.rmi.CORBA;

import gnu.javax.rmi.CORBA.GetDelegateInstanceException;
import java.util.HashMap;

public class DelegateFactory {
    private static HashMap cache = new HashMap(4);

    public static synchronized Object getInstance(String type) throws GetDelegateInstanceException {
        Object r = cache.get(type);
        if (r != null) {
            return r;
        }
        String dcname = System.getProperty("javax.rmi.CORBA." + type + "Class");
        if (dcname == null) {
            dcname = "gnu.javax.rmi.CORBA." + type + "DelegateImpl";
        }
        try {
            Class dclass = Class.forName(dcname);
            r = dclass.newInstance();
            cache.put(type, r);
            return r;
        }
        catch (Exception e) {
            throw new GetDelegateInstanceException("Exception when trying to get delegate instance:" + dcname, e);
        }
    }
}

