/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.io.ASN1ParsingException;
import gnu.java.security.OID;
import gnu.java.security.der.DER;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashSet;
import java.util.LinkedList;

public class X500DistinguishedName {
    public static final OID CN = new OID("2.5.4.3");
    public static final OID C = new OID("2.5.4.6");
    public static final OID L = new OID("2.5.4.7");
    public static final OID ST = new OID("2.5.4.8");
    public static final OID STREET = new OID("2.5.4.9");
    public static final OID O = new OID("2.5.4.10");
    public static final OID OU = new OID("2.5.4.11");
    public static final OID T = new OID("2.5.4.12");
    public static final OID DNQ = new OID("2.5.4.46");
    public static final OID NAME = new OID("2.5.4.41");
    public static final OID GIVENNAME = new OID("2.5.4.42");
    public static final OID INITIALS = new OID("2.5.4.43");
    public static final OID GENERATION = new OID("2.5.4.44");
    public static final OID EMAIL = new OID("1.2.840.113549.1.9.1");
    public static final OID DC = new OID("0.9.2342.19200300.100.1.25");
    public static final OID UID = new OID("0.9.2342.19200300.100.1.1");
    private String commonName;
    private String country;
    private String locality;
    private String orgUnit;
    private String organization;
    private String street;
    private String state;
    private String title;
    private String dnQualifier;
    private String surname;
    private String givenName;
    private String initials;
    private String generation;
    private String email;
    private String domainComponent;
    private String userid;
    private String nameRFC1779;
    private String nameRFC2253;
    private String nameCanonical;
    private transient byte[] encoded;

    public X500DistinguishedName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            this.parseDN(name, true);
        }
        catch (Exception e) {
            this.parseDN(name, false);
        }
    }

    public X500DistinguishedName(byte[] encoded) throws IOException {
        this(new ByteArrayInputStream(encoded));
    }

    public X500DistinguishedName(InputStream encoded) throws IOException {
        this.parseDER(encoded);
    }

    public boolean equals(Object o) {
        return this.commonName != null && this.commonName.equals(((X500DistinguishedName)o).commonName) && this.country != null && this.country.equals(((X500DistinguishedName)o).country) && this.locality != null && this.locality.equals(((X500DistinguishedName)o).locality) && this.orgUnit != null && this.orgUnit.equals(((X500DistinguishedName)o).orgUnit) && this.organization != null && this.organization.equals(((X500DistinguishedName)o).organization) && this.street != null && this.street.equals(((X500DistinguishedName)o).street) && this.state != null && this.state.equals(((X500DistinguishedName)o).state) && this.domainComponent != null && this.domainComponent.equals(((X500DistinguishedName)o).domainComponent) && this.title != null && this.title.equals(((X500DistinguishedName)o).title) && this.dnQualifier != null && this.dnQualifier.equals(((X500DistinguishedName)o).dnQualifier) && this.surname != null && this.surname.equals(((X500DistinguishedName)o).surname) && this.givenName != null && this.givenName.equals(((X500DistinguishedName)o).givenName) && this.initials != null && this.initials.equals(((X500DistinguishedName)o).initials) && this.generation != null && this.generation.equals(((X500DistinguishedName)o).generation) && this.email != null && this.email.equals(((X500DistinguishedName)o).email) && this.userid != null && this.userid.equals(((X500DistinguishedName)o).userid);
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            this.encoded = this.encodeDER();
        }
        return (byte[])this.encoded.clone();
    }

    private static String quote(String str) {
        if (str.indexOf(" ") > 0 || str.indexOf("\f") > 0 || str.indexOf("\n") > 0 || str.indexOf("\r") > 0 || str.indexOf("\t") > 0) {
            str = '\"' + str + '\"';
        }
        return str;
    }

    public String toRFC1779() {
        if (this.nameRFC1779 != null) {
            return this.nameRFC1779;
        }
        StringBuffer buf = new StringBuffer();
        if (this.commonName != null) {
            buf.append("CN=").append(X500DistinguishedName.quote(this.commonName)).append(", ");
        }
        if (this.country != null) {
            buf.append("C=").append(X500DistinguishedName.quote(this.country)).append(", ");
        }
        if (this.locality != null) {
            buf.append("L=").append(X500DistinguishedName.quote(this.locality)).append(", ");
        }
        if (this.orgUnit != null) {
            buf.append("OU=").append(X500DistinguishedName.quote(this.orgUnit)).append(", ");
        }
        if (this.organization != null) {
            buf.append("O=").append(X500DistinguishedName.quote(this.organization)).append(", ");
        }
        if (this.street != null) {
            buf.append("STREET=").append(X500DistinguishedName.quote(this.street)).append(", ");
        }
        if (this.state != null) {
            buf.append("ST=").append(X500DistinguishedName.quote(this.state)).append(", ");
        }
        if (this.title != null) {
            buf.append(T).append("=").append(X500DistinguishedName.quote(this.title)).append(", ");
        }
        if (this.dnQualifier != null) {
            buf.append(DNQ).append("=").append(X500DistinguishedName.quote(this.dnQualifier)).append(", ");
        }
        if (this.surname != null) {
            buf.append(NAME).append("=").append(X500DistinguishedName.quote(this.surname)).append(", ");
        }
        if (this.givenName != null) {
            buf.append(GIVENNAME).append("=").append(X500DistinguishedName.quote(this.givenName)).append(", ");
        }
        if (this.initials != null) {
            buf.append(INITIALS).append("=").append(X500DistinguishedName.quote(this.initials)).append(", ");
        }
        if (this.generation != null) {
            buf.append(GENERATION).append("=").append(X500DistinguishedName.quote(this.generation)).append(", ");
        }
        if (this.email != null) {
            buf.append(EMAIL).append("=").append(X500DistinguishedName.quote(this.email)).append(", ");
        }
        if (this.domainComponent != null) {
            buf.append(DC).append("=").append(X500DistinguishedName.quote(this.domainComponent)).append(", ");
        }
        if (this.userid != null) {
            buf.append(UID).append("=").append(X500DistinguishedName.quote(this.userid)).append(", ");
        }
        this.nameRFC1779 = buf.substring(0, buf.length() - 2);
        return this.nameRFC1779;
    }

    public String toRFC2253() {
        if (this.nameRFC2253 != null) {
            return this.nameRFC2253;
        }
        StringBuffer buf = new StringBuffer();
        if (this.commonName != null) {
            buf.append("CN=").append(X500DistinguishedName.quote(this.commonName)).append(",");
        }
        if (this.country != null) {
            buf.append("C=").append(X500DistinguishedName.quote(this.country)).append(",");
        }
        if (this.locality != null) {
            buf.append("L=").append(X500DistinguishedName.quote(this.locality)).append(",");
        }
        if (this.orgUnit != null) {
            buf.append("OU=").append(X500DistinguishedName.quote(this.orgUnit)).append(",");
        }
        if (this.organization != null) {
            buf.append("O=").append(X500DistinguishedName.quote(this.organization)).append(",");
        }
        if (this.street != null) {
            buf.append("STREET=").append(X500DistinguishedName.quote(this.street)).append(",");
        }
        if (this.state != null) {
            buf.append("ST=").append(X500DistinguishedName.quote(this.state)).append(",");
        }
        if (this.title != null) {
            buf.append(T).append("=").append(X500DistinguishedName.quote(this.title)).append(",");
        }
        if (this.dnQualifier != null) {
            buf.append(DNQ).append("=").append(X500DistinguishedName.quote(this.dnQualifier)).append(",");
        }
        if (this.surname != null) {
            buf.append(NAME).append("=").append(X500DistinguishedName.quote(this.surname)).append(",");
        }
        if (this.givenName != null) {
            buf.append(GIVENNAME).append("=").append(X500DistinguishedName.quote(this.givenName)).append(",");
        }
        if (this.initials != null) {
            buf.append(INITIALS).append("=").append(X500DistinguishedName.quote(this.initials)).append(",");
        }
        if (this.generation != null) {
            buf.append(GENERATION).append("=").append(X500DistinguishedName.quote(this.generation)).append(",");
        }
        if (this.email != null) {
            buf.append(EMAIL).append("=").append(X500DistinguishedName.quote(this.email)).append(",");
        }
        if (this.domainComponent != null) {
            buf.append(DC).append("=").append(X500DistinguishedName.quote(this.domainComponent)).append(",");
        }
        if (this.userid != null) {
            buf.append(UID).append("=").append(X500DistinguishedName.quote(this.userid)).append(",");
        }
        this.nameRFC2253 = buf.substring(0, buf.length() - 1);
        return this.nameRFC2253;
    }

    public String toCanonical() {
        if (this.nameCanonical != null) {
            return this.nameCanonical;
        }
        this.nameCanonical = this.toRFC2253();
        return this.nameCanonical;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getCountry() {
        return this.country;
    }

    public String getLocality() {
        return this.locality;
    }

    public String getOrganizationalUnit() {
        return this.orgUnit;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getStreet() {
        return this.street;
    }

    public String getState() {
        return this.state;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDNQualifier() {
        return this.dnQualifier;
    }

    public String getSurname() {
        return this.surname;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getInitials() {
        return this.initials;
    }

    public String getGeneration() {
        return this.generation;
    }

    public String getEmail() {
        return this.email;
    }

    public String getDomain() {
        return this.domainComponent;
    }

    public String getUserID() {
        return this.userid;
    }

    private static String unquote(String str) {
        if (str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    private void parseDN(String name, boolean rfc2253) {
        if (name.length() == 0) {
            throw new IllegalArgumentException("zero-length distinguished name");
        }
        StreamTokenizer parse = new StreamTokenizer(new StringReader(name));
        parse.resetSyntax();
        parse.wordChars(0, 126);
        parse.ordinaryChar(35);
        parse.ordinaryChar(44);
        parse.ordinaryChar(61);
        parse.ordinaryChar(60);
        parse.ordinaryChar(62);
        parse.ordinaryChar(59);
        parse.ordinaryChar(92);
        parse.quoteChar(34);
        String attrib = null;
        String value = null;
        int lastToken = 44;
        while (true) {
            int token;
            try {
                token = parse.nextToken();
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException();
            }
            switch (token) {
                case -3: {
                    if (lastToken == 44 || lastToken == 43 || !rfc2253 && lastToken == 59) {
                        attrib = parse.sval.trim();
                        break;
                    }
                    if (lastToken == 61) {
                        value = X500DistinguishedName.unquote(parse.sval.trim());
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 34: {
                    if (lastToken == 61) {
                        value = parse.sval;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 59: {
                    if (rfc2253) {
                        throw new IllegalArgumentException();
                    }
                }
                case 43: 
                case 44: {
                    if (attrib == null || value == null) {
                        throw new IllegalArgumentException("extraneous separator");
                    }
                    try {
                        this.setAttribute(new OID(attrib), value);
                    }
                    catch (Exception x) {
                        this.setAttribute(attrib, value);
                    }
                    attrib = null;
                    value = null;
                    break;
                }
                case 61: {
                    break;
                }
                case -1: {
                    return;
                }
                default: {
                    throw new IllegalArgumentException("unknown token " + (char)token + " (" + token + ")");
                }
            }
            lastToken = token;
        }
    }

    private void parseDER(InputStream in) throws IOException {
        int len2;
        DERReader der = new DERReader(in);
        DERValue name = der.read();
        if (!name.isConstructed()) {
            throw new ASN1ParsingException("badly formed Name");
        }
        for (int len = 0; len < name.getLength(); len += len2 + 1 + DERWriter.definiteEncodingSize(name.getLength())) {
            DERValue atav;
            DERValue rdn = der.read();
            if (rdn.getValue() != DER.CONSTRUCTED_VALUE) {
                throw new ASN1ParsingException("badly formed RDNSequence");
            }
            for (len2 = 0; len2 < rdn.getLength(); len2 += 1 + atav.getLength() + DERWriter.definiteEncodingSize(atav.getLength())) {
                atav = der.read();
                if (atav.getValue() != DER.CONSTRUCTED_VALUE) {
                    throw new ASN1ParsingException("badly formed AttributeTypeAndValue");
                }
                OID atype = (OID)der.read().getValue();
                String aval = (String)der.read().getValue();
                this.setAttribute(atype, aval);
            }
        }
    }

    private byte[] encodeDER() {
        try {
            LinkedList atav;
            HashSet rdn;
            LinkedList name = new LinkedList();
            if (this.commonName != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, CN));
                atav.add(new DERValue(19, this.commonName));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.country != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, C));
                atav.add(new DERValue(19, this.country));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.locality != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, L));
                atav.add(new DERValue(19, this.locality));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.orgUnit != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, OU));
                atav.add(new DERValue(19, this.orgUnit));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.organization != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, O));
                atav.add(new DERValue(19, this.organization));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.street != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, STREET));
                atav.add(new DERValue(19, this.street));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.state != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, ST));
                atav.add(new DERValue(19, this.state));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.title != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, T));
                atav.add(new DERValue(19, this.title));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.dnQualifier != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, DNQ));
                atav.add(new DERValue(19, this.dnQualifier));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.surname != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, NAME));
                atav.add(new DERValue(19, this.surname));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.givenName != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, GIVENNAME));
                atav.add(new DERValue(19, this.givenName));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.initials != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, INITIALS));
                atav.add(new DERValue(19, this.initials));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.generation != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, GENERATION));
                atav.add(new DERValue(19, this.generation));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.email != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, EMAIL));
                atav.add(new DERValue(19, this.email));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.domainComponent != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, DC));
                atav.add(new DERValue(19, this.domainComponent));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            if (this.userid != null) {
                rdn = new HashSet();
                atav = new LinkedList();
                atav.add(new DERValue(6, UID));
                atav.add(new DERValue(19, this.userid));
                rdn.add(new DERValue(48, atav));
                name.add(new DERValue(49, rdn));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DERWriter.write(out, new DERValue(48, name));
            return out.toByteArray();
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
    }

    private void setAttribute(String atype, String aval) {
        if (atype.equals("CN")) {
            this.commonName = aval;
        } else if (atype.equals("C")) {
            this.country = aval;
        } else if (atype.equals("L")) {
            this.locality = aval;
        } else if (atype.equals("ST")) {
            this.state = aval;
        } else if (atype.equals("STREET")) {
            this.street = aval;
        } else if (atype.equals("O")) {
            this.organization = aval;
        } else if (atype.equals("OU")) {
            this.orgUnit = aval;
        } else if (atype.equals("T")) {
            this.title = aval;
        } else if (atype.equals("DNQ") || atype.equals("DNQUALIFIER")) {
            this.dnQualifier = aval;
        } else if (atype.equals("SURNAME")) {
            this.surname = aval;
        } else if (atype.equals("GIVENNAME")) {
            this.givenName = aval;
        } else if (atype.equals("INITIALS")) {
            this.initials = aval;
        } else if (atype.equals("GENERATION")) {
            this.generation = aval;
        } else if (atype.equals("EMAILADDRESS")) {
            this.email = aval;
        } else if (atype.equals("DC")) {
            this.domainComponent = aval;
        } else if (atype.equals("UID")) {
            this.userid = aval;
        } else {
            throw new IllegalArgumentException("unknown attribute " + atype);
        }
    }

    private void setAttribute(OID atype, String aval) {
        if (atype.equals(CN)) {
            this.commonName = aval;
        } else if (atype.equals(C)) {
            this.country = aval;
        } else if (atype.equals(L)) {
            this.locality = aval;
        } else if (atype.equals(ST)) {
            this.state = aval;
        } else if (atype.equals(STREET)) {
            this.street = aval;
        } else if (atype.equals(O)) {
            this.organization = aval;
        } else if (atype.equals(OU)) {
            this.orgUnit = aval;
        } else if (atype.equals(T)) {
            this.title = aval;
        } else if (atype.equals(DNQ)) {
            this.dnQualifier = aval;
        } else if (atype.equals(NAME)) {
            this.surname = aval;
        } else if (atype.equals(GIVENNAME)) {
            this.givenName = aval;
        } else if (atype.equals(INITIALS)) {
            this.initials = aval;
        } else if (atype.equals(GENERATION)) {
            this.generation = aval;
        } else if (atype.equals(EMAIL)) {
            this.email = aval;
        } else if (atype.equals(DC)) {
            this.domainComponent = aval;
        } else if (atype.equals(UID)) {
            this.userid = aval;
        } else {
            throw new IllegalArgumentException("unknown attribute " + atype);
        }
    }
}

