/*
 * kernel/power/ui.h
 *
 * Copyright 2004-2006 Nigel Cunningham <nigel@suspend2.net>
 */

extern int suspend_default_console_level;

enum {
	DONT_CLEAR_BAR,
	CLEAR_BAR
};

enum {
	/* Userspace -> Kernel */
	USERUI_MSG_ABORT = 0x11,
	USERUI_MSG_SET_STATE = 0x12,
	USERUI_MSG_GET_STATE = 0x13,
	USERUI_MSG_GET_DEBUG_STATE = 0x14,
	USERUI_MSG_SET_DEBUG_STATE = 0x15,
	USERUI_MSG_SET_PROGRESS_GRANULARITY = 0x17,
	USERUI_MSG_SPACE = 0x18,

	/* Kernel -> Userspace */
	USERUI_MSG_MESSAGE = 0x21,
	USERUI_MSG_PROGRESS = 0x22,
	USERUI_MSG_REDRAW = 0x25,
	USERUI_MSG_KEYPRESS = 0x26,
	USERUI_MSG_DEBUG_STATE = 0x29,

	USERUI_MSG_MAX,
};

struct userui_msg_params {
	unsigned long a, b, c, d;
	char text[255];
};

#if defined(CONFIG_NET)

extern unsigned long suspend_update_status(unsigned long value, unsigned long maximum,
		const char *fmt, ...);
extern void suspend_prepare_status (int clearbar, const char *fmt, ...);
extern void suspend_cond_pause(int pause, char *message);
extern void abort_suspend(const char *fmt, ...);
extern void suspend_prepare_console(void);
extern void suspend_cleanup_console(void);
extern void userui_redraw(void);

#else
static inline char suspend_wait_for_keypress(int timeout)
{
	return 0;
} 

static inline unsigned long suspend_update_status(unsigned long value, unsigned long maximum,
		const char *fmt, ...)
{
	return maximum;
} 

static inline void __suspend_message(unsigned long section, unsigned long level,
		int normally_logged,
		const char *fmt, ...)  { }
static inline void suspend_prepare_status(int clearbar, const char *fmt, ...) { }
static inline void suspend_cond_pause(int pause, char *message) { }
static inline void abort_suspend(const char *fmt, ...) { }
static inline void suspend_prepare_console(void) { }
static inline void suspend_cleanup_console(void) { }
static inline void userui_redraw(void) { }
#endif
