/*
 * kernel/power/suspend.h
 *
 * Copyright (C) 2004-2006 Nigel Cunningham <nigel@suspend2.net>
 *
 * This file is released under the GPLv2.
 *
 * It contains declarations used throughout swsusp.
 *
 */

#ifndef KERNEL_POWER_SUSPEND_H
#define KERNEL_POWER_SUSPEND_H

#include <linux/delay.h>
#include <linux/bootmem.h>

#define SUSPEND_CORE_VERSION "2.2.8"
#define name_suspend "Suspend2 " SUSPEND_CORE_VERSION ": "

extern __nosavedata suspend_pagedir_t *pagedir_nosave;
extern int save_image_part1(void);
extern int suspend_atomic_restore(void);
extern void suspend_main(int had_pmsem);

extern unsigned long suspend_orig_mem_free;

#define KB(x) ((x) << (PAGE_SHIFT - 10))
#define MB(x) ((x) >> (20 - PAGE_SHIFT))

extern int suspend_start_anything(int starting_cycle);
extern void suspend_finish_anything(int finishing_cycle);

#ifdef CONFIG_PM_DEBUG
#define set_debug_state(bit) (test_and_set_bit(bit, &suspend_debug_state))
#define clear_debug_state(bit) (test_and_clear_bit(bit, &suspend_debug_state))
#else
#define set_debug_state(bit) (0)
#define clear_debug_state(bit) (0)
#endif

#define set_result_state(bit) (test_and_set_bit(bit, &suspend_result))
#define clear_result_state(bit) (test_and_clear_bit(bit, &suspend_result))

enum {
	SUSPEND_ABORTED,
	SUSPEND_ABORT_REQUESTED,
	SUSPEND_NOSTORAGE_AVAILABLE,
	SUSPEND_INSUFFICIENT_STORAGE,
	SUSPEND_FREEZING_FAILED,
	SUSPEND_UNEXPECTED_ALLOC,
	SUSPEND_KEPT_IMAGE,
	SUSPEND_WOULD_EAT_MEMORY,
	SUSPEND_UNABLE_TO_FREE_ENOUGH_MEMORY,
	SUSPEND_ENCRYPTION_SETUP_FAILED,
	SUSPEND_PM_SEM,
	SUSPEND_DEVICE_REFUSED,
};

extern unsigned int nr_suspends;
extern char resume2_file[256];
#endif
