/*
 * kernel/power/prepare_image.h
 *
 * Copyright (C) 2003-2006 Nigel Cunningham <nigel@suspend.net>
 *
 * This file is released under the GPLv2.
 *
 */

#include <asm/sections.h>

extern int suspend_prepare_image(void);
extern void suspend_recalculate_image_contents(int storage_available);
extern long real_nr_free_pages(void);
extern long image_size_limit;
extern long pageset1_sizelow, pageset2_sizelow;

struct pageset_sizes_result {
	long size1; /* Can't be unsigned - breaks MAX function */
	long size1low;
	long size2;
	long size2low;
};

#ifdef CONFIG_CRYPTO
extern int suspend_expected_compression_ratio(void);
#else
static inline int suspend_expected_compression_ratio(void)
{
	return 0;
};
#endif

#define MIN_FREE_RAM 2000
#define MIN_EXTRA_PAGES_ALLOWANCE 500

extern long extra_pd1_pages_allowance;
extern long storage_needed(int use_ecr, int ignore_extra_p1_allowance);
extern long ram_to_suspend(void);

#ifdef CONFIG_DEBUG_RODATA
static inline struct page* rodata_start_page(void)
{
	return virt_to_page(&__start_rodata);
}

static inline struct page* rodata_end_page(void)
{
	return virt_to_page(&__end_rodata);
}

#else
static inline struct page* rodata_start_page(void)
{
	return NULL;
}

static inline struct page* rodata_end_page(void)
{
	return NULL;
}
#endif

#ifdef CONFIG_PPC
static inline struct page* rotext_start_page(void)
{
	return virt_to_page(PAGE_OFFSET);
}
#else
static inline struct page* rotext_start_page(void)
{
	return virt_to_page(_text);
}
#endif

static inline struct page* rotext_end_page(void)
{
	return virt_to_page(_etext);
}

static inline struct page* nosave_start_page(void)
{
	return virt_to_page(&__nosave_begin);
}

static inline struct page* nosave_end_page(void)
{
	return virt_to_page(&__nosave_end);
}
