/* Freezer declarations */

#define FREEZER_ON 0
#define ABORT_FREEZING 1
#define FREEZING_COMPLETE 2

#define FREEZER_KERNEL_THREADS 0
#define FREEZER_ALL_THREADS 1

#ifdef CONFIG_PM
extern unsigned long freezer_state;

#define test_freezer_state(bit) test_bit(bit, &freezer_state)
#define set_freezer_state(bit) set_bit(bit, &freezer_state)
#define clear_freezer_state(bit) clear_bit(bit, &freezer_state)

#define freezer_is_on() (test_freezer_state(FREEZER_ON))

#else

#define test_freezer_state(bit) (0)
#define set_freezer_state(bit) do { } while(0)
#define clear_freezer_state(bit) do { } while(0)

#define freezer_is_on() (0)

#endif
