#!/bin/sh

# Build script template [20060120]

### Configurations (edit below):

PREFIX=/usr
DOCPREFIX=${DOCPREFIX:-/usr/share/doc}

ORIGVER=3.4.7
ORIGVER2=823
PKGVER=P1
PACKAGE=ninix_aya-${ORIGVER/-/_}-i386-$PKGVER.tgz

SRCURL1=http://osdn.dl.sourceforge.jp/ninix-aya/15966/ninix-aya-3.4.7.tgz
SRC1=ninix-aya-$ORIGVER.tgz
SRCDIR1=ninix-aya-$ORIGVER
PATCH11=patches/ninix-aya-2.6-plamodefault.patch
SRCURL2=http://jaist.dl.sourceforge.net/sourceforge/kawari/kawari-823.zip
SRC2=kawari-$ORIGVER2.zip
SRCDIR2=kawari-$ORIGVER2
SRCURL3=http://www.geocities.co.jp/SiliconValley-Cupertino/7565/archive/sstpsend.tar.gz
SRC3=sstpsend.tar.gz
PATCH31=patches/sstpsend.patch
SRCURL4=http://www.geocities.co.jp/SiliconValley-Cupertino/7565/archive/ninix-balloon-v13.zip
SRC4=ninix-balloon-v13.zip
SRC5=$SRCDIR1/dot.http_proxy
SRC6=patches/README.ninix

INITSCRIPTS=

if [ ! -f $SRC1 ]; then
    wget -O $SRC1 $SRCURL1
fi
if [ ! -f $SRC2 ]; then
    wget -O $SRC2 $SRCURL2
fi
if [ ! -f $SRC3 ]; then
    wget -O $SRC3 $SRCURL3
fi
if [ ! -f $SRC4 ]; then
    wget -O $SRC4 $SRCURL4
fi

### Common preparations:

TMPDIR=`pwd`
SRCROOT=`pwd`
BUILDROOT=$TMPDIR/.work
PKGROOT=$BUILDROOT/pkgroot
mkdir -p $BUILDROOT
chown 0.0 $BUILDROOT
chmod 0755 $BUILDROOT

### Build and install (edit below):

cd $BUILDROOT
tar zxf $SRCROOT/$SRC1

cd $SRCDIR1
cat $SRCROOT/$PATCH11 | patch -sp1
make prefix=$PREFIX python=/usr/bin/python || exit 1
make install DESTDIR=$PKGROOT prefix=$PREFIX docdir=$PKGROOT$DOCPREFIX/$SRCDIR1 python=/usr/bin/python || exit 1

cd $BUILDROOT
unzip -q $SRCROOT/$SRC2

cd $SRCDIR2
(
    cd build/src
    make -f gcc.mak MACH_TYPE=linux SAORI_NATIVE=no SAORI_PYTHON=yes SHIORI_PYTHON=yes LDFLAGS_linux='-L/usr/lib/python2.3/config' SHIOSRC_python=shiori/py_shiori.cpp ../mach/linux/libshiori.so || exit 1
    cp ../mach/linux/libshiori.so $PKGROOT$PREFIX/lib/ninix/_kawari8.so
)
mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR2
cp readme.1st license.txt $PKGROOT$DOCPREFIX/$SRCDIR2
cp -R document $PKGROOT$DOCPREFIX/$SRCDIR2/html

cd $BUILDROOT
tar zxf $SRCROOT/$SRC3

cat $SRCROOT/$PATCH31 | patch -s
cp sstpsend.py $PKGROOT$PREFIX/bin/sstpsend
chmod 755 $PKGROOT$PREFIX/bin/sstpsend

mkdir -p $PKGROOT$PREFIX/share/ninix/default
cp $SRCROOT/$SRC4 $BUILDROOT/$SRC5 $PKGROOT$PREFIX/share/ninix/default

cp $SRCROOT/$SRC6 $PKGROOT$DOCPREFIX/$SRCDIR1

## Common packaging sequence:

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/build
cp $SRCROOT/$0 $PKGROOT$DOCPREFIX/$SRCDIR1/build
if [ -d $SRCROOT/patches ]; then
    mkdir $PKGROOT$DOCPREFIX/$SRCDIR1/build/patches
    cp $SRCROOT/patches/* $PKGROOT$DOCPREFIX/$SRCDIR1/build/patches
fi

if [ -d $PKGROOT$PREFIX/bin ]; then
    strip $PKGROOT$PREFIX/bin/*
fi
if [ -d $PKGROOT$PREFIX/sbin ]; then
    strip $PKGROOT$PREFIX/sbin/*
fi
if [ -d $PKGROOT$PREFIX/libexec ]; then
    find $PKGROOT$PREFIX/libexec -type f -exec strip {} ';'
fi
if [ -d $PKGROOT$PREFIX/lib ]; then
    find $PKGROOT$PREFIX/lib -type f -name '*.so*' -exec strip -g {} ';'
    find $PKGROOT$PREFIX/lib -mindepth 2 '(' -name '*.a' -o -name '*.la' ')' -exec rm {} ';'
fi
for docdir in $PKGROOT$DOCPREFIX/*; do
    if [ -d $docdir ]; then
	gzip $docdir/*
    fi
done
if [ -d $PKGROOT$PREFIX/man ]; then
    if [ ! -d $PKGROOT$PREFIX/share ]; then
	mkdir $PKGROOT$PREFIX/share
    fi
    ( cd $PKGROOT$PREFIX; tar cf - man ) | ( cd $PKGROOT$PREFIX/share; tar xfp - )
    rm -rf $PKGROOT$PREFIX/man
fi
if [ -d $PKGROOT$PREFIX/share/man ]; then
    symlinks=
    for l in `find $PKGROOT$PREFIX/share/man -type l -print`; do
	symlinks="$symlinks $l:`perl -e "print readlink '$l';"`"
	rm -f $l
    done
    gzip $PKGROOT$PREFIX/share/man/man?/*
    for l in $symlinks; do
	ln -s ${l#*:}.gz ${l%%:*}.gz
    done
fi

if [ -r $PKGROOT$PREFIX/info/dir ]; then
    rm -f $PKGROOT$PREFIX/info/dir
    echo "if [ -x /usr/bin/install-info ]; then" >> $BUILDROOT/initpkg
    echo "  ( cd $PREFIX/info" >> $BUILDROOT/initpkg
    for infofile in $PKGROOT$PREFIX/info/*.info; do
	echo "    /usr/bin/install-info ${infofile##*/} dir" >> $BUILDROOT/initpkg
    done
    echo "  )" >> $BUILDROOT/initpkg
    echo "fi" >> $BUILDROOT/initpkg
fi
for i in $INITSCRIPTS; do
    cat $SRCROOT/$i >> $BUILDROOT/initpkg
done
if [ -s $BUILDROOT/initpkg ]; then
    mkdir $PKGROOT/install
    mv -f $BUILDROOT/initpkg $PKGROOT/install
fi

cd $PKGROOT
makepkg $PACKAGE

cp -f $PACKAGE $SRCROOT
cd $SRCROOT
rm -rf $BUILDROOT
