# -*- coding: ascii -*-
#
#  Copyright (C) 2003-2005 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import sys
import os
import md5

if os.environ.has_key('DISPLAY'):
    import gtk

def get_translucent_cmap():
    try:
        visual = gtk.gdk.visual_get_best_with_depth(32) # RGBA
        return gtk.gdk.Colormap(visual, True)
    except:
        sys.stderr.write("Translucency is not available on this Xserver.\n")
        return None

def create_blank_pixbuf(width, height):
    pixbuf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, width, height)
    pixbuf.fill(0xffffffffL)
    return pixbuf

def create_pixbuf_from_DGP_file(path):
    head, tail = os.path.split(path)
    filename = tail
    m_half = md5.new(filename[:len(filename) / 2]).hexdigest()
    m_full = md5.new(filename).hexdigest()
    tmp = m_full + filename
    key = ''
    j = 0
    for i in range(len(tmp)):
        value = ord(tmp[i]) ^ ord(m_half[j])
        if not value:
            break
        key += chr(value)
        j += 1
        if j >= len(m_half):
            j = 0
    key_length = len(key)
    if key_length == 0:
        print filename + ' generates a null key.'
        pixbuf = gtk.gdk.pixbuf_new_from_file(filename)
        return pixbuf # not encrypted
    key = key[1:] + key[0]
    key_pos = 0
    file = open(path, 'r')
    loader = gtk.gdk.PixbufLoader("png")
    while 1:
        c = file.read(1)
        if c == '':
            break
        loader.write(chr(ord(c) ^ ord(key[key_pos])), 1)
        key_pos += 1
        if key_pos >= key_length:
            key_pos = 0
    file.close()
    pixbuf = loader.get_pixbuf()
    loader.close()
    return pixbuf

def add_alpha_from_PNA_file(pixbuf, path):
    assert pixbuf.get_has_alpha()
    pna_pixbuf = gtk.gdk.pixbuf_new_from_file(path)
    pna_array = pna_pixbuf.get_pixels_array()
    assert pna_pixbuf.get_bits_per_sample() / 8 == 1 ## FIXME
    pixbuf_array = pixbuf.get_pixels_array()
    width = pixbuf.get_width()
    height = pixbuf.get_height()
    for i in range(height):
        for j in range(width):
            pixbuf_array[i][j][3] = pna_array[i][j][0]

def create_pixbuf_from_file(path, type='pnr', use_pna=0):
    head, tail = os.path.split(path)
    basename, suffix = os.path.splitext(tail)
    if suffix == '.dgp':
        pixbuf = create_pixbuf_from_DGP_file(path)
    else:
        pixbuf = gtk.gdk.pixbuf_new_from_file(path)
    if type == 'pnr':
        array = pixbuf.get_pixels_array()
        if not pixbuf.get_has_alpha():
            r, g, b = array[0][0]
            pixbuf = pixbuf.add_alpha(True, chr(r), chr(g), chr(b))
        else:
            r, g, b, a = array[0][0]
            width = pixbuf.get_width()
            height = pixbuf.get_height()
            for i in range(height):
                for j in range(width):
                    if array[i][j][0] == r and \
                       array[i][j][1] == g and \
                       array[i][j][2] == b and \
                       array[i][j][3] == a:
                        for k in range(4):
                            array[i][j][k] = 0
    if use_pna:
        path = os.path.join(head, basename + '.pna')
        if os.path.exists(path):
            add_alpha_from_PNA_file(pixbuf, path)
    return pixbuf

def create_pixmap_from_file(path):
    pixbuf = create_pixbuf_from_file(path)
    pixmap, mask = pixbuf.render_pixmap_and_mask(1)
    return pixmap, mask

def reduce_pixbuf(target_pixbuf, pixbuf, dest_x, dest_y):
    if pixbuf.get_has_alpha():
        dest_w = target_pixbuf.get_width()
        dest_h = target_pixbuf.get_height()
        target_array = target_pixbuf.get_pixels_array()
        array = pixbuf.get_pixels_array()
        w = pixbuf.get_width()
        h = pixbuf.get_height()
        for i in range(h):
            for j in range(w):
                if array[i][j][3] == 0: # alpha
                    x = j + dest_x
                    y = i + dest_y
                    if x >= 0 and x < dest_w and \
                       y >= 0 and y < dest_h:
                        for k in range(4):
                            target_array[y][x][k] = 0
    return target_pixbuf

class TranslucentWindow(gtk.Window):

    def __init__(self, type=gtk.WINDOW_TOPLEVEL):
        translucent_cmap = get_translucent_cmap()
        if translucent_cmap:
            self.translucency = 1
        else:
            self.translucency = 0
        if self.translucency:
            gtk.widget_push_colormap(translucent_cmap)
        gtk.Window.__init__(self, type)
        if self.translucency:
            gtk.widget_pop_colormap()
            self.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse("black"))
