# -*- coding: ascii -*-
#
#  Copyright (C) 2003-2005 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2003 by Shun-ichi TAHARA <jado@flowernet.gr.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os
import re
import types

if os.environ.has_key("DISPLAY"):
    import gtk
    import ninix.pix

import ninix.sakura
import ninix.surface

class Menu:

    def __init__(self, ghost, surface):
        self.__ghost = ghost
        self.__surface = surface
        ui_info = '''
        <ui>
          <popup name='popup'>
            <menu action='Portal'>
            </menu>
            <menu action='Recommend'>
            </menu>
            <separator/>
            <menu action='File'>
            <menuitem action='Update'/>
            <menuitem action='Vanish'/>
            <menuitem action='Reload'/>
            <menuitem action='Settings'/>
            <menuitem action='Manager'/>
            <menuitem action='Usage'/>
            <menuitem action='Version'/>
            <menuitem action='Exit'/>
            </menu>
            <menu action='Change'>
            </menu>
            <menu action='Summon'>
            </menu>
            <menu action='Shell'>
            </menu>
            <menu action='Balloon'>
            </menu>
            <separator/>
            <menuitem action='Scaling'/>
            <menu action='Costume'>
            </menu>
            <menuitem action='Stick'/>
            <menuitem action='Wait'/>
            <separator/>
            <menu action='Nekodorif'>
            </menu>
            <menu action='Kinoko'>
            </menu>
            <menu action='Plugin'>
            </menu>
          </popup>
        </ui>
        '''
        self.__menu_list = { ## FIXME
            'Portal': [('Portal', None, _('Portal sites(_P)'), None),
                       None, 1, 1],
            'Recommend': [('Recommend', None, _('Recommend sites(_R)'), None),
                          None, 1, 1],
            'File': [('File', None, _('File(_F)'), None),
                     None, 1, 1],
            'File/Update': [('Update', None, _('Network Update(_U)'), None,
                             '', lambda *a: self.__ghost.network_update()),
                            None, 1, 1],
            'File/Vanish': [('Vanish', None, _('Vanish(_F)'), None,
                             '', lambda *a: self.__ghost.vanish()),
                            None, 1, 1],
            'File/Reload': [('Reload', None, _('Reload(_L)'), None,
                             '', lambda *a: self.__ghost.reload()),
                            None, 1, 1],
            'File/Settings': [('Settings', None, _('Settings...(_O)'), None,
                               '', lambda *a: self.__ghost.edit_preferences()),
                              None, 1, 1],
            'File/Manager': [('Manager', None, _('Ghost Manager(_M)'), None,
                              '', lambda *a: self.__ghost.open_ghost_manager()),
                             None, 1, 1],
            'File/Usage': [('Usage', None, _('Usage graph(_A)'), None,
                            '', lambda *a: self.__ghost.show_usage()),
                           None, 1, 1],
            'File/Version': [('Version', None, _('Version(_V)'), None,
                              '', lambda *a: self.__ghost.about()),
                             None, 1, 1],
            'File/Exit': [('Exit', None, _('Exit(_Q)'), None,
                           '', lambda *a: self.__ghost.close()),
                          None, 1, 1],
            'Change': [('Change', None, _('Change(_G)'), None),
                       None, 1, 1],
            'Summon': [('Summon', None, _('Summon(_X)'), None),
                       None, 1, 1],
            'Shell': [('Shell', None, _('Shell(_S)'), None),
                      None, 1, 1],
            'Balloon': [('Balloon', None, _('Balloon(_B)'), None),
                        None, 1, 1],
            'Scaling': [('Scaling', None, _('Surface Scaling(_S)'), None),
                        None, 1, 1],
            'Costume': [('Costume', None, _('Costume(_C)'), None),
                        None, 1, 1],
            'Stick': [('Stick', None, _('Stick(_Y)'), None,
                       '', self.__surface.window_stick, False),
                      None, 1, 1],
            'Wait': [('Wait', None, _('Script Wait(_W)'), None),
                     None, 1, 1],
            'Nekodorif': [('Nekodorif', None, _('Nekodorif(_N)'), None),
                          None, 1, 1],
            'Kinoko': [('Kinoko', None, _('Kinoko(_K)'), None),
                       None, 1, 1],
            'Plugin': [('Plugin', None, _('Plugin(_P)'), None),
                       None, 1, 1],
            }
        self.__pixmap = None
        self.__pixma_with_sidebar = None
        self.__ghost_list = None
        self.__shell_list = None
        self.__balloon_list = None
        self.__plugin_list = None
        self.__fontcolor = "#000000" ## FIXME
        self.__sidebar_width = 0
        actions = gtk.ActionGroup("Actions")
        entry = []
        for key in self.__menu_list.keys():
            if key != 'Stick':
                entry.append(self.__menu_list[key][0])
        actions.add_actions(tuple(entry))
        actions.add_toggle_actions(tuple([self.__menu_list['Stick'][0]]))
        self.ui_manager = gtk.UIManager()
        self.ui_manager.insert_action_group(actions, 0)
        self.ui_manager.add_ui_from_string(ui_info)
        self.__popup_menu = self.ui_manager.get_widget("/popup")
        self.__create_scale_menu()
        self.__create_speed_menu()

    def __create_scale_menu(self):
        menu = gtk.Menu()
        item = gtk.CheckMenuItem(_('Scale Balloon'))
        if self.__ghost.get_balloon_scalling():
            item.set_active(True)
        else:
            item.set_active(False)
        item.connect("activate", self.toggle_balloon_scalling)
        menu.add(item)
        item.show()
        item = gtk.SeparatorMenuItem()
        menu.add(item)
        item.show()
        group = None
        for label, value in ninix.surface.range_scale:
            item = group = gtk.RadioMenuItem(group, label)
            item.set_name("popup menu item")
            item.connect("activate", self.select_surface_scale, value)
            if value == self.__ghost.get_surface_scale():
                item.set_active(True)
            item.show()
            menu.append(item)
        menuitem = self.ui_manager.get_widget('/popup/' + 'Scaling')
        menuitem.set_submenu(menu)
        self.__menu_list['Scaling'][3] = 1 # changed

    def __create_speed_menu(self):
        menu = gtk.Menu()
        group = None
        for label, value in ninix.sakura.range_script_speed:
            item = group = gtk.RadioMenuItem(group, unicode(label, 'utf-8'))
            item.set_name("popup menu item")
            item.connect("activate", self.select_script_speed, value)
            if value == self.__surface.sakura.get_script_speed(): ## FIXME
                item.set_active(True)
            item.show()
            menu.append(item)
        menuitem = self.ui_manager.get_widget('/popup/' + 'Wait')
        menuitem.set_submenu(menu)
        self.__menu_list['Wait'][3] = 1 # changed

    def select_surface_scale(self, widget, value):
        ##print "select_surface_scale", value
        self.__ghost.set_surface_scale(value)

    def select_script_speed(self, widget, value):
        ##print "select_script_speed", value
        self.__surface.sakura.set_script_speed(value) ## FIXME

    def toggle_balloon_scalling(self, widget, value=None):
        if widget.get_active():
            balloon_scalling = 1
        else:
            balloon_scalling = 0
        self.__ghost.set_balloon_scalling(balloon_scalling)

    def set_fontcolor(self, r, g ,b):
        self.__fontcolor = "#%02x%02x%02x" % (r, g, b)

    def set_pixmap(self, path_background, path_sidebar):
        pixbuf = None
        if path_background and os.path.exists(path_background):
            try:
                pixbuf = ninix.pix.create_pixbuf_from_file(path_background, 'png')
            except:
                pixbuf = None
        if pixbuf == None:
            self.__pixmap = None
            self.__pixmap_with_sidebar = None
            return
        pixmap, mask = pixbuf.render_pixmap_and_mask(255)
        self.__pixmap = pixmap
        pixbuf_sidebar = None
        if path_sidebar and os.path.exists(path_sidebar):
            try:
                pixbuf_sidebar = ninix.pix.create_pixbuf_from_file(path_sidebar, 'png')
            except:
                pixbuf_sidebar = None
        if pixbuf_sidebar:
            width = pixbuf.get_width()
            height = pixbuf.get_height()
            sidebar_width = pixbuf_sidebar.get_width()
            sidebar_height = pixbuf_sidebar.get_height()
            new_pixbuf = gtk.gdk.Pixbuf(
                pixbuf.get_colorspace(), False,
                pixbuf.get_bits_per_sample(),
                width + sidebar_width, max(height, sidebar_height))
            pixbuf.composite(
                new_pixbuf,
                0, 0, new_pixbuf.get_width(), new_pixbuf.get_height(),
                width - 1, height - 1,
                1.0, 1.0, gtk.gdk.INTERP_BILINEAR, 255)
            pixbuf_sidebar.composite(
                new_pixbuf,
                0, 0, sidebar_width, sidebar_height,
                0, 0,
                1.0, 1.0, gtk.gdk.INTERP_BILINEAR, 255)
            pixbuf.composite(
                new_pixbuf,
                sidebar_width, 0, width, height,
                0, 0,
                1.0, 1.0, gtk.gdk.INTERP_BILINEAR, 255)
            pixbuf = new_pixbuf
            self.__sidebar_width = sidebar_width
            pixmap, mask = pixbuf.render_pixmap_and_mask(255)
        else:
            self.__sidebar_width = 0
        self.__pixmap_with_sidebar = pixmap

    def __set_mayuna_menu(self, side):
        if len(self.__mayuna_menu) > side and \
           self.__mayuna_menu[side] != None:
            menuitem = self.ui_manager.get_widget('/popup/' + 'Costume')
            menuitem.set_submenu(self.__mayuna_menu[side])
            if self.__pixmap:
                tearoff = self.__mayuna_menu[side].get_children()[0]
                tearoff.realize()
                tearoff.window.set_back_pixmap(self.__pixmap, False)
            self.__set_visible('Costume', 1)
        else:
            self.__set_visible('Costume', 0)

    def create_mayuna_menu(self, mayuna_menu):
        self.__mayuna_menu = []
        for side, index in [('sakura', 0), ('kero', 1)]:
            if mayuna_menu[side]:
                self.__mayuna_menu.append(gtk.Menu())
                item = gtk.TearoffMenuItem()
                item.show()
                self.__mayuna_menu[index].append(item)
                for j in range(len(mayuna_menu[side])):
                    key, name, state = mayuna_menu[side][j]
                    if key != '-':
                        item = gtk.CheckMenuItem(name)
                        item.set_name("popup menu item")
                        if state:
                            item.set_active(True)
                        else:
                            item.set_active(False)
                        item.connect("activate", self.__surface.toggle_bind, (index, key))
                    else:
                        item = gtk.SeparatorMenuItem()
                    item.show()
                    self.__mayuna_menu[index].append(item)
            else:
                self.__mayuna_menu.append(None)

    __re_shortcut = re.compile(r'&(?=[\x21-\x7e])')

    def __modify_shortcut(self, caption):
        return self.__re_shortcut.sub('_', caption)

    __re_mnemonic = re.compile(r'\(_.\)|_')

    def __cut_mnemonic(self, caption):
        return self.__re_mnemonic.sub('', caption)

    __ui = {'File/Update': ([["updatebuttoncaption", "updatebutton.caption"], ["updatebuttoncaption", "updatebutton.caption"]], "(_U)", [[],[]]),
            'File/Vanish': ([["vanishbuttoncaption", "vanishbutton.caption"], ["vanishbuttoncaption", "vanishbutton.caption"]], "(_F)", [["vanishbuttonvisible", "vanishbutton.visible"], ["vanishbuttonvisible", "vanishbutton.visible"]]),
            'Portal': ([["sakura.portalbuttoncaption", "portalrootbutton.caption"], []], "(_P)", [[], None]),
            'Recommend': ([["sakura.recommendbuttoncaption", "recommendrootbutton.caption"], ["kero.recommendbuttoncaption"]], "(_R)", [[], []]),
           }

    def __update_ui(self, side):
        for key in self.__ui.keys():
            if not self.__menu_list.has_key(key):
                continue
            if side > 1:
                if key in ['File/Update', 'File/Vanish']:
                    list = self.__ui[key][0][1] # same as "kero"
                elif key == 'Portal':
                    list = [] # same as "kero"
                elif key == 'Recommend':
                    list = ["char%d.recommendbuttoncaption" % side]
            else:
                list = self.__ui[key][0][side]
            if list: # caption
                for name in list:
                    caption = self.__ghost.getstring(name)
                    if caption:
                        break
                if caption:
                    caption = self.__modify_shortcut(caption)
                    if caption == self.__cut_mnemonic(caption):
                        caption += self.__ui[key][1]
                    self.__set_caption(key, caption)
            if side > 1:
                list = self.__ui[key][2][1] # same as "kero"
            else:
                list = self.__ui[key][2][side]
            if list: # visible
                for name in list:
                    visible = self.__ghost.getstring(name)
                    if visible is not None:
                        break
                if visible == "0":
                    self.__set_visible(key, 0)
                else:
                    self.__set_visible(key, 1)
            elif list is None:
                self.__set_visible(key, 0)

    def set_submenu_back_pixmap(self, submenu, pixmap):
        item_list = submenu.get_children()
        if len(item_list) > 0:
            item = item_list[0]
            item.realize()
            item.window.set_back_pixmap(self.__pixmap, False)
            for item in item_list:
                submenu = item.get_submenu()
                if submenu:
                    self.set_submenu_back_pixmap(submenu, pixmap)

    def set_submenu_fontcolor(self, submenu, fontcolor):
        for item in submenu.get_children():
            # reset label
            children = item.get_children()
            if len(children) > 0:
                label = children[0]
                text = label.get_text()
                markup = '<span foreground="%s">%s</span>' % (self.__fontcolor, text)
                label.set_markup_with_mnemonic(markup)
            submenu = item.get_submenu()
            if submenu:
                self.set_submenu_fontcolor(submenu, fontcolor)

    def popup(self, button, side):
        self.__update_ui(side)
        if side == 0:
            portal = self.__ghost.getstring("sakura.portalsites")
        else:
            portal = None
        self.__set_portal_menu(side, portal)
        if side > 1:
            string = "char%d" % side
        else:
            assert side in [0, 1]
            string = ["sakura", "kero"][side]
        string += ".recommendsites"
        recommend = self.__ghost.getstring(string)
        self.__set_recommend_menu(side, recommend)
        self.__set_ghost_menu()
        self.__set_shell_menu()
        self.__set_balloon_menu()
        self.__set_plugin_menu()
        self.__set_mayuna_menu(side)
        self.__set_nekodorif_menu()
        self.__set_kinoko_menu()
        for key in self.__menu_list.keys():
            item = self.ui_manager.get_widget('/popup/' + key)
            visible = self.__menu_list[key][2]
            changed = self.__menu_list[key][3]
            if item and changed:
                self.__menu_list[key][3] = 0 # changed
                if visible:
                    label = item.get_children()[0]
                    text = label.get_text()
                    markup = '<span foreground="%s">%s</span>' % (self.__fontcolor, text)
                    label.set_markup_with_mnemonic(markup)
                    item.show()
                    submenu = item.get_submenu()
                    if self.__pixmap:
                        if key == 'File':
                            item.realize()
                            item.window.set_back_pixmap(self.__pixmap_with_sidebar, False)
                        if submenu:
                            self.set_submenu_back_pixmap(submenu, self.__pixmap)
                    if submenu:
                        self.set_submenu_fontcolor(submenu, self.__fontcolor)
                else:
                    item.hide()
        self.__popup_menu.popup(None, None, None, button, gtk.get_current_event_time())
        for item in self.__popup_menu.get_children():
            if gtk.REALIZED & item.flags():
                allocation = item.get_allocation()
                allocation.x += self.__sidebar_width
                allocation.width -= self.__sidebar_width
                item.size_allocate(allocation)
        self.__popup_menu.resize_children()

    def __set_caption(self, name, caption):
        assert self.__menu_list.has_key(name)
        assert type(caption) in [types.StringType, types.UnicodeType]
        item = self.ui_manager.get_widget('/popup/' + name)
        if item:
            label = item.get_children()[0]
            label.set_text(caption)
        self.__menu_list[name][3] = 1 # changed

    def __set_visible(self, name, visible):
        assert self.__menu_list.has_key(name)
        assert visible in [0, 1]
        if self.__menu_list[name][2] == visible:
            return
        self.__menu_list[name][2] = visible
        self.__menu_list[name][3] = 1 # changed

    def __set_portal_menu(self, side, portal):
        if side >= 1:
            self.__set_visible('Portal', 0)
        else:
            if portal:
                menu = gtk.Menu()
                list = portal.split(chr(2))
                for site in list:
                    entry = site.split(chr(1))
                    if len(entry) < 1:
                        continue
                    title = entry[0]
                    if title == '-':
                        item = gtk.SeparatorMenuItem()
                    else:
                        if len(entry) < 2:
                            continue
                        url = entry[1]
                        if len(entry) > 2:
                            bannar = entry[2] ## FIXME
                        else:
                            bannar = None
                        item = gtk.MenuItem(title)
                        item.connect("activate", self.__ghost.launch_browser, (title, url))
                    menu.add(item)
                    item.show()
                menuitem = self.ui_manager.get_widget('/popup/' + 'Portal')
                menuitem.set_submenu(menu)
                menu.show()
                self.__set_visible('Portal', 1)
            else:
                self.__set_visible('Portal', 0)
        self.__menu_list['Portal'][3] = 1 # changed

    def __set_recommend_menu(self, side, recommend):
        if recommend:
            menu = gtk.Menu()
            list = recommend.split(chr(2))
            for site in list:
                entry = site.split(chr(1))
                if len(entry) < 1:
                    continue
                title = entry[0]
                if title == '-':
                    item = gtk.SeparatorMenuItem()
                else:
                    if len(entry) < 2:
                        continue
                    url = entry[1]
                    if len(entry) > 2:
                        bannar = entry[2] ## FIXME
                    else:
                        bannar = None
                    item = gtk.MenuItem(title)
                    item.connect("activate", self.__ghost.launch_browser, (title, url))
                menu.add(item)
                item.show()
            menuitem =  self.ui_manager.get_widget('/popup/' + 'Recommend')
            menuitem.set_submenu(menu)
            menu.show()
            self.__set_visible('Recommend', 1)
        else:
            self.__set_visible('Recommend', 0)
        self.__menu_list['Recommend'][3] = 1 # changed

    def __update_ghost_menu(self, list):
        ##if self.__ghost_list == None:
        ##    self.__create_ghost_menu(list)
        ##else:
        ghost_menu = gtk.Menu()
        for i in range(len(list)):
            if list[i] == None:
                continue
            name = list[i]['name']
            icon_path = list[i]['icon']
            pixbuf = None
            if icon_path != None:
                try:
                    pixbuf = ninix.pix.create_pixbuf_from_file(icon_path, 'ico')
                except:
                    pixbuf = None
            shell_list = list[i]['shell']
            if pixbuf is not None:
                pixbuf = pixbuf.scale_simple(16, 16, gtk.gdk.INTERP_BILINEAR)
                image = gtk.Image()
                image.set_from_pixbuf(pixbuf)
                image.show()
                item = gtk.ImageMenuItem(name)
                item.set_image(image)
            else:
                item = gtk.MenuItem(name)
            item.set_name("popup menu item")
            item.show()
            ghost_menu.append(item)
            if len(shell_list) <= 1:
                shell_name, value = shell_list[0]
                item.connect("activate", self.__ghost.app.select_sakura, (self.__ghost, value)) ## FIXME
                if list[i]['instance'].is_running():
                    item.set_sensitive(False)
            else:
                submenu = gtk.Menu()
                submenu.set_name("popup menu")
                item.set_submenu(submenu)
                for shell_name, value in shell_list:
                    item = gtk.MenuItem(shell_name)
                    item.set_name("popup menu item")
                    item.connect("activate", self.__ghost.app.select_sakura, (self.__ghost, value)) ## FIXME
                    item.show()
                    if list[i]['instance'].is_running():
                        if self.__ghost.current[1] != value[1]:
                            item.set_sensitive(False)
                        elif self.__ghost.current[2] == value[2]:
                            item.set_sensitive(False)
                    submenu.append(item)
        menuitem =  self.ui_manager.get_widget('/popup/' + 'Change')
        menuitem.set_submenu(ghost_menu)
        self.__menu_list['Change'][3] = 1
        self.__ghost_list = list

    def __set_ghost_menu(self):
        list = self.__ghost.app.get_ghost_list() ## FIXME
        self.__update_ghost_menu(list)
        self.__update_summon_menu(list)

    def __update_summon_menu(self, list):
        ##if self.__ghost_list == None:
        ##    self.__create_ghost_menu(list)
        ##else:
        ghost_menu = gtk.Menu()
        for i in range(len(list)):
            if list[i] == None:
                continue
            name = list[i]['name']
            icon_path = list[i]['icon']
            pixbuf = None
            if icon_path != None:
                try:
                    pixbuf = ninix.pix.create_pixbuf_from_file(icon_path, 'ico')
                except:
                    pixbuf = None
            shell_list = list[i]['shell']
            if pixbuf is not None:
                pixbuf = pixbuf.scale_simple(16, 16, gtk.gdk.INTERP_BILINEAR)
                image = gtk.Image()
                image.set_from_pixbuf(pixbuf)
                image.show()
                item = gtk.ImageMenuItem(name)
                item.set_image(image)
            else:
                item = gtk.MenuItem(name)
            item.set_name("popup menu item")
            item.show()
            ghost_menu.append(item)
            if len(shell_list) <= 1:
                shell_name, value = shell_list[0]
                item.connect("activate", self.__ghost.app.start_sakura_cb, value) ## FIXME
                if list[i]['instance'].is_running():
                    item.set_sensitive(False)
            else:
                submenu = gtk.Menu()
                submenu.set_name("popup menu")
                item.set_submenu(submenu)
                for shell_name, value in shell_list:
                    item = gtk.MenuItem(shell_name)
                    item.set_name("popup menu item")
                    item.connect("activate", self.__ghost.app.start_sakura_cb, value) ## FIXME
                    item.show()
                    if list[i]['instance'].is_running():
                        item.set_sensitive(False)
                    submenu.append(item)
        menuitem = self.ui_manager.get_widget('/popup/' + 'Summon')
        menuitem.set_submenu(ghost_menu)
        self.__menu_list['Summon'][3] = 1
        self.__ghost_list = list

    def __update_shell_menu(self, list):
        ##if self.__shell_list == None:
        ##    self.__create_shell_menu(list)
        ##else:
        shell_menu = gtk.Menu()
        for i in range(len(list)):
            name = list[i]['name']
            item = gtk.MenuItem(name)
            item.set_name("popup menu item")
            item.show()
            shell_menu.append(item)
            shell_list = list[i]['shell']
            if len(shell_list) <= 1:
                shell_name, value = shell_list[0]
                item.connect("activate", self.__ghost.app.select_sakura, (self.__ghost, value)) ## FIXME
                ##if working:
                ##    item.set_sensitive(False)
            else:
                submenu = gtk.Menu()
                submenu.set_name("popup menu")
                item.set_submenu(submenu)
                for shell_name, value in shell_list:
                    item = gtk.MenuItem(shell_name)
                    item.set_name("popup menu item")
                    item.connect("activate", self.__ghost.app.select_sakura, (self.__ghost, value)) ## FIXME
                    item.show()
                    ##if working: ## FIXME
                    ##    item.set_sensitive(False)
                    submenu.append(item)
        menuitem = self.ui_manager.get_widget('/popup/' + 'Shell')
        menuitem.set_submenu(shell_menu)
        self.__menu_list['Shell'][3] = 1
        self.__shell_list = list

    def __set_shell_menu(self):
        list = self.__ghost.app.get_shell_list() ## FIXME
        self.__update_shell_menu(list)

    def __update_balloon_menu(self, list):
        ##if self.__balloon_list == None:
        ##    self.__create_balloon_menu(list)
        ##else:
        balloon_menu = gtk.Menu()
        group = None
        name_own = self.__ghost.get_own_balloon_name()
        if name_own != None:
            item = group = gtk.RadioMenuItem(group, name_own)
            item.set_name("popup menu item")
            hid = item.connect("activate", self.__ghost.select_balloon, name_own)
            item.show()
            balloon_menu.append(item)
        item = gtk.SeparatorMenuItem()
        balloon_menu.add(item)
        item.show()
        for i in range(len(list)):
            name = list[i]['name']
            item = group = gtk.RadioMenuItem(group, name)
            item.set_name("popup menu item")
            hid = item.connect("activate", self.__ghost.select_balloon, name)
            item.show()
            balloon_menu.append(item)
            if name == self.__ghost.get_current_balloon_name():
                item.handler_block(hid)
                item.activate()
                item.handler_unblock(hid)
        menuitem = self.ui_manager.get_widget('/popup/' + 'Balloon')
        menuitem.set_submenu(balloon_menu)
        self.__menu_list['Balloon'][3] = 1
        self.__balloon_list = list

    def __set_balloon_menu(self):
        list = self.__ghost.app.get_balloon_list() ## FIXME
        self.__update_balloon_menu(list)

    def __update_plugin_menu(self, list):
        ##if self.__plugin_list == None:
        ##    self.__create_plugin_menu(list)
        ##else:
        plugin_menu = gtk.Menu()
        for i in range(len(list)):
            name = list[i]['name']
            item = gtk.MenuItem(name)
            item.set_name("popup menu item")
            item.show()
            plugin_menu.append(item)
            item_list = list[i]['items']
            if len(item_list) <= 1:
                label, value = item_list[0]
                item.connect("activate", self.__ghost.app.select_plugin, value) ## FIXME
                ##if working:
                ##    item.set_sensitive(False)
            else:
                submenu = gtk.Menu()
                submenu.set_name("popup menu")
                item.set_submenu(submenu)
                for label, value in item_list:
                    item = gtk.MenuItem(label)
                    item.set_name("popup menu item")
                    item.connect("activate", self.__ghost.app.select_plugin, value) ## FIXME
                    item.show()
                    ##if working:
                    ##    item.set_sensitive(False)
                    submenu.append(item)
        menuitem = self.ui_manager.get_widget('/popup/' + 'Plugin')
        menuitem.set_submenu(plugin_menu)
        self.__menu_list['Plugin'][3] = 1
        self.__plugin_list = list

    def __set_plugin_menu(self):
        list = self.__ghost.app.get_plugin_list() ## FIXME
        self.__update_plugin_menu(list)

    def __update_nekodorif_menu(self, list):
        ##if self.__nekodorif_list == None:
        ##    self.__create_nekodorif_menu(list)
        ##else:
        nekodorif_menu = gtk.Menu()
        for i in range(len(list)):
            name = list[i]['name']
            item = gtk.MenuItem(name)
            item.set_name("popup menu item")
            item.show()
            nekodorif_menu.append(item)
            item.connect("activate", self.__ghost.app.select_nekodorif, (self.__ghost, list[i]['dir'])) ## FIXME
            ##if working:
            ##    item.set_sensitive(False)
        menuitem = self.ui_manager.get_widget('/popup/' + 'Nekodorif')
        menuitem.set_submenu(nekodorif_menu)
        self.__menu_list['Nekodorif'][3] = 1
        self.__nekodorif_list = list

    def __set_nekodorif_menu(self):
        list = self.__ghost.app.get_nekodorif_list() ## FIXME
        self.__update_nekodorif_menu(list)

    def __update_kinoko_menu(self, list):
        ##if self.__kinoko_list == None:
        ##    self.__create_kinoko_menu(list)
        ##else:
        kinoko_menu = gtk.Menu()
        for i in range(len(list)):
            name = list[i]['title']
            item = gtk.MenuItem(name)
            item.set_name("popup menu item")
            item.show()
            kinoko_menu.append(item)
            item.connect("activate", self.__ghost.app.select_kinoko, (self.__ghost, list[i])) ## FIXME
            ##if working:
            ##    item.set_sensitive(False)
        menuitem = self.ui_manager.get_widget('/popup/' + 'Kinoko')
        menuitem.set_submenu(kinoko_menu)
        self.__menu_list['Kinoko'][3] = 1
        self.__kinoko_list = list

    def __set_kinoko_menu(self):
        list = self.__ghost.app.get_kinoko_list() ## FIXME
        self.__update_kinoko_menu(list)

    def get_stick(self):
        item =  self.ui_manager.get_widget('/popup/' + 'Stick')
        if item and item.get_active():
            return 1
        else:
            return 0

def test():
    pass

if __name__ == "__main__":
    test()
