export PATH=/bin:/usr/bin:/sbin:/usr/sbin
export LANG=C
export LC_ALL=C

if [ -r /tmp/SeTT_PX ]; then
  ROOT="`cat /tmp/SeTT_PX`"
fi

APACI_DIR=$ROOT/opt/httpd-2.0.63

if [ -d $ROOT/opt/httpd ] ; then
  mv $ROOT/opt/httpd $ROOT/opt/httpd.bak
fi
ln -sf $APACI_DIR $ROOT/opt/httpd

/usr/sbin/groupadd apache
/usr/sbin/useradd -g apache wadm
/usr/sbin/useradd -g apache www
chown -R root.apache $APACI_DIR
chmod -R go+rX $APACI_DIR
chown -R wadm $APACI_DIR/htdocs
chmod -R u+w $APACI_DIR/htdocs
mkdir $APACI_DIR/proxy
chown -R www $APACI_DIR/proxy

#mkdir -p $ROOT/var/log/httpd
#(cd $APACI_DIR/; ln -sf /var/log/httpd logs)
mkdir -p $APACI_DIR/logs
if [ -f $ROOT/var/log/httpd ]; then
  echo "Warning! Moving $ROOT/var/log/httpd to $ROOT/var/log/httpd.bak"
  mv $ROOT/var/log/httpd to $ROOT/var/log/httpd.bak
fi
(cd $ROOT/var/log; ln -sf $APACI_DIR/logs httpd)

if [ -d $ROOT/etc/logrotate.d ]; then  
  if [ ! -f $ROOT/etc/logrotate.d/httpd ]; then
    cp $APACI_DIR/logs/logrotate.httpd $ROOT/etc/logrotate.d/httpd  
  fi
else  
  if ! fgrep "/opt/httpd/logs/" $ROOT/etc/logrotate.conf 1> /dev/null 2>&1; then     
    cat $APACI_DIR/logs/logrotate.httpd >> $ROOT/etc/logrotate.conf  
  fi  
fi


cd $ROOT/

#NNAME=`hostname -f`
#for Plamo-4.2
NNAME=`cat /etc/HOSTNAME`
if [ ".$NNAME" = "." ]; then
  NNAME=`hostname`
  if [ ".$NNAME" = "." ]; then
    NNAME=localhost
  fi
fi

if [ "$NNAME" != "" ] ; then
    if [ ! -f $APACI_DIR/conf/httpd.conf ]; then
	sed -e "s/LOCALHOST/$NNAME/" \
	$APACI_DIR/conf/httpd.conf.template \
	> $APACI_DIR/conf/httpd.conf
    fi
    if [ ! -f $APACI_DIR/conf/ssl.conf ]; then
	sed -e "s/LOCALHOST/$NNAME/" \
	$APACI_DIR/conf/ssl.conf.template \
	> $APACI_DIR/conf/ssl.conf
    fi
    mkdir -p $APACI_DIR/htdocs/new
    (cd $APACI_DIR/htdocs/;
	 for f in index.html* ;
		do sed -e "s/domain/$NNAME/" $f > new/$f ;
	 done;
	 mv new/index.html* .;
	 rmdir new;
    )
fi
( cd $APACI_DIR/conf/; echo "#ServerTokens	Prod" >> httpd.conf )

#
# ( DONOT CHANGE THE NEXT ONE LINE )
# Add Apache-httpd-2.0.63 Entry to Apache document index.
#
if ! fgrep "Apache-httpd-2.0.63" $ROOT/opt/httpd/htdocs/contents.list 1> /dev/null 2>&1; then
  cat >> $ROOT/opt/httpd/htdocs/contents.list <<EOL
	<p>
	Apache-httpd-2.0.63
	(Apache/httpd-2.0.63 and DAV/2 with OpenSSL)
	</p>
EOL
fi

# Create new RSA key for SSL.
if [ "$NNAME" != "" ] ; then
        sed -e "s/LOCALHOST/$NNAME/" \
        $APACI_DIR/bin/mkrsakey.sh.template \
        > $APACI_DIR/bin/mkrsakey.sh
        chmod +x $APACI_DIR/bin/mkrsakey.sh
fi
sh $APACI_DIR/bin/mkrsakey.sh

if [ -f /tmp/add_httpd_test.sh ] ; then
    sh /tmp/add_httpd_test.sh
    rm -f /tmp/add_httpd_test.sh
fi

cd $ROOT/

( cd ./opt/httpd/lib ; rm -rf libapr-0.so )
( cd ./opt/httpd/lib ; ln -sf libapr-0.so.0.9.17 libapr-0.so )
( cd ./opt/httpd/lib ; rm -rf libapr-0.so.0 )
( cd ./opt/httpd/lib ; ln -sf libapr-0.so.0.9.17 libapr-0.so.0 )
( cd ./opt/httpd/lib ; rm -rf libaprutil-0.so )
( cd ./opt/httpd/lib ; ln -sf libaprutil-0.so.0.9.17 libaprutil-0.so )
( cd ./opt/httpd/lib ; rm -rf libaprutil-0.so.0 )
( cd ./opt/httpd/lib ; ln -sf libaprutil-0.so.0.9.17 libaprutil-0.so.0 )

if [ -x $ROOT/usr/libexec/namazu.cgi ] ; then
  cp -p $ROOT/usr/libexec/namazu.cgi  $ROOT/opt/httpd/cgi-bin/
fi
if [ -f $ROOT/usr/share/namazu/etc/namazu.png ] ; then
  cp -p $ROOT/usr/share/namazu/etc/namazu.png $ROOT/opt/httpd/htdocs
fi


if [ "$ROOT" = "" ]; then
  /opt/httpd/bin/apachectl startssl
fi

