<?PHP

/*
 *	W-AGORA 4.1
 *	-----------
 *	$Id: globals.inc,v 1.39 2005/06/03 14:54:08 mdruilhe Exp $
 *	Usage:			Global settings for the entire application
 *	Description:	This script is to define global variables and constants to use in all files
 *	Author:			Stefan Schreyjak <Stefan.Schreyjak@cyperon.de>
 *					Marc Druilhe <mdruilhe@w-agora.net>
 */

if (defined("_GLOBALS")) return;
define('_GLOBALS', 1);

$ext		= 'php5';
$main_page	= "index.$ext";

# Set here the default site to be displayed if no site is defined in the list page (default = list of sites)
# $default_site = "my_site";

# default Locale configuration
# ----------------------------
$default_lang = "en";		// Make sure the directory locales/$default_lang exists !
$bn_charset = 'iso-8859-1';	// should be redefined in locales/lang_xx.inc
$bn_html_dir = 'ltr';		// should be redefined in locales/lang_xx.inc

# set $debug= 1 for debugging mode
# --------------------------------
$debug = 0;

# initialize w-agora directories
# ------------------------------
$bin_dir	= '.';
$inc_dir	= 'include';
$cfg_dir	= 'conf';
$tmpl_dir	= 'templates';
$user_dir	= 'user';
$icon_dir	= 'images/icons';
$img_dir	= 'images';
$lang_dir	= 'locales';

# Set general directives for PHP engine behaviour
# -----------------------------------------------
error_reporting (E_ERROR | E_WARNING | E_PARSE);
# error_reporting (E_ALL);		// uncomment if you want all errors/warning to be output
@ini_set('display_errors', '1');
set_magic_quotes_runtime(0);	// Disable magic_quotes_runtime

# set to 1 if the PATH_INFO variable is properly set by the server (allows w-agora to use friendly 
# URLs : getfile.php/myforum/101/image.gif instead of getfile.php?bn=myforum&att_id=101
# -------------------------------------------------------------------------------------------------
$use_path_info = 1;

# handle configs that have REGISTER_GLOBALS turned off
# ----------------------------------------------------
if (!get_cfg_var("register_globals") ) {
	include "include/register_globals.$ext";
}

# Some layout configuration values
# --------------------------------
$bn_win_width	= 750;		// popup windows width
$bn_win_height	= 560;		// popup window height
$bn_max_img_width = 600;	// Max. attached images width

# htmlarea wysiwyg editor
# -----------------------
define('HTMLAREA_DIR', 'htmlarea');
$use_htmlarea = 1;

/* RFU
$html_editor = 'fckeditor';
define('EDITOR_DIR', 'FCKeditor');
define('EDITOR_URL', 'FCKeditor');
*/

# set the current time & formated date
# -------------------------------------
$now = time();					// system local time
$today = mktime (0, 0, 0, date ('m'), date ('d'), date ('Y') ); // Today's (00h00) date
$bn_tz_offset = isset($bn_tz_offset) ? $bn_tz_offset : 0;	// Default Time zone (overwritten in config file)
$bn_date_format = isset($bn_date_format) ? $bn_date_format : 'M-Y-d H:i';	// default date format (overwritten in config file)

# set modes for creating directories and files
# --------------------------------------------
define('_DIRMODE', 0777);
define('_FILEMODE', 0666);
@umask (0);

# Define here the URL of the w-agora directory, eg. :
# $bn_base_url = "http://your.hostname.com/w-agora";
$bn_base_url = 'http://'.$_SERVER['HTTP_HOST'].dirname($_SERVER['PHP_SELF']);

# email header terminator : using the standard "\r\n" doesn't seem to work with all MTA
# see http://bugs.php.net/bug.php?id=15841&edit=1 discussion
define('MAIL_MIME_CRLF', "\n");

# Check the existence of DNS MX record for address domain while checking emails
define('MAIL_CHECK_DNS', false);

# Default values used in the admin panel
# --------------------------------------
$nb_users_list = 20;	// number of users displayed/ page in the admin panel

# Default thread sort order (format = fieldname[ ASC|DESC])
$default_threads_order = "newest DESC";	// sort by Last posting date
# $default_threads_order = "thread DESC";	// sort Reverse thread starting date

# Default values used in the form or template
# -------------------------------------------
$att_num_cells = 5;			// number of attachments per row
$default_html_tags = 0;		// default for the "preserve HTML" option
$default_mail_reply = 0;	// default for the "send reply by email" option

$oldfiles_gctime  = 3600;		// Purge "orphan" uploaded files older than 1 hour (3600 sec.).

# Avatars 
# -------
$bn_avatar_remote = true;	// Enable remote avatars (avatars linked to from another website)
$bn_browse_avatar = true;	// Enable gallery avatars (allow users to choose an avatar from a list on the server)
$bn_avatar_upload = true;	// allow users to upload an avatar
$bn_avatar_dir = "images/avatars";

$max_avatar_size = 50000;
$max_avatar_width = 200;
$max_avatar_height = 200;

# Allows "index.php?about" url 
# ----------------------------
define('ALLOWS_INFOS_URL', true);

# ----------------------------------------------------------------------
# Nothing should be changed beyond this point unless you know what you do
# -----------------------------------------------------------------------

# initialize some values
# ----------------------
$WA_SELF = basename($_SERVER['PHP_SELF']);
$bn_action	= isSet($bn_action)? $bn_action : '';
$bn_action_mode = isset($bn_action_mode) ? $bn_action_mode : 'R';
$bn_dir_default = isset($bn_dir_default) ? $bn_dir_default : 'forums/agora';

$winbox		= (defined('PHP_OS') && eregi('win', PHP_OS));
$lynx		= isset($lynx) ? $lynx : 0;

# Loads localized constants
# -------------------------
if (isset($_GET['lang']) ) {
	$lang = strtolower($_GET['lang']);
} elseif (isset($_POST['lang'])) {
	$lang = $_POST['lang'];
} elseif (isset($_COOKIE['wa_lang'])) {
	$lang = $_COOKIE['wa_lang'];
} elseif (isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) ) {
	$lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
} elseif (isset($_COOKIE['lang'])) {
	$lang = strtolower($_COOKIE['lang']);
}

if (!empty($lang) && file_exists("$lang_dir/lang_$lang.inc") ) {
	if (!isset($_COOKIE['wa_lang']) || ($lang != $_COOKIE['wa_lang']) ) {
		@setcookie ('wa_lang', $lang, 0, '/');
	}
} else {
	$lang = $default_lang;
}

require ("$lang_dir/lang_$lang.inc");

# user privileges labels
#-----------------------

$user_privs = array (
	'root'  => '<font color="red">' . LABEL_ROOT . '</font>',
	'admin' => '<font color="red">' . LABEL_ADMINISTRATOR . '</font>',
	'moder' => '<font color="blue">'. LABEL_MODERATOR . '</font>',
	'user'  => LABEL_USER
);

# registration mode labels
#-------------------------

define('REG_NO_CONTROL', 0);
define('REG_CHALLENGE_RESPONSE', 1);	// RFU
define('REG_ADMIN_APPROVAL', 2);

?>
