<?php

/*
 *	W-AGORA 4.2
 *	-----------
 *	$Id: editconf.php5,v 1.39 2005/06/22 13:13:50 mdruilhe Exp $
 *	Usage:		Edit configuration of a forum
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 */

	$header = "";

	require ("init_admin.inc");

	if ( ($site=='agora') || ($editsite==1) ) {
		$mode = 'editsite';
	} elseif (!isset($mode) ) {
	    $mode = 'basic';
	}

	if ($site=='agora') {
		if ($auth->level < ROOT) {
			MsgForm (ERROR_NO_ROOT, "admin_site.$ext?site=$site&force_login=1", "", "_top");
			echo "</body></html>";
			exit;
		}
	} elseif ( ($auth->level < ADMIN) && ($mode!="basic") ) {
		MsgForm (ERROR_NO_ADMIN, "admin_site.$ext?site=$site&force_login=1", "", "_top");
		echo "</body></html>";
		exit;
	}

	function setTitle ($title, $anchor="") {
		if (empty($anchor) ) {
			$anchor=$title;
		}
		print "</TABLE><A NAME=\"$anchor\"></A><TABLE cellspacing=2 cellpadding=4 WIDTH='100%'>";
		echo "<TR><TD COLSPAN=3>&nbsp;</TD></TR>\n";
		echo "<TR><TH COLSPAN=3 BGCOLOR=\"#E0E0E0\" ALIGN=\"left\">$title</TH></TR>\n";
	}

	function getBoolean ($name, $value, $role, $comment) {
		echo "<TR><TD width=5>&nbsp;</TD><TD COLSPAN=2>";
		checkBox ($name, "1", $value, "<font size=2><B>$role</B></font>");
		echo "<font size=1> (<i>$comment</i>)</font></td></tr>\n";
	}

	function getCombo ($name, $choices, $value, $role, $comment) {
		echo "<TR><TD width=5>&nbsp;</TD><TD align='right'>";
		echo "<font size=2><B>$role</B></font></TD><TD>";
		listBox ($name, $choices, $value);
		echo "</TD></TR><TR><TD width=5>&nbsp;</TD><TD COLSPAN=2 valign='top'><font size=1> (<i>$comment</i>)</font></td></tr>\n";
	}

	function GetValue ($name, $size, $value, $role, $comment) {
		$value = htmlspecialchars ($value);
		if ($size < 50) {
			echo "<tr><td width=\"5\">&nbsp;</td><td align=\"right\">";
			echo "<font size=2><B>$role</B></font></TD><TD>";
			echo "<input type=\"text\" name=\"$name\" size=\"$size\" VALUE=\"$value\">";
			echo "</TD></TR>\n<TR><TD width=5>&nbsp;</TD><TD COLSPAN=2 valign='top'>(<font size='1'><i>$comment</i></font>)</TD></TR>\n";
		}	else {
			echo "<TR><TD width=5>&nbsp;</TD><TD COLSPAN=2><b>$role</b> (<font size='1'><i>$comment</i></font>) :<br><INPUT TYPE=\"text\" NAME=\"$name\" SIZE=\"$size\" VALUE=\"$value\"></TD></TR>\n";
		}
	}

# Entry point
# -----------

	if (isset($save)) {

		// remove extras spaces and formats tags
		$bn_banned_tags = ereg_replace ("[<,;>?]", " ", $bn_banned_tags);
		$bn_banned_tags = trim(ereg_replace ("[[:space:]]+", " ", $bn_banned_tags));

		$bn_allowed_tags = ereg_replace ("[<,;>?]", " ", $bn_allowed_tags);
		$bn_allowed_tags = trim(ereg_replace ("[[:space:]]+", " ", $bn_allowed_tags));

		$bn_banned_ips = ereg_replace ("[<,;>?]", " ", $bn_banned_ips);
		$bn_banned_ips = trim(ereg_replace ("[[:space:]]+", " ", $bn_banned_ips));

		$bn_allowed_extensions = eregi_replace ("[[:punct:]]", " ", $bn_allowed_extensions);
		$bn_allowed_extensions = eregi_replace ("([a-z]+)", ".\\1", $bn_allowed_extensions);
		$bn_allowed_extensions = trim(ereg_replace ("[[:space:]]+", " ", $bn_allowed_extensions));

		$bn_banned_extensions = eregi_replace ("[[:punct:]]", " ", $bn_banned_extensions);
		$bn_banned_extensions = eregi_replace ("([a-z]+)", ".\\1", $bn_banned_extensions);
		$bn_banned_extensions = trim(ereg_replace ("[[:space:]]+", " ", $bn_banned_extensions));

		$bn_allowed_mimetypes = eregi_replace ("[,;.]", " ", $bn_allowed_mimetypes);
		$bn_allowed_mimetypes = trim(ereg_replace ("[[:space:]]+", " ", $bn_allowed_mimetypes));

		$bn_banned_mimetypes = eregi_replace ("[,;.]", " ", $bn_banned_mimetypes);
		$bn_banned_mimetypes = trim(ereg_replace ("[[:space:]]+", " ", $bn_banned_mimetypes));

		$bn_mail_from = (empty ($bn_mail_from) ) ? "forums@$SERVER_NAME" : $bn_mail_from;

		//  Update Configuration File
		$conf = new Config;
		$ret = $conf->open("$cfg_file");
		if (!$ret) {
			MsgForm (ERROR_NO_WRITE_CONFIGURATION, "$WA_SELF?site=$site&bn=$bn", 'back'); /* access problem */
			exit;
		}

		foreach($_POST as $key=>$val) {
			$config[$key] = strip_magic_quotes($val);
		}
		$conf->writeConfig($config);
		$conf->close ();

		if ($bn_search && ($bn_search_engine != "none") ) {
			include "$inc_dir/$bn_search_engine.$ext";
			$search->initSearchConf();
		}
		$header = "<br><b>" . LABEL_CHANGE_CONFIG_DONE .  "$cfg_file</b>";
	} elseif (isset($undo)) {
		$conf = new Config;
		if ($conf->restore("$cfg_file") ) {
			$header = "<br><b>" . LABEL_SETTINGS_RESTORED . "</b>";
		}
	}

	unset ($bn_body); // used in display_header

	display_header (sprintf(LABEL_FORUM_CONFIGURATION, ($mode == "basic") ? LABEL_BASIC : LABEL_ADVANCED) );

	print $header;

	include "$cfg_file";

	beginForm();
	hiddenField ("mode", $mode);
	hiddenField ("bn_dir", $bn_dir);
	hiddenField ("bn_dir_notes", $bn_dir_notes);

	table_header(LABEL_EDITING_FILE . " : $cfg_file");
	?><table cellspacing="1" cellpadding="2" width="100%"><?php 

if ($mode == "advanced") {

# ADVANCED Configuration
# -------------------
	hiddenField ("bn_body", $bn_body);
	hiddenField ("bn_date_format", $bn_date_format);
	hiddenField ("bn_tz_offset", $bn_tz_offset);

	hiddenField ("bn_cookies", $bn_cookies);

	hiddenField ("bn_modify", $bn_modify);
	hiddenField ("bn_delete", $bn_delete);

	hiddenField ("bn_allow_html", $bn_allow_html);
	hiddenField ("bn_banned_tags", $bn_banned_tags);
	hiddenField ("bn_allowed_tags", $bn_allowed_tags);
	hiddenField ("bn_use_smileys", $bn_use_smileys);
	hiddenField ("bn_auto_url", $bn_auto_url);

	hiddenField ("bn_banned_ips", $bn_banned_ips);

	hiddenField ("bn_file_upload", $bn_file_upload);
	hiddenField ("MAX_FILE_SIZE", $MAX_FILE_SIZE);
	hiddenField ("bn_allowed_extensions", $bn_allowed_extensions);
	hiddenField ("bn_banned_extensions", $bn_banned_extensions);
	hiddenField ("bn_allowed_mimetypes", $bn_allowed_mimetypes);
	hiddenField ("bn_banned_mimetypes", $bn_banned_mimetypes);

	hiddenField ("bn_search", $bn_search);
	hiddenField ("bn_search_engine", $bn_search_engine);
	hiddenField ("bn_search_path", $bn_search_path);

	hiddenField ("bn_mail", $bn_mail);
	hiddenField ("bn_user_mail", $bn_user_mail);
	hiddenField ("bn_private_mail", $bn_private_mail);
	hiddenField("bn_mail_attachment",$bn_mail_attachment); 


	setTitle (LABEL_FRAMES);
	getBoolean ("bn_frames", "$bn_frames", COLUMN_USE_FRAMES, ALT_USE_FRAMES);
	GetValue ("bn_frameset", 40, "$bn_frameset", COLUMN_FRAMESET_PARAMETER, ALT_FRAMESET_PARAMETER);
	GetValue ("bn_frame1", 40, "$bn_frame1", COLUMN_HEADER_FRAME_PARAMETER, ALT_HEADER_FRAME_PARAMETER);
	GetValue ("bn_frame2", 40, "$bn_frame2", COLUMN_FOOTER_FRAME_PARAMETER, ALT_HEADER_FRAME_PARAMETER);

	setTitle (TITLE_POST_MESSAGES);
	getBoolean ("bn_popup", $bn_popup, COLUMN_POST_POPUP, ALT_POST_POPUP);
	getBoolean ("bn_no_form_button_bar", $bn_no_form_button_bar, COLUMN_NO_BUTTON_BAR, ALT_NO_BUTTON_BAR);
	getBoolean ("bn_no_thanks_msg", $bn_no_thanks_msg, COLUMN_NO_THANKS, ALT_NO_THANKS);
	getCombo ("bn_post_return", array ("view" => COLUMN_NEWLY_POSTED, "list"=>COLUMN_MESSAGE_LIST, "thread" => COLUMN_FIRST_MESSAGE), $bn_post_return, COLUMN_AFTER_POSTING, ALT_AFTER_POSTING);

	setTitle (sprintf(TITLE_INCLUDE_FILES, $bn_dir), "include");
	GetValue ("bn_style", 30, "$bn_style", COLUMN_CSS_FILE, ALT_CSS_FILE);
	GetValue ("bn_header", 30, "$bn_header", COLUMN_HEADER_FILE, ALT_HEADER_FILE);
	GetValue ("bn_footer", 30, "$bn_footer", COLUMN_FOOTER_FILE, ALT_FOOTER_FILE);
	GetValue ("bn_list_vars", 30, "$bn_list_vars", COLUMN_LISTING_OUTLINE, ALT_LISTING_OUTLINE);
	GetValue ("bn_msgs", 30, "$bn_msgs", COLUMN_INCLUDE_MESSAGES, ALT_INCLUDE_MESSAGES);
	GetValue ("bn_form", 30, "$bn_form", COLUMN_FORM_FILE, ALT_FORM_FILE);
	GetValue ("bn_mail_form", 30, "$bn_mail_form", COLUMN_MAIL_FORM_FILE, ALT_MAIL_FORM_FILE);
	GetValue ("bn_search_form", 30, "$bn_search_form", COLUMN_FILE_SEARCH, ALT_FILE_SEARCH);
	GetValue ("bn_template", 30, "$bn_template", COLUMN_TEMPLATE_FILE, ALT_TEMPLATE_FILE);
	GetValue ("bn_fields", 30, "$bn_fields", COLUMN_FIELDS_NAME, ALT_FIELDS_NAME);
	GetValue ("bn_before_access", 30, "$bn_before_access", COLUMN_PHP_INCLUDE, ALT_PHP_INCLUDE);
	GetValue ("bn_login_form", 30, "$bn_login_form", COLUMN_FILE_LOGIN, ALT_FILE_LOGIN);
	GetValue ("bn_register_form", 30, "$bn_register_form", COLUMN_REGISTER_FORM, ALT_FILE_REGISTER);
	GetValue ("bn_show_profile", 30, "$bn_show_profile", COLUMN_SHOW_PROFILE, ALT_FILE_SHOW_PROFILE);
	GetValue ("bn_change_form", 30, "$bn_change_form", COLUMN_FILE_CHANGE_PASSWORD, ALT_FILE_CHANGE_PASSWORD);
	GetValue ("bn_forgot_form", 30, "$bn_forgot_form", COLUMN_FILE_FORGOT_PASSWORD, ALT_FILE_FORGOT_PASSWORD);
	GetValue ("bn_mail_template", 30, "$bn_mail_template", COLUMN_FILE_MAIL_TEMPLATE, ALT_FILE_MAIL_TEMPLATE);
	GetValue ("bn_subscribe_form", 30, "$bn_subscribe_form", COLUMN_SUBSCRIBE_FORM_TEMPLATE,  ALT_FILE_SUBSCRIBE_FORM);
	
	setTitle (TITLE_DISCUSSION_BOARD);
	getBoolean ("bn_thread", $bn_thread, COLUMN_ALLOW_REPLIES, ALT_ALLOW_REPLIES);

	setTitle (TITLE_DISPLAYED_MESSAGE);
	getBoolean ("bn_no_toolbar", $bn_no_toolbar, COLUMN_NO_TOOLBAR, ALT_NO_TOOLBAR);
	getBoolean ("bn_no_nav_bar", $bn_no_nav_bar, COLUMN_NO_NAVIGATION_BAR, ALT_NO_NAVIGATION_NAR);
	getBoolean ("bn_no_thread_list", $bn_no_thread_list, COLUMN_NO_THREAD, ALT_NO_THREAD);
	getBoolean ("bn_view_reply", $bn_view_reply, COLUMN_APPEND_MESSAGE, ALT_APPEND_MESSAGE);

	setTitle (TITLE_MESSAGE_LISTING);
	getBoolean ("bn_list_no_nav_bar", $bn_list_no_nav_bar, COLUMN_MESSAGE_NO_NAVIGATION_BAR, ALT_MESSAGE_NO_NAVIGATION_NAR);
	getBoolean ("bn_list_post", $bn_list_post, COLUMN_GUESTBOOK, ALT_GUESTBOOK);

	setTitle (TITLE_BROWSE_SERVER);
	getBoolean ("bn_browse_server", $bn_browse_server, COLUMN_BROWSE_SERVER, ALT_BROWSE_SERVER);
	GetValue ("bn_browse_dir", 30, "$bn_browse_dir", COLUMN_BASE_DIRECTORY, ALT_BASE_DIRECTORY);

} elseif ($mode == "editsite") {

# SITE LIST Configuration
# -----------------------
	hiddenField ("bn_dir_forums", $bn_dir_forums);
	hiddenField ("bn_dir_default", $bn_dir_default);
	hiddenField ("bn_usersource", $bn_usersource);
	hiddenField ("bn_access", $bn_access);
	hiddenField ("bn_db", $bn_db);
	hiddenField ("dbname", $dbname);
	hiddenField ("dbuser", $dbuser);
	hiddenField ("dbpassword", $dbpassword);
	hiddenField ("dbadmuser", $dbadmuser);
	hiddenField ("dbadmpassword", $dbadmpassword);
	hiddenField ("dbhost", $dbhost);
	hiddenField ("dbport", $dbport);

	hiddenField ("bn_search", $bn_search);
	hiddenField ("bn_search_engine", $bn_search_engine);
	hiddenField ("bn_search_path", $bn_search_path);
 	hiddenField ("bn_mail", $bn_mail);
	hiddenField ("bn_user_mail", $bn_user_mail);

	hiddenField ("bn_browse_server", $bn_browse_server);
	hiddenField ("bn_browse_dir", $bn_browse_dir);

	hiddenField ("bn_form", $bn_form);
	hiddenField ("bn_search_form", $bn_search_form);
	hiddenField ("bn_template", $bn_template);
	hiddenField ("bn_fields", $bn_fields);
	hiddenField ("bn_before_access", $bn_before_access);
	hiddenField ("bn_login_form", $bn_login_form);
	hiddenField ("bn_register_form", $bn_register_form);
	hiddenField ("bn_show_profile", $bn_show_profile);
	hiddenField ("bn_change_form", $bn_change_form);
	hiddenField ("bn_forgot_form", $bn_forgot_form);
	hiddenField ("bn_mail_template", $bn_mail_template);
	hiddenField ("bn_subscribe_form", $bn_subscribe_form);

	setTitle (TITLE_GENERAL_SETTINGS);
	GetValue ("bn_body", 40, "$bn_body", COLUMN_BODY, ALT_BODY);
	GetValue ("bn_date_format", 30, "$bn_date_format", COLUMN_DATE_FORMAT, ALT_DATE_FORMAT);
	if ($bn_tz_offset>0) {
	    $bn_tz_offset = '+' .$bn_tz_offset;
	}
	GetValue ("bn_tz_offset", 30, "$bn_tz_offset", COLUMN_TIME_OFFSET, ALT_TIME_OFFSET);
	getBoolean ("bn_cookies", $bn_cookies, COLUMN_USE_COOKIE, ALT_USE_COOKIE);

	setTitle (sprintf(TITLE_INCLUDE_FILES, $bn_dir), "include");
	GetValue ("bn_style", 30, "$bn_style", COLUMN_CSS_FILE, ALT_CSS_FILE);
	GetValue ("bn_header", 30, "$bn_header", COLUMN_HEADER_FILE, ALT_HEADER_FILE);
	GetValue ("bn_footer", 30, "$bn_footer", COLUMN_FOOTER_FILE, ALT_FOOTER_FILE);
	GetValue ("bn_list_vars", 30, "$bn_list_vars", COLUMN_LISTING_OUTLINE, ALT_LISTING_OUTLINE);
	GetValue ("bn_msgs", 30, "$bn_msgs", COLUMN_INCLUDE_MESSAGES, ALT_INCLUDE_MESSAGES);

} else {

# BASIC Configuration
# -------------------


	hiddenField ("bn_frames", $bn_frames);
	hiddenField ("bn_frameset", $bn_frameset);
	hiddenField ("bn_frame1", $bn_frame1);
	hiddenField ("bn_frame2", $bn_frame2);

	hiddenField ("bn_thread", $bn_thread);
	hiddenField ("bn_popup", $bn_popup);
	hiddenField ("bn_no_form_button_bar", $bn_no_form_button_bar);
	hiddenField ("bn_post_return", $bn_post_return);
	hiddenField ("bn_no_thanks_msg", $bn_no_thanks_msg);

	hiddenField ("bn_style", $bn_style);
	hiddenField ("bn_header", $bn_header);
	hiddenField ("bn_footer", $bn_footer);
	hiddenField ("bn_list_vars", $bn_list_vars);
	hiddenField ("bn_msgs", $bn_msgs);
	hiddenField ("bn_form", $bn_form);
	hiddenField ("bn_search_form", $bn_search_form);
	hiddenField ("bn_template", $bn_template);
	hiddenField ("bn_fields", $bn_fields);
	hiddenField ("bn_before_access", $bn_before_access);
	hiddenField ("bn_login_form", $bn_login_form);
	hiddenField ("bn_register_form", $bn_register_form);
	hiddenField ("bn_show_profile", $bn_show_profile);
	hiddenField ("bn_change_form", $bn_change_form);
	hiddenField ("bn_forgot_form", $bn_forgot_form);
	hiddenField ("bn_mail_template", $bn_mail_template);
	hiddenField ("bn_subscribe_form", $bn_subscribe_form);

	hiddenField ("bn_view_reply", $bn_view_reply);
	hiddenField ("bn_no_toolbar", $bn_no_toolbar);
	hiddenField ("bn_no_thread_list", $bn_no_thread_list);
	hiddenField ("bn_no_nav_bar", $bn_no_nav_bar);
	hiddenField ("bn_list_post", $bn_list_post);
	hiddenField ("bn_list_no_nav_bar", $bn_list_no_nav_bar);
	hiddenField ("bn_browse_server", $bn_browse_server);
	hiddenField ("bn_browse_dir", $bn_browse_dir);

	setTitle (TITLE_GENERAL_SETTINGS);
	GetValue ("bn_body", 40, "$bn_body", COLUMN_BODY, ALT_BODY);
	GetValue ("bn_date_format", 30, "$bn_date_format", COLUMN_DATE_FORMAT, ALT_DATE_FORMAT);
	if ($bn_tz_offset>0) {
	    $bn_tz_offset = '+' .$bn_tz_offset;
	}
	GetValue ("bn_tz_offset", 30, "$bn_tz_offset", COLUMN_TIME_OFFSET, ALT_TIME_OFFSET);
	getBoolean ("bn_cookies", $bn_cookies, COLUMN_USE_COOKIE, ALT_USE_COOKIE);

	getBoolean ("bn_modify", $bn_modify, COLUMN_ALLOW_MODIFICATION, ALT_ALLOW_MODIFICATION);
	getBoolean ("bn_delete", $bn_delete, COLUMN_ALLOW_DELETE, ALT_ALLOW_DELETE);

	setTitle (TITLE_MESSAGE_FORMATING);
	getBoolean ("bn_allow_html", $bn_allow_html, COLUMN_ALLOW_HTML, ALT_ALLOW_HTML);
	GetValue ("bn_allowed_tags", 40, "$bn_allowed_tags", COLUMN_TAGS_ALLOWED, ALT_TAGS_ALLOWED);
	GetValue ("bn_banned_tags", 40, "$bn_banned_tags", COLUMN_TAGS_DISALLOWED, ALT_TAGS_DISALLOWED);
	getBoolean ("bn_use_smileys", $bn_use_smileys, COLUMN_USE_SMILEY, ALT_USE_SMILEY);
	getBoolean ("bn_auto_url", $bn_auto_url, COLUMN_CONVERT_URL, ALT_CONVERT_URL);

	setTitle (TITLE_LAMER_FILTER);
	GetValue ("bn_banned_ips", 40, "$bn_banned_ips", COLUMN_DISALLOW_IP, ALT_DISALLOW_IP);

	setTitle (TITLE_FILE_UPLOAD);
	$file_uploads = (function_exists('ini_get')) ? ini_get('file_uploads') : get_cfg_var('file_uploads');
	if ($file_uploads) {
		getBoolean ("bn_file_upload", "$bn_file_upload", COLUMN_FILE_UPLOAD, ALT_FILE_UPLOAD);

		$phpsize = @get_cfg_var("upload_max_filesize");
		$maxsize = (int) $phpsize;
		if (eregi('k', $phpsize)) {
			$maxsize *= 1024;
		} elseif (eregi('m', $phpsize)) {
			$maxsize = $maxsize * 1024*1024;
		}

		if (empty($maxsize)) {
			$maxsize = 2*1024*1024;
		}

		$s = 32*1024;
		while ($s<=$maxsize) {
			$upload_sizes[$s] =pretty_size($s, 0);
			$s1 = $s;
			$s*=2;
			if ( ($MAX_FILE_SIZE>$s1) && ($MAX_FILE_SIZE<=$s) ) {
				$sz = $s;
			}
		}

		// GetValue ("MAX_FILE_SIZE", 10, "$MAX_FILE_SIZE", COLUMN_MAX_FILE_SIZE, ALT_MAX_FILE_SIZE);
		getCombo ("MAX_FILE_SIZE", $upload_sizes, $sz, COLUMN_MAX_FILE_SIZE, ALT_MAX_FILE_SIZE);

		GetValue ("bn_allowed_extensions", 40, "$bn_allowed_extensions", COLUMN_ALLOW_EXTENSION, ALT_ALLOW_EXTENSION);
		GetValue ("bn_banned_extensions", 40, "$bn_banned_extensions", COLUMN_DENY_EXTENSION, ALT_DENY_EXTENSION);
		GetValue ("bn_allowed_mimetypes", 40, "$bn_allowed_mimetypes", COLUMN_ALLOW_MIME, ALT_ALLOW_MIME);
		GetValue ("bn_banned_mimetypes", 40, "$bn_banned_mimetypes", COLUMN_DENY_MIME, ALT_DENY_MIME);

	} else {
		echo "<TR><td colspan=3 align=\"center\"><font color=\"red\"><b>".ERROR_FILE_UPLOAD_DISABLED."</b></font></td></tr>\n";
	}


	setTitle (TITLE_SEARCH);
	getBoolean ("bn_search", $bn_search, COLUMN_SEARCH_SUPPORT, ALT_SEARCH_SUPPORT);

	echo "<TR><TD width=5>&nbsp;</TD><TD colspan=2><I>" . COLUMN_SEARCH_ENGINE. "</I>: ";
	listBox ("bn_search_engine", $search_engines, $bn_search_engine);
	echo "</TD></TR>";
	GetValue ("bn_search_path", 30, "$bn_search_path", COLUMN_PATH_NAME, ALT_PATH_NAME);

	setTitle (TITLE_SEND_MAIL);
	getBoolean ("bn_mail", $bn_mail, COLUMN_MAIL_MODERATOR, ALT_MAIL_MODERATOR);
	getBoolean ("bn_user_mail", $bn_user_mail, COLUMN_ALLOW_MAIL_SUBSCRIPTION, ALT_ALLOW_MAIL_SUBSCRIPTION);
	getBoolean ("bn_private_mail", $bn_private_mail, COLUMN_ALLOW_PRIVATE_MAIL, ALT_ALLOW_PRIVATE_MAIL);
	getBoolean ("bn_mail_attachment", $bn_mail_attachment, COLUMN_MAIL_ATTACHMENT, ALT_MAIL_ATTACHMENT); 

}
?>
</TABLE>
<br />
 <div align="center">
  <?php submitButton('save', LABEL_SAVE); ?>
  <?php resetButton('reset', LABEL_RESET); ?>
  <?php submitButton('undo', LABEL_DEFAULT); ?>
 </div>
<?php
	table_footer(); 
	endForm();
	display_footer();
?>
