CREATE TABLE videolib (
  title varchar(128) DEFAULT '' NOT NULL,
  description varchar(256) DEFAULT '',
  PRIMARY KEY (title)
);

CREATE TABLE record (
  program varchar(128) DEFAULT '' NOT NULL,
  recordno INTEGER NOT NULL,
  title varchar(128) DEFAULT '' NOT NULL,
  filename varchar(128) NOT NULL,
  recdate date NOT NULL,
  rectime time NOT NULL,
  duration interval, 
  description varchar(256),
  channel varchar(10) NOT NULL,
  quality varchar(16), 
  dimension varchar(16),
  smultiplex varchar(16), 
  atno INTEGER,
  avisize INTEGER,
  thumb OID,
  
  PRIMARY KEY (program, recordno),
  CONSTRAINT record_fk1 FOREIGN KEY (title)
  REFERENCES videolib (title)
  ON DELETE CASCADE ON UPDATE CASCADE
);

CREATE TABLE bstation (
  channel varchar(10) DEFAULT '' NOT NULL,
  bcasname varchar(64) DEFAULT '' NOT NULL,
  alias1 varchar(64) DEFAULT '' NOT NULL,
  alias2 varchar(64) DEFAULT '' NOT NULL,
  alias3 varchar(64) DEFAULT '' NOT NULL,
  alias4 varchar(64) DEFAULT '' NOT NULL,
  alias5 varchar(64) DEFAULT '' NOT NULL,
  url varchar(128) DEFAULT ''
);

CREATE TABLE quality (
  bitrate INTEGER NOT NULL,
  name varchar(32) NOT NULL
);

CREATE TABLE multiplex (
  id varchar(16) NOT NULL,
  name varchar(32) NOT NULL
);

CREATE TABLE dimension (
  id varchar(16) NOT NULL,
  name varchar(32) NOT NULL
);

CREATE TABLE iepgsite (
  url varchar(128),
  sitename varchar(128)
);

GRANT ALL ON videolib TO tvrec;
GRANT ALL ON record TO tvrec;
GRANT ALL ON bstation TO tvrec;
GRANT ALL ON iepgsite TO tvrec;
GRANT SELECT ON quality TO tvrec;
GRANT SELECT ON multiplex TO tvrec;
GRANT SELECT ON dimension TO tvrec;

INSERT INTO quality VALUES(2000, '');
INSERT INTO quality VALUES(1500, '');
INSERT INTO quality VALUES(1250, '');
INSERT INTO quality VALUES(1000, '');

INSERT INTO multiplex VALUES('amode=0', 'Υ');
INSERT INTO multiplex VALUES('amode=1', 'ƥ쥪');
INSERT INTO multiplex VALUES('amode=2', '粻');
INSERT INTO multiplex VALUES('amode=3', '');

INSERT INTO dimension VALUES('640:480', '640480');
INSERT INTO dimension VALUES('512:384', '512384');
INSERT INTO dimension VALUES('480:360', '480360');
INSERT INTO dimension VALUES('400:300', '400300');
INSERT INTO dimension VALUES('352:288', '352288');

