<?php
class pgdb {
	var $user = "tvrec";
	var $passwd = "";
	var $host = "localhost";
	var $port = 5432;
	var $dbname = "tvrec";
	var $constr = "";
	var $db = "";
	
	// constructor
	function pgdb($params = false) {
		if(is_array($params)) {
            foreach ($params as $p => $v) {
                $this->$p = $v;
			}
		}	
		$this->constr = sprintf("dbname=%s user=%s",
								$this->dbname, $this->user);
	}
	function &connect($constr = false) {
		if(is_string($constr)) {
			$this->constr = $constr;
		}
		$this->db = pg_connect($this->constr);
		return($this->db);
	}
	
	function &select($sql, $keys, $quotes) {
		if(!is_array($keys)) return(false);
		$n = 0;
		foreach($keys as $k => $v) {
			$q = $quotes[$k];
			if($q) {
//				$val = addslashes($v);
				$w[$n] = "$k=$q$v$q";
			} else {
				$val = $v;
				$w[$n] = "$k=$v";
			}
			$n++;
		}
		$sql .= " WHERE ";
		for($i=0; ; $i++) {
			$sql .= $w[$i];
			if($i >= $n-1) break;
			$sql .= " AND ";
		}
//		print $sql;
		return(pg_query($this->db, $sql));
	}

	function &delete($table, $keys, $quotes) {
		if(!is_array($keys)) return(false);
		$n = 0;
		foreach($keys as $k => $v) {
			$q = $quotes[$k];
			if($q) {
//				$val = addslashes($v);
				$w[$n] = "$k=$q$v$q";
			} else {
				$val = $v;
				$w[$n] = "$k=$v";
			}
			$n++;
		}
		$sql = "DELETE FROM $table WHERE ";
		for($i=0; ; $i++) {
			$sql .= $w[$i];
			if($i >= $n-1) break;
			$sql .= " AND ";
		}
//		print $sql;
		return(pg_query($this->db, $sql));
	}

	function &insert($table, $keys, $vars, $quotes) {
		if(!is_array($keys) || !is_array($vars)) return(false);
		$query = "SELECT * FROM $table";
		$res = $this->select($query, $keys, $quotes);
		if(!$res || pg_num_rows($res) > 0) {
			return(false);
		}
		$n = 0;
		foreach($vars as $c => $v) {
			$cols[$n] = $c;
			$vars[$n] = $v;
			$n++;
		}
		$values = "";
		$columns = "";
		for($i=0; ; $i++) {
			$columns .= $cols[$i];
			$q = $quotes[$cols[$i]];
			if($q) {
//				$val = addslashes($vars[$i]);
				$val = $vars[$i];
				$values .= "$q$val$q";
			} else {
				$val = $vars[$i];
				$values .= "$val";
			}
			if($i >= $n-1) break;
			$columns .= ",";
			$values .= ",";
		}
		$insert = "INSERT INTO $table ($columns) VALUES($values)";
//		print $insert;
		return(pg_query($this->db, $insert));
	}

	function &update($table, $keys, $vars, $quotes) {
		if(!is_array($keys) || !is_array($vars)) return(false);
		$query = "SELECT * FROM $table";
		$res = $this->select($query, $keys, $quotes);
		if(!$res) {
			return(false);
		}
		if(!pg_fetch_row($res, 0)) {
			return(false);
		}
		$sql = "UPDATE $table SET ";
		$n = 0;
		foreach($keys as $k => $v) {
			$q = $quotes[$k];
			if($q) {
//				$val = addslashes($v);
				$w[$n] = "$k=$q$v$q";
			} else {
				$val = $v;
				$w[$n] = "$k=$v";
			}
			$n++;
		}
		$where = " WHERE ";
		for($i=0; ; $i++) {
			$where .= $w[$i];
			if($i >= $n-1) break;
			$where .= " AND ";
		}
		$n = 0;
		foreach($vars as $c => $v) {
			$cols[$n] = $c;
			$vars[$n] = $v;
			$n++;
		}
		for($i=0; ; $i++) {
			$q = $quotes[$cols[$i]];
			if($q) {
//				$val = addslashes($vars[$i]);
				$val = $vars[$i];
				$sql .= "$cols[$i] = $q$val$q";
			} else {
				$val = $vars[$i];
				$sql .= "$cols[$i] = $val";
			}
			if($i >= $n-1) break;
			$sql .= ",";
		}
		$sql .= $where;
//		print $sql;
		return(pg_query($this->db, $sql));
	}

	function &query($sql) {
		return(pg_query($this->db, $sql));
	}

	function &num_rows($res) {
		return(pg_num_rows($res));
	}

	function &fetch_assoc($res, $row) {
		return(pg_fetch_assoc($res, $row));
	}

	function &lo_open($oid, $mode) {
		return(pg_lo_open($this->db, $oid, $mode));
	}

	function &lo_create() {
		return(pg_lo_create($this->db));
	}

	function &lo_read($im, $size) {
		return(pg_lo_read($im, $size));
	}

	function &lo_read_all($im) {
		return(pg_lo_read_all($im));
	}

	function &lo_write($lo, $im) {
		return(pg_lo_write($lo, $im));
	}

	function &lo_seek($im, $off, $whence) {
		return(pg_lo_seek($im, $off, $whence));
	}

	function &lo_tell($im) {
		return(pg_lo_tell($im));
	}

	function &lo_close($im) {
		return(pg_lo_close($im));
	}

	function &lo_unlink($oid) {
		return(pg_lo_unlink($this->db, $oid));
	}
}
?>
