/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.FontDeclaration;
import writer2latex.office.ListStyle;
import writer2latex.office.MasterPage;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.office.PageMaster;
import writer2latex.office.ParStyle;
import writer2latex.office.PropertySet;
import writer2latex.office.SectionStyle;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Misc;

public class WriterStyleCollection {
    private OfficeStyleFamily font = new OfficeStyleFamily(class$writer2latex$office$FontDeclaration == null ? (class$writer2latex$office$FontDeclaration = WriterStyleCollection.class$("writer2latex.office.FontDeclaration")) : class$writer2latex$office$FontDeclaration);
    private OfficeStyleFamily text = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = WriterStyleCollection.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily par = new OfficeStyleFamily(class$writer2latex$office$ParStyle == null ? (class$writer2latex$office$ParStyle = WriterStyleCollection.class$("writer2latex.office.ParStyle")) : class$writer2latex$office$ParStyle);
    private OfficeStyleFamily section = new OfficeStyleFamily(class$writer2latex$office$SectionStyle == null ? (class$writer2latex$office$SectionStyle = WriterStyleCollection.class$("writer2latex.office.SectionStyle")) : class$writer2latex$office$SectionStyle);
    private OfficeStyleFamily table = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = WriterStyleCollection.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily column = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = WriterStyleCollection.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily row = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = WriterStyleCollection.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily cell = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = WriterStyleCollection.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily frame = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = WriterStyleCollection.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily list = new OfficeStyleFamily(class$writer2latex$office$ListStyle == null ? (class$writer2latex$office$ListStyle = WriterStyleCollection.class$("writer2latex.office.ListStyle")) : class$writer2latex$office$ListStyle);
    private OfficeStyleFamily pageMaster = new OfficeStyleFamily(class$writer2latex$office$PageMaster == null ? (class$writer2latex$office$PageMaster = WriterStyleCollection.class$("writer2latex.office.PageMaster")) : class$writer2latex$office$PageMaster);
    private OfficeStyleFamily masterPage = new OfficeStyleFamily(class$writer2latex$office$MasterPage == null ? (class$writer2latex$office$MasterPage = WriterStyleCollection.class$("writer2latex.office.MasterPage")) : class$writer2latex$office$MasterPage);
    private String sFirstMasterPageName = null;
    private ListStyle outline = new ListStyle();
    private PropertySet footnotes = null;
    private PropertySet endnotes = null;
    static /* synthetic */ Class class$writer2latex$office$FontDeclaration;
    static /* synthetic */ Class class$writer2latex$office$StyleWithProperties;
    static /* synthetic */ Class class$writer2latex$office$ParStyle;
    static /* synthetic */ Class class$writer2latex$office$SectionStyle;
    static /* synthetic */ Class class$writer2latex$office$ListStyle;
    static /* synthetic */ Class class$writer2latex$office$PageMaster;
    static /* synthetic */ Class class$writer2latex$office$MasterPage;

    public OfficeStyleFamily getFontDeclarations() {
        return this.font;
    }

    public FontDeclaration getFontDeclaration(String string) {
        return (FontDeclaration)this.font.getStyle(string);
    }

    public OfficeStyleFamily getTextStyles() {
        return this.text;
    }

    public StyleWithProperties getTextStyle(String string) {
        return (StyleWithProperties)this.text.getStyle(string);
    }

    public OfficeStyleFamily getParStyles() {
        return this.par;
    }

    public ParStyle getParStyle(String string) {
        return (ParStyle)this.par.getStyle(string);
    }

    public ParStyle getDefaultParStyle() {
        return (ParStyle)this.par.getDefaultStyle();
    }

    public OfficeStyleFamily getSectionStyles() {
        return this.section;
    }

    public SectionStyle getSectionStyle(String string) {
        return (SectionStyle)this.section.getStyle(string);
    }

    public OfficeStyleFamily getTableStyles() {
        return this.table;
    }

    public StyleWithProperties getTableStyle(String string) {
        return (StyleWithProperties)this.table.getStyle(string);
    }

    public OfficeStyleFamily getColumnStyles() {
        return this.column;
    }

    public StyleWithProperties getColumnStyle(String string) {
        return (StyleWithProperties)this.column.getStyle(string);
    }

    public OfficeStyleFamily getRowStyles() {
        return this.row;
    }

    public StyleWithProperties getRowStyle(String string) {
        return (StyleWithProperties)this.row.getStyle(string);
    }

    public OfficeStyleFamily getCellStyles() {
        return this.cell;
    }

    public StyleWithProperties getCellStyle(String string) {
        return (StyleWithProperties)this.cell.getStyle(string);
    }

    public StyleWithProperties getDefaultCellStyle() {
        return (StyleWithProperties)this.cell.getDefaultStyle();
    }

    public OfficeStyleFamily getFrameStyles() {
        return this.frame;
    }

    public StyleWithProperties getFrameStyle(String string) {
        return (StyleWithProperties)this.frame.getStyle(string);
    }

    public StyleWithProperties getDefaultFrameStyle() {
        return (StyleWithProperties)this.frame.getDefaultStyle();
    }

    public OfficeStyleFamily getListStyles() {
        return this.list;
    }

    public ListStyle getListStyle(String string) {
        return (ListStyle)this.list.getStyle(string);
    }

    public OfficeStyleFamily getPageMasters() {
        return this.pageMaster;
    }

    public PageMaster getPageMaster(String string) {
        return (PageMaster)this.pageMaster.getStyle(string);
    }

    public OfficeStyleFamily getMasterPages() {
        return this.masterPage;
    }

    public MasterPage getMasterPage(String string) {
        return (MasterPage)this.masterPage.getStyle(string);
    }

    public String getFirstMasterPageName() {
        return this.sFirstMasterPageName;
    }

    public ListStyle getOutlineStyle() {
        return this.outline;
    }

    public PropertySet getFootnotesConfiguration() {
        return this.footnotes;
    }

    public PropertySet getEndnotesConfiguration() {
        return this.endnotes;
    }

    private void loadStylesFromDOM(Node node, boolean bl) {
        boolean bl2 = "office:automatic-styles".equals(node.getNodeName());
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                StyleWithProperties styleWithProperties;
                String string;
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                if (node2.getNodeName().equals("style:style")) {
                    string = Misc.getAttribute(node2, "style:family");
                    if ("text".equals(string)) {
                        this.text.loadStyleFromDOM(node2, bl2);
                        continue;
                    }
                    if ("paragraph".equals(string)) {
                        this.par.loadStyleFromDOM(node2, bl2 && !bl);
                        continue;
                    }
                    if ("section".equals(string)) {
                        this.section.loadStyleFromDOM(node2, bl2);
                        continue;
                    }
                    if ("table".equals(string)) {
                        this.table.loadStyleFromDOM(node2, bl2);
                        continue;
                    }
                    if ("table-column".equals(string)) {
                        this.column.loadStyleFromDOM(node2, bl2);
                        continue;
                    }
                    if ("table-row".equals(string)) {
                        this.row.loadStyleFromDOM(node2, bl2);
                        continue;
                    }
                    if ("table-cell".equals(string)) {
                        this.cell.loadStyleFromDOM(node2, bl2);
                        continue;
                    }
                    if (!"graphics".equals(string)) continue;
                    this.frame.loadStyleFromDOM(node2, bl2);
                    continue;
                }
                if (node2.getNodeName().equals("style:page-master")) {
                    this.pageMaster.loadStyleFromDOM(node2, bl2);
                    continue;
                }
                if (node2.getNodeName().equals("style:master-page")) {
                    this.masterPage.loadStyleFromDOM(node2, bl2);
                    if (this.sFirstMasterPageName != null) continue;
                    this.sFirstMasterPageName = Misc.getAttribute(node2, "style:name");
                    continue;
                }
                if (node2.getNodeName().equals("text:list-style")) {
                    this.list.loadStyleFromDOM(node2, bl2);
                    continue;
                }
                if (node2.getNodeName().equals("text:outline-style")) {
                    this.outline.loadStyleFromDOM(node2);
                    continue;
                }
                if (!node2.getNodeName().equals("style:default-style")) continue;
                string = Misc.getAttribute(node2, "style:family");
                if ("paragraph".equals(string)) {
                    styleWithProperties = new ParStyle();
                    ((ParStyle)styleWithProperties).loadStyleFromDOM(node2);
                    this.par.setDefaultStyle(styleWithProperties);
                    continue;
                }
                if ("graphics".equals(string)) {
                    styleWithProperties = new StyleWithProperties();
                    styleWithProperties.loadStyleFromDOM(node2);
                    this.frame.setDefaultStyle(styleWithProperties);
                    continue;
                }
                if (!"table-cell".equals(string)) continue;
                styleWithProperties = new StyleWithProperties();
                styleWithProperties.loadStyleFromDOM(node2);
                this.cell.setDefaultStyle(styleWithProperties);
            }
        }
    }

    public void loadStylesFromDOM(Document document, Document document2) {
        this.loadStylesFromDOM(document, document2, false);
    }

    public void loadStylesFromDOM(Document document, Document document2, boolean bl) {
        Node node;
        NodeList nodeList = document == null ? document2.getElementsByTagName("office:font-decls") : document.getElementsByTagName("office:font-decls");
        if (nodeList.getLength() != 0 && (node = nodeList.item(0)).hasChildNodes()) {
            NodeList nodeList2 = node.getChildNodes();
            int n = nodeList2.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList2.item(i);
                if (node2.getNodeType() != 1 || !node2.getNodeName().equals("style:font-decl")) continue;
                this.font.loadStyleFromDOM(node2, false);
            }
        }
        if ((nodeList = document == null ? document2.getElementsByTagName("office:styles") : document.getElementsByTagName("office:styles")).getLength() != 0) {
            this.loadStylesFromDOM(nodeList.item(0), bl);
        }
        if ((nodeList = document == null ? document2.getElementsByTagName("office:master-styles") : document.getElementsByTagName("office:master-styles")).getLength() != 0) {
            this.loadStylesFromDOM(nodeList.item(0), bl);
        }
        if (document != null && (nodeList = document.getElementsByTagName("office:automatic-styles")).getLength() != 0) {
            this.loadStylesFromDOM(nodeList.item(0), bl);
        }
        if ((nodeList = document2.getElementsByTagName("office:automatic-styles")).getLength() != 0) {
            this.loadStylesFromDOM(nodeList.item(0), bl);
        }
        if ((nodeList = document == null ? document2.getElementsByTagName("text:footnotes-configuration") : document.getElementsByTagName("text:footnotes-configuration")).getLength() != 0) {
            this.footnotes = new PropertySet();
            this.footnotes.loadFromDOM(nodeList.item(0));
        }
        if ((nodeList = document == null ? document2.getElementsByTagName("text:endnotes-configuration") : document.getElementsByTagName("text:endnotes-configuration")).getLength() != 0) {
            this.endnotes = new PropertySet();
            this.endnotes.loadFromDOM(nodeList.item(0));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

