/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import writer2latex.office.ListStyle;
import writer2latex.util.Misc;

public class ListCounter {
    private int[] nCounter = new int[11];
    private String[] sNumFormat = new String[11];
    private ListStyle style;
    private int nLevel = 1;

    public ListCounter(ListStyle listStyle) {
        this.style = listStyle;
        for (int i = 1; i <= 10; ++i) {
            this.sNumFormat[i] = listStyle.getLevelProperty(i, "style:num-format");
        }
    }

    public ListCounter step(int n) {
        int n2 = n;
        this.nCounter[n2] = this.nCounter[n2] + 1;
        if (n < 10) {
            this.nCounter[n + 1] = 0;
        }
        this.nLevel = n;
        return this;
    }

    public String getLabel() {
        if (this.sNumFormat[this.nLevel] == null) {
            return "*";
        }
        int n = Misc.getPosInteger(this.style.getLevelProperty(this.nLevel, "text:display-levels"), 1);
        String string = this.style.getLevelProperty(this.nLevel, "style:num-prefix");
        String string2 = this.style.getLevelProperty(this.nLevel, "style:num-suffix");
        String string3 = "";
        if (string != null) {
            string3 = string3 + string;
        }
        for (int i = this.nLevel - n + 1; i < this.nLevel; ++i) {
            string3 = string3 + this.formatNumber(this.nCounter[i], this.sNumFormat[i], true) + ".";
        }
        string3 = string3 + this.formatNumber(this.nCounter[this.nLevel], this.sNumFormat[this.nLevel], true);
        if (string2 != null) {
            string3 = string3 + string2;
        }
        return string3;
    }

    private String formatNumber(int n, String string, boolean bl) {
        if ("a".equals(string)) {
            return Misc.int2alph(n, bl);
        }
        if ("A".equals(string)) {
            return Misc.int2Alph(n, bl);
        }
        if ("i".equals(string)) {
            return Misc.int2roman(n);
        }
        if ("I".equals(string)) {
            return Misc.int2Roman(n);
        }
        if ("1".equals(string)) {
            return Misc.int2arabic(n);
        }
        return "";
    }
}

