/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.content;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.HeadingMap;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class InlineConverter
extends ConverterHelper {
    public InlineConverter(Config config, ConverterPalette converterPalette) {
        super(config, converterPalette);
    }

    public void traverseInlineText(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context, boolean bl) {
        if (this.onlyNote(element)) {
            bl = false;
        }
        boolean bl2 = false;
        String string = element.getAttribute("text:style-name");
        this.palette.getI18n().pushSpecialTable(this.palette.getCharSc().getFontName(string));
        BeforeAfter beforeAfter = new BeforeAfter();
        Context context2 = (Context)context.clone();
        this.palette.getCharSc().applyTextStyle(string, beforeAfter, context2);
        if (bl && !context2.isInFootnote()) {
            bl2 = true;
        }
        if (bl) {
            if (bl2) {
                context2.setNoFootnotes(true);
            }
            laTeXDocumentPortion.append(beforeAfter.getBefore());
        }
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            block4: for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                short s = node.getNodeType();
                switch (s) {
                    case 3: {
                        String string2 = node.getNodeValue();
                        if (string2.length() <= 0) continue block4;
                        laTeXDocumentPortion.append(this.palette.getI18n().convert(string2, false, context2.getLang()));
                        continue block4;
                    }
                    case 1: {
                        Element element2 = (Element)node;
                        String string3 = element2.getTagName();
                        if (element2.getNodeName().startsWith("draw:")) {
                            this.palette.getDrawCv().handleDrawElement(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:s")) {
                            String string4;
                            if (this.config.ignoreDoubleSpaces()) {
                                laTeXDocumentPortion.append(" ");
                                continue block4;
                            }
                            String string5 = string4 = this.config.ignoreDoubleSpaces() ? " " : "\\ ";
                            for (int j = Misc.getPosInteger(element2.getAttribute("text:c"), 1); j > 0; --j) {
                                laTeXDocumentPortion.append("\\ ");
                            }
                            continue block4;
                        }
                        if (string3.equals("text:tab-stop")) {
                            if (context2.isInHeaderFooter()) {
                                laTeXDocumentPortion.append("\\hfill ");
                                continue block4;
                            }
                            laTeXDocumentPortion.append(" ");
                            continue block4;
                        }
                        if (string3.equals("text:line-break")) {
                            if (!context2.isInHeaderFooter() && !this.config.ignoreHardLineBreaks()) {
                                laTeXDocumentPortion.append("\\newline").nl();
                                continue block4;
                            }
                            laTeXDocumentPortion.append(" ");
                            continue block4;
                        }
                        if (string3.equals("text:span")) {
                            if (context2.isVerbatim()) {
                                this.traverseVerbatimInlineText(element2, laTeXDocumentPortion, context2, true);
                                continue block4;
                            }
                            this.traverseInlineText(element2, laTeXDocumentPortion, context2, true);
                            continue block4;
                        }
                        if (string3.equals("text:a")) {
                            this.palette.getFieldCv().handleAnchor(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("office:annotation")) {
                            this.handleOfficeAnnotation(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:page-number")) {
                            this.palette.getFieldCv().handlePageNumber(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:page-count")) {
                            this.palette.getFieldCv().handlePageCount(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (context2.isInHeaderFooter()) {
                            if (string3.equals("text:chapter")) {
                                this.handleChapterField(element2, laTeXDocumentPortion, context2);
                                continue block4;
                            }
                            if (!string3.startsWith("text:")) continue block4;
                            this.traverseInlineText(element2, laTeXDocumentPortion, context2, false);
                            continue block4;
                        }
                        if (string3.equals("text:footnote")) {
                            this.palette.getNoteCv().handleFootnote(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:endnote")) {
                            this.palette.getNoteCv().handleEndnote(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:sequence")) {
                            this.palette.getFieldCv().handleSequence(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:sequence-ref")) {
                            this.palette.getFieldCv().handleSequenceRef(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:footnote-ref")) {
                            this.palette.getNoteCv().handleFootnoteRef(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:endnote-ref")) {
                            this.palette.getNoteCv().handleEndnoteRef(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:reference-mark")) {
                            this.palette.getFieldCv().handleReferenceMark(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:reference-mark-start")) {
                            this.palette.getFieldCv().handleReferenceMark(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:reference-ref")) {
                            this.palette.getFieldCv().handleReferenceRef(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:bookmark")) {
                            this.palette.getFieldCv().handleBookmark(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:bookmark-start")) {
                            this.palette.getFieldCv().handleBookmark(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:bookmark-ref")) {
                            this.palette.getFieldCv().handleBookmarkRef(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:bibliography-mark")) {
                            this.palette.getIndexCv().handleBibliographyMark(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:alphabetical-index-mark")) {
                            this.palette.getIndexCv().handleAlphabeticalIndexMark(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (string3.equals("text:alphabetical-index-mark-start")) {
                            this.palette.getIndexCv().handleAlphabeticalIndexMark(element2, laTeXDocumentPortion, context2);
                            continue block4;
                        }
                        if (!string3.startsWith("text:")) continue block4;
                        this.traverseInlineText(element2, laTeXDocumentPortion, context2, false);
                        continue block4;
                    }
                }
            }
        }
        if (bl) {
            laTeXDocumentPortion.append(beforeAfter.getAfter());
            context2.setNoFootnotes(false);
            if (!context2.isInFootnote()) {
                this.palette.getNoteCv().flushFootnotes(laTeXDocumentPortion, context);
            }
        }
        this.palette.getI18n().popSpecialTable();
    }

    public void traversePlainInlineText(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        if (element.hasChildNodes()) {
            String string = element.getAttribute("text:style-name");
            this.palette.getI18n().pushSpecialTable(this.palette.getCharSc().getFontName(string));
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            block4: for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                short s = node.getNodeType();
                switch (s) {
                    case 3: {
                        String string2 = node.getNodeValue();
                        if (string2.length() <= 0) continue block4;
                        laTeXDocumentPortion.append(this.palette.getI18n().convert(string2, false, context.getLang()));
                        continue block4;
                    }
                    case 1: {
                        Element element2 = (Element)node;
                        String string3 = element2.getTagName();
                        if (string3.equals("text:s")) {
                            for (int j = Misc.getPosInteger(element2.getAttribute("text:c"), 1); j > 0; --j) {
                                laTeXDocumentPortion.append("\\ ");
                            }
                            continue block4;
                        }
                        if (string3.equals("text:tab-stop")) {
                            laTeXDocumentPortion.append(" ");
                            continue block4;
                        }
                        if (string3.equals("text:footnote") || string3.equals("text:endnote") || !string3.startsWith("text:")) continue block4;
                        this.traversePlainInlineText(element2, laTeXDocumentPortion, context);
                        continue block4;
                    }
                }
            }
            this.palette.getI18n().popSpecialTable();
        }
    }

    public void traverseVerbatimInlineText(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context, boolean bl) {
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            block4: for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                short s = node.getNodeType();
                switch (s) {
                    case 3: {
                        String string = node.getNodeValue();
                        if (string.length() <= 0) continue block4;
                        laTeXDocumentPortion.append(string);
                        continue block4;
                    }
                    case 1: {
                        Element element2 = (Element)node;
                        String string = element2.getTagName();
                        if (string.equals("text:s")) {
                            for (int j = Misc.getPosInteger(element2.getAttribute("text:c"), 1); j > 0; --j) {
                                laTeXDocumentPortion.append(" ");
                            }
                            continue block4;
                        }
                        if (string.equals("text:tab-stop")) {
                            laTeXDocumentPortion.append(" ");
                            continue block4;
                        }
                        if (string.equals("text:line-break")) {
                            if (bl) continue block4;
                            laTeXDocumentPortion.nl();
                            continue block4;
                        }
                        if (string.equals("text:footnote") || string.equals("text:endnote") || !string.startsWith("text:")) continue block4;
                        this.traverseVerbatimInlineText(element2, laTeXDocumentPortion, context, bl);
                        continue block4;
                    }
                }
            }
        }
    }

    public void traversePCDATA(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                if (nodeList.item(i).getNodeType() != 3) continue;
                laTeXDocumentPortion.append(this.palette.getI18n().convert(nodeList.item(i).getNodeValue(), false, context.getLang()));
            }
        }
    }

    private void handleChapterField(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        HeadingMap headingMap = this.config.getHeadingMap();
        int n = Misc.getPosInteger(element.getAttribute("text:outline-level"), 1);
        if (n <= headingMap.getMaxLevel()) {
            int n2 = headingMap.getLevel(n);
            if (n2 == 1) {
                this.palette.getPageSc().setChapterField1(element.getAttribute("text:display"));
                laTeXDocumentPortion.append("{\\leftmark}");
            } else if (n2 == 2) {
                this.palette.getPageSc().setChapterField2(element.getAttribute("text:display"));
                laTeXDocumentPortion.append("{\\rightmark}");
            }
        }
    }

    private void handleOfficeAnnotation(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        laTeXDocumentPortion.append("%").nl().append("%");
        Element element2 = Misc.getChildByTagName(element, "text:p");
        if (element2 != null) {
            this.traversePCDATA(element2, laTeXDocumentPortion, context);
        }
        laTeXDocumentPortion.nl();
    }

    private boolean onlyNote(Node node) {
        if (!node.hasChildNodes()) {
            return false;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        block4: for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            short s = node2.getNodeType();
            String string = node2.getNodeName();
            switch (s) {
                case 3: {
                    return false;
                }
                case 1: {
                    if ("text:footnote".equals(string) || "text:endnote".equals(string)) continue block4;
                    return false;
                }
            }
        }
        return true;
    }
}

