/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.bibtex;

import java.io.IOException;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.converter.xml.sxw.SxwDocument;
import org.w3c.dom.NodeList;
import writer2latex.bibtex.BibTeXDocument;
import writer2latex.office.BibMark;
import writer2latex.util.Misc;

public final class DocumentSerializerImpl
implements DocumentSerializer {
    private SxwDocument sxwDoc;
    private String sOutFileName;

    public void setOutFileName(String string) {
        this.sOutFileName = Misc.trimDocumentName(string, ".bib");
    }

    public DocumentSerializerImpl(Document document) {
        this.sxwDoc = (SxwDocument)document;
        this.sOutFileName = this.sxwDoc.getName();
    }

    public ConvertData serialize() throws IOException, ConvertException {
        ConvertData convertData = new ConvertData();
        BibTeXDocument bibTeXDocument = new BibTeXDocument(this.sOutFileName);
        org.w3c.dom.Document document = this.sxwDoc.getContentDOM();
        NodeList nodeList = document.getElementsByTagName("text:bibliography-mark");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string = Misc.getAttribute(nodeList.item(i), "text:identifier");
            if (bibTeXDocument.containsKey(string)) continue;
            bibTeXDocument.put(new BibMark(nodeList.item(i)));
        }
        convertData.addDocument((Document)bibTeXDocument);
        return convertData;
    }
}

