<?xml version="1.0" encoding="UTF-8"?>
<!--

    OpenOffice.org - a multi-platform office productivity suite
 
    $RCSfile: body.xsl,v $
 
    $Revision: 1.6 $
 
    last change: $Author: rt $ $Date: 2005/09/08 22:00:53 $
 
    The Contents of this file are made available subject to
    the terms of GNU Lesser General Public License Version 2.1.
 
 
      GNU Lesser General Public License Version 2.1
      =============================================
      Copyright 2005 by Sun Microsystems, Inc.
      901 San Antonio Road, Palo Alto, CA 94303, USA
 
      This library is free software; you can redistribute it and/or
      modify it under the terms of the GNU Lesser General Public
      License version 2.1, as published by the Free Software Foundation.
 
      This library is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
      Lesser General Public License for more details.
 
      You should have received a copy of the GNU Lesser General Public
      License along with this library; if not, write to the Free Software
      Foundation, Inc., 59 Temple Place, Suite 330, Boston,
      MA  02111-1307  USA
 
-->
<!--
	For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:office="http://openoffice.org/2000/office"
	xmlns:style="http://openoffice.org/2000/style"
	xmlns:text="http://openoffice.org/2000/text"
	xmlns:table="http://openoffice.org/2000/table"
	xmlns:draw="http://openoffice.org/2000/drawing"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:number="http://openoffice.org/2000/datastyle"
	xmlns:svg="http://www.w3.org/2000/svg"
	xmlns:chart="http://openoffice.org/2000/chart"
	xmlns:dr3d="http://openoffice.org/2000/dr3d"
	xmlns:math="http://www.w3.org/1998/Math/MathML"
	xmlns:form="http://openoffice.org/2000/form"
	xmlns:script="http://openoffice.org/2000/script"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:meta="http://openoffice.org/2000/meta"
	xmlns:config="http://openoffice.org/2001/config"
	xmlns:help="http://openoffice.org/2000/help"
	xmlns:java="http://xml.apache.org/xslt/java"
	xmlns:urlencoder="http://www.jclark.com/xt/java/java.net.URLEncoder"
	exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help java urlencoder">


	<xsl:include href="table_of_content.xsl" />


	<!-- ****************** -->
	<!-- *** Whitespace *** -->
	<!-- ****************** -->

	<xsl:template match="text:s">
		<xsl:call-template name="write-breakable-whitespace">
			<xsl:with-param name="whitespaces" select="@text:c" />
		</xsl:call-template>
	</xsl:template>


	<!--write the number of 'whitespaces' -->
	<xsl:template name="write-breakable-whitespace">
		<xsl:param name="whitespaces" />

		<!--write two space chars as the normal white space character will be stripped
			and the other is able to break -->
		<xsl:text>&#160;</xsl:text>
		<xsl:if test="$whitespaces >= 2">
			<xsl:call-template name="write-breakable-whitespace-2">
				<xsl:with-param name="whitespaces" select="$whitespaces - 1" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>


	<!--write the number of 'whitespaces' -->
	<xsl:template name="write-breakable-whitespace-2">
		<xsl:param name="whitespaces" />
		<!--write two space chars as the normal white space character will be stripped
			and the other is able to break -->
		<xsl:text> </xsl:text>
		<xsl:if test="$whitespaces >= 2">
			<xsl:call-template name="write-breakable-whitespace">
				<xsl:with-param name="whitespaces" select="$whitespaces - 1" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>



	<!--
	TABHANDLING PROBLEM: Tabs are possible to be shown in the HTML text file, but will be later stripped as whitespaces.
		To prevent this one way would be the PRE tag which unfortunately ALWAYS result into a line-break. No surrounding NOBR tags help.

	<xsl:template match="text:tab-stop">
		<xsl:if test="not(preceding-sibling::text:tab-stop)">
			<xsl:element namespace="{$namespace}" name="pre"><xsl:text>&#9;</xsl:text><xsl:for-each select="following-sibling::text:tab-stop"><xsl:text>&#9;</xsl:text></xsl:for-each></xsl:element>
		</xsl:if>
	 </xsl:template>

	<xsl:template match="text:tab-stop"><xsl:text>&#9;</xsl:text></xsl:template>
	-->
	<!-- currentSolution: 8 non-breakable-spaces instead of a TAB is an approximation.
		 Sometimes less spaces than 8 might be needed and the output might be more difficult to read -->
	<xsl:template match="text:tab-stop">
		<xsl:call-template name="write-breakable-whitespace">
			<xsl:with-param name="whitespaces" select="8" />
		</xsl:call-template>
	</xsl:template>



	<!-- *************** -->
	<!-- *** Textbox *** -->
	<!-- *************** -->

	<!-- ID / NAME of text-box -->
	<xsl:template match="@draw:name">
		<xsl:attribute name="id">
			<xsl:value-of select="translate(., '. %()/\+', '_')" />
		</xsl:attribute>
	</xsl:template>



	<xsl:template match="text:line-break">
		<xsl:element namespace="{$namespace}" name="br" />
	</xsl:template>



	<!-- currently there have to be an explicit call of the style attribute nodes, maybe the attributes nodes have no priority only order relevant-->
	<!-- STRANGE: checked with biorythm.sxc a simple xsl:apply-templates did not recognice the styles. Maybe caused by the template match order?  -->
	<xsl:template name="apply-styles-and-content">
		<xsl:param name="globalData" />

		<xsl:apply-templates select="@text:style-name | @draw:style-name | @draw:text-style-name | @table:style-name"><!-- | @presentation:style-name -->
			<xsl:with-param name="globalData" select="$globalData" />
		</xsl:apply-templates>

		<xsl:apply-templates>
			<xsl:with-param name="globalData" select="$globalData" />
		</xsl:apply-templates>
	</xsl:template>



	<xsl:template match="text:sequence">
		<xsl:param name="globalData" />

		<xsl:apply-templates>
			<xsl:with-param name="globalData" select="$globalData" />
		</xsl:apply-templates>
	</xsl:template>


	<!-- ************************ -->
	<!-- *** Reference Fields *** -->
	<!-- ************************ -->

	<xsl:template match="text:reference-ref">
		<xsl:param name="globalData" />
		<!-- Java is needed as we have to encode the relative links (bug#102311) -->
		<xsl:choose>
			<xsl:when test="$javaEnabled">
				<xsl:element namespace="{$namespace}" name="a">
					<xsl:attribute name="href">
						<xsl:text>#</xsl:text>
						<xsl:call-template name="encode-string">
						<!-- the space has to be normalized,
							otherwise an illegal argument exception will be thrown for XT-->
							<xsl:with-param name="textToBeEncoded" select="@text:ref-name" />
						</xsl:call-template>
					</xsl:attribute>

					<xsl:apply-templates>
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:apply-templates>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates>
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="text:reference-mark">
		<xsl:param name="globalData" />

		<!-- Java is needed as we have to encode the relative links (bug#102311) -->
		<xsl:choose>
			<xsl:when test="$javaEnabled">
				<xsl:element namespace="{$namespace}" name="a">
					<xsl:attribute name="name">
						<xsl:call-template name="encode-string">
						<!-- the space has to be normalized,
							otherwise an illegal argument exception will be thrown for XT-->
							<xsl:with-param name="textToBeEncoded" select="@text:name" />
						</xsl:call-template>
					</xsl:attribute>

					<xsl:apply-templates>
						<xsl:with-param name="globalData" select="$globalData" />
					</xsl:apply-templates>

				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates>
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>



	<xsl:template match="text:reference-mark-start">
		<xsl:param name="globalData" />

		<!-- Java is needed as we have to encode the relative links (bug#102311) -->
		<xsl:choose>
			<xsl:when test="$javaEnabled">
				<xsl:element namespace="{$namespace}" name="a">
					<xsl:attribute name="name">
						<xsl:call-template name="encode-string">
						<!-- the space has to be normalized,
							otherwise an illegal argument exception will be thrown for XT-->
							<xsl:with-param name="textToBeEncoded" select="@text:name" />
						</xsl:call-template>
					</xsl:attribute>

					<xsl:variable name="endOfReference">
						<xsl:for-each select="text:reference-mark-end[@name=current()/@text:name]">
							<xsl:value-of select="position()" />
						</xsl:for-each>
					</xsl:variable>

					<xsl:for-each select="following-sibling::*[position() &lt; $endOfReference]">
						<xsl:apply-templates>
							<xsl:with-param name="globalData" select="$globalData" />
						</xsl:apply-templates>
					</xsl:for-each>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates>
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>




	<!-- *************** -->
	<!-- *** HELPER  *** -->
	<!-- *************** -->


	<xsl:template name="create-href">
		<xsl:param name="href" />

		<xsl:choose>
			<!-- internal OOo URL used in content tables -->
			<xsl:when test="contains($href, '%7Coutline')">
				<!-- the simple workaround for content tables in a single document is to create create an anchor from every heading element
					 work-around downside: Multiple identical headings won't refer always to the first.
				-->
				<xsl:text>#</xsl:text>
				<xsl:variable name="title"><xsl:apply-templates mode="concatenate" /></xsl:variable>
				<xsl:call-template name="encode-string">
				<!-- the space has to be normalized,
					otherwise an illegal argument exception will be thrown for XT-->
					<xsl:with-param name="textToBeEncoded" select="normalize-space(string($title))" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					 <!-- for images jared in open office document -->
					<xsl:when test="starts-with($href, '#')">
						<xsl:choose>
							<xsl:when test="starts-with($href, '#.')">
								<!-- creating an absolute http URL to the packed image file (removing the '.')-->
								<xsl:value-of select="concat($sourceBaseURL, '/', substring-after($href, '#.'), $optionalURLSuffix)" />
							</xsl:when>
							<xsl:otherwise>
								<!-- creating an absolute http URL to the packed image file -->
								<xsl:value-of select="concat($sourceBaseURL, '/', substring-after($href, '#'), $optionalURLSuffix)" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					 <!-- for absolute URLs -->
					<xsl:when test="contains($href, ':')">
						<xsl:value-of select="concat($href, $optionalURLSuffix)" />
					</xsl:when>
					 <!-- for relative URLs -->
					<xsl:otherwise>
						<xsl:value-of select="concat($targetBaseURL, $href, $optionalURLSuffix)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template match="text()" mode="concatenate"><xsl:value-of select="."/></xsl:template>
	<xsl:template match="*" mode="concatenate"><xsl:apply-templates mode="concatenate"/></xsl:template>

	<!-- ********************* -->
	<!-- *** Common Helper *** -->
	<!-- ********************* -->

	<!-- Chapters from the Content Table have currently no anchor to child documents in OOo XML.
		 As solution, whenever a a master document  every header of the HTML output gets get's an anchor in the Therefore-->
	<xsl:template name="encode-string">
		<xsl:param name="encoding" select="'UTF-8'" />
		<xsl:param name="textToBeEncoded" />

		<xsl:choose>
			<xsl:when test="function-available('urlencoder:encode')">
				<xsl:value-of select="translate(urlencoder:encode(normalize-space($textToBeEncoded),$encoding), '%+', '__')" />
			</xsl:when>
			<xsl:when test="function-available('java:java.net.URLEncoder.encode')">
				<xsl:value-of select="translate(java:java.net.URLEncoder.encode(string(normalize-space($textToBeEncoded)),string($encoding)), '%+', '__')" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">ERROR: Function not found: java:java.net.URLEncoder.encode</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- ******************** -->
	<!-- *** Common Rules *** -->
	<!-- ******************** -->

	<!-- deactivating default template -->
	<xsl:template match="*" />

	<!-- allowing all matched text nodes -->
	<xsl:template match="text()">
		<xsl:value-of select="." />
	</xsl:template>

</xsl:stylesheet>
