#!/bin/sh

SWNAME=Imaging-1.1.4
PKGDIR=`pwd`/pkg
ARCH=i386
PVER=P1
DOCDIR=/usr/share/doc

#LIBTCLVERSION=8.0jp
#LIBTKVERSION=8.0jp

LIBTCLVERSION=8.3
LIBTKVERSION=8.3

PYTHONDIR=python2.4
PYTHONLIBDIR=/usr/lib/$PYTHONDIR
PYTHONINCDIR=/usr/include/$PYTHONDIR

rm -rf $SWNAME
tar zxvf $SWNAME.tar.gz
cd $SWNAME
cd libImaging
./configure
make
cd ..
make -f Makefile.pre.in boot
cp -p Makefile Makefile._orig_
cat Makefile._orig_ | sed -e "s/ltcl8.0/ltcl$LIBTCLVERSION/g" | sed -e "s/ltk8.0/ltk$LIBTKVERSION/g" | sed -e "s/@DEFS@//g" > Makefile
make

rm -rf $PKGDIR
mkdir -p ${PKGDIR}${PYTHONLIBDIR}/site-packages/PIL
mkdir -p ${PKGDIR}${PYTHONINCDIR}/Extensions
mkdir -p ${PKGDIR}/usr/lib
mkdir -p ${PKGDIR}${DOCDIR}/$SWNAME
cp -p PIL.pth ${PKGDIR}${PYTHONLIBDIR}/site-packages/.
cp -p _imaging*.so PIL/* ${PKGDIR}${PYTHONLIBDIR}/site-packages/PIL/.
cp -p libImaging/*.h ${PKGDIR}${PYTHONINCDIR}/Extensions/.
cp -p libImaging/libImaging.a ${PKGDIR}/usr/lib/.
( cd ${PKGDIR}${PYTHONLIBDIR}/site-packages/
  ln -sf ../../libImaging.a .
)
( cd ${PKGDIR}/usr/lib
  ln -sf $PYTHONDIR/site-packages/PIL/_imaging.so .
  ln -sf $PYTHONDIR/site-packages/PIL/_imagingtk.so .
)
cp -p C* R* ${PKGDIR}${DOCDIR}/$SWNAME/.
cp -p ../PlamoBuild.sh ${PKGDIR}${DOCDIR}/$SWNAME/.

cd $PKGDIR
chown -R root:root usr
/sbin/makepkg ${SWNAME}-${ARCH}-${PVER}.tgz <<EOF
y
y
EOF
