;; -*- mode: scheme; coding: utf-8 -*-

;;; byeoru-dic.scm: Hangul character to Chinese character
;;; dictionary for byeoru.scm
;;;
;;; Copyright (c) 2003-2005 uim Project http://uim.freedesktop.org/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

;;; This data is from imhangul 0.9.11 courtesy of Choe Hwanjin
;;; <krisna@kldp.org>.
;;; A Korean-to-Chinese word dictionary project is under discussion.
;;; For more information, see the libhangul project web page at
;;; http://kldp.net/projects/hangul/, and the hangul-hackers mailing list
;;; at http://lists.kldp.net/mailman/listinfo/hangul-hackers.

(define byeoru-dic
  '(("가"
     ("伽" . "절 가")
     ("佳" . "아름다울 가")
     ("假" . "거짓 가")
     ("價" . "값 가")
     ("加" . "더할 가")
     ("可" . "옳을 가")
     ("呵" . "꾸짖을 가")
     ("哥" . "노래 가")
     ("嘉" . "아름다울 가")
     ("嫁" . "시집갈 가")
     ("家" . "집 가")
     ("暇" . "겨를 가")
     ("架" . "시렁 가")
     ("枷" . "목칼 가, 도리깨채 가")
     ("柯" . "가지 가")
     ("歌" . "노래 가")
     ("珂" . "옥 이름 가")
     ("痂" . "헌데 딱지 가")
     ("稼" . "심을 가")
     ("苛" . "매울 가")
     ("茄" . "가지 가")
     ("街" . "거리 가")
     ("袈" . "가사 가")
     ("訶" . "꾸짖을 가")
     ("賈" . "값 가")
     ("跏" . "책상다리할 가")
     ("軻" . "수레 가기 힘들 가")
     ("迦" . "부처이름 가")
     ("駕" . "멍에 가")
     ("个" . "명당 곁방 가")
     ("仮" . "假의 略字")
     ("価" . "價의 略字")
     ("傢" . "세간 가")
     ("叚" . "빌 가")
     ("咖" . "커피차 가, 커피의 음차로 쓰는자 가")
     ("哿" . "좋을 가")
     ("嘏" . "클 가, 복 가, 멀 가, 굳을 가")
     ("坷" . "험할 가")
     ("宊" . "家와 同字")
     ("斝" . "옥잔 가")
     ("榎" . "檟와 同字")
     ("檟" . "오동나무 가")
     ("珈" . "머리꾸미개 가")
     ("笳" . "갈잎피리 가")
     ("耞" . "도리깨 가")
     ("舸" . "큰 배 가")
     ("葭" . "갈대 가")
     ("謌" . "歌와 同字")
     ("髂" . "허리뼈 가"))
    ("각"
     ("刻" . "새길 각")
     ("却" . "물리칠 각")
     ("各" . "각각 각")
     ("恪" . "삼갈 각")
     ("慤" . "삼갈 각")
     ("殼" . "껍질 각")
     ("珏" . "쌍옥 각")
     ("脚" . "다리 각")
     ("覺" . "깨달을 각")
     ("角" . "뿔 각")
     ("較" . "수레 귀 각")
     ("閣" . "문설주 각")
     ("傕" . "성 각")
     ("卻" . "却의 本字")
     ("咯" . "토할 각")
     ("埆" . "메마를 각")
     ("搉" . "칠 각")
     ("擱" . "놓을 각")
     ("桷" . "서까래 각")
     ("殻" . "殼과 同字")
     ("玨" . "珏의 古字")
     ("覚" . "覺의 略字"))
    ("간"
     ("乾" . "마를 간")
     ("侃" . "강직할 간")
     ("刊" . "책 펴낼 간")
     ("墾" . "따비질할 간")
     ("奸" . "범할 간, 간악할 간")
     ("姦" . "간사할 간")
     ("干" . "방패 간")
     ("幹" . "줄기 간, 우물난간 간")
     ("懇" . "정성 간")
     ("揀" . "가릴 간")
     ("斡" . "관리할 간")
     ("杆" . "지레 간, 나무이름 간")
     ("柬" . "가릴 간")
     ("澗" . "산골물 간")
     ("癎" . "경풍 간")
     ("看" . "볼 간")
     ("磵" . "산골 시내 간, 석간수 간")
     ("稈" . "짚 간")
     ("竿" . "장대 간, 화살대 간, 횃대 간")
     ("簡" . "대쪽 간")
     ("肝" . "간 간")
     ("艮" . "괘이름 간")
     ("艱" . "어려울 간")
     ("諫" . "간할 간")
     ("閒" . "틈 간")
     ("間" . "틈 간, 사이 간")
     ("亁" . "乾의 俗字")
     ("倝" . "해 돋을 간")
     ("偘" . "侃과 同字")
     ("囏" . "艱의 古字")
     ("慳" . "아낄 간")
     ("旰" . "해질 간")
     ("栞" . "도표 간")
     ("榦" . "幹의 本字")
     ("玕" . "옥돌 간")
     ("珢" . "부르터 삐어진 흔적 있는 옥 간")
     ("秆" . "稈과 同字")
     ("茛" . "독초이름 간, 미나리아재비 간")
     ("衎" . "즐길 간, 바를 간")
     ("赶" . "달릴 간")
     ("迀" . "구할 간, 권할 간")
     ("齦" . "물을 간"))
    ("갈"
     ("乫" . "땅이름 갈")
     ("喝" . "꾸짖을 갈, 성낸 소리 갈")
     ("揭" . "높이 들 갈, 옷 걷고 물 건널 갈, 등에 질 갈")
     ("曷" . "어찌 갈, 그칠 갈, 벌레이름 갈")
     ("渴" . "목마를 갈, 급할 갈")
     ("碣" . "비 갈, 우뚝선 돌 갈, 동해의 산이름 갈")
     ("竭" . "다할 갈, 마를 갈")
     ("葛" . "칡 갈")
     ("蝎" . "전갈 갈, 빈대 갈")
     ("褐" . "털베 갈, 굵은 베 갈, 천한사람 갈, 갈옷 갈")
     ("鞨" . "말갈나라 갈, 말갈보석 갈")
     ("丐" . "거지 갈, 줄 갈")
     ("匄" . "청구할 갈, 줄 갈, 빌 갈")
     ("咭" . "쥐 우는 소리 갈")
     "嘠"
     ("噶" . "벼슬이름 갈, 땅이름 갈")
     ("掲" . "揭과 同字")
     ("楬" . "패를 써서 표시할 갈")
     ("渇" . "渴과 同字")
     ("秸" . "볏짚 갈, 짚 고갱이 갈")
     ("羯" . "불친 양 갈, 땅이름 갈")
     ("蠍" . "전갈 갈")
     ("頡" . "긁을 갈, 밟을 갈")
     ("鶡" . "할단새 갈, 관이름 갈"))
    ("감"
     ("勘" . "마감할 감, 정할 감")
     ("坎" . "구덩이 감, 험할 감, 작은 잔 감, 괘 이름 감, 불우하여 뜻을 이루지 못할 감")
     ("堪" . "견딜 감, 이길 감, 맡을 감, 하늘 감, 산 모양이 기괴할 감")
     ("嵌" . "깊은 골 감, 곁굴 감, 깊은 산 감")
     ("感" . "감동할 감, 찌를 감, 깨달을 감, 느낄 감")
     ("憾" . "섭섭할 감, 한할 감, 한혐할 감")
     ("戡" . "찌를 감, 이길 감, 죽일 감")
     ("敢" . "감히 감, 구태여 감, 날랠 감, 용맹할 감")
     ("柑" . "감귤 감, 감자 감")
     ("橄" . "감람나무 감")
     ("欠" . "하픔할 감, 기지개 켤 감, 이지러질 감")
     ("減" . "덜 감, 무지러질 감, 가벼울 감, 물이름 감")
     ("甘" . "달 감, 달게 여길 감")
     ("疳" . "감질병 감, 궤양 감, 창병 감, 종기 아플 감")
     ("監" . "거느릴 감, 살필 감, 볼 감, 벼슬 감, 감옥 감")
     ("瞰" . "굽어볼 감, 내려다 볼 감")
     ("紺" . "아청 감, 보랏빛 감")
     "鍼"
     ("鑑" . "거울 감, 밝을 감, 비칠 감, 경계할 감")
     ("鑒" . "鑑과 同字")
     ("龕" . "취할 감, 이길 감, 감실 감")
     ("减" . "減의 俗字")
     ("凵" . "입 벌릴 감, 위가 벌어진 그릇 감")
     ("坩" . "도가니 감")
     ("埳" . "구덩이 감")
     ("嵁" . "산 험할 감")
     ("弇" . "뚜껑 감, 사람이름 감")
     ("憨" . "어리석을 감, 미련할 감")
     ("撼" . "흔들 감, 움직일 감, 깨뜨릴 감")
     ("欿" . "서운할 감, 찌푸릴 감, 걱정할 감"))
    ("갑"
     ("匣" . "궤 갑, 상자 갑")
     ("合" . "부를 갑, 홉 갑")
     ("岬" . "산 허구리 갑, 줄이 느런할 갑")
     ("押" . "도울 갑, 단속할 갑, 잡아들일 갑")
     ("甲" . "갑옷 갑, 첫째 천간 갑, 비롯할 갑, 떡잎 날 갑, 법령 갑, 대궐 갑")
     ("胛" . "어깻죽지 갑")
     ("鉀" . "갑옷 갑")
     ("閘" . "문 빗장 갑, 물 문 갑")
     ("韐" . "가죽바지 갑"))
    ("강"
     ("剛" . "굳을 강, 굳셀 강, 꼬장할 강, 바야흐로 강")
     ("堈" . "언덕 강, 밭 두둑 강")
     ("姜" . "성씨 강, 강할 강")
     ("岡" . "멧동 강, 산등성이 강")
     ("崗" . "岡의 俗字")
     ("康" . "편안할 강, 즐거울 강, 다섯거리 강")
     ("强" . "강할 강, 나머지 강, 바구미 강")
     ("彊" . "굳셀 강, 센 활 강, 사나울 강, 송장 뻣뻣할 강")
     ("慶" . "복 강, 이에 강")
     ("慷" . "강개할 강")
     ("控" . "칠 강")
     ("江" . "가람 강, 물 강")
     ("畺" . "疆과 同字")
     ("疆" . "땅 경계 강, 갈피 강, 굳셀 강, 변방 강")
     ("糠" . "겨 강, 번쇄할 강")
     ("絳" . "깊게 붉을 강, 강초 강")
     ("綱" . "벼리 강, 근본 강, 법 강, 대강 강")
     ("羌" . "오랑캐 강, 말 끝낼 강")
     ("腔" . "창자 강, 속 빌 강, 뼈대 강, 말 허구리 강")
     ("舡" . "오나라 배 강")
     ("薑" . "생강 강")
     ("虹" . "골이름 강")
     ("襁" . "포대기 강")
     ("講" . "강론할 강, 강구할 강, 익힐 강, 강화할 강")
     ("鋼" . "쇠 강")
     ("降" . "내릴 강, 떨어질 강, 돌아갈 강")
     ("鱇" . "천징어 강")
     ("傋" . "아첨 아니할 강")
     ("僵" . "엎드러질 강, 쓰러질 강")
     ("匟" . "평상 강")
     ("唴" . "어린아이 울 강, 울어 기진할 강")
     ("壃" . "疆과 同字")
     ("強" . "强의 本字")
     ("忼" . "강개할 강, 뜻이 크고 기개있을 강, 탄식할 강")
     ("扛" . "마주 들 강")
     ("杠" . "외나무 다리 강, 깃대 강, 상 앞 가로막대 강, 올릴 강")
     ("橿" . "참죽나무 강, 호미자루 강, 사닥다리 강, 억셀 강")
     ("殭" . "죽어 썩지 않을 강, 마른 누에 강")
     ("矼" . "돌다리 강, 징검다리 강, 성실할 강")
     ("穅" . "겨 강, 악기이름 강")
     ("繈" . "繦의 本字")
     ("繦" . "돈꿰미 강")
     ("罡" . "강별 강")
     ("羗" . "羌과 同字")
     ("羫" . "밭 갈 강")
     ("茳" . "강리풀 강")
     ("豇" . "광저기 강")
     ("韁" . "고삐 강"))
    ("개"
     ("介" . "낄 개, 도울 개, 맬 개, 클 개, 중매할 개")
     ("价" . "착할 개, 클 개, 사신 개")
     ("佳" . "착할 개, 좋을 개, 좋아할 개")
     ("個" . "낱 개, 치우칠 개")
     ("凱" . "싸움 이긴 풍류 개, 착할 개, 마파람 개, 좋은 사람 개")
     ("塏" . "시원한 땅 개")
     ("恝" . "걱정 없을 개")
     ("愷" . "탐할 개, 급할 개")
     ("愾" . "한숨 쉴 개, 성낼 개")
     ("慨" . "분할 개, 강개할 개, 슬플 개")
     ("改" . "고칠 개, 거듭할 개, 바꿀 개")
     ("槪" . "평두목 개, 절개 개, 대강 개, 거리낄 개, 칠한 술통 개")
     ("漑" . "물 댈 개, 씻을 개, 물 천천히 흐를 개")
     ("疥" . "옴 개")
     ("皆" . "모두 개, 한 가지 개, 같을 개")
     ("盖" . "蓋의 俗字")
     ("箇" . "낱 개, 개수 개")
     ("芥" . "겨자 개, 갓 개, 지푸라기 개, 티끌 개")
     ("蓋" . "뚜껑 개, 덮개 개, 이엉 개, 우산 개, 가리울 개")
     ("解" . "벗을 개, 풀 개, 헤칠 개, 발신할 개")
     ("豈" . "승전악 개")
     ("鎧" . "투구 개, 갑옷 개")
     ("開" . "열 개, 통할 개, 발할 개, 베풀 개, 풀 개")
     ("豈" . "승전악 개")
     ("丐" . "빌 개")
     ("个" . "낱 개")
     ("剴" . "낫 개, 가까울 개, 간절할 개")
     ("匃" . "청구할 개, 줄 개, 빌 개")
     ("匄" . "匃와 同字")
     ("喈" . "새소리 개, 빠를 개")
     ("嘅" . "탄식할 개, 성낼 개")
     ("揩" . "문지를 개, 문질러 훔칠 개")
     ("概" . "槪와 同字")
     ("槩" . "槪와 同字")
     ("溉" . "漑와 同字")
     ("玠" . "큰 서옥 개")
     ("磕" . "돌 부딪는 소리 개")
     ("闓" . "열 개, 풀 개, 활깍지 개"))
    ("객"
     ("喀" . "기침할 객, 토할 객")
     ("客" . "손님 객, 부칠 객, 나그네 객, 지날 객"))
    ("갱"
     ("坑" . "빠질 갱, 묻을 갱, 구덩이 갱")
     ("更" . "다시 갱")
     ("粳" . "메벼 갱")
     ("羹" . "국 갱")
     ("更" . "다시 갱")
     ("硜" . "아릿아릿할 갱, 알랑알랑할 갱, 돌소리 갱")
     ("賡" . "이을 갱, 일 갱")
     ("鏗" . "금석 소리 갱, 사람이름 갱"))
    ("갹"
     ("醵" . "술추렴 갹, 추렴 걷을 갹")
     ("噱" . "껄껄 웃을 갹, 입 벌일 갹"))
    ("거"
     ("倨" . "거만할 거, 걸터 앉을 거, 굽을 거")
     ("去" . "갈 거, 버릴 거, 오래될 거, 떨어질 거, 쫓을 거, 감출 거")
     ("居" . "살 거, 곳 거, 앉을 거, 놓을 거, 쌓을 거")
     ("巨" . "클 거, 많을 거, 억 거")
     ("拒" . "막을 거, 맞설 거, 다닥칠 거, 다다를 거")
     ("据" . "가질 거, 길거할 거, 의지할 거, 손병 거")
     ("據" . "의지할 거, 기댈 거, 웅거할 거, 짚을 거")
     ("擧" . "들 거, 받들 거, 움직일 거, 일걸을 거")
     ("渠" . "개천 거, 도랑 거, 휑덩그렁할 거, 클 거, 껄껄 웃을 거, 무엇 거")
     ("炬" . "횃불 거, 불 땔 거")
     ("祛" . "물리칠 거, 빌 거, 굳셀 거")
     ("距" . "며느리 발톱 거, 지낼 거, 뛸 거, 겨룰 거, 미눌 거")
     ("踞" . "걸터앉을 거")
     ("車" . "수레 거, 그물 거, 잇몸 거")
     ("遽" . "급할 거, 두려울 거, 역말 수레 거")
     ("醵" . "술추렴 거, 추렴 걷을 거")
     ("鉅" . "갈고리 거, 클 거, 강한 쇠 거")
     ("鋸" . "톱 거, 다리 꺾는 형벌 거")
     ("車" . "수레 거, 그물 거, 잇몸 거")
     ("佉" . "나라이름 거")
     ("俥" . "인력거 거")
     ("凥" . "居와 同字")
     ("勮" . "부지런히 힘쓸 거, 두려울 거")
     ("厺" . "去의 本字")
     ("呿" . "입 딱 벌일 거")
     ("拠" . "據의 俗字")
     ("昛" . "밝을 거")
     ("秬" . "검은 기장 거")
     ("筥" . "쌀 담는 광주리 거, 볏단 거")
     ("籧" . "대자리 거, 천상바라기 거, 양잠기 거")
     ("胠" . "열 거, 갈비 거")
     ("腒" . "건치 거, 꿩 포 거")
     "艍"
     ("苣" . "상추 거, 검은 깨 거")
     ("莒" . "모시풀 거, 나라이름 거, 고을이름 거")
     ("蕖" . "연꽃 거")
     ("蘧" . "패랭이꽃 거, 석죽화 거, 마음에 든든할 거")
     ("袪" . "소매 거, 소매 아귀 거")
     ("裾" . "옷 뒷자락 거")
     ("詎" . "어찌 거, 모를 거")
     ("駏" . "튀기 거, 거공벌레 거"))
    ("걱"
     ("巪" . "사람 이름자 걱"))
    ("건"
     ("乾" . "하늘 건, 괘 이름 건, 서북쪽 건, 굳셀 건, 임금 건")
     ("件" . "조건 건, 가지 건, 구별할 건, 나눌 건")
     ("健" . "굳셀 건, 병 없을 건, 탐할 건")
     ("巾" . "수건 건, 덮을 건")
     ("建" . "세울 건, 둘 건, 심을 건, 칼집 건, 별이름 건")
     ("愆" . "죄 건, 허물 건, 어기어질 건")
     ("楗" . "문 빗장 건, 문지방 건")
     ("腱" . "힘줄 건")
     ("虔" . "정성 건, 빼앗을 건, 죽일 건")
     ("蹇" . "절름거릴 건, 험할 건, 교만할 건")
     ("鍵" . "열쇠 건, 수레 굴대 건")
     ("騫" . "말 배 앓을 건, 이지러질 건, 휙 뛰어 나아갈 건")
     ("亁" . "乾과 同字")
     ("囝" . "아이 건")
     ("揵" . "멜 건, 막을 건, 들 건")
     ("犍" . "불친 소 건, 짐승이름 건, 촉나라 고을이름 건")
     ("睷" . "눈으로 세어볼 건")
     "荐"
     ("褰" . "바지 건, 걷을 건, 발 걷을 건")
     ("謇" . "말 더듬거릴 건, 바른말할 건")
     ("鞬" . "칼집 건, 동개 건"))
    ("걸"
     ("乞" . "구걸할 걸, 요구할 걸, 원할 걸, 거지 걸")
     ("偈" . "힘 빼두를 걸, 빠를 걸, 헌걸찰 걸")
     ("傑" . "호걸 걸, 준걸 걸, 뛰어날 걸, 거만할 걸, 떡잎 걸")
     ("杰" . "傑의 俗字")
     ("桀" . "찢을 걸, 홰 걸, 빼어날 걸, 멜 걸, 사나을 걸, 왕이름 걸")
     ("渴" . "물 잦을 걸")
     ("竭" . "다할 걸, 마를 걸")
     ("乬" . "갈 걸")
     ("朅" . "갈 걸")
     ("榤" . "닭의 홰 걸")
     ("渇" . "渴과 同字"))
    ("검"
     ("儉" . "검소할 검, 흉년들 검, 적을 검, 가난할 검")
     ("劍" . "칼 검, 칼로 찔러 죽일 검, 칼 쓰는법 검")
     ("劒" . "劎의 譌字")
     "柑"
     ("檢" . "교정할 검, 금제할 검, 법 검, 봉할 검, 책메뚜기 검, 수결둘 검")
     ("瞼" . "눈시울 검")
     ("鈐" . "굴대 비녀장 검, 자물쇠 검, 큰 보습 검")
     ("黔" . "검을 검")
     ("倹" . "儉의 略字")
     ("剣" . "劍과 同字")
     ("劎" . "劍과 同字")
     ("劔" . "劎의 俗字")
     ("撿" . "잡을 검, 구속할 검, 관찰할 검, 비교할 검")
     ("検" . "檢과 同字")
     ("歛" . "탐할 검, 구걸할 검")
     "泔"
     "淦"
     "澉"
     "矙"
     ("芡" . "마름 검, 가시연밥 검")
     "轗"
     "酣"
     ("鹻" . "소금물 검, 잿물 검, 비누 검"))
    ("겁"
     ("劫" . "위협할 겁, 겁탈할 겁, 부지런할 겁, 대궐 층계 겁, 겁 겁, 화재 겁")
     ("怯" . "무서워할 겁, 겁낼 겁, 으를 겁")
     "迲"
     ("刦" . "겁탈할 겁, 구속할 겁")
     ("刧" . "刦의 俗字"))
    ("것"
     ("唟" . "땅이름 것"))
    ("게"
     ("偈" . "쉴 게, 게타 게, 글귀 게")
     ("憩" . "쉴 게")
     ("揭" . "높이 들 게, 옷 걷고 물 건널 게, 등에 질 게")
     ("卟" . "점칠 게, 생각할 게")
     ("掲" . "揭와 同字"))
    ("격"
     ("擊" . "撃과 同字")
     ("格" . "이를 격, 올 격, 바를 격, 대적할 격, 감동할 격")
     ("檄" . "격서 격, 격문 격, 과격할 격")
     ("激" . "물결 부딪혀 흐를 격, 찌를 격, 맑은 소리 격, 말 과격히 할 격")
     ("膈" . "명치 격")
     ("覡" . "박수 격, 남자무당 격")
     ("隔" . "막을 격, 멀 격")
     ("嗝" . "딸꾹질할 격, 꿩 울 격")
     ("挌" . "칠 격, 들 격")
     ("撃" . "칠 격, 두드릴 격, 눈에 마주칠 격, 죽일 격")
     ("毄" . "맞부딛는 소리 격, 충돌할 격, 창 격")
     ("闃" . "고요할 격")
     ("骼" . "마른 뼈 격, 드러난 뼈 격, 짐승의 뼈 격")
     ("鬲" . "오지병 격, 땅이름 격")
     ("鴃" . "왜가리 격, 때까치 격"))
    ("견"
     ("健" . "탐할 견")
     ("堅" . "굳을 견, 굳셀 견, 반드시 견")
     ("牽" . "당길 견, 이끌 견, 빠를 견, 거리낄 견, 볏줄 견")
     ("犬" . "큰 개 견")
     ("甄" . "질그릇 견, 살필 견, 표시할 견, 진 이름 견, 면할 견, 밝을 견")
     ("絹" . "비단 견, 깁 견")
     ("繭" . "고치 견, 발 부르틀 견, 목 쉴 견, 비단 견")
     ("肩" . "어깨 견, 이길 견, 맡길 견, 멜 견, 세 살 된 짐승 견")
     ("見" . "볼 견, 만날 견, 당할 견")
     ("譴" . "꾸짖을 견, 성낼 견, 귀양갈 견")
     ("遣" . "보낼 견, 쫓을 견, 견전제 견")
     ("鵑" . "접동새 견, 두견새 견, 뻐꾹새 견")
     ("樫" . "떡갈나무 견")
     ("狷" . "고집스러울 견, 조수할 견, 편협할 견")
     ("甽" . "畎의 古字")
     ("畎" . "밭 도랑 견, 산골 도랑 견")
     ("筧" . "대 홈통 견")
     ("縳" . "올 견, 낳이 실 견")
     ("縴" . "궂은 솜 견")
     ("繾" . "곡진할 견, 마지 않을 견")
     ("羂" . "걸 견, 걸릴 견")
     ("蠲" . "밝을 견, 조촐할 견, 반딧불 견")
     ("豣" . "큰 돼지 견, 세 살 된 돼지 견")
     ("趼" . "발 부르틀 견")
     ("鰹" . "큰 가물치 견, 물치 견, 강고도리 견"))
    ("결"
     ("抉" . "긁을 결, 당길 결")
     ("拮" . "길거할 결, 열심히 일할 결")
     ("決" . "결단할 결, 물이름 결, 물골 터 놓을 결, 끊을 결, 이별할 결")
     ("潔" . "맑을 결, 정결할 결, 조촐할 결")
     ("結" . "맺을 결, 마칠 결, 나중 결, 몫 결")
     ("缺" . "이지러질 결, 번개 번쩍거릴 결, 깨어질 결, 이 빠질 결")
     ("訣" . "이별할 결, 열결할 결, 사례할 결, 비결 결")
     ("僪" . "해무리 결, 미칠 결")
     ("决" . "決의 俗字")
     ("刔" . "抉과 同字")
     ("玦" . "옥패 결, 활 깍지 결")
     ("觖" . "서운할 결, 들쳐낼 결, 바랄 결")
     ("闋" . "쉴 결, 다할 결, 풍류 마칠 결, 문 닫을 결"))
    ("겸"
     ("兼" . "겸할 겸, 아우를 겸, 둘 얻을 겸, 모을 겸")
     ("慊" . "앙심먹을 겸, 불만족하게 생각할 겸, 싫을 겸")
     ("箝" . "재갈 겸, 족집개 겸, 목 잠글 겸")
     ("謙" . "사양할 겸, 겸손할 겸, 괘 이름 겸")
     ("鉗" . "목사슬 겸, 세력으로써 남을 누를 겸, 입 다물 겸")
     ("鎌" . "낫 겸")
     ("傔" . "겸종 겸")
     ("嗛" . "부족히 여길 겸, 겸손 겸, 입에 밥 물고 있을 겸")
     ("岒" . "산 작고 높을 겸")
     ("拑" . "자갈 먹일 겸")
     ("歉" . "흉년들 겸, 적을 겸, 나쁠 겸")
     ("縑" . "합사비단 겸")
     ("蒹" . "갈대 겸")
     ("黚" . "얕은 금향빛 겸")
     ("鼸" . "두더쥐 겸"))
    ("겹"
     ("俠" . "아오를 겹")
     ("侠" . "俠의 俗字")
     ("唊" . "망녕되이 말할 겹")
     ("郟" . "그을 이름 겹"))
    ("경"
     ("京" . "서울 경")
     ("俓" . "徑과 同字")
     ("倞" . "굳셀 경")
     ("傾" . "기울 경")
     ("儆" . "경계할 경")
     ("勁" . "굳셀 경")
     ("勍" . "셀 경")
     ("卿" . "벼슬 경")
     ("坰" . "들 경")
     ("境" . "지경 경")
     ("庚" . "일곱째 천간 경")
     ("徑" . "지름길 경")
     ("慶" . "경사 경")
     ("憬" . "깨달을 경")
     ("擎" . "들 경")
     ("敬" . "공경할 경")
     ("景" . "별 경")
     ("暻" . "밝을 경")
     ("更" . "고칠 경")
     ("梗" . "대개 경")
     ("涇" . "통할 경")
     ("炅" . "빛날 경")
     ("烱" . "빛날 경")
     ("璟" . "옥 빛 경")
     ("璥" . "경옥 경")
     ("瓊" . "옥 경")
     ("痙" . "심줄 땅길 경")
     ("硬" . "굳을 경")
     ("磬" . "경쇠 경")
     ("竟" . "다할 경")
     ("競" . "겨룰 경")
     ("絅" . "끌어 쥘 경")
     ("經" . "날 경")
     ("耕" . "밭갈 경")
     ("耿" . "빛날 경")
     ("脛" . "정강이 경")
     ("莖" . "줄기 경")
     ("警" . "경계할 경")
     ("輕" . "가벼울 경")
     ("逕" . "소로 경")
     ("鏡" . "거울 경")
     ("頃" . "밭 넓이 단위 경")
     ("頸" . "목 경")
     ("驚" . "놀랄 경")
     ("鯨" . "고래 경")
     ("亰" . "서울 경")
     ("冂" . "먼데 경")
     ("冏" . "빛날 경")
     ("剄" . "목 벨 경")
     ("剠" . "鯨과 同字")
     ("哽" . "목멜 경")
     ("囧" . "冏과 同字")
     ("径" . "통할 경")
     ("惸" . "근심할 경")
     ("憼" . "공경할 경")
     ("扃" . "빗장 경")
     ("檠" . "도지개 경")
     ("焭" . "근싱할 경")
     ("煢" . "외로울 경")
     ("熲" . "빛날 경")
     ("畊" . "耕의 古字")
     ("竸" . "競과 同字")
     ("経" . "날 경")
     ("綆" . "두레박줄 경")
     ("罄" . "빌 경")
     ("褧" . "홑옷 경")
     ("謦" . "기침 경")
     ("軽" . "천할 경")
     ("頚" . "頸의 俗字")
     ("顈" . "홑옷 경")
     ("駉" . "목장 경")
     ("鯁" . "생선뼈 경")
     ("黥" . "묵형할 경"))
    ("계"
     ("係" . "걸릴 계")
     ("啓" . "열 계")
     ("堺" . "界와 同字")
     ("契" . "맺을 계")
     ("季" . "끝 계")
     ("屆" . "이를 계")
     ("悸" . "두근거를 계")
     ("戒" . "경계할 계")
     ("桂" . "계수나무 계")
     ("械" . "형틀 계")
     ("棨" . "창 계")
     ("溪" . "시내 계")
     ("界" . "지경 계")
     ("癸" . "열째 천간 계")
     "碣"
     ("磎" . "谿와 同字")
     ("稽" . "머무를 계")
     ("系" . "이을 계")
     ("繫" . "맬 계, 맺을 계")
     ("繼" . "이을 계")
     ("計" . "꾀 계")
     ("誡" . "경계할 계")
     ("谿" . "시내 계")
     ("階" . "섬돌 계")
     ("鷄" . "닭 계")
     ("乩" . "점칠 계")
     ("启" . "啓와 同字")
     ("啟" . "인도할 계")
     ("堦" . "섬돌 계")
     ("挈" . "끊을 계")
     ("烓" . "화덕 계")
     ("瘈" . "미칠 계")
     ("禊" . "계제 계")
     ("筓" . "비녀 계")
     ("継" . "繼의 俗字")
     ("綮" . "발 고운 비단 계")
     ("縘" . "繫와 同字")
     ("繋" . "繫와 同字")
     ("罽" . "물고기 그물 계")
     ("葪" . "베일 계, 삽주 계")
     ("薊" . "삽주 계")
     ("雞" . "닭 계")
     ("髻" . "상투 계")
     ("鳮" . "鷄의 俗字"))
    ("고"
     ("古" . "옛 고")
     ("叩" . "두드릴 고")
     ("告" . "알릴 고")
     ("呱" . "울 고")
     ("咎" . "허물 고")
     ("固" . "굳을 고")
     ("姑" . "시어미 고")
     ("孤" . "외로울 고")
     ("尻" . "꽁무니 고")
     ("庫" . "곳집 고")
     ("拷" . "가질 고")
     ("攷" . "考의 古字")
     ("故" . "옛 고")
     ("敲" . "두드릴 고")
     ("暠" . "흴 고")
     ("枯" . "마를 고")
     ("槁" . "槀와 同字")
     ("沽" . "팔 고")
     ("痼" . "고질 고")
     ("皐" . "부르는 소리 고")
     ("睾" . "못 고")
     ("稿" . "볏집 고")
     ("羔" . "새끼양 고")
     ("考" . "상고할 고")
     ("股" . "넓적다리 고")
     ("膏" . "살찔 고")
     ("苦" . "쓸 고")
     ("苽" . "줄 고")
     ("菰" . "향초 고")
     ("藁" . "마른 나무 고")
     ("蠱" . "독 고")
     ("袴" . "바지 고")
     ("誥" . "고할 고")
     ("賈" . "장사 고")
     ("辜" . "허물 고")
     ("錮" . "땜질할 고")
     ("雇" . "새이름 고")
     ("顧" . "돌아볼 고")
     ("高" . "높을 고")
     ("鼓" . "북 고")
     ("賈" . "장사 고")
     ("估" . "값 고")
     ("侤" . "생각할 고")
     ("凅" . "얼어붙을 고")
     ("刳" . "가를 고")
     ("吿" . "告와 同字")
     ("咕" . "투덜거릴 고")
     ("嚳" . "고할 고")
     ("塙" . "단단할 고")
     ("杲" . "밝을 고")
     ("栲" . "북나무 고")
     ("槀" . "마를 고")
     ("槹" . "두레박 고")
     ("櫜" . "활집 고")
     ("牯" . "암소 고")
     ("皋" . "못 고")
     ("盬" . "염지 고")
     ("瞽" . "소경 고")
     ("稁" . "稿와 同字")
     ("箍" . "테 고")
     ("篙" . "상앗대 고")
     ("糕" . "떡 고")
     ("罟" . "그물 고")
     ("羖" . "검은 암양 고")
     ("翱" . "翺와 同字")
     ("翺" . "날 고")
     ("胯" . "사타구니 고")
     "脵"
     ("觚" . "술잔 고")
     ("詁" . "주석 고")
     ("郜" . "나라이름 고")
     ("酤" . "계명주 고")
     ("鈷" . "다리미 고")
     ("靠" . "기댈 고")
     ("骷" . "해골 고")
     ("髙" . "高와 同字")
     ("鯝" . "참마자 고")
     ("鴣" . "자고 고")
     ("鷱" . "새이름 고"))
    ("곡"
     ("告" . "청할 곡")
     ("哭" . "울 곡")
     ("斛" . "휘 곡")
     ("曲" . "굽을 곡")
     ("梏" . "쇠고랑 곡")
     ("珏" . "쌍옥 곡")
     ("穀" . "곡식 곡")
     "角"
     ("谷" . "골짜기 곡")
     ("鵠" . "고니 곡")
     ("吿" . "告과 同字")
     ("榖" . "穀의 俗字")
     ("槲" . "떡갈나무 곡")
     ("玨" . "珏의 古字")
     ("縠" . "주름 비단 곡")
     ("觳" . "뿔잔 곡")
     ("轂" . "바퀴 곡"))
    ("곤"
     ("困" . "괴로울 곤")
     ("坤" . "땅 곤")
     ("崑" . "산이름 곤")
     ("昆" . "형 곤")
     ("梱" . "문지방 곤")
     ("棍" . "몽둥이 곤")
     ("混" . "서쪽 오랑캐 곤")
     ("滾" . "흐를 곤")
     ("琨" . "옥돌 곤")
     ("袞" . "곤룡포 곤")
     ("鯤" . "준마 이름 곤")
     ("丨" . "뚫을 곤")
     ("堃" . "따 곤")
     ("崐" . "곤륜산 곤")
     ("悃" . "정성 곤")
     ("捆" . "두드릴 곤")
     ("滚" . "滾과 同字")
     ("緄" . "띠 곤")
     ("衮" . "袞과 同字")
     ("裍" . "걷어 올릴 곤")
     ("褌" . "잠방이 곤")
     ("錕" . "붉은 쇠 곤")
     ("閫" . "문지방 곤")
     ("髡" . "머리 깍을 곤")
     ("鯀" . "물고기 이름 곤")
     ("鵾" . "댓닭 곤")
     ("鶤" . "댓닭 곤")
     ("齫" . "이 빠질 곤"))
    ("골"
     ("汨" . "빠질 골")
     ("滑" . "어지러울 골")
     ("骨" . "뼈 골")
     ("滑" . "어지러울 골")
     ("搰" . "팔 골")
     ("榾" . "등걸 골")
     ("矻" . "돌 골")
     ("鶻" . "송골매 골"))
    ("공"
     ("供" . "이바지할 공")
     ("公" . "공변될 공")
     ("共" . "함께 공")
     ("功" . "공 공")
     ("孔" . "구멍 공")
     ("工" . "장인 공")
     ("恐" . "두려울 공")
     ("恭" . "공손할 공")
     ("拱" . "두 손 맞잡을 공")
     ("控" . "당길 공")
     ("攻" . "칠 공")
     ("珙" . "큰 옥 공")
     ("空" . "빌 공")
     ("紅" . "상복 이름 공")
     ("蚣" . "지네 공")
     ("貢" . "바칠 공")
     ("鞏" . "묶을 공")
     ("倥" . "어리석을 공")
     ("卭" . "병될 공")
     ("崆" . "산이름 공")
     ("悾" . "정성 공")
     ("栱" . "두공 공")
     ("槓" . "지렛대 공")
     ("笻" . "대이름 공")
     ("箜" . "공후 공")
     ("蛩" . "메뚜기 공")
     ("蛬" . "귀뚜라미 공")
     ("贛" . "줄 공")
     ("跫" . "발자국 소리 공")
     ("邛" . "언덕 공")
     ("釭" . "굴대 공")
     ("銎" . "도끼 구멍 공")
     ("龔" . "공손할 공"))
    ("곶"
     ("串" . "땅이름 곶")
     ("串" . "곶 곶")
     ("廤" . "곳 곶"))
    ("과"
     ("寡" . "적을 과")
     ("戈" . "창 과")
     ("果" . "실과 과")
     ("瓜" . "오이 과")
     ("科" . "과정 과")
     ("菓" . "과일 과")
     ("誇" . "자랑할 과")
     ("課" . "매길 과")
     ("跨" . "타넘을 과")
     ("過" . "지날 과")
     ("鍋" . "노구솥 과")
     ("顆" . "낟알 과")
     ("侉" . "자랑할 과")
     ("剮" . "바를 과")
     ("堝" . "도가니 과")
     ("夥" . "많을 과")
     ("夸" . "자랑할 과")
     ("媧" . "사람 이름 과")
     ("撾" . "칠 과")
     ("猓" . "긴 꼬리 원숭이 과")
     ("稞" . "보리 과")
     ("窠" . "보금자리 과")
     ("胯" . "사타구니 과")
     ("蝌" . "올챙이 과")
     ("裹" . "쌀 과")
     ("踝" . "복사뼈 과")
     ("銙" . "대구 과")
     ("騍" . "암말 과")
     ("髁" . "넓적다리뼈 과"))
    ("곽"
     ("廓" . "둘레 곽")
     ("槨" . "덧널 곽")
     ("藿" . "콩잎 곽")
     ("郭" . "성곽 곽")
     ("椁" . "관 곽")
     ("癨" . "곽란 곽")
     ("躩" . "바삐 갈 곽")
     ("霍" . "빠를 곽")
     ("鞹" . "무두질한 가죽 곽"))
    ("관"
     ("串" . "익힐 관")
     ("冠" . "갓 관")
     ("官" . "벼슬 관")
     ("寬" . "너그러울 관")
     ("慣" . "버릇 관")
     ("棺" . "널 관")
     ("款" . "정성 관")
     ("灌" . "물 댈 관")
     ("琯" . "옥피리 관")
     ("瓘" . "옥 이름 관")
     ("管" . "피리 관")
     ("綸" . "관건 관")
     ("罐" . "두레박 관")
     ("莞" . "골풀 관")
     ("菅" . "골풀 관")
     ("觀" . "볼 관")
     ("貫" . "꿸 관")
     ("關" . "빗장 관")
     ("館" . "객사 관")
     ("丱" . "쌍상투 관")
     ("倌" . "수레 모는 사람 관")
     ("卝" . "丱과 同字")
     ("寛" . "용서할 관")
     ("涫" . "끓을 관")
     ("爟" . "봉화 관")
     ("盥" . "대야 관")
     ("祼" . "강신제 관")
     ("窾" . "빌 관")
     ("筦" . "피리 관")
     ("綰" . "얽을 관")
     ("舘" . "객사 관")
     ("覌" . "볼 관")
     ("観" . "볼 관")
     ("輨" . "줏대 관")
     ("錧" . "비녀장 관")
     ("鑵" . "두레박 관")
     ("関" . "쇠사슬 관")
     ("闗" . "빗장 관")
     ("雚" . "황새 관")
     ("顴" . "광대뼈 관")
     ("髖" . "허리뼈 관")
     ("鸛" . "황새 관")
     ("館" . "객사 관"))
    ("괄"
     ("刮" . "깍을 괄")
     ("恝" . "걱정 없을 괄")
     ("括" . "묶을 괄")
     ("檜" . "전나무 괄, 나라이름 괄")
     ("活" . "물 소리 괄")
     ("适" . "빠를 괄")
     ("佸" . "힘 쓸 괄")
     ("劀" . "궂은 살을 잘라낼 괄")
     ("栝" . "노송나무 괄")
     ("筈" . "하눌타리 괄")
     ("聒" . "떠들석할 괄")
     ("颳" . "모진 바람 괄")
     ("髺" . "머리 묶을 괄")
     ("鬠" . "결발할 괄")
     ("鴰" . "재두루미 괄"))
    ("광"
     ("侊" . "성한 모양 광")
     ("光" . "빛 광")
     ("匡" . "바룰 광")
     ("壙" . "광 광")
     ("廣" . "넓을 광")
     ("擴" . "넓힐 광")
     ("曠" . "밝을 광")
     ("洸" . "물 용솟음할 광")
     ("炚" . "햇빚 뜨거울 광")
     ("狂" . "미질 광")
     ("珖" . "옥피리 광")
     ("筐" . "광주리 광")
     ("胱" . "오줌통 광")
     ("鑛" . "쇳돌 광")
     ("俇" . "허둥지둥할 광")
     ("劻" . "급할 광")
     ("広" . "廣의 略字")
     ("恇" . "겁낼 광")
     ("拡" . "擴의 略字")
     ("桄" . "광랑나무 광")
     ("框" . "문테 광")
     ("爌" . "불 빛 환할 광")
     ("獷" . "사나울 광")
     ("磺" . "쇳돌 광")
     ("礦" . "쇳돌 광")
     ("絖" . "솜 광")
     ("纊" . "솜 광")
     ("茪" . "초결명 광")
     ("誆" . "속일 광")
     ("誑" . "속일 광")
     ("鄺" . "성 광")
     ("鉱" . "鑛의 俗字"))
    ("괘"
     ("卦" . "걸 괘")
     ("掛" . "걸 괘")
     ("罫" . "줄 괘")
     ("叏" . "나누어 가를 괘")
     ("咼" . "입 비뚤어질 괘")
     ("挂" . "그림족자 괘")
     ("罣" . "걸 괘")
     ("詿" . "그르칠 괘"))
    ("괴"
     ("乖" . "어그러질 괴")
     ("傀" . "클 괴")
     ("塊" . "흙덩이 괴")
     ("壞" . "무너질 괴")
     ("怪" . "기이할 괴")
     ("愧" . "부끄러워할 괴")
     ("拐" . "속일 괴")
     ("會" . "그림 괴")
     ("槐" . "홰나무 괴")
     ("魁" . "으뜸 괴")
     ("会" . "會의 略字")
     ("儈" . "거간군 괴")
     ("凷" . "흙덩이 괴")
     ("劊" . "끊을 괴")
     ("喟" . "한숨쉴 괴")
     ("嘳" . "한숨쉴 괴")
     ("媿" . "창피줄 괴")
     ("廥" . "여물광 괴")
     ("恠" . "怪의 俗字")
     ("瑰" . "슬이름 괴")
     ("璝" . "옥돌 괴")
     ("蒯" . "황모 괴")
     ("襘" . "띠매듭 괴"))
    ("괵"
     ("剨" . "자끈할 괵")
     ("嘓" . "귀찮을 괵")
     ("馘" . "벨 괵"))
    ("굉"
     ("宏" . "클 굉")
     ("紘" . "갓끈 굉")
     ("肱" . "팔뚝 굉")
     ("轟" . "울릴 굉")
     ("卝" . "丱과 同字")
     ("厷" . "둥글 굉")
     ("浤" . "용솟음할 굉")
     ("纮" . "넓을 굉")
     ("觥" . "뿔잔 굉")
     ("訇" . "큰 소리 굉")
     ("鍠" . "종고 소리 굉")
     ("锽" . "쇠북소리 굉")
     ("閎" . "마을문 굉"))
    ("교"
     ("交" . "사귈 교")
     ("僑" . "높을 교")
     ("咬" . "새소리 교")
     ("喬" . "높을 교")
     ("嬌" . "아리따울 교")
     ("嶠" . "뾰족하게 높을 교")
     ("巧" . "공교할 교")
     ("招" . "들 교")
     ("攪" . "어지러울 교")
     ("敎" . "가르침 교")
     ("敲" . "두드릴 교")
     ("校" . "학교 교")
     ("橋" . "다리 교")
     ("狡" . "교활할 교")
     ("皎" . "달빛 교")
     ("矯" . "바로잡을 교")
     ("糾" . "맺힐 교")
     ("絞" . "목맬 교")
     ("翹" . "꼬리 긴 깃털 교")
     ("膠" . "아교 교")
     ("蕎" . "메밀 교")
     ("蛟" . "교룡 교")
     ("覺" . "꿈 깰 교")
     ("較" . "견줄 교")
     ("轎" . "가마 교")
     ("郊" . "성 밖 교")
     ("餃" . "경단 교")
     ("驕" . "교만할 교")
     ("鮫" . "상어 교")
     ("丂" . "교묘할 교")
     ("佼" . "예쁠 교")
     ("儌" . "갈 교")
     ("啋" . "움직일 교")
     ("嘂" . "크게 부르짖을 교")
     ("嘄" . "부르짖을 교")
     ("嘐" . "닭 울 교")
     ("嘺" . "입 비뚤러질 교")
     ("噭" . "부르짖을 교")
     ("嚙" . "깨물 교")
     ("姣" . "예쁠 교")
     ("憍" . "교만할 교")
     ("撟" . "들 교")
     ("撹" . "攪의 略字")
     ("教" . "敎의 俗字")
     ("晈" . "달 밝을 교")
     ("暞" . "밝을 교")
     ("榷" . "외나무 다리 교")
     ("磽" . "메마른 땅 교")
     ("窖" . "움 교, 지함 교")
     ("覚" . "覺의 略字")
     ("趫" . "나무에 잘 오를 교, 잘 달아날 교")
     ("跤" . "발화목 교")
     ("蹺" . "발돋움할 교")
     ("鉸" . "가위 교, 금장식 교")
     ("鞽" . "신 교")
     ("骹" . "발회목뼈 교")
     ("鵁" . "교청새 교")
     ("齩" . "뼈 깨물 교"))
    ("구"
     ("丘" . "언덕 구")
     ("久" . "오랠 구")
     ("九" . "아홉 구")
     ("仇" . "짝 구")
     ("俱" . "함께 구")
     ("具" . "갖출 구")
     ("勾" . "글귀절 구")
     ("區" . "감출 구")
     ("口" . "입 구")
     ("句" . "글귀절 구")
     ("咎" . "허물 구")
     ("嘔" . "토할 구")
     ("坵" . "丘의 俗字")
     ("垢" . "때 구, 더러울 구")
     ("寇" . "도둑 구")
     ("嶇" . "산험준할 구")
     ("廐" . "마구간 구")
     ("懼" . "두려워할 구")
     ("拒" . "진이름 구")
     ("拘" . "잡을 구")
     ("救" . "구원할 구")
     ("枸" . "구기자 구")
     ("柩" . "관 구")
     ("柾" . "관 구, 널 구")
     ("構" . "집세울 구")
     ("歐" . "토할 구")
     ("毆" . "때릴 구")
     ("毬" . "제기 구")
     ("求" . "찾을 구")
     ("溝" . "개천 구")
     ("灸" . "지질 구")
     ("狗" . "개 구")
     ("玖" . "옥 다음가는 돌 구")
     ("球" . "옥경쇠 구")
     ("瞿" . "놀라서 볼 구")
     ("矩" . "곡척 구")
     ("穀" . "녹봉 구")
     ("究" . "궁리할 구")
     ("絿" . "급박할 구")
     ("耉" . "늙을 구")
     ("臼" . "절구 구")
     ("舅" . "외삼촌 구")
     ("舊" . "옛 구")
     ("苟" . "진실로 구")
     ("衢" . "네거리 구")
     ("謳" . "읊조릴 구")
     ("購" . "살(구입할) 구")
     ("軀" . "몸 구")
     ("逑" . "짝 구")
     ("邱" . "언덕 구")
     ("鉤" . "갈고랑쇠 구")
     ("銶" . "끌 구")
     "鞫"
     ("駒" . "망아지 구")
     ("驅" . "몰 구")
     ("鳩" . "비둘기 구")
     ("鷗" . "갈매기 구")
     ("龜" . "나라 이름 구")
     ("丠" . "丘와 同字")
     ("丩" . "넝쿨 구")
     ("乆" . "久의 俗字")
     ("佉" . "나라 이름 구")
     ("佝" . "꼽추 구")
     ("俅" . "공손할 구")
     ("倃" . "훼방할 구")
     ("倶" . "俱와 同字")
     ("傴" . "구부릴 구")
     ("冓" . "재목 어긋매겨 쌓을 구")
     ("劬" . "수고로울 구")
     ("劶" . "부지런할 구")
     ("勼" . "모을 구")
     ("匓" . "배불러 싫을 구")
     ("匛" . "관 구, 널 구")
     ("匶" . "柩의 古字")
     ("区" . "區의 略字")
     ("厩" . "마구 구")
     ("厹" . "세모창 구")
     ("叴" . "소리 높일 구")
     ("呴" . "숨을 내쉴 구")
     ("坸" . "垢와 同字")
     ("夻" . "대구 구")
     ("姤" . "만날 구")
     ("媾" . "겹사돈 구")
     ("嫗" . "할미 구")
     ("屨" . "삼으로 짠 신 구")
     ("岣" . "산이름 구")
     ("廄" . "廐와 同字")
     ("廏" . "廐와 同字")
     ("彀" . "활 잔뜩 당길 구")
     ("戵" . "창 구")
     ("扣" . "두드릴 구")
     ("捄" . "흙파올릴 구")
     ("搆" . "얽어맬 구")
     ("摳" . "치마걷어들 구")
     ("旧" . "舊의 略字")
     ("昫" . "해돋아 따뜻할 구")
     ("榘" . "곡척 구")
     ("漚" . "물거품 구")
     ("璆" . "옥경쇠 구")
     ("甌" . "사발 구")
     ("疚" . "오랜 병 구")
     ("痀" . "곱사등이 구")
     ("癯" . "여윌 구")
     ("窛" . "노략질할 구")
     ("窶" . "가난하여 예절없을 구")
     ("篝" . "불덮개 구")
     ("糗" . "마른밥가루 구")
     ("耇" . "명길 구")
     ("耈" . "耇와 同字")
     ("胊" . "포(얇게 저미어서 말린 고기) 구")
     ("蒟" . "구장 구")
     ("蚯" . "지렁이 구")
     ("裘" . "갓옷 구")
     ("覯" . "만나볼 구")
     ("詬" . "꾸짖을 구")
     ("遘" . "만날 구")
     ("釦" . "그릇에 금테 두를 구")
     ("鞲" . "팔찌 구")
     ("韝" . "깍지 구")
     ("韭" . "부추 구")
     ("韮" . "韭와 同字")
     ("颶" . "사방풍 구")
     ("駆" . "驅의 略字")
     ("駈" . "驅와 同字")
     ("鬮" . "제비뽑을 구")
     ("鷇" . "새 새끼 구")
     ("鸜" . "구관조 구")
     ("鼽" . "감기들어 코 막힐 구"))
    ("국"
     ("國" . "나라 국")
     ("局" . "부분 국")
     ("菊" . "국화 국")
     ("鞠" . "기를 국")
     ("麴" . "누룩 국")
     ("侷" . "죄어칠 국")
     ("匊" . "움켜 뜰 국")
     ("囗" . "國의 古字")
     ("囶" . "國의 古字")
     ("国" . "國의 略字")
     ("圀" . "國의 古字")
     ("掬" . "두 손으로 움킬 국")
     ("跼" . "구부릴 국")
     ("麯" . "麴과 同字")
     ("麹" . "누룩 국"))
    ("군"
     ("君" . "임금 군")
     ("窘" . "군색할 군")
     ("群" . "무리 군")
     ("裙" . "치마 군")
     ("軍" . "군사 군")
     ("郡" . "고을 군")
     ("僒" . "구부릴 군")
     ("捃" . "주울 군")
     ("桾" . "고욤나무 군")
     ("皸" . "얼어터질 군")
     ("麇" . "무리 군"))
    ("굴"
     ("厥" . "나라이름 굴")
     ("堀" . "굴뚝 굴")
     ("屈" . "굽을 굴")
     ("掘" . "팔 굴")
     ("窟" . "구멍 굴")
     ("倔" . "딱딱할 굴")
     ("崛" . "산 높을 굴")
     ("淈" . "흐릴 굴")
     ("詘" . "굽을 굴"))
    ("궁"
     ("宮" . "굴궐 궁")
     ("弓" . "활 궁")
     ("穹" . "높을 궁")
     ("窮" . "다할 궁")
     ("芎" . "궁궁이 궁")
     ("躬" . "몸 궁")
     ("匑" . "공손할 궁")
     ("宫" . "宮의 略字")
     ("躳" . "躬의 本字"))
    ("권"
     ("倦" . "게으를 권")
     ("券" . "엄쪽(어음을 쪼갠 한 쪽) 권")
     ("勸" . "권할 권")
     ("卷" . "굽을 권")
     ("圈" . "둥글 권")
     ("拳" . "주먹 권")
     ("捲" . "거둘 권")
     ("權" . "권세 권")
     ("淃" . "물돌아 흐를 권")
     ("眷" . "돌아볼 권")
     ("劵" . "게으를 권, 고달플 권, 수고로울 권")
     ("勌" . "倦과 同字")
     ("勧" . "勸의 略字")
     ("圏" . "圈과 同字")
     ("巻" . "卷의 俗字")
     ("惓" . "삼갈 권")
     ("棬" . "휘어만든 나무그릇 권")
     ("権" . "權의 俗字")
     ("睠" . "眷과 同字")
     ("綣" . "정다울 권")
     ("蜷" . "움추러질 권")
     ("鬈" . "수염좋을 권"))
    ("궐"
     ("厥" . "그 궐")
     ("掘" . "뚫을 궐")
     ("獗" . "도둑 일어날 궐")
     ("蕨" . "고사리 궐")
     ("蹶" . "우물벌레 궐")
     ("闕" . "대궐 궐")
     ("亅" . "갈고리 궐")
     ("鱖" . "쏘가리 궐"))
    ("궤"
     ("机" . "느티나무 궤")
     ("櫃" . "상자 궤")
     ("歸" . "먹일 궤")
     ("潰" . "흩어질 궤")
     ("詭" . "속일 궤")
     ("蹶" . "급히걸을 궤")
     ("軌" . "수레바퀴 사이 궤")
     ("饋" . "먹일 궤")
     ("佹" . "포갤 궤")
     ("儿" . "어진 사람 궤")
     ("几" . "안석 궤")
     ("劂" . "새김칼 궤")
     ("匭" . "갑 궤")
     ("匱" . "갑 궤")
     ("厬" . "목마를 궤")
     ("帰" . "歸의 俗字")
     ("憒" . "심란할 궤")
     ("撅" . "옷걷을 궤")
     ("樻" . "가마테나무 궤")
     ("氿" . "물가 궤")
     ("簋" . "대제기 궤")
     ("繢" . "톱끝 궤")
     ("跪" . "끓어앉을 궤")
     ("闠" . "저자문 궤")
     ("餽" . "饋와 同字")
     ("鱖" . "쏘가리 궤")
     ("麂" . "큰고라니 궤"))
    ("귀"
     ("勾" . "句와 同字")
     ("句" . "글귀 귀")
     ("晷" . "시각 귀")
     ("歸" . "돌아올 귀")
     ("貴" . "높을 귀")
     ("鬼" . "귀신 귀")
     ("龜" . "거북 귀")
     ("句" . "글귀 귀")
     ("龜" . "거북 귀")
     ("亀" . "龜의 略字")
     ("劌" . "상할 귀")
     ("帰" . "歸의 俗字")
     ("櫷" . "느티나무 귀"))
    ("규"
     ("九" . "모을 규")
     ("叫" . "부를 규")
     ("圭" . "서옥 규")
     ("奎" . "별 규")
     ("揆" . "헤아릴 규")
     ("槻" . "물푸레나무 규")
     ("珪" . "圭와 同字")
     ("硅" . "유리만드는 흙 규")
     ("窺" . "엿볼 규")
     ("竅" . "구멍 규")
     ("糾" . "삼합노 규")
     ("葵" . "해바라기 규")
     ("規" . "그림쇠 규")
     ("赳" . "헌걸찰 규")
     ("逵" . "구거리 규")
     ("閨" . "색시 규")
     ("頃" . "반걸음 규")
     ("乣" . "糺의 譌字")
     ("刲" . "찌를 규")
     ("呌" . "부르짖을 규")
     ("嫢" . "가는 허리 규")
     ("嬀" . "성 규")
     ("巋" . "높고 험준할 규")
     ("暌" . "해질 규")
     ("楏" . "호미자루 규")
     ("樛" . "나무가지 휘어질 규")
     ("潙" . "물이름 규")
     ("睽" . "어그러질 규")
     ("糺" . "거둘 규")
     ("虬" . "虯와 同字")
     ("虯" . "뿔없는 용 규")
     ("跬" . "한발자국 규")
     ("邽" . "고을이름 규")
     ("闚" . "갸웃이 볼 규")
     ("頍" . "고깔비녀 규")
     ("馗" . "아홉거리 규"))
    ("균"
     ("勻" . "고를 균")
     ("均" . "고를 균")
     ("畇" . "밭개간할 균")
     ("筠" . "대껍질 균")
     ("菌" . "버섯 균")
     ("鈞" . "서른 근 균")
     ("龜" . "(피부가)틀 균")
     ("龜" . "(피부가)틀 균")
     ("亀" . "龜의 略字")
     ("匀" . "고를 균")
     ("囷" . "둥근곳집 균")
     ("麇" . "노루 균")
     ("麏" . "고라니 균"))
    ("귤"
     ("橘" . "귤나무 귤"))
    ("극"
     ("克" . "이길 극")
     ("剋" . "깍일 극")
     ("劇" . "심할 극")
     ("可" . "오랑캐 임금 이름 극")
     ("戟" . "갈래진 창 극")
     ("棘" . "가시나무 극")
     ("極" . "가운데 극")
     ("隙" . "틈 극")
     ("革" . "위독해질 극")
     ("丮" . "잡을 극")
     ("亟" . "빠를 극")
     ("勀" . "이길 극")
     ("尅" . "剋과 同字")
     ("屐" . "나막신 극")
     ("郄" . "隙과 同字")
     ("郤" . "틈 극"))
    ("근"
     ("僅" . "겨우 근")
     ("劤" . "힘많을 근")
     ("勤" . "부지런할 근")
     ("懃" . "은근할 근")
     ("斤" . "근 근")
     ("根" . "뿌리 근")
     ("槿" . "무궁화 근")
     ("瑾" . "붉은옥 근")
     ("矜" . "창자루 근")
     ("筋" . "힘줄 근")
     ("芹" . "미나리 근")
     ("菫" . "오랑캐 꽃 근")
     ("覲" . "뵈올 근")
     ("謹" . "삼갈 근")
     ("近" . "가까울 근")
     ("饉" . "주릴 근")
     ("卺" . "합환주잔 근")
     ("厪" . "적을 근")
     ("堇" . "노란진흙 근")
     ("墐" . "진흙 근")
     ("巹" . "받들 근")
     ("廑" . "작은집 근")
     ("漌" . "맑을 근")
     ("觔" . "筋과 同字")
     ("跟" . "발두꿈치 근")
     ("釿" . "대패 근")
     ("靳" . "아낄 근"))
    ("글"
     ("契" . "부족 이름 글")
     ("契" . "부족 이름 글"))
    ("금"
     ("今" . "이제 금")
     ("妗" . "외숙모 금")
     ("擒" . "사로잡을 금")
     ("昑" . "밝을 금")
     ("檎" . "능금나무 금")
     ("琴" . "거문고 금")
     ("禁" . "금할 금")
     ("禽" . "날짐승 금")
     ("芩" . "풀 이름 금")
     ("衾" . "이불 금")
     ("衿" . "옷깃 금")
     ("襟" . "옷깃 금")
     ("金" . "쇠 금")
     ("錦" . "비단 금")
     ("黔" . "귀신 이름 금")
     ("金" . "성 금")
     ("僸" . "우러를 금")
     ("凚" . "쌀쌀하게 추울 금")
     "厼"
     ("唫" . "입 다물 금")
     ("噤" . "입 다물 금")
     ("嵚" . "산 솟을 금")
     ("嶔" . "높고 험할 금")
     ("笒" . "첨대 금")
     ("黅" . "누른 빛 금"))
    ("급"
     ("伋" . "속일 급")
     ("及" . "미칠 급")
     ("急" . "급할 급")
     ("扱" . "미칠 급")
     ("汲" . "길을 급")
     ("級" . "등급 급")
     ("給" . "넉넉할 급")
     ("圾" . "위태할 급")
     ("岌" . "높을 급")
     ("皀" . "고소할 급")
     ("礏" . "산 높은 모양 급")
     ("笈" . "책상자 급")
     ("芨" . "말오줌나무 급"))
    ("긍"
     ("兢" . "삼갈 긍")
     ("恒" . "시위 긍, 두루할 긍")
     ("矜" . "불쌍히 여길 긍")
     ("肯" . "옳이 여길 긍")
     ("亙" . "뻗칠 긍")
     ("殑" . "까무라칠 긍")
     ("鹶" . "짜고 쓸 긍"))
    ("기"
     ("乞" . "줄 기")
     ("企" . "꾀할 기")
     ("伎" . "재주 기")
     ("俟" . "성씨 기")
     ("倚" . "기이할 기")
     ("其" . "그 기")
     ("冀" . "바랄 기")
     ("嗜" . "즐길 기")
     ("器" . "그릇 기")
     ("圻" . "경기 기")
     ("基" . "터 기")
     ("埼" . "崎와 同字")
     ("夔" . "조심할 기")
     ("奇" . "기이할 기")
     ("妓" . "기생 기")
     ("寄" . "부칠 기")
     ("居" . "어조사 기")
     ("岐" . "갈림길 기")
     ("崎" . "험할 기")
     ("己" . "자기 기")
     ("幾" . "기미 기")
     ("忌" . "꺼릴 기")
     ("技" . "재주 기")
     ("旗" . "기 기")
     ("旣" . "이미 기")
     ("朞" . "돌 기")
     ("期" . "기약할 기")
     ("杞" . "나무 이름 기")
     ("枳" . "해할 기, 사타구니 기")
     ("棄" . "버릴 기")
     ("棋" . "바둑 기")
     ("機" . "틀 기")
     ("欺" . "속일 기")
     ("氣" . "기운 기")
     ("汽" . "김 기")
     ("沂" . "물 이름 기")
     ("淇" . "강 이름 기")
     ("玘" . "패옥 기")
     ("琦" . "옥 이름 기")
     ("琪" . "옥 기")
     ("璂" . "피변 꾸미개 기")
     ("璣" . "구슬 기")
     ("畸" . "뙈기 밭 기")
     ("畿" . "경기 기")
     ("碁" . "棋와 同字")
     ("磯" . "물가 기")
     ("示" . "땅 귀신 기")
     ("祁" . "성할 기")
     ("祇" . "토지의 신 기")
     ("祈" . "빌 기")
     ("祺" . "복 기")
     ("箕" . "키 기")
     ("紀" . "벼리 기")
     ("綺" . "비단 기")
     ("羈" . "굴레 기")
     ("耆" . "늙은이 기")
     ("耭" . "갈 기")
     ("肌" . "살 기")
     ("記" . "기록할 기")
     ("譏" . "나무랄 기")
     ("豈" . "어찌 기")
     ("起" . "일어날 기")
     ("錡" . "솥 기")
     ("錤" . "호미 기")
     ("飢" . "주릴 기")
     ("饑" . "주릴 기")
     ("騎" . "말탈 기")
     ("騏" . "털총이 기")
     ("驥" . "천리마 기")
     ("麒" . "기린 기")
     ("丌" . "책상 기")
     ("亓" . "其의 古字")
     ("亟" . "자주 기")
     ("倛" . "탈 기")
     ("僛" . "취하여 춤추는 모양 기")
     ("僟" . "삼갈 기")
     ("刏" . "찌를 기")
     ("剞" . "새김칼 기")
     ("呮" . "도사리고 앉을 기")
     ("唭" . "듣지도 보지도 않을 기")
     ("嘰" . "쪽잘거릴 기")
     ("噐" . "그릇 기")
     ("墍" . "맥질할 기")
     ("屺" . "민둥산 기")
     ("庋" . "시렁 기")
     ("弃" . "棄의 古字")
     ("忮" . "해칠 기")
     ("怾" . "산 이름 기")
     ("愭" . "공손할 기")
     ("掎" . "끌 기")
     ("攲" . "기울기 기")
     ("旂" . "기 기")
     ("既" . "旣의 訛字")
     ("暣" . "볕기운 기")
     ("暨" . "曁와 同字")
     ("曁" . "및 기, 미칠 기, 굳셀 기")
     ("棊" . "棋와 同字")
     ("歧" . "岐와 同字")
     ("気" . "氣의 略字")
     ("炁" . "기운 기")
     ("猉" . "강아지 기")
     ("禨" . "조짐 기")
     ("綥" . "비단 쑥색 기")
     ("綦" . "연두빛 비단 기")
     ("羇" . "나그네 기")
     ("肵" . "적대 기")
     ("芪" . "단너삼 기")
     ("芰" . "세발 마름 기")
     ("蘄" . "풀 이름 기")
     ("虁" . "夔와 同字")
     ("蜝" . "방계 기")
     ("蟣" . "서캐 기")
     ("覉" . "구속할 기, 말 굴레 기")
     ("覬" . "바랄 기")
     ("跂" . "육발 기")
     ("跽" . "꿇어앉을 기")
     ("锜" . "세발 가마 기")
     ("隑" . "사닥다리 기")
     ("頎" . "헌걸찰 기")
     ("鬐" . "갈기 기")
     ("鰭" . "지느러미 기")
     ("黖" . "물건 생겨날 기"))
    ("긴"
     ("緊" . "굳게 얽힐 긴"))
    ("길"
     ("佶" . "건장할 길")
     ("吉" . "길할 길")
     ("拮" . "일할 길")
     ("桔" . "도라지 길")
     ("咭" . "웃는 모양 길")
     ("姞" . "성 길")
     ("蛣" . "장구벌레 길")
     ("鮚" . "대합 길"))
    ("김"
     ("金" . "사람의 성 김"))
    ("끝"
     ("印" . "끝(官簿之末端書字) 끝"))
    ("끽"
     ("喫" . "마실 끽"))
    ("나"
     ("儺" . "역귀 쫓을 나")
     ("奈" . "어찌 나")
     ("娜" . "아리따울 나")
     ("懦" . "나약할 나")
     ("拏" . "붙잡을 나")
     ("拿" . "붙잡을 나")
     ("那" . "어찌 나")
     ("難" . "성할 나, 탈 나")
     ("喇" . "나팔 라, 라마교 라")
     ("奈" . "어찌 나")
     ("懶" . "게으를 나")
     ("癩" . "약물 중독 나")
     ("羅" . "새 그물 나")
     ("蘿" . "소나무겨우살이 나")
     ("螺" . "소라 라")
     ("裸" . "벌거벗을 라, 털 없는 벌레 라")
     ("邏" . "돌 나")
     ("哪" . "연귀 쫓는 소리 나")
     ("挐" . "붙잡을 나")
     ("挪" . "옮길 나")
     ("梛" . "나무 이름 나")
     ("糥" . "糯와 同字")
     ("糯" . "찰벼 나"))
    ("낙"
     ("格" . "막힐 락")
     ("諾" . "대답할 낙")
     ("樂" . "즐길 낙")
     ("洛" . "강 이름 낙")
     ("烙" . "지질 낙")
     ("珞" . "구슬 목걸이 낙")
     ("落" . "떨어질 낙")
     ("酪" . "타락 낙")
     ("駱" . "낙타 낙"))
    ("난"
     ("暖" . "따뜻할 난")
     ("煖" . "따뜻할 난")
     ("難" . "어려울 난")
     ("亂" . "어지러울 난")
     ("卵" . "알 난")
     ("欄" . "난간 난")
     ("爛" . "문드러질 난")
     ("蘭" . "난초 난")
     ("鸞" . "난새 난")
     ("偄" . "언약할 난")
     ("煗" . "터울 난")
     ("赧" . "얼굴 붉힐 난")
     ("餪" . "풀보기 잔치 난"))
    ("날"
     ("捏" . "이길 날")
     ("捺" . "누를 날")
     ("涅" . "앙금 흙 날"))
    ("남"
     ("南" . "남녘 남")
     ("枏" . "녹나무 남")
     ("楠" . "녹나무 남")
     ("湳" . "강 이름 남")
     ("男" . "사내 남")
     ("嵐" . "남기 남")
     ("濫" . "퍼질 남")
     ("藍" . "쪽 남")
     ("襤" . "누더기 남")
     ("喃" . "재잘거릴 남")
     ("柟" . "枏의 俗字"))
    ("납"
     ("內" . "들일 납")
     ("納" . "바칠 납")
     ("衲" . "기울 납")
     ("拉" . "꺽을 납")
     ("臘" . "납향 납")
     ("蠟" . "밀 납")
     ("内" . "받아들일 납"))
    ("낭"
     ("囊" . "주머니 낭")
     ("娘" . "아가씨 낭")
     ("廊" . "복도 낭")
     ("朗" . "밝을 낭")
     ("浪" . "물결 낭")
     ("狼" . "이리 낭")
     ("郎" . "사나이 낭")
     ("嚢" . "囊과 同字")
     ("曩" . "접때 낭"))
    ("내"
     ("乃" . "이에 내")
     ("內" . "안 내")
     ("奈" . "어찌 내")
     ("柰" . "능금나무 내")
     ("耐" . "견딜 내")
     ("能" . "세 발 자라 내")
     ("來" . "올 내")
     ("内" . "內와 同字")
     ("匂" . "향내 내")
     ("奶" . "젖 내")
     ("嬭" . "젖 내")
     ("廼" . "迺의 俗字")
     ("迺" . "이에 내")
     ("鼐" . "가마솥 내"))
    ("냉"
     ("冷" . "차가울 냉"))
    ("녀"
     ("女" . "계집 녀")
     ("挐" . "이끌 녀"))
    ("녁"
     ("惄" . "마음 졸일 녁"))
    ("년"
     ("年" . "해 년")
     ("撚" . "비틀 년")
     ("秊" . "年의 本字")
     ("碾" . "맷돌 년"))
    ("녈"
     ("涅" . "죽을 녈")
     "囓")
    ("념"
     ("念" . "생각 념")
     ("恬" . "편안할 념")
     ("拈" . "집을 념")
     ("捻" . "비틀 념"))
    ("녑"
     ("捻" . "비틀 녑"))
    ("녕"
     ("寗" . "편안할 녕")
     ("寧" . "편안할 녕")
     ("佞" . "재주 녕")
     ("儜" . "고달플 녕")
     ("嚀" . "정녕할 녕")
     ("寕" . "문안할 녕")
     ("寜" . "차라리 녕")
     ("濘" . "진흙 녕")
     ("甯" . "편안할 녕")
     ("矃" . "볼 녕"))
    ("녜"
     ("昵" . "아비사당 녜"))
    ("노"
     ("努" . "힘쓸 노")
     ("奴" . "종 노")
     ("帑" . "처자식 노")
     ("弩" . "쇠뇌(여러 개의 화살이나 돌을 잇따라 쏘게 된 큰 활) 노")
     ("怒" . "성낼 노")
     ("瑙" . "마노 노")
     ("駑" . "둔할 노")
     ("勞" . "수고할 노")
     ("擄" . "사로잡을 노")
     ("櫓" . "큰 방패 노")
     ("爐" . "화로 노")
     ("盧" . "밥그릇 노")
     ("老" . "늙을 노")
     ("蘆" . "갈대 노")
     ("虜" . "포로 노")
     ("路" . "길 노")
     ("露" . "이슬 노")
     ("魯" . "미련할 노")
     ("鷺" . "해오라기 노")
     ("呶" . "들랠 노")
     ("孥" . "자식 노")
     ("峱" . "산이름 노")
     ("猱" . "못할 노")
     ("笯" . "새장 노")
     ("臑" . "팔마디 노"))
    ("녹"
     ("碌" . "푸른 빛 녹")
     ("祿" . "행복 녹")
     ("綠" . "초록빛 녹")
     ("菉" . "조개풀 녹")
     ("錄" . "기록할 녹")
     ("鹿" . "사슴 녹"))
    ("논"
     ("論" . "말할 논"))
    ("농"
     ("濃" . "짙을 농")
     ("膿" . "고름 농")
     ("農" . "농사 농")
     ("龐" . "통통하게 살질 롱")
     ("壟" . "밭두둑 농")
     ("弄" . "희롱할 농")
     ("籠" . "대그릇 농")
     ("聾" . "귀머거리 농")
     ("儂" . "나 농")
     ("噥" . "달게 먹을 농")
     ("穠" . "후한 제사 농")
     ("竜" . "두덕 롱")
     ("醲" . "텁텁한 술 농"))
    ("뇌"
     ("惱" . "괴로워할 뇌")
     ("腦" . "머리 뇌")
     ("牢" . "가축우리 뇌")
     ("磊" . "돌이 많이 쌓인 모양 뇌")
     ("賂" . "뇌물 뇌")
     ("雷" . "우뢰 뇌")
     ("匘" . "살찐 모양 뇌")
     ("悩" . "惱의 俗字")
     ("脳" . "머리골 뇌")
     ("餒" . "굶길 뇌"))
    ("뇨"
     ("尿" . "오줌 뇨")
     ("溺" . "우줌눌 뇨")
     ("鬧" . "시끄러울 뇨")
     "啂"
     ("嫋" . "날릴 뇨")
     ("嬲" . "샘낼 뇨")
     ("淖" . "진흙 뇨")
     ("磠" . "약돌 뇨")
     ("裊" . "끄을 뇨")
     ("鐃" . "작은 징 뇨"))
    ("누"
     ("壘" . "진 누")
     ("屢" . "(빛이 들어오는)창 누")
     ("樓" . "다락 누")
     ("淚" . "눈물 누")
     ("漏" . "샐 누")
     ("累" . "포갤 누")
     ("縷" . "자세할 누")
     ("陋" . "줍을 누")
     ("耨" . "김맬 누"))
    ("눈"
     ("嫩" . "언약할 눈"))
    ("눌"
     ("訥" . "말 더듬거릴 눌")
     ("吶" . "말 더듬을 눌")
     ("呐" . "吶과 同字")
     ("肭" . "물개 눌"))
    ("뉴"
     ("杻" . "옷 부드러울 뉴")
     ("紐" . "잡색비단 뉴")
     ("忸" . "익을 뉴")
     ("靵" . "단추 뉴"))
    ("뉵"
     ("衄" . "코피 뉵"))
    ("늑"
     ("勒" . "굴레 늑")
     ("肋" . "갈비대 늑"))
    ("늠"
     ("凜" . "찰 늠"))
    ("능"
     ("能" . "능할 능")
     ("凌" . "얼음 능")
     ("稜" . "모질 능")
     ("綾" . "무늬 놓은 비단 능")
     ("菱" . "마름 능")
     ("陵" . "능 능"))
    ("늦"
     ("莻" . "늦을 늦"))
    ("니"
     ("尼" . "여승 니")
     ("泥" . "막힐 니")
     ("你" . "너 니")
     ("呢" . "소근거릴 니")
     ("怩" . "부끄러워할 니")
     ("柅" . "얼레자루 니")
     ("祢" . "아비사당 니")
     ("禰" . "아비사당 니")
     ("膩" . "살찔 니"))
    ("닉"
     ("匿" . "숨쉴 닉")
     ("溺" . "빠질 닉"))
    ("닐"
     ("昵" . "가깝게 할 닐")
     ("暱" . "칠근할 닐"))
    ("다"
     ("多" . "많을 다")
     ("茶" . "차풀 다")
     ("爹" . "아비 다"))
    ("단"
     ("丹" . "붉을 단")
     ("亶" . "믿을 단")
     ("但" . "다만 단")
     ("單" . "홀로 단")
     ("團" . "둥글 단")
     ("壇" . "제터 단")
     ("彖" . "결단할 단")
     ("斷" . "끊을 단")
     ("旦" . "밝을 단")
     ("檀" . "향나무 단")
     ("段" . "층계 단")
     ("湍" . "여울 단")
     "澾"
     ("短" . "짧을 단")
     ("端" . "끝 단")
     ("簞" . "소쿠리 단")
     ("緞" . "비단 단")
     ("緣" . "단옷 단")
     ("蛋" . "오랑캐 이름 단")
     ("袒" . "웃옷 벗을 단")
     ("鄲" . "조나라 서울 단")
     ("鍛" . "쇠불릴 단")
     ("剬" . "단정할 단")
     ("剸" . "끊을 단")
     ("勯" . "힘다할 단")
     ("匰" . "신주독 단")
     ("单" . "홀로 단")
     ("単" . "單의 略字")
     ("唌" . "참소리 단")
     ("団" . "團의 略字")
     ("慱" . "근심할 단")
     ("担" . "원숭이 같은 짐승 단")
     ("断" . "어질 단")
     ("椴" . "자작나무 단")
     ("漙" . "이슬방울 맺을 단")
     ("癉" . "황달 단")
     ("笪" . "고리짝 단")
     ("箪" . "밥그릇 단")
     ("糰" . "경단 단")
     ("縁" . "緣의 略字")
     ("耑" . "시초 단")
     ("胆" . "침비깨 단")
     ("腶" . "약포 단")
     ("蜑" . "오랑캐 이름 단")
     ("踹" . "발꿈치 단"))
    ("달"
     ("撻" . "매질할 달")
     ("獺" . "수달 달")
     ("疸" . "황달 달")
     ("達" . "통달할 달")
     ("呾" . "마주 꾸짖을 달")
     ("噠" . "오랑캐 나라 이름 달")
     ("妲" . "계집의 이름 달")
     ("怛" . "깜짝 놀랄 달")
     ("笪" . "뜸 달, 배 덮는 삿자리 달")
     ("闥" . "대문 달")
     ("靼" . "다룬가죽 달")
     ("韃" . "칠 달"))
    ("담"
     ("啖" . "씹을 담")
     ("坍" . "물이 언덕 찰 담")
     ("憺" . "고요할 담")
     ("擔" . "질 담")
     ("曇" . "날 흐릴 담")
     ("淡" . "물모양 담")
     ("湛" . "즐거울 담")
     ("潭" . "깊을 담")
     ("澹" . "맑을 담")
     ("痰" . "가래 담")
     ("聃" . "노자이름 담")
     ("膽" . "쓸개 담")
     ("蕁" . "말 담")
     ("覃" . "미칠 담")
     ("談" . "말씀 담")
     ("譚" . "클 담")
     ("錟" . "긴 창 담")
     ("倓" . "편안할 담")
     ("儋" . "기운차고 날쌜해집 담")
     ("啗" . "씹을 담")
     ("啿" . "많을 담")
     ("嘾" . "탐할 담")
     ("噇" . "먹는 모양 담")
     ("噉" . "씹을 담")
     ("嚪" . "먹을 담")
     ("墰" . "목긴 술병 담")
     ("壜" . "술병 담")
     ("毯" . "담자리 담")
     ("禫" . "담제 담")
     ("罎" . "壜과 同字")
     ("薝" . "치자나무 담")
     ("郯" . "나라이름 담")
     ("黮" . "검을 담")
     ("黵" . "문신할 담"))
    ("답"
     ("沓" . "거듭 답")
     ("畓" . "논 답")
     ("答" . "젖을 답")
     ("踏" . "떨어지는 소리 답")
     ("遝" . "가다가설 답")
     ("匒" . "포갤 답"))
    ("당"
     ("唐" . "당나라 당")
     ("堂" . "집 당")
     ("塘" . "연못 당")
     ("幢" . "기 당")
     ("戇" . "어리석을 당")
     ("撞" . "두드릴 당")
     ("棠" . "아가위 당")
     ("當" . "마땅할 당")
     ("糖" . "엿 당")
     ("螳" . "버마 재비 당")
     ("黨" . "무리 당")
     ("倘" . "혹시 당")
     ("儻" . "빼어날 당")
     ("党" . "黨의 略字")
     ("当" . "當의 略字")
     ("搪" . "당동할 당")
     ("檔" . "책상 당")
     ("溏" . "진수렁 당")
     ("瑭" . "옥이름 당")
     ("璫" . "귀고리 당")
     ("瞠" . "바로볼 당")
     ("礑" . "밑바닥 당")
     ("蟷" . "사마귀 당")
     ("襠" . "잠방이 당")
     ("讜" . "곧은 말 당")
     ("鏜" . "북방축소 당")
     ("鐺" . "죄인 자물쇠 당")
     ("餳" . "엿 당")
     ("餹" . "엿 당"))
    ("대"
     ("代" . "대신할 대")
     ("坮" . "들 대")
     ("垈" . "터 대")
     ("大" . "큰 대")
     ("對" . "마주볼 대")
     ("岱" . "태산 대")
     ("帶" . "띠 대")
     ("待" . "기다릴 대")
     ("戴" . "받들 대")
     ("擡" . "들 대")
     ("玳" . "대모(바다거북) 대")
     ("臺" . "능 대")
     ("袋" . "자루 대")
     ("貸" . "빌릴 대")
     ("錞" . "창고달 대")
     ("隊" . "군대 대")
     ("黛" . "눈썹 그릴 대, 새파랄 대")
     ("儓" . "하인 대")
     ("对" . "對의 略字")
     ("対" . "對의 略字")
     ("带" . "띠 대")
     ("帯" . "帶의 俗字")
     ("懟" . "원망할 대")
     ("旲" . "햇빛 대")
     "枱"
     ("檯" . "등대 대")
     ("歹" . "거스릴 대")
     ("汏" . "씻을 대")
     ("碓" . "방아 대")
     ("鐓" . "창고달 대"))
    ("댁"
     ("宅" . "집 댁"))
    ("덕"
     ("德" . "품행 덕, 큰 덕, 은혜 덕")
     ("悳" . "德의 古字")
     ("徳" . "德의 略字")
     ("惪" . "悳과 同字"))
    ("도"
     ("倒" . "넘어질 도")
     ("刀" . "칼 도")
     ("到" . "이를 도")
     ("圖" . "그림 도")
     ("堵" . "담 도")
     ("塗" . "바를 도")
     ("導" . "이끌 도")
     ("屠" . "잡을 도")
     ("島" . "섬 도")
     ("嶋" . "섬 도")
     ("度" . "법도 도")
     ("徒" . "무리 도")
     ("悼" . "슬퍼할 도")
     ("挑" . "돋을 도")
     ("掉" . "흔들 도")
     ("搗" . "찧을 도")
     ("桃" . "복숭아 나무 도")
     ("棹" . "노 저을 도")
     ("櫂" . "상앗대 도")
     ("淘" . "일 도")
     ("渡" . "건널 도")
     ("滔" . "물 넘칠 도")
     ("濤" . "물결 도")
     ("燾" . "비칠 도")
     ("盜" . "도둑 도")
     ("睹" . "볼 도")
     ("禱" . "빌 도")
     ("稻" . "벼 도")
     ("綢" . "쌀 도")
     ("纛" . "클 깃발 도")
     ("萄" . "포도나무 도")
     ("覩" . "睹와 同字")
     ("賭" . "노름 도")
     ("跳" . "뛸 도")
     ("蹈" . "밟을 도")
     ("逃" . "달아날 도")
     ("途" . "길 도")
     ("道" . "길 도")
     ("都" . "도읍 도")
     ("鍍" . "도금할 도")
     ("陶" . "질 그도 도")
     ("韜" . "활집 도")
     ("刂" . "刀와 同字")
     ("匋" . "질그릇 도")
     ("叨" . "탐할 도")
     ("咷" . "아이 울음 끈질길 도")
     ("啕" . "수도할 도")
     ("嘟" . "칭찬할 도")
     ("図" . "圖의 俗字")
     ("圗" . "그림 도")
     ("壔" . "작은 성 도")
     ("弢" . "활집 도")
     ("忉" . "근심할 도")
     ("慆" . "기뻐할 도")
     ("掏" . "가릴(선택)할 도")
     ("搯" . "두드릴 도")
     ("擣" . "찧을 도")
     ("檮" . "그루터기 도")
     ("洮" . "달아날 도")
     ("涂" . "길 도")
     ("祷" . "禱와 同字")
     ("稌" . "찰벼 도")
     ("稲" . "稻의 俗字")
     ("菟" . "고을 이름 도")
     ("酴" . "두번 빚은 술 도")
     ("闍" . "성문 층대 도")
     ("鞀" . "소고 도")
     ("鞱" . "너그러울 도")
     ("饕" . "탐할 도")
     ("鼗" . "땡땡이 도")
     ("都" . "도읍 도"))
    ("독"
     ("毒" . "독 독")
     ("瀆" . "도랑 독")
     ("牘" . "편지 독")
     ("犢" . "송아지 독")
     ("獨" . "홀로 독")
     ("督" . "감독할 독")
     ("禿" . "대머리 독")
     ("竺" . "두터울 독")
     ("篤" . "도타울 독")
     ("讀" . "읽을 독")
     ("匵" . "손궤 독")
     ("櫝" . "함 독")
     ("涜" . "瀆과 同字")
     ("独" . "獨의 俗字")
     ("秃" . "禿과 同字")
     ("読" . "교활할 독")
     ("黷" . "더러울 독"))
    ("돈"
     ("墩" . "돈대 돈")
     ("惇" . "두터울 돈")
     ("敦" . "도타울 돈")
     ("旽" . "늘 돋을 돈")
     ("暾" . "아침해 돈")
     ("沌" . "기름 덩어리 돈")
     ("焞" . "귀갑 지지는 불 돈")
     ("燉" . "불 성할 돈")
     ("盾" . "사람이름 돈")
     ("豚" . "돼지 돈")
     ("遁" . "달아날 돈")
     ("頓" . "조아릴 돈")
     ("伅" . "어두울 돈")
     ("囤" . "작을 곳집 돈")
     ("弴" . "그림 그린 활 돈")
     ("潡" . "큰 물 돈")
     ("犜" . "돈피 돈")
     ("獤" . "돈피 돈")
     ("躉" . "거룻배 돈"))
    ("돌"
     ("乭" . "이름 돌")
     ("凸" . "뾰족할 돌, 내밀 돌, 도도록할 돌")
     ("突" . "부딪칠 돌")
     ("咄" . "꾸짖을 돌")
     ("堗" . "굴똑 돌"))
    ("동"
     ("仝" . "同의 古字")
     ("冬" . "겨울 동")
     ("凍" . "얼 동")
     ("動" . "움직일 동")
     ("同" . "같을 동")
     ("憧" . "동경할 동")
     ("東" . "동녘 동")
     ("桐" . "오동나무 동")
     ("棟" . "용마루 동")
     ("洞" . "마을 동")
     ("潼" . "물 이름 동")
     ("疼" . "아플 동")
     ("瞳" . "눈동자 동")
     ("童" . "아이 동")
     ("胴" . "큰 창자 동")
     ("董" . "바로잡을 동")
     ("銅" . "구리 동")
     "佟"
     ("侗" . "무지할 동")
     ("倲" . "어리석을 동")
     ("偅" . "흐리멍텅할 동")
     ("働" . "궁닐 동")
     ("僮" . "아이 동")
     ("哃" . "클말할 동")
     ("垌" . "항아리 동")
     ("峒" . "산이름 동")
     ("彤" . "붉은 칠 동")
     ("朣" . "달 뜰 동")
     ("橦" . "나무이름 동")
     ("涷" . "마룻대 동")
     ("炵" . "불꽃 동")
     ("艟" . "배 동")
     ("苳" . "겨울살이 동")
     ("茼" . "쏙갓 동")
     ("蕫" . "황모 동")
     ("蝀" . "무지개 동")
     ("錬" . "보습날 동")
     ("鮗" . "전어 동")
     ("鼕" . "북소리 동"))
    ("두"
     ("兜" . "투구 두")
     ("土" . "뿌리 두")
     ("斗" . "말 두")
     ("杜" . "막을 두")
     ("枓" . "두공 두")
     ("痘" . "마마 두")
     ("竇" . "구멍 두")
     ("荳" . "콩 두")
     ("讀" . "귀절 두")
     ("豆" . "콩 두")
     ("逗" . "머무를 두")
     ("頭" . "머리 두")
     ("讀" . "구절 두")
     ("亠" . "뜻 없는 토 두")
     ("侸" . "마를 두")
     ("吺" . "말 많을 두")
     ("抖" . "퍼주거릴 두")
     ("斁" . "섞을 두")
     ("肚" . "밥통 두")
     ("脰" . "목 두")
     ("蚪" . "올챙이 두")
     ("蠹" . "좀 두")
     ("読" . "讀의 略字")
     ("陡" . "절벽 두"))
    ("둔"
     ("屯" . "진칠 둔")
     ("臀" . "볼기 둔")
     ("芚" . "채소 이름 둔")
     ("遁" . "달아날 둔")
     ("遯" . "달아날 둔")
     ("鈍" . "무딜 둔")
     ("頓" . "조아릴 둔")
     ("吨" . "말 분명치 못할 둔")
     ("窀" . "광중 둔")
     ("迍" . "머뭇거릴 둔"))
    ("둘"
     ("乧" . "음역자 둘"))
    ("득"
     ("得" . "얻을 득"))
    ("등"
     ("嶝" . "고개 등")
     ("橙" . "등자나무 등")
     ("燈" . "등잔 등")
     ("登" . "오를 등")
     ("等" . "가지런할 등")
     ("藤" . "등나무 등")
     ("謄" . "베낄 등")
     ("鄧" . "나라 이름 등")
     ("騰" . "오를 등")
     ("凳" . "걸상 등")
     ("墱" . "자드락길 등")
     "𣎳"
     ("滕" . "물 솟을 등")
     ("灯" . "燈의 略字")
     ("磴" . "돌 비탈길 등")
     ("籐" . "대 기구 등")
     ("縢" . "봉할 등")
     ("腾" . "달릴 등, 뛰놀 등, 날칠 등의 簡體字")
     ("螣" . "등사 등")
     ("鐙" . "등자 등"))
    ("라"
     ("喇" . "나팔 라")
     ("懶" . "게으를 라")
     ("癩" . "약물 중독 라")
     ("羅" . "새그물 라")
     ("蘿" . "무 라")
     ("螺" . "소라 라")
     ("裸" . "벌거벗을 라")
     ("邏" . "순행할 라")
     ("拏" . "붙잡을 라")
     "亽"
     ("倮" . "알몸 라")
     ("儸" . "간능할 라")
     "嗠"
     ("囉" . "소리 읽힐 라")
     ("曪" . "날 흐릴 라")
     ("瘰" . "연주창 라")
     ("砢" . "돌 쌓일 라")
     ("臝" . "벌거벗을 라")
     ("蠃" . "소라 라, 나나니벌 라")
     ("鑼" . "징 라")
     ("陏" . "오이 라, 풀열매 라")
     ("騾" . "노새 라")
     ("驘" . "옹 솥 라"))
    ("락"
     ("樂" . "즐길 락")
     ("洛" . "강이름 락")
     ("烙" . "지질 락")
     ("珞" . "구슬 목걸이 락")
     ("絡" . "헌솜 락")
     ("落" . "떨어질 락")
     ("諾" . "대답할 락")
     ("酪" . "진한 유즙 락")
     ("駱" . "낙타 락")
     ("樂" . "즐거울 락")
     ("諾" . "대답할 락")
     ("犖" . "얼룩소 락")
     ("雒" . "수리부엉이 락"))
    ("란"
     ("亂" . "어지러울 란")
     ("卵" . "알 란")
     ("懶" . "게으를 란")
     ("欄" . "난간 란")
     ("欒" . "나무 이름 란")
     ("瀾" . "물결 란")
     ("爛" . "문드러질 란")
     ("蘭" . "난초 란")
     ("鸞" . "난새 란")
     ("丹" . "붉을 란")
     ("乱" . "어지러울 란")
     ("囒" . "거짓말 할 란")
     ("圝" . "둥글 란")
     ("嬾" . "게으를 란")
     ("幱" . "내리다지 란")
     ("攔" . "막을 란")
     ("灓" . "적실 란")
     ("襴" . "난삼 란")
     ("鑾" . "방울 란")
     ("闌" . "가막을 란"))
    ("랄"
     ("剌" . "어그러질 랄")
     ("喇" . "말굽히할 랄")
     ("辣" . "매울 랄")
     ("埒" . "바자울 랄")
     ("辢" . "辣과 同字"))
    ("람"
     ("嵐" . "남기 람")
     ("擥" . "攬과 同字")
     ("攬" . "잡을 람")
     ("欖" . "감람나무 람")
     ("濫" . "퍼질 람")
     ("籃" . "바구니 람")
     ("纜" . "닻줄 람")
     ("藍" . "쪽 람")
     ("襤" . "누더기 람")
     ("覽" . "볼 람")
     ("啉" . "술순배 람")
     ("嚂" . "먹을 람")
     ("婪" . "탐할 람")
     ("惏" . "떨릴 람")
     ("覧" . "볼 람"))
    ("랍"
     ("拉" . "꺽을 랍")
     ("臘" . "납향 랍")
     ("蠟" . "밀 랍, 백랍 랍")
     ("蝋" . "蠟과 同字")
     ("鑞" . "땜납 랍"))
    ("랑"
     ("廊" . "복도 랑")
     ("朗" . "밝을 랑")
     ("浪" . "물결 랑")
     ("狼" . "이리 랑")
     ("琅" . "옥 이름 랑")
     ("瑯" . "고을 이름 랑")
     ("螂" . "蜋과 同字")
     ("郞" . "사나이 랑")
     ("榔" . "나무 이름 랑")
     ("硠" . "돌 부딪는 소라 랑")
     ("稂" . "강아지 풀 랑")
     ("莨" . "수크령 랑")
     ("蜋" . "사마귀 랑")
     ("郎" . "남편 랑")
     ("閬" . "솟을 대문 랑"))
    ("래"
     ("來" . "올 래")
     ("崍" . "산 이름 래")
     ("徠" . "올 래")
     ("萊" . "명아주 래")
     ("儽" . "게으를 래")
     ("勑" . "위로할 래")
     ("淶" . "강 이름 래")
     ("莱" . "명아주 래")
     ("騋" . "큰 말 래")
     ("黧" . "검을 래"))
    ("랭"
     ("冷" . "찰 랭"))
    ("략"
     ("掠" . "노략질할 략")
     ("略" . "다스릴 략")
     ("剠" . "鯨과 同字")
     ("畧" . "略과 同字"))
    ("량"
     ("亮" . "밝을 량")
     ("倆" . "재주 량")
     ("兩" . "두 량")
     ("凉" . "涼의 俗字")
     ("掠" . "볼기칠 량")
     ("梁" . "푸조나무 량")
     ("樑" . "서늘할 량")
     ("粮" . "糧과 同字")
     ("粱" . "기장 량")
     ("糧" . "양식 량")
     ("良" . "좋을 량")
     ("諒" . "믿을 량")
     ("輛" . "수레 량")
     ("量" . "헤아릴 량")
     ("両" . "兩의 俗字")
     ("两" . "쌍 량")
     ("俍" . "良과 同字")
     ("剠" . "鯨과 同字")
     ("喨" . "소리 맑을 량")
     ("悢" . "슬퍼할 량")
     ("椋" . "들보 량")
     ("涼" . "서늘할 량")
     ("踉" . "뛸 량")
     ("魎" . "도깨비 량"))
    ("레"
     "螺")
    ("려"
     ("侶" . "짝 려")
     ("儷" . "짝 려")
     ("勵" . "힘쓸 려")
     ("呂" . "음률 려")
     ("廬" . "오두막집 려")
     ("慮" . "생각할 려")
     ("戾" . "여그러질 려")
     ("旅" . "군사 려")
     ("櫚" . "종려나무 려")
     ("濾" . "겨를 려")
     ("礪" . "거친 숫돌 려")
     ("藜" . "나라 이름 려")
     ("蠣" . "굴 려")
     ("閭" . "이문 려")
     ("驢" . "나귀 려")
     ("驪" . "가라말 려")
     ("麗" . "고울 려")
     ("黎" . "검을 려")
     ("侣" . "侶와 同字")
     ("儢" . "맘에 하기 싫을 려")
     "刕"
     ("励" . "勵의 略字")
     ("勴" . "마음으로 도울 려")
     ("厉" . "厲의 略字")
     ("厲" . "갈 려")
     ("吕" . "呂와 同字")
     ("唳" . "울 려")
     ("戻" . "수레 옆문 려")
     "攊"
     ("梠" . "평고대 려")
     ("癘" . "창질 려")
     ("砺" . "礪의 略字")
     ("糲" . "현미 려")
     ("膂" . "등골 뼈 려")
     ("臚" . "살갗 려")
     ("蠡" . "좀먹을 려")
     ("邌" . "천천히 걸을 려")
     ("鑢" . "줄 려")
     ("鱺" . "뱀장어 려")
     ("黧" . "검을 려"))
    ("력"
     ("力" . "힘 력")
     ("曆" . "책력 력")
     ("歷" . "지낼 력")
     ("瀝" . "거를 력")
     ("礫" . "조약돌 력")
     ("轢" . "삐걱거릴 력")
     ("靂" . "벼락 력")
     ("厤" . "다스릴 력")
     ("嚦" . "소리 력")
     ("櫟" . "상수리나무 력")
     ("櫪" . "말구유 력")
     ("癧" . "연주창 력")
     ("躒" . "움직일 력")
     ("轣" . "갈 력")
     ("酈" . "땅 이름 력"))
    ("련"
     ("怜" . "연리할 련")
     ("憐" . "불쌍히 여길 련")
     ("戀" . "사모할 련")
     ("攣" . "걸릴 련")
     ("漣" . "물놀이 련")
     ("煉" . "불릴 련")
     ("璉" . "호련 련")
     ("練" . "익힐 련")
     ("聯" . "잇달 련")
     ("蓮" . "연밥 련")
     ("輦" . "손수레 련")
     ("連" . "잇닿을 련")
     ("鍊" . "불릴 련")
     ("零" . "조용히 오는 비 련")
     ("零" . "조용히 오는 비 련")
     ("僆" . "쌍둥이 련")
     ("嗹" . "길게 말할 련")
     ("孌" . "아름다울 련")
     ("恋" . "戀의 俗字")
     "挒"
     ("楝" . "멀구슬나무 련")
     ("湅" . "누일 련")
     ("聫" . "聮과 同字")
     ("聮" . "연할 련")
     ("臠" . "저민고기 련")
     "錬"
     ("鏈" . "쇠사슬 련")
     ("鰊" . "고기 이름 련")
     ("鰱" . "연어 련"))
    ("렬"
     ("冽" . "찰 렬")
     ("列" . "줄 렬")
     ("劣" . "못할 렬")
     ("戾" . "어그러질 렬, 휘어질 렬")
     ("洌" . "맑을 렬")
     ("烈" . "세찰 렬")
     ("裂" . "찢을 렬")
     ("咧" . "새소리 렬")
     ("哷" . "닭 우는 소리 렬")
     "戻"
     ("捩" . "비틀 렬")
     ("颲" . "사나운 바람 렬"))
    ("렴"
     ("廉" . "청렴할 렴")
     ("斂" . "거둘 렴")
     ("殮" . "염할 렴")
     ("濂" . "내 이름 렴")
     ("簾" . "발 렴")
     ("亷" . "廉과 同字")
     ("匲" . "경대 렴")
     ("匳" . "경대 렴")
     ("奩" . "화장 상자 렴")
     ("帘" . "주막기 렴")
     ("瀲" . "넘칠 렴")
     ("磏" . "거친 숫돌 렴"))
    ("렵"
     ("獵" . "사냥 렵")
     ("儠" . "풍신 좃을 렵")
     ("躐" . "밟을 렵")
     ("鬣" . "갈기 렵"))
    ("령"
     ("令" . "명령 령, 시킬 령")
     ("伶" . "영리할 령, 악공 령, 광대 령")
     ("囹" . "옥 령")
     ("岺" . "재 령")
     ("嶺" . "재 령")
     ("怜" . "영리할 령")
     ("玲" . "옥이름 령")
     ("笭" . "도꼬마리 령")
     ("羚" . "영양 령")
     ("翎" . "깃 령")
     ("聆" . "들을 령")
     ("逞" . "굳셀 령")
     ("鈴" . "방울 령")
     ("零" . "조용히 오는 비 령")
     ("靈" . "신령 령")
     ("領" . "옷깃 령")
     ("齡" . "나이 령")
     ("寧" . "편안할 령")
     ("另" . "나눌 령, 다를 령, 헤어질 령")
     ("呤" . "속삭일 령")
     ("呬" . "왁자할 령")
     ("姈" . "계집 슬기로울 령")
     ("岭" . "산 이름 령")
     ("昤" . "날 빛 영롱할 령")
     ("欞" . "격자창 령")
     ("泠" . "깨우칠 령")
     ("灵" . "靈의 俗字")
     ("秢" . "벼 처음 익을 령")
     ("苓" . "도꼬마리 령")
     ("蛉" . "장자리 령")
     ("軨" . "사냥 수레 령")
     ("鴒" . "할미새 령")
     ("鹷" . "나이 령"))
    ("례"
     ("例" . "법식 례")
     ("澧" . "강 이름 례")
     ("禮" . "예도 례")
     ("豊" . "禮의 古字")
     ("醴" . "단술 례")
     ("隷" . "隸와 同字")
     ("劙" . "가를 례")
     ("礼" . "禮의 古字")
     ("隸" . "붙을 례")
     ("鱧" . "가물치 례")
     ("礼" . "禮의 略字"))
    ("로"
     ("勞" . "일할 로")
     ("撈" . "잡을 로")
     ("擄" . "사로잡을 로")
     ("櫓" . "방패 로")
     ("潞" . "강 이름 로")
     ("瀘" . "강 이름 로")
     ("爐" . "화로 로")
     ("牢" . "우리 로")
     ("盧" . "밥그릇 로")
     ("老" . "늙은이 로")
     ("蘆" . "갈대 로")
     ("虜" . "포로 로")
     ("賂" . "뇌물 줄 로")
     ("路" . "길 로")
     ("輅" . "수레 로")
     ("露" . "이슬 로")
     ("魯" . "노둔할 로")
     ("鷺" . "해오라기 로")
     ("鹵" . "소금 로")
     ("怒" . "성냉 로")
     ("労" . "勞의 略字")
     ("哰" . "말 알아듣지 못할 로")
     ("嚕" . "아까워할 로")
     ("嚧" . "웃을 로")
     ("壚" . "흑토 로")
     ("滷" . "소금밭 로")
     ("炉" . "爐의 略字")
     ("玈" . "검을 로")
     ("癆" . "종독 로")
     ("窂" . "우리 로")
     ("艪" . "艫와 同字")
     ("艫" . "뱃머리 로")
     ("轤" . "고패 로")
     ("鐪" . "부레 로")
     ("鑪" . "화로 로")
     ("顱" . "머리뼈 로")
     ("髗" . "해골 로")
     ("鱸" . "농어 로")
     ("鸕" . "가마우지 로"))
    ("록"
     ("碌" . "돌 모양 록")
     ("祿" . "복 록")
     ("綠" . "초록빛 록")
     ("菉" . "조개풀 록")
     ("角" . "신선이름 록, 사람이름 록")
     ("錄" . "기록할 록")
     ("鹿" . "사슴 록")
     ("麓" . "신기슭 록")
     ("圥" . "버섯 록")
     ("彔" . "나무 깍을 록")
     ("淥" . "밭을 록")
     ("渌" . "淥의 略字")
     ("漉" . "거를 록")
     ("簏" . "대 상자 록")
     ("緑" . "綠의 略字")
     ("轆" . "도르래 록")
     ("録" . "희학질할 록")
     ("騄" . "말이름 록"))
    ("론"
     ("淪" . "기운덩어리 론")
     ("論" . "말할 론"))
    ("롱"
     ("壟" . "언덕 롱")
     ("弄" . "희롱할 롱")
     ("朧" . "흐릿할 롱")
     ("籠" . "대그릇 롱")
     ("聾" . "귀머거리 롱")
     ("龍" . "언덕 롱")
     ("儱" . "건목칠 롱")
     ("哢" . "지저귈 롱")
     ("嚨" . "목구멍 롱")
     ("攂" . "攏의 本字")
     ("攏" . "누를 롱")
     ("曨" . "어스레할 롱")
     ("礱" . "갈 롱")
     ("篭" . "籠과 同字")
     ("蘢" . "개여뀌 롱")
     ("隴" . "고개 이름 롱")
     ("龎" . "충실할 롱 (龐의 俗字)"))
    ("뢰"
     ("儡" . "영락할 뢰")
     ("瀨" . "여울 뢰")
     ("牢" . "우리 뢰")
     ("磊" . "돌무더기 뢰")
     ("賂" . "뇌물 줄 뢰")
     ("賚" . "줄 뢰")
     ("賴" . "힘 입을 뢰")
     ("雷" . "우뢰 뢰")
     ("瀬" . "여울 뢰")
     ("礌" . "돌 굴러내릴 뢰")
     ("礧" . "바위너설 뢰")
     ("籟" . "세 구멍 퉁소 뢰")
     ("纇" . "실 마디 뢰")
     ("罍" . "술독 뢰")
     ("耒" . "쟁기 뢰")
     ("蕾" . "꽃봉오리 뢰")
     ("誄" . "뇌사 뢰")
     ("酹" . "부을 뢰")
     ("頼" . "賴의 俗字")
     ("顂" . "덮을 뢰"))
    ("료"
     ("了" . "마칠 료")
     ("僚" . "동료 료")
     ("寥" . "쓸쓸할 료")
     ("寮" . "벼슬아쳐 료")
     ("廖" . "공허할 료")
     ("料" . "되질할 료")
     ("燎" . "화톳불 료")
     ("療" . "병고칠 료")
     ("瞭" . "밝을 료")
     ("聊" . "귀 울 료")
     ("蓼" . "여뀌 료")
     ("遼" . "멀 료")
     ("鬧" . "시끄러울 료")
     ("嘹" . "울 료")
     ("嫽" . "외조모 료")
     ("撩" . "다스릴 료")
     ("暸" . "밝을 료")
     ("潦" . "큰 비 료")
     ("獠" . "밤사냥 료")
     ("繚" . "감길 료")
     ("膋" . "발기름 료")
     ("醪" . "막걸리 료")
     ("鐐" . "은 료")
     ("飂" . "높이 부는 바람 료")
     ("飉" . "바람 료"))
    ("룡"
     ("瀧" . "비 올 룡")
     ("瓏" . "옥소리 룡")
     ("龍" . "용 룡")
     ("竜" . "龍의 古字")
     ("龒" . "龍의 古字"))
    ("루"
     ("壘" . "진 루")
     ("婁" . "별 이름 루")
     ("屢" . "창 루")
     ("樓" . "다락 루")
     ("淚" . "눈물 루")
     ("漏" . "샐 루")
     ("瘻" . "부스럼 루")
     ("累" . "묶을 루")
     ("縷" . "실 루")
     ("蔞" . "쑥 루")
     ("褸" . "남루할 루")
     ("鏤" . "새길 루")
     ("陋" . "줍을 루")
     ("僂" . "구부릴 루")
     ("嘍" . "시끄러울 루")
     ("嶁" . "봉우리 루")
     ("慺" . "정성스러울 루")
     ("楼" . "樓의 俗字")
     ("涙" . "淚와 同字")
     ("耬" . "씨 뿌리는 기구 루")
     ("螻" . "땅강아지 루")
     ("髏" . "해굴 루"))
    ("뤼"
     ("厽" . "흙을 쌓아서 담 쌓을 뤼"))
    ("류"
     ("劉" . "죽일 류")
     ("旒" . "깃발 류")
     ("柳" . "버들 류")
     ("榴" . "석류나무 류")
     ("流" . "흐를 류")
     ("溜" . "방울져 떨어질 류")
     ("瀏" . "맑을 류")
     ("琉" . "유리 류")
     ("瑠" . "琉와 同字")
     ("留" . "머무를 류")
     ("瘤" . "혹 류")
     ("硫" . "유황 류")
     ("謬" . "그릇될 류")
     ("類" . "무리 류")
     ("刘" . "劉의 略字")
     ("嚠" . "瀏와 同字")
     ("橊" . "榴의 本字")
     ("类" . "나눌 류")
     ("縲" . "포승 류")
     ("纍" . "갇힐 류")
     ("遛" . "머무를 류")
     ("鎏" . "급속 류")
     ("鶹" . "올빼미 류"))
    ("륙"
     ("六" . "여섯 륙")
     ("戮" . "죽일 륙")
     ("陸" . "뭍 륙")
     ("僇" . "욕보일 륙")
     ("剹" . "깎을 륙")
     ("勠" . "협력할 륙"))
    ("륜"
     ("侖" . "둥글 륜")
     ("倫" . "인륜 륜")
     ("崙" . "산 이름 륜")
     ("淪" . "물놀이 륜")
     ("潤" . "젖을 륜")
     ("綸" . "낚싯줄 륜")
     ("輪" . "바퀴 륜")
     ("閏" . "윤달 륜")
     ("嗧" . "갤런 륜")
     ("圇" . "완전할 륜")
     ("掄" . "가릴 륜"))
    ("률"
     ("律" . "법 률")
     ("慄" . "두려워할 률")
     ("栗" . "밤나무 률")
     ("率" . "거느릴 률")
     ("率" . "헤아릴 률")
     ("嵂" . "가파를 률")
     ("溧" . "강 이름 률")
     ("篥" . "대 이름 률"))
    ("륭"
     ("隆" . "클 륭")
     ("癃" . "느른할 륭")
     ("窿" . "활꼴 륭"))
    ("륵"
     ("勒" . "굴레 륵")
     ("肋" . "갈비 륵")
     ("仂" . "나머지 륵")
     ("嘞" . "어조사 륵")
     ("泐" . "돌 갈라질 륵")
     ("鰳" . "준치 륵"))
    ("름"
     ("凜" . "찰 름")
     ("凛" . "찰 름")
     ("廩" . "곳집 름")
     ("澟" . "서늘할 름"))
    ("릉"
     ("凌" . "능가할 릉")
     ("楞" . "모 릉")
     ("稜" . "모 릉")
     ("綾" . "비단 릉")
     ("菱" . "蔆과 同字")
     ("陵" . "큰 언덕 릉")
     ("倰" . "속일 릉")
     ("蔆" . "마름 릉")
     ("鯪" . "천산갑 릉"))
    ("리"
     ("俚" . "속될 리")
     ("利" . "날카로울 리")
     ("厘" . "釐의 俗字")
     ("吏" . "벼슬아치 리")
     ("唎" . "가는 소리 리")
     ("履" . "신 리")
     ("悧" . "영리할 리")
     ("李" . "오얏 리")
     ("梨" . "태나무 리")
     ("浬" . "해리 리")
     ("犁" . "얼룩소 리")
     ("狸" . "貍와 同字")
     ("理" . "다스릴 리")
     ("璃" . "유리 리")
     ("痢" . "설사 리")
     ("籬" . "울타리 리")
     ("罹" . "근심 리")
     ("羸" . "여윌 리")
     ("莉" . "말리 리")
     ("裏" . "속 리")
     ("裡" . "裏와 同字")
     ("里" . "마을 리")
     ("釐" . "다스릴 리")
     ("離" . "떼 놓을 리")
     ("鯉" . "잉어 리")
     ("麗" . "고울 리")
     ("異" . "다를 리")
     ("俐" . "똑똑할 리")
     ("刕" . "벨 리")
     ("剓" . "뱃길 리")
     ("剺" . "벗길 리")
     ("劙" . "가를 리")
     ("哩" . "어조사 리")
     ("嫠" . "과부 리")
     ("涖" . "다다를 리")
     ("漓" . "스며들 리")
     ("离" . "산신 리")
     ("莅" . "다다를 리")
     ("蒞" . "莅의 俗字")
     ("蜊" . "참조개 리")
     ("螭" . "교륭 리")
     ("貍" . "삵 리")
     ("邐" . "이어질 리")
     ("魑" . "도깨비 리")
     ("鱺" . "뱀장어 리")
     ("黐" . "끈끈이 리")
     ("黧" . "검을 리"))
    ("린"
     ("吝" . "아낄 린")
     ("潾" . "맑을 린")
     ("燐" . "도깨비불 린")
     ("璘" . "옥빛 린")
     ("藺" . "골풀 린")
     ("躪" . "짓밟을 린")
     ("隣" . "鄰의 俗字")
     ("鱗" . "비늘 린")
     ("麟" . "기린 린")
     ("厸" . "鄰의 古字")
     ("嶙" . "가파를 린")
     ("悋" . "아낄 린")
     ("獜" . "튼튼할 린")
     ("磷" . "돌 을 틈물이 흐르는 모양 린")
     ("粦" . "도깨비 불 린")
     ("粼" . "물 맑을 린")
     ("繗" . "이을 린")
     ("躙" . "짓밟을 린")
     ("轔" . "수레 소리 린")
     ("鄰" . "이웃 린")
     ("鏻" . "굳셀 린")
     ("驎" . "워라말 린"))
    ("림"
     ("林" . "수풀 림")
     ("淋" . "물뿌릴 림")
     ("琳" . "아름다운 옥 림")
     ("臨" . "임할 림")
     ("霖" . "장마 림")
     ("痳" . "임질 림"))
    ("립"
     ("砬" . "돌 소리 립")
     ("立" . "설 립")
     ("笠" . "우리 립")
     ("粒" . "알 립")
     ("岦" . "산 우뚝할 립"))
    ("마"
     ("摩" . "갈 마")
     ("瑪" . "마노 마")
     ("痲" . "저릴 마")
     ("碼" . "마노 마")
     ("磨" . "갈 마")
     ("馬" . "말 마")
     ("魔" . "마귀 마")
     ("麻" . "삼 마")
     ("亇" . "망치 마")
     ("亍" . "땅 이름 마")
     ("傌" . "욕할 마")
     ("劘" . "깍을 마")
     ("哶" . "양울 마")
     ("嗎" . "꾸짖을 마")
     ("嘛" . "나마 마")
     ("媽" . "어미 마")
     ("螞" . "말거머리 마")
     ("蟇" . "개구리 마")
     ("麼" . "작을 마")
     ("麽" . "잘 마")
     ("麿" . "갈 마"))
    ("막"
     ("寞" . "쓸쓸할 막")
     ("幕" . "막 막")
     ("漠" . "사막 막")
     ("膜" . "막 막")
     ("莫" . "없을 막")
     ("貌" . "모뜰 막")
     ("邈" . "멀 막")
     ("嗼" . "고요할 막")
     ("瞙" . "눈 흐릴 막")
     ("鏌" . "칼 이름 막"))
    ("만"
     ("万" . "일만 만")
     ("卍" . "만자 만")
     ("娩" . "해산할 만")
     ("巒" . "뫼 만")
     ("彎" . "굽을 만")
     ("慢" . "게으를 만")
     ("挽" . "당길 만")
     ("晩" . "저물 만")
     ("曼" . "끌 만")
     ("滿" . "찰 만")
     ("漫" . "질펀할 만")
     ("灣" . "물굽이 만")
     ("瞞" . "속일 만")
     ("萬" . "일만 만")
     ("蔓" . "덩굴 만")
     ("蠻" . "오랑캐 만")
     ("輓" . "끌 만")
     ("饅" . "만두 만")
     ("鰻" . "뱀장어 만")
     ("僈" . "얕볼 만")
     ("卐" . "卍과 同字")
     ("墁" . "흙손 만")
     ("嫚" . "업신여길 만")
     ("幔" . "막 만")
     ("晚" . "저물 만")
     ("縵" . "무늬 없는 비단 만")
     ("蛮" . "蠻의 略字")
     ("謾" . "속일 만")
     ("蹣" . "비틀거릴 만")
     ("鏋" . "금 만")
     ("鏝" . "흙손 만")
     ("鞔" . "신울 만")
     ("鬘" . "머리장식 만"))
    ("말"
     ("唜" . "끌 말")
     ("抹" . "바랄 말")
     ("末" . "끝 말")
     ("沫" . "거품 말")
     ("茉" . "말리 말")
     ("襪" . "버선 말")
     ("靺" . "버선 말")
     ("帕" . "머리띠 말")
     ("秣" . "꼴 말"))
    ("망"
     ("亡" . "망할 망")
     ("妄" . "허망할 망")
     ("孟" . "맹랑할 망")
     ("忘" . "잊을 망")
     ("忙" . "바쁠 망")
     ("望" . "바랄 망")
     ("網" . "그물 망")
     ("罔" . "그물 망")
     ("芒" . "까끄라기 망")
     ("茫" . "아득할 망")
     ("莽" . "우거질 망")
     ("輞" . "바퀴테 망")
     ("邙" . "산 이름 망")
     ("亾" . "兦과 同字")
     ("兦" . "亡의 本字")
     ("惘" . "멍할 망")
     ("汒" . "황급할 망")
     ("漭" . "넓을 망")
     ("莾" . "마디 짧은 대 망")
     ("蟒" . "이무기 망")
     ("魍" . "도깨비 망"))
    ("매"
     ("埋" . "묻을 매")
     ("妹" . "누이 매")
     ("媒" . "중매 매")
     ("寐" . "잠잘 매")
     ("昧" . "새벽 매")
     ("枚" . "줄기 매")
     ("某" . "매화나무 매")
     ("梅" . "매화나무 매")
     ("每" . "매양 매")
     ("煤" . "그을음 매")
     ("罵" . "욕할 매")
     ("買" . "살 매")
     ("賣" . "팔 매")
     ("邁" . "갈 매")
     ("魅" . "도깨비 매")
     ("勱" . "힘쓸 매")
     ("呅" . "웃을 매")
     ("呆" . "어리석을 매")
     ("嚜" . "거짓말할 매")
     ("売" . "賣의 略字")
     ("楳" . "梅의 古字")
     ("毎" . "每의 略字")
     ("沬" . "지명 매")
     ("玫" . "매괴 매")
     ("眛" . "어두울 매")
     ("苺" . "딸기 매")
     ("莓" . "나무딸기 매")
     ("酶" . "술밑 매")
     ("霉" . "매우 매")
     ("霾" . "흙비 올 매"))
    ("맥"
     ("百" . "힘쓸 맥")
     ("脈" . "맥 맥")
     ("貊" . "북방 종족 맥")
     ("陌" . "두렁 맥")
     ("驀" . "말탈 맥")
     ("麥" . "보리 맥")
     ("脉" . "脈의 古字")
     ("貃" . "오랑캐 맥")
     ("貘" . "짐승 이름 맥")
     ("麦" . "麥의 俗字"))
    ("맹"
     ("孟" . "맏 맹")
     ("氓" . "백성 맹")
     ("猛" . "사나울 맹")
     ("盟" . "맹세할 맹")
     ("盲" . "소경 맹")
     ("萌" . "싹 맹"))
    ("먀"
     ("乜" . "사팔 뜨기 먀"))
    ("멍"
     "儚"
     "甍"
     "甿"
     "虻")
    ("며"
     ("旀" . "하며 며"))
    ("멱"
     ("冪" . "덮을 멱")
     ("汨" . "물이름 멱")
     ("覓" . "찾을 멱")
     ("冖" . "덮을 멱")
     ("幎" . "덮을 멱"))
    ("면"
     ("免" . "면할 면")
     ("冕" . "면류관 면")
     ("勉" . "힘쓸 면")
     ("棉" . "목화 면")
     ("沔" . "물 흐를 면")
     ("眄" . "애꾸눈 면")
     ("眠" . "잠잘 면")
     ("瞑" . "눈 감을 면")
     ("綿" . "이어질 면")
     ("緬" . "가는 실 면")
     ("面" . "낯 면")
     ("麵" . "麪의 俗字")
     ("丏" . "가릴 면")
     ("俛" . "힘쓸 면")
     ("偭" . "향할 면")
     ("湎" . "빠질 면")
     ("糆" . "麪과 同字")
     ("緜" . "햇솜 면")
     ("麪" . "밀가루 면")
     ("麺" . "麵의 簡體字"))
    ("멸"
     ("滅" . "멸망할 멸")
     ("蔑" . "업신여길 멸")
     ("篾" . "대 껍질 멸")
     ("衊" . "모독할 멸"))
    ("명"
     ("冥" . "어두울 명")
     ("名" . "이름 명")
     ("命" . "목숨 명")
     ("明" . "밝을 명")
     ("暝" . "어두울 명")
     ("椧" . "홈 통 명")
     ("溟" . "어두울 명")
     ("皿" . "그릇 명")
     ("瞑" . "눈 감을 명")
     ("茗" . "차 싹 명")
     ("蓂" . "명협 명")
     ("螟" . "마디충 명")
     ("酩" . "술 취할 명")
     ("銘" . "새길 명")
     ("鳴" . "울 명")
     ("洺" . "강 이름 명"))
    ("몌"
     ("袂" . "소매 몌"))
    ("모"
     ("侮" . "업신여길 모")
     ("冒" . "가릴 모")
     ("募" . "모을 모")
     ("姆" . "여스승 모")
     ("帽" . "모자 모")
     ("慕" . "그리워할 모")
     ("摸" . "찾을 모")
     ("摹" . "베낄 모")
     ("暮" . "저물 모")
     ("木" . "나무에 서화를 새길 모, 목각활자 모")
     ("某" . "아무 모")
     ("模" . "법 모")
     ("母" . "어미 모")
     ("毛" . "털 모")
     ("牟" . "소 우는 소리 모")
     ("牡" . "수컷 모")
     ("瑁" . "서옥 모")
     ("眸" . "눈동자 모")
     ("矛" . "창 모")
     ("耗" . "줄 모")
     ("膜" . "무릎 꿇을 모")
     ("芼" . "풀 우거질 모")
     ("茅" . "띠 모")
     ("莫" . "저물 모")
     ("謀" . "꾀할 모")
     ("謨" . "꾀 모")
     ("貌" . "얼굴 모")
     ("侔" . "가지런 할 모")
     ("冃" . "어린이 머리 건 모")
     ("冐" . "冒의 俗字")
     ("姥" . "할미 모")
     ("媢" . "강새암 할 모")
     ("嫫" . "예쁠 모")
     ("恈" . "탐할 모")
     ("旄" . "깃대 장식 모")
     ("皃" . "貌와 同字")
     ("眊" . "눈 흐릴 모")
     ("粍" . "밀리메트로 모")
     ("糢" . "模의 俗字")
     ("耄" . "늙은이 모")
     ("蝥" . "해충 모")
     ("蟊" . "蝥와 同字")
     ("鉾" . "칼 끝 모")
     ("髦" . "다팔머리 모")
     ("麰" . "보리 모"))
    ("목"
     ("冒" . "무릅쓸 목")
     ("匹" . "집 오리 목")
     ("木" . "나무 목")
     ("沐" . "머리감을 목")
     ("牧" . "칠 목")
     ("目" . "눈 목")
     ("睦" . "화목할 목")
     ("穆" . "화목할 목")
     ("鶩" . "집오리 목")
     ("凩" . "찬바람 목")
     ("苜" . "거여목 목"))
    ("몰"
     ("勿" . "없을 몰")
     ("歿" . "죽을 몰")
     ("沒" . "가라 앉을 몰")
     ("殁" . "歿의 俗字"))
    ("몽"
     ("夢" . "꿈 몽")
     ("朦" . "풍부할 몽")
     ("蒙" . "입을 몽")
     ("冡" . "덮어쓸 몽")
     ("幪" . "덮을 몽")
     ("懞" . "어두울 몽")
     ("曚" . "어두울 몽")
     ("溕" . "가랑비 몽, 이슬비 몽")
     ("濛" . "비 부슬부슬 올 몽, 기운덩어리 몽")
     ("瞢" . "어두울 몽")
     ("矇" . "소경 몽")
     ("艨" . "싸움배 몽")
     ("雺" . "안개 몽")
     ("鸏" . "비둘기 몽"))
    ("묘"
     ("卯" . "토끼 묘")
     ("墓" . "무덤 묘")
     ("妙" . "묘할 묘")
     ("廟" . "사당 묘")
     ("描" . "그릴 묘")
     ("昴" . "별자리 이름 묘")
     ("杳" . "어두울 묘")
     ("渺" . "아득할 묘")
     ("猫" . "고양이 묘")
     ("秒" . "까끄라기 묘")
     ("竗" . "땅 이름 묘")
     ("苗" . "모 묘")
     ("錨" . "닻 묘")
     ("吵" . "지저귈 묘")
     ("淼" . "물 아득할 묘")
     ("眇" . "애꾸눈 묘")
     ("緲" . "아득할 묘")
     ("藐" . "작을 묘")
     ("貓" . "猫와 同字"))
    ("무"
     ("亡" . "없을 무")
     ("務" . "일 무, 힘쓸 무, 권장할 무")
     ("巫" . "무당 무, 산 이름 무")
     ("憮" . "어루만질 무, 애무할 무")
     ("懋" . "힘쓸 무, 노력할 무")
     ("戊" . "다섯째 천간 무, 무성할 무")
     ("拇" . "엄지손가락 무")
     ("撫" . "어루만질 무, 누를 무")
     ("无" . "없을 무")
     ("楙" . "무성할 무, 아름다울 무")
     ("武" . "굳셀 무, 자만할 무, 군인 무")
     ("毋" . "말 무")
     ("無" . "없을 무")
     ("珷" . "옥돌 무")
     ("畝" . "이랑 무")
     ("繆" . "묶을 무, 얽을 무, 삼 무")
     ("舞" . "춤출 무")
     ("茂" . "우거질 무, 무성할 무")
     ("蕪" . "거칠어질 무, 거친풀 무")
     ("誣" . "무고할 무, 깔볼 무")
     ("謬" . "그릇될 무, 어지러울 무, 속일 무, 망령되게 말할 무")
     ("貿" . "바꿀 무, 물건 살 무")
     ("霧" . "안개 무, 어두울 무")
     ("鵡" . "앵무새 무")
     ("亾" . "兦와 同字")
     ("儛" . "舞와 同字")
     ("兦" . "亡의 本字")
     ("嘸" . "분명하지 않을 무, 모호한 모양 무")
     ("廡" . "집 무, 처마 무, 지붕 무")
     ("畮" . "畝의 正字")
     ("膴" . "포 무, 크게 저민 고기 무")
     ("袤" . "길이 무")
     ("鍪" . "투구 무, 가마 무")
     ("騖" . "달릴 무, 질주할 무"))
    ("묵"
     ("万" . "성씨 묵")
     ("墨" . "먹 묵, 형벌 이름 묵")
     ("默" . "묵묵할 묵, 고요할 묵")
     ("嘿" . "고요할 묵, 말 아니할 묵")
     ("嚜" . "거짓 묵, 불만스러운 모양 묵"))
    ("문"
     ("們" . "들 문, 무리 문")
     ("免" . "해산할 문, 통건 쓸 문")
     ("刎" . "목 벨 문, 자를 문, 끊을 문")
     ("吻" . "입술 문, 입가 문")
     ("問" . "물을 문, 알릴 문")
     ("文" . "무늬 문, 얼룩 문")
     ("汶" . "내 이름 문, 수치 문")
     ("紊" . "어지러울 문")
     ("紋" . "무늬 문, 주름 문")
     ("聞" . "들을 문")
     ("蚊" . "모기 문")
     ("門" . "문 문")
     ("雯" . "구름 무늬 문")
     ("亹" . "땅이름 문")
     ("勽" . "덮을 문")
     ("匁" . "몸메 문")
     ("呅" . "웃을 문")
     ("悗" . "잊어버릴 문")
     ("懣" . "번거로울 문")
     ("抆" . "닦을 문, 문지를 문")
     ("捫" . "어루만질 문, 쓰다듬을 문")
     ("炆" . "따뜻할 문")
     ("璊" . "붉은 옥 문"))
    ("물"
     ("勿" . "말 물, 아닐 물, 깃발 물")
     ("沕" . "아득할 물, 숨길 물")
     ("物" . "만물 물, 무리 물"))
    ("미"
     ("味" . "맛 미, 뜻 미")
     ("媚" . "아첨할 미, 풍치가 아름다울 미")
     ("尾" . "꼬리 미, 등 미")
     ("嵋" . "산이름 미")
     ("彌" . "두루 미, 널리 미")
     ("微" . "작을 미, 자질구레할 미")
     ("未" . "아닐 미")
     ("梶" . "나무 끝 미")
     ("楣" . "문미 미, 처마 미")
     ("渼" . "물놀이 미, 내 이름 미")
     ("湄" . "물 가 미, 더운 물 미")
     ("眉" . "눈썹 미, 노인 미")
     ("米" . "쌀 미")
     ("美" . "아름다울 미, 맛이 좋을 미")
     ("薇" . "고삐 미")
     ("謎" . "수수께끼 미")
     ("迷" . "미혹할 미, 전념할 미")
     ("靡" . "쓰러질 미, 쏠릴 미")
     ("黴" . "곰팡이 미, 검을 미, 썪을 미")
     ("亹" . "힘쓸 미, 문채가 있는 모양 미")
     ("侎" . "어루만질 미")
     ("冞" . "점점 미, 두루 다닐 미")
     ("咩" . "양 울 미")
     ("咪" . "咩와 同字")
     ("娓" . "장황할 미, 힘쓸 미")
     ("媄" . "빛 고울 미")
     ("媺" . "착하고 아름다울 미")
     ("弥" . "彌와 同字")
     ("弭" . "활고자 미, 그칠 미")
     ("敉" . "어루만질 미")
     ("瀰" . "물 넓을 미")
     ("獼" . "원숭이 미")
     ("糜" . "죽 미, 싸라기 미")
     ("縻" . "고삐 미, 얽어맬 미")
     ("羋" . "양 울 미")
     ("芈" . "양이 울 미, 성씨 미")
     ("苿" . "味와 同字")
     ("菋" . "오미자 미")
     ("蘼" . "장미 미, 천궁 미")
     ("麋" . "큰사슴 미, 부서질 미"))
    ("민"
     ("岷" . "산이름 민")
     ("悶" . "번민할 민")
     ("愍" . "근심할 민")
     ("憫" . "불쌍히 여길 민")
     ("敏" . "민첩할 민")
     ("旻" . "하늘 민")
     ("旼" . "온화할 민")
     ("民" . "백성 민")
     ("泯" . "망할 민")
     ("玟" . "옥돌 민")
     ("珉" . "아름다운돌 민")
     ("緡" . "낚시줄 민")
     ("閔" . "위문할 민")
     ("僶" . "어거지로 할 민")
     ("勔" . "권면할 민, 힘쓸 민")
     ("忞" . "강인할 민")
     ("忟" . "강인할 민")
     ("暋" . "굳셀 민")
     ("湣" . "낚시줄 민")
     ("緍" . "낚시줄 민")
     ("罠" . "그물 민")
     ("苠" . "속대 민")
     ("閩" . "종족이름 민")
     ("鰵" . "대구 민")
     ("黽" . "힘쓸 민"))
    ("밀"
     ("密" . "빽빽할 밀")
     ("蜜" . "꿀 밀")
     ("謐" . "고요할 밀")
     ("宻" . "密의 俗字")
     ("樒" . "침향 밀")
     ("滵" . "물 흐르는 모양 밀"))
    ("박"
     ("剝" . "벗길 박")
     ("博" . "넓을 박")
     ("拍" . "칠 박")
     ("搏" . "칠 박")
     ("撲" . "업어질 박")
     ("朴" . "나무껍질 박")
     ("樸" . "통나무 박")
     ("泊" . "머무를 박")
     ("溥" . "빽빽할 박")
     ("爆" . "지질 박")
     ("珀" . "호박 박")
     ("璞" . "옥덩어리 박")
     ("箔" . "발 박")
     ("簿" . "잠박 박")
     ("粕" . "지게미 박")
     ("縛" . "묶을 박")
     ("膊" . "포 박")
     ("舶" . "배 박")
     ("薄" . "숲 박")
     ("迫" . "닥칠 박")
     ("雹" . "누리 박")
     ("駁" . "얼룩말 박")
     ("亳" . "땅이름 박")
     ("剥" . "剝의 略字")
     ("嚗" . "역정낼 박, 지팡이 던지는 소리 박")
     ("欂" . "주두 박")
     ("牔" . "박공 박")
     ("趵" . "차는 소리 박")
     ("鉑" . "금박 박")
     ("鎛" . "종 박")
     ("駮" . "짐승이름 박")
     ("髆" . "어깨쭉지 박"))
    ("반"
     ("伴" . "짝 반")
     ("半" . "반 반")
     ("反" . "돌이킬 반")
     ("叛" . "배반할 반")
     ("弁" . "즐거워할 반")
     ("扮" . "꾸밀 반")
     ("拌" . "버릴 반")
     ("搬" . "옮길 반")
     ("攀" . "더위잡을 반")
     ("斑" . "얼룩 반")
     ("槃" . "쟁반 반")
     ("泮" . "학교 반")
     ("潘" . "뜨물 반")
     ("班" . "나눌 반")
     ("畔" . "지경 반")
     ("番" . "갈아치울 반, 차례 반, 땅이름 반")
     ("瘢" . "흉터 반")
     ("盤" . "소반 반")
     ("盼" . "곁눈질 할 반")
     ("磐" . "넓을 반")
     ("磻" . "강이름 반")
     ("礬" . "명반 반")
     ("竝" . "짝지을 반, 고을이름 반")
     ("絆" . "줄 반")
     ("繁" . "뱃대끈 반")
     ("般" . "옮길 반")
     ("蟠" . "서릴 반")
     ("返" . "돌이킬 반")
     ("頒" . "나눌 반")
     ("飯" . "밥 반")
     ("仮" . "反과 同字")
     ("冸" . "녹을 반")
     ("媻" . "비틀거릴 반")
     ("扳" . "끌 반")
     ("搫" . "덜 반")
     ("攽" . "나눌 반")
     ("朌" . "구실 반")
     ("肦" . "나눌 반")
     ("胖" . "희생 반")
     ("螌" . "가뢰 반")
     ("頖" . "풀릴 반")
     ("飯" . "밥 반"))
    ("발"
     ("勃" . "갑작스러울 발")
     ("悖" . "우쩍 일어날 발")
     ("拔" . "뺄 발")
     ("撥" . "다스릴 발")
     ("渤" . "바다이름 발")
     ("潑" . "뿌릴 발")
     ("發" . "쏠 발")
     ("跋" . "밟을 발")
     ("醱" . "술 괼 발")
     ("鉢" . "바리때 발")
     ("髮" . "터럭 발")
     ("魃" . "가물 귀신 발")
     ("哱" . "어지러울 발")
     ("彂" . "發과 同字")
     ("抜" . "拔의 俗字")
     ("拨" . "撥의 簡體字")
     "浌"
     ("浡" . "일어날 발")
     ("溌" . "潑의 略字")
     ("発" . "發의 略字")
     ("脖" . "배꼽 발")
     ("酦" . "술기운 발")
     ("醗" . "醱의 略字")
     ("鈸" . "방울 발")
     ("鵓" . "집비둘기 발"))
    ("방"
     ("倣" . "본뜰 방")
     ("傍" . "곁 방")
     ("坊" . "동네 방")
     ("妨" . "방해할 방")
     ("尨" . "삽살개 방")
     ("幇" . "幫과 同字")
     ("彭" . "많을 방")
     ("彷" . "거닐 방")
     ("房" . "방 방")
     ("放" . "놓을 방")
     ("方" . "모 방")
     ("旁" . "두루 방")
     ("昉" . "마침 방")
     ("枋" . "다목 방")
     ("榜" . "매 방")
     ("滂" . "비 퍼부을 방")
     ("磅" . "돌 떨어지는 소리 방")
     ("紡" . "자을 방")
     ("肪" . "기름 방")
     ("膀" . "쌍배 방")
     ("舫" . "배 방")
     ("芳" . "꽃다울 방")
     ("蒡" . "인동 덩굴 방")
     ("蚌" . "방합 방")
     ("訪" . "찾을 방")
     ("謗" . "헐뜯을 방")
     ("邦" . "나라 방")
     ("防" . "둑 방")
     ("龍" . "잿빛 방")
     ("龐" . "어지러울 방")
     ("仿" . "헤멜 방")
     ("匚" . "상자 방")
     ("厖" . "클 방")
     ("哤" . "난잡할 방")
     ("嗙" . "웃을 방")
     ("幚" . "幫과 同字")
     ("幫" . "도울 방")
     ("徬" . "시중들 방")
     ("搒" . "배저을 방")
     ("旊" . "옹기장 방")
     ("梆" . "목어 방")
     ("牓" . "패 방")
     ("舽" . "배 방")
     ("螃" . "방게 방")
     ("邡" . "고을 이름 방")
     ("鎊" . "깎을 방")
     ("髣" . "비슷할 방")
     ("魴" . "방어 방")
     ("龎" . "龐의 俗字"))
    ("배"
     ("俳" . "광대 배")
     ("倍" . "곱 배")
     ("培" . "북돋을 배")
     ("妃" . "짝(配) 배")
     ("徘" . "노닐 배")
     ("拜" . "절 배")
     ("排" . "밀칠 배")
     ("杯" . "잔 배")
     ("湃" . "물결 이는 모양 배")
     ("焙" . "불에 쬘 배")
     ("牌" . "배지 배")
     ("白" . "땅이름 배")
     ("盃" . "杯의 俗字")
     ("背" . "등 배")
     ("胚" . "아이 밸 배")
     ("裴" . "옷 치렁치렁할 배")
     ("賠" . "물어줄 배")
     ("輩" . "무리 배")
     ("配" . "아내 배")
     ("陪" . "쌓아올릴 배")
     ("偝" . "버릴 배")
     ("啡" . "코 고는 소리 배")
     ("坏" . "언덕 배")
     ("坯" . "坏와 同字")
     ("扒" . "뺄 배")
     ("琲" . "구슬 꿰미 배")
     ("蓓" . "꽃봉오리 배"))
    ("백"
     ("伯" . "맏 백")
     ("帛" . "비단 백")
     ("柏" . "나무 이름 백")
     ("栢" . "柏의 俗字")
     ("白" . "흰 백")
     ("百" . "일백 백")
     ("覇" . "霸의 俗字")
     ("魄" . "넋 백")
     ("兡" . "헥트르램 백")
     ("粨" . "힉터메트르 백")
     ("霸" . "달력 백"))
    ("번"
     ("反" . "되돌릴 번")
     ("幡" . "기 번")
     ("樊" . "울 번")
     ("潘" . "넘칠 번")
     ("煩" . "괴로워할 번")
     ("燔" . "구울 번")
     ("番" . "갈마들 번")
     ("磻" . "강이름 번")
     ("繁" . "많을 번")
     ("蕃" . "우거질 번")
     ("藩" . "덮을 번")
     ("飜" . "뒤칠 번")
     ("磻" . "강이름 번")
     ("噃" . "산돼지 번, 소리 번")
     ("繙" . "되풀이 풀이할 번")
     ("翻" . "날 번")
     ("膰" . "제사 고기 번")
     ("蘩" . "산흰쑥 번")
     ("袢" . "속옷 번")
     ("蹯" . "짐승 발바닥 번"))
    ("벌"
     ("伐" . "칠 벌")
     ("筏" . "떼 벌")
     ("罰" . "죄 벌")
     ("閥" . "공훈 벌")
     ("橃" . "떼 벌")
     ("罸" . "罰과 同字"))
    ("범"
     ("凡" . "무릇 범")
     ("帆" . "돛 범")
     ("梵" . "범어 범")
     ("氾" . "넘칠 범")
     ("汎" . "뜰 범")
     ("泛" . "뜰 범")
     ("犯" . "범할 범")
     ("範" . "법 범")
     ("范" . "풀 이름 범")
     ("凢" . "凡의 俗字")
     ("凣" . "凡의 俗字")
     ("笵" . "법 범")
     ("訉" . "말 많을 범")
     ("颿" . "돛 범"))
    ("법"
     ("法" . "법 법")
     ("琺" . "법랑 법"))
    ("베"
     "北"
     "裵"
     "褙"
     "北")
    ("벡"
     "佰")
    ("벽"
     ("僻" . "후미질 벽")
     ("劈" . "쪼갤 벽")
     ("壁" . "벽 벽")
     ("擘" . "엄지손가락 벽")
     ("檗" . "황벽나무 벽")
     ("璧" . "동근 옥 벽")
     ("癖" . "적취 벽")
     ("碧" . "푸를 벽")
     ("蘗" . "황경나무 벽")
     ("闢" . "열 벽")
     ("霹" . "벼락 벽")
     ("擗" . "가슴칠 벽")
     ("甓" . "벽돌 벽")
     ("疈" . "가를 벽")
     ("薜" . "승검초 벽")
     ("襞" . "주름 벽")
     ("辟" . "임금 벽")
     ("鷿" . "농병아리 벽")
     ("鼊" . "거북 벽"))
    ("변"
     ("便" . "똥오줌 변")
     ("卞" . "조급할 변")
     ("弁" . "고깔 변")
     ("扁" . "현판 변, 모난 그릇 변, 비천할 변")
     ("編" . "땋을 변")
     ("變" . "변할 변")
     ("辨" . "분별할 변")
     ("辯" . "말잘할 변")
     ("邊" . "가 변")
     ("騈" . "나란히 할 변")
     ("便" . "똥오줌 변")
     ("匥" . "관갑 변, 옷상자 변, 대그릇 변")
     ("变" . "変과 同字")
     ("変" . "變의 俗字")
     ("忭" . "기뻐할 변")
     ("抃" . "손뼉칠 변")
     ("籩" . "제기 이름 변")
     ("胼" . "腁의 俗字")
     ("腁" . "살갗 틀 변")
     ("賆" . "더할 변")
     ("辮" . "땋을 변, 엮을 변, 얽을 변, 단추 변")
     ("边" . "邊의 略字")
     ("辺" . "邊의 略字")
     ("釆" . "분별할 변")
     ("駢" . "騈의 俗字")
     ("骿" . "통갈비 변")
     ("鴘" . "매 변"))
    ("별"
     ("別" . "나눌 별")
     ("批" . "거스를 별")
     ("瞥" . "언뜻 볼 별")
     ("閉" . "막을 별")
     ("鱉" . "鼈과 同字")
     ("鼈" . "자라 별")
     ("丿" . "삐침 별")
     ("别" . "別의 俗字")
     ("彆" . "활 뒤틀릴 별")
     ("憋" . "악할 별")
     ("蹩" . "절름발이 별")
     ("鷩" . "금계 별")
     ("龞" . "鼈과 同字"))
    ("병"
     ("丙" . "남녘 병")
     ("倂" . "아우를 병")
     ("兵" . "군사 병")
     ("屛" . "병풍 병")
     ("幷" . "합할 병, 아우를 병, 겸할 병")
     ("昞" . "밝을 병")
     ("昺" . "昞과 同字")
     ("柄" . "자루 병")
     ("棅" . "柄과 同字")
     ("榜" . "게시판 병, 방 써붙일 병, 매 병, 볼기칠 병")
     ("炳" . "밝을 병")
     ("甁" . "병 병")
     ("病" . "병 병")
     ("秉" . "잡을 병")
     ("竝" . "아우를 병")
     ("輧" . "거마 소리 병")
     ("餠" . "떡 병")
     ("騈" . "나란히 할 병")
     ("並" . "竝과 同字")
     ("併" . "倂의 俗字")
     ("塀" . "담 병")
     ("屏" . "屛의 俗字")
     ("并" . "幷의 俗字")
     ("摒" . "제거할 병")
     ("瓶" . "甁의 俗字")
     ("絣" . "무늬없는 비단 병, 이을 병, 먹줄 튀길 병")
     ("缾" . "두레박 병")
     ("軿" . "輧의 俗字")
     ("迸" . "달아날 병")
     ("邴" . "고을 이름 병")
     ("鈵" . "굳을 병")
     ("鉼" . "판금 병")
     ("鋲" . "넓은 못 병, 징 병")
     ("餅" . "餠의 俗字")
     ("駢" . "騈의 俗字"))
    ("보"
     ("保" . "지킬 보")
     ("堡" . "작은 성 보")
     ("報" . "갚을 보")
     ("寶" . "보배 보")
     ("普" . "널리 보")
     ("步" . "걸을 보")
     ("洑" . "보 보")
     "湺"
     ("潽" . "물(水) 보")
     ("父" . "남자의 미칭(美稱) 보")
     ("珤" . "寶의 古字")
     ("甫" . "클 보")
     ("菩" . "보살 보")
     ("補" . "기울 보")
     ("褓" . "포대기 보")
     ("譜" . "계보 보")
     ("輔" . "덧방나무 보")
     ("俌" . "도울 보")
     ("呆" . "保와 同字")
     ("宝" . "寶의 俗字")
     ("寳" . "寶의 俗字")
     ("椺" . "들보 보")
     ("歩" . "步의 俗字")
     ("盙" . "簠의 本字")
     ("簠" . "제기 이름 보")
     ("葆" . "풀 더부룩할 보")
     ("靌" . "寶와 同字")
     ("鴇" . "능에 보")
     ("黼" . "수 보"))
    ("복"
     ("伏" . "엎드릴 복")
     ("僕" . "종 복")
     ("副" . "버금 복")
     ("匐" . "길 복")
     ("卜" . "점 복")
     ("宓" . "성 복")
     ("復" . "돌아올 복")
     ("撲" . "닦을 복")
     ("服" . "옷 복")
     ("樸" . "총생할 복")
     ("福" . "복 복")
     ("腹" . "배 복")
     ("茯" . "복령 복")
     ("蔔" . "무우 복")
     ("複" . "겹옷 복")
     ("覆" . "뒤집힐 복")
     ("輹" . "복토 복")
     ("輻" . "바퀴살 복")
     ("馥" . "향기 복")
     ("鰒" . "전복 복")
     ("墣" . "흙덩이 복")
     ("幞" . "건 복")
     ("扑" . "칠 복")
     ("濮" . "강 이름 복")
     ("箙" . "전동 복")
     ("菔" . "무 복")
     ("蝠" . "박쥐 복")
     ("蝮" . "살무사 복")
     ("袱" . "보 복")
     ("踣" . "넘어질 복")
     ("蹼" . "물갈퀴 복")
     ("鵩" . "새 이름 복")
     ("福" . "복 복"))
    ("본"
     ("本" . "밑 본"))
    ("봉"
     ("俸" . "녹 봉")
     ("奉" . "받들 봉")
     ("封" . "봉할 봉")
     ("尨" . "헝클어진 모양 봉")
     ("峯" . "봉우리 봉")
     ("峰" . "峯과 同字")
     ("捧" . "받들 봉")
     ("棒" . "몽둥이 봉")
     ("汎" . "뜰 봉")
     ("泛" . "엎을 봉")
     ("烽" . "봉화 봉")
     ("熢" . "연기 자욱할 봉")
     ("琫" . "칼집 장식 봉")
     ("縫" . "꿰맬 봉")
     ("蓬" . "쑥 봉")
     ("蜂" . "벌 봉")
     ("逢" . "만날 봉")
     ("鋒" . "칼끝 봉")
     ("鳳" . "봉새 봉")
     ("丰" . "예쁠 봉")
     ("唪" . "껄껄 웃을 봉")
     ("塜" . "먼지 일 봉")
     ("夆" . "끌 봉")
     ("篷" . "뜸 봉")
     ("綘" . "縫과 同字")
     ("菶" . "풀 무성할 봉")
     ("鳯" . "鳳의 俗字")
     ("鴌" . "鳳의 古字"))
    ("부"
     ("不" . "아닐 부")
     ("付" . "줄 부")
     ("伏" . "알 안을 부")
     ("俯" . "구푸릴 부")
     ("傅" . "스승 부")
     ("剖" . "쪼갤 부")
     ("副" . "버금 부")
     ("否" . "아닐 부")
     ("咐" . "분부할 부")
     ("埠" . "선창 부")
     ("培" . "무덤 부")
     ("報" . "나아갈 부")
     ("夫" . "지아비 부")
     ("婦" . "며느리 부")
     ("孚" . "미쁠 부")
     ("孵" . "알 깔 부")
     ("富" . "가멸 부")
     ("府" . "곳집 부")
     ("復" . "다시 부")
     ("扶" . "도울 부")
     ("敷" . "펼 부")
     ("斧" . "도끼 부")
     ("浮" . "뜰 부")
     ("溥" . "펼 부")
     ("父" . "아비 부")
     ("符" . "부신 부")
     ("簿" . "장부 부")
     ("缶" . "장군 부")
     ("腐" . "썩을 부")
     ("腑" . "장부 부")
     ("膚" . "살갗 부")
     ("艀" . "작은 배 부")
     ("芙" . "부용 부")
     ("莩" . "풀 이름 부")
     ("複" . "겹칠 부")
     ("覆" . "덮을 부, 가리울 부, 고루고루 퍼질 부")
     ("訃" . "부고 부")
     ("負" . "질 부")
     ("賦" . "구실 부")
     ("賻" . "부의 부")
     ("赴" . "나아갈 부")
     ("趺" . "책상다리할 부")
     ("部" . "거느릴 부")
     ("釜" . "가마 부")
     ("阜" . "언덕 부")
     ("附" . "붙을 부")
     ("駙" . "곁마 부")
     ("鳧" . "오리 부")
     ("復" . "다시 부")
     ("仆" . "엎드릴 부")
     ("俘" . "사로잡을 부")
     ("偩" . "본뜰 부")
     ("冨" . "富의 俗字")
     ("哹" . "부는 소리 부, 물새 우는 소리 부")
     ("媍" . "婦와 同字")
     "巬"
     ("巭" . "공부할 부")
     ("抔" . "움킬 부")
     ("拊" . "어루만질 부")
     ("掊" . "그러모을 부")
     ("旉" . "敷의 古字")
     ("桴" . "마룻대 부")
     ("榑" . "부상 부")
     ("涪" . "물거품 부")
     ("玞" . "옥돌 부")
     ("祔" . "합사할 부")
     ("筟" . "대청 부")
     ("罘" . "그물 부")
     ("罦" . "그물 부")
     ("胕" . "장부 부")
     ("芣" . "질경이 부")
     ("苻" . "귀목풀 부")
     ("蔀" . "빈지문 부")
     ("蚨" . "파랑강충이 부")
     ("蜉" . "하루살이 부")
     ("袝" . "성한 옷 부")
     ("裒" . "모을 부")
     ("跗" . "발등 부")
     ("踣" . "넘어질 부")
     ("鈇" . "도끼 부")
     ("阝" . "언덕 부")
     ("頫" . "머리 숙일 부")
     ("鮒" . "붕어 부")
     ("鳬" . "鳧의 俗字")
     ("麩" . "밀기울 부"))
    ("북"
     "伏"
     ("北" . "북녘 북")
     ("僰" . "오랑캐 북"))
    ("분"
     ("分" . "나눌 분")
     ("匪" . "나눌 분")
     ("吩" . "뿜을 분")
     ("噴" . "뿜을 분")
     ("墳" . "무덤 분")
     ("奔" . "달릴 분")
     ("奮" . "떨칠 분")
     ("忿" . "성낼 분")
     ("憤" . "결낼 분")
     ("扮" . "꾸밀 분")
     ("昐" . "햇빛 분")
     ("汾" . "클 분")
     ("焚" . "불사를 분")
     ("盆" . "동이 분")
     ("粉" . "가루 분")
     ("糞" . "똥 분")
     ("紛" . "어지러워질 분")
     ("芬" . "향기로울 분")
     ("賁" . "클 분")
     ("雰" . "안개 분")
     ("頒" . "큰 머리 분")
     ("体" . "용렬할 분")
     ("倴" . "사람이름 분, 둔한 사람 분")
     ("僨" . "넘어질 분")
     ("坌" . "먼지 분")
     ("帉" . "걸레 분, 행주 분")
     ("朌" . "頒과 同字")
     ("枌" . "나무 이름 분")
     ("棻" . "棼과 同字")
     ("棼" . "겹들보 분, 삼베 분, 어지러울 분")
     ("氛" . "기운 분")
     ("湓" . "용솟음할 분")
     ("濆" . "뿜을 분")
     ("犇" . "달아날 분")
     ("畚" . "삼태기 분")
     ("砏" . "큰 소리 분")
     ("笨" . "거칠 분")
     ("肦" . "머리 클 분")
     ("膹" . "고기 삶은 국 분")
     ("苯" . "풀 떨기로 날 분")
     ("蕡" . "들깨 분")
     ("轒" . "병거 분")
     ("鱝" . "가오리 분")
     ("黺" . "옷에 오색 수 놓을 분")
     ("鼢" . "두더지 분"))
    ("불"
     ("不" . "아닐 불")
     ("佛" . "부처 불")
     ("弗" . "아닐 불")
     ("彿" . "비슷할 불")
     ("拂" . "떨 불")
     ("沸" . "용솟음할 불")
     ("不" . "아닐 불")
     ("乀" . "파임 불")
     ("仏" . "佛의 古字")
     ("冹" . "찰 불")
     ("刜" . "칠 불")
     ("咈" . "어길 불")
     "堋"
     ("岪" . "산길 불")
     ("払" . "떨칠 불")
     "漰"
     ("祓" . "푸닥거리할 불")
     ("紱" . "인끈 불")
     ("艴" . "발끈할 불")
     ("茀" . "풀 우거질 불")
     ("韍" . "폐슬 불")
     ("髴" . "비슷할 불")
     "鬅"
     ("黻" . "수 불"))
    ("붕"
     ("崩" . "무너질 붕")
     ("朋" . "벗 붕")
     ("棚" . "시렁 붕")
     ("硼" . "붕산 붕")
     ("繃" . "묶을 붕")
     ("鵬" . "대붕새 붕")
     ("倗" . "부탁할 붕")
     ("傰" . "성 붕")
     ("綳" . "繃과 同字"))
    ("비"
     ("丕" . "클 비")
     ("備" . "갖출 비")
     ("匕" . "비수 비")
     ("匪" . "대상자 비")
     ("卑" . "낮을 비")
     ("否" . "막힐 비, 더러울 비, 악할 비")
     ("妃" . "왕비 비")
     ("婢" . "여자종 비")
     ("庇" . "덮을 비")
     ("悲" . "슬플 비")
     ("憊" . "고달플 비")
     ("扉" . "문짝 비")
     ("批" . "칠 비")
     ("斐" . "오락가락할 비")
     ("枇" . "비파나무 비")
     ("榧" . "비자나무 비")
     ("比" . "견줄 비")
     ("毖" . "삼갈 비")
     ("毗" . "도울 비")
     ("毘" . "毗와 同字")
     ("沸" . "끓을 비")
     ("泌" . "샘물 흐르는 모양 비")
     ("琵" . "비파 비")
     ("痺" . "암메추라기 비")
     ("砒" . "비상 비")
     ("碑" . "돌기둥 비")
     ("秕" . "쭉정이 비")
     ("秘" . "숨길 비")
     ("粃" . "쭉정이 비")
     ("緋" . "붉은 빛 비")
     ("翡" . "물총새 비")
     ("肥" . "살찔 비")
     ("脾" . "지라 비")
     ("臂" . "팔 비")
     ("菲" . "엷을 비")
     ("蜚" . "바퀴 비")
     ("裨" . "도울 비")
     ("誹" . "헐뜯을 비")
     ("譬" . "비유할 비")
     ("費" . "쓸 비")
     ("鄙" . "다라울 비")
     ("非" . "아닐 비")
     ("飛" . "날 비")
     ("鼻" . "코 비")
     ("泌" . "샘물 흐르는 모양 비")
     ("仳" . "떠날 비")
     ("伾" . "힘셀 비")
     ("俷" . "등질 비")
     ("俻" . "하여금 비, 좇을 비, 흘겨볼 비")
     ("俾" . "더할 비")
     ("偹" . "備의 俗字")
     ("剕" . "발 벨 비")
     ("厞" . "더러울 비")
     ("呸" . "다투는 소리 비")
     ("啚" . "鄙와 同字")
     ("啡" . "코 고는 소리 비")
     ("嚊" . "헐떡거릴 비")
     ("嚭" . "클 비")
     ("圮" . "무너질 비")
     ("埤" . "더할 비")
     ("妣" . "죽은 어미 비")
     ("屁" . "방귀 비")
     ("庳" . "집 낮을 비")
     ("悱" . "표현 못할 비")
     ("棐" . "도지개 비")
     ("椑" . "술통 비")
     ("榌" . "사닥다리 비")
     ("沘" . "강 이름 비")
     ("淝" . "강 이름 비")
     ("淠" . "강 이름 비")
     ("濞" . "물 소리 비")
     ("狉" . "삵의 새끼 비")
     ("狒" . "비비 비")
     ("畀" . "줄 비")
     ("痞" . "뱃속 결릴 비")
     ("痹" . "저릴 비")
     ("睥" . "흘겨볼 비")
     ("祕" . "귀신 비")
     ("篦" . "빗치개 비")
     ("紕" . "가선 비")
     ("羆" . "큰 곰 비")
     ("腓" . "장딴지 비")
     ("芘" . "풀 이름 비")
     ("芾" . "작은 모양 비")
     ("萆" . "비해 비")
     ("蓖" . "아주까리 비")
     ("蚍" . "왕개미 비")
     ("貔" . "비휴 비")
     ("贔" . "힘쓸 비")
     ("轡" . "고삐 비")
     ("邳" . "클 비")
     ("郫" . "고을 이름 비")
     ("閟" . "문 닫을 비")
     ("陴" . "성가퀴 비")
     ("霏" . "눈 펄펄 내릴 비")
     ("鞴" . "풀무 비")
     ("騑" . "곁마 비")
     ("騛" . "빠른 말 비")
     ("髀" . "넓적다리 비")
     ("鯡" . "곤이 비")
     ("鼙" . "마상북 비"))
    ("빈"
     ("嚬" . "찡그릴 빈")
     ("嬪" . "아내 빈")
     ("彬" . "빛날 빈")
     ("斌" . "빛날 빈")
     ("檳" . "빈랑나무 빈")
     ("殯" . "염할 빈")
     ("浜" . "물가 빈")
     ("濱" . "물가 빈")
     ("瀕" . "물가 빈")
     ("牝" . "암컷 빈")
     ("玭" . "구슬 이름 빈")
     ("貧" . "가난할 빈")
     ("賓" . "손 빈")
     ("頻" . "자주 빈")
     ("份" . "빛날 빈")
     ("儐" . "인도할 빈")
     ("擯" . "물리칠 빈")
     ("矉" . "찡그릴 빈")
     ("繽" . "어지러울 빈")
     ("臏" . "종지뼈 빈")
     ("蘋" . "네가래 빈")
     ("豳" . "나라 이름 빈")
     ("賔" . "손 빈")
     ("邠" . "나라 이름 빈")
     ("鑌" . "강철 빈")
     ("霦" . "옥 광채 빈")
     ("顰" . "찡그릴 빈")
     ("髕" . "종지뼈 빈")
     ("鬂" . "鬢의 俗字")
     ("鬢" . "살쩍 빈"))
    ("빙"
     ("憑" . "기대다 빙")
     ("氷" . "얼음 빙")
     ("聘" . "찾아가다 빙")
     ("騁" . "달리다 빙")
     ("俜" . "비틀거리다 빙")
     ("冫" . "얼음 빙")
     ("冰" . "氷의 本字")
     ("凭" . "기대다 빙")
     ("凴" . "凭과 同字")
     ("娉" . "장가들다 빙"))
    ("뿐"
     ("兺" . "그 뿐"))
    ("사"
     ("乍" . "잠깐 사")
     ("事" . "일 사")
     ("些" . "적을 사")
     ("仕" . "벼슬할 사")
     ("伺" . "엿볼 사")
     ("似" . "같을 사")
     ("使" . "하여금 사")
     ("俟" . "기다릴 사")
     ("僿" . "잘게 부슬 사")
     ("史" . "역사 사")
     ("司" . "맡을 사")
     ("唆" . "부추길 사")
     ("嗣" . "이을 사")
     ("四" . "넉 사")
     ("士" . "선비 사")
     ("夕" . "한 움큼 사")
     ("奢" . "사치할 사")
     ("娑" . "춤출 사")
     ("寫" . "베낄 사")
     ("寺" . "절 사")
     ("射" . "궁술 사")
     ("巳" . "여섯째 지지 사")
     ("師" . "스승 사")
     ("徙" . "옮길 사")
     ("思" . "생각할 사")
     ("捨" . "버릴 사")
     ("斜" . "비낄 사")
     ("斯" . "이 사")
     ("柶" . "수저 사")
     ("査" . "조사할 사, 떼 사")
     ("梭" . "북 사")
     ("死" . "죽을 사")
     ("沙" . "모래 사")
     ("泗" . "물 이름 사")
     ("渣" . "찌끼 사")
     ("瀉" . "토할 사")
     "灼"
     ("犧" . "술그릇 사")
     ("獅" . "사자 사")
     ("獻" . "술통 사")
     ("砂" . "모래 사")
     ("社" . "토지의 신 사")
     ("祀" . "제사 사")
     ("祠" . "사당 사")
     ("私" . "사사 사")
     ("篩" . "체 사")
     ("紗" . "깁 사")
     ("絲" . "실 사")
     ("肆" . "방자할 사")
     ("舍" . "집 사")
     ("莎" . "향부자 사")
     ("蓑" . "도롱이 사")
     ("蛇" . "뱀 사")
     ("裟" . "가사 사")
     ("詐" . "속일 사")
     ("詞" . "말씀 사")
     ("謝" . "사례할 사")
     ("賜" . "줄 사")
     ("赦" . "용서할 사")
     ("辭" . "말 사")
     ("邪" . "간사할 사")
     ("食" . "밥 먹일 사")
     ("飼" . "먹일 사")
     ("駟" . "사마 사")
     ("麝" . "사향노루 사")
     ("亊" . "事와 同字")
     ("佀" . "같을 사")
     ("佘" . "산 이름 사")
     ("倳" . "찌를 사")
     ("傞" . "취하여 춤추는 모양 사")
     ("傻" . "약을 사")
     ("儩" . "다할 사")
     ("写" . "冩의 略字")
     ("冩" . "베낄 사")
     ("剚" . "찌를 사")
     ("卸" . "짐 부릴 사, 벗을 사")
     ("厶" . "사사 사")
     ("叓" . "事의 古字")
     ("咋" . "잠간 사")
     ("喳" . "예하고 대답하는 소리 사")
     ("嗄" . "목 잠길 사")
     ("姒" . "동서 사")
     ("查" . "査와 同字")
     ("楂" . "떼 사")
     ("榭" . "정자 사")
     ("汜" . "지류 사")
     ("献" . "獻의 俗字")
     ("痧" . "쥐통 사")
     ("皶" . "코에 열꽃 돋을 사, 주부코 사, 분가시 사")
     ("竢" . "기다릴 사")
     ("笥" . "상자 사")
     ("簑" . "蓑와 同字")
     ("簔" . "簑와 同字")
     ("糸" . "가는 실 사")
     ("缷" . "卸의 俗字")
     ("蜡" . "납향 사")
     ("覗" . "엿볼 사")
     ("辞" . "辭의 俗字")
     ("駛" . "달릴 사")
     ("魦" . "鯊와 同字")
     ("鯊" . "문절망둑 사")
     ("鯋" . "상어 사, 모래무지 사")
     ("鰤" . "새우 사")
     ("飼" . "기를 사"))
    ("삭"
     ("削" . "깎을 삭")
     ("數" . "자주 삭")
     ("朔" . "초하루 삭")
     ("溯" . "물이름 삭, 빨래한 물 삭")
     ("索" . "동아줄 삭")
     ("數" . "자주 삭")
     ("索" . "동아줄 삭")
     ("槊" . "창 삭")
     ("爍" . "빛날 삭")
     ("蒴" . "말오줌대 삭")
     ("鑠" . "녹일 삭"))
    ("산"
     ("傘" . "우산 산")
     ("刪" . "깎을 산")
     ("山" . "뫼 산")
     ("散" . "흩을 산")
     ("汕" . "오구 산")
     ("珊" . "산호 산")
     ("産" . "낳을 산")
     ("疝" . "산증 산")
     ("算" . "셀 산")
     ("蒜" . "달래 산")
     ("酸" . "초 산")
     ("霰" . "싸라기눈 산")
     ("删" . "刪의 略字")
     ("剷" . "깎을 산")
     ("匴" . "관상자 산")
     ("姍" . "헐뜯을 산")
     ("姗" . "姍의 略字")
     ("孿" . "쌍둥이 산")
     ("橵" . "산자 산")
     ("潸" . "눈물흐를 산")
     ("澘" . "潸의 略字")
     ("狻" . "사자 산")
     ("產" . "産의 略字")
     ("繖" . "일산 산")
     "虄"
     ("訕" . "헐뜯을 산")
     ("跚" . "비틀거릴 산")
     ("鏟" . "대패 산")
     ("閊" . "비색할 산"))
    ("살"
     ("乷" . "음역자 살")
     ("撒" . "뿌릴 살")
     ("殺" . "죽일 살")
     ("煞" . "죽일 살")
     ("蔡" . "내칠 살")
     ("薩" . "보살 살"))
    ("삼"
     ("三" . "석 삼")
     ("參" . "석 삼")
     ("杉" . "삼나무 삼")
     ("森" . "나무빽빽할 삼")
     ("芟" . "벨 삼")
     ("蔘" . "인삼 삼")
     ("衫" . "적삼 삼")
     ("參" . "석 삼")
     ("叁" . "參의 略字")
     ("参" . "參의 略字")
     ("叄" . "參의 俗字")
     ("嘇" . "머금을 삼")
     ("毿" . "털긴 삼")
     ("糝" . "나물죽 삼")
     ("釤" . "낫 삼")
     ("鬖" . "헝클어질 삼"))
    ("삽"
     ("扱" . "거둘 삽, 들 삽, 당길 삽, 깊을 삽")
     ("揷" . "꽂을 삽")
     ("澁" . "떫을 삽")
     ("鈒" . "창 삽")
     ("颯" . "바람소리 삽")
     ("偛" . "키작을 삽")
     ("卅" . "서른 삽")
     ("唼" . "쪼아먹을 삽")
     ("啃" . "입 다시는 소리 삽")
     ("啑" . "오리가 텁석텁석 먹을 삽")
     ("插" . "揷의 略字")
     ("歃" . "마실 삽")
     ("翣" . "운삽 삽")
     ("趿" . "발가락으로잡을 삽")
     ("鍤" . "가래 삽")
     ("钑" . "鈒의 略字")
     ("霅" . "비올 삽")
     ("霎" . "가랑비 삽"))
    ("상"
     ("上" . "위 상")
     ("傷" . "상처 상")
     ("像" . "형상 상")
     ("償" . "갚을 상")
     ("向" . "성 상")
     ("商" . "헤아릴 상")
     ("喪" . "죽을 상")
     ("嘗" . "맛볼 상")
     ("孀" . "과부 상")
     ("尙" . "오히려 상")
     ("峠" . "고개 상")
     ("常" . "항상 상")
     ("床" . "牀의 俗字")
     ("庠" . "학교 상")
     ("廂" . "행랑 상")
     ("想" . "생각할 상")
     ("桑" . "뽕나무 상")
     ("樣" . "橡의 略字")
     ("橡" . "상수리나무 상")
     ("湘" . "강이름 상")
     ("湯" . "물흐를 상")
     ("爽" . "시원할 상")
     ("牀" . "평상 상")
     ("狀" . "형상 상")
     ("相" . "서로 상")
     ("祥" . "상서로울 상")
     ("箱" . "상자 상")
     ("翔" . "빙빙돌아날 상")
     ("裳" . "치마 상")
     ("觴" . "잔 상")
     ("詳" . "자세할 상")
     ("象" . "코끼리 상")
     ("賞" . "상줄 상")
     ("霜" . "서리 상")
     ("丄" . "上의 古字")
     ("儴" . "고생할 상, 훔칠 상, 인연할 상")
     ("勨" . "느즈러질 상, 힘쓸 상, 움직일 상")
     "响"
     ("嗓" . "목구멍 상")
     ("塽" . "높고밝은땅 상")
     ("尚" . "尙의 略字")
     ("徜" . "노닐 상")
     ("晌" . "정오 상")
     ("殤" . "일찍죽을 상")
     ("状" . "狀의 略字")
     ("甞" . "맛볼 상")
     ("緗" . "담황색 상")
     ("鎟" . "방울소리 상")
     ("顙" . "이마 상")
     ("鬺" . "삶을 상")
     ("鮝" . "건어 상")
     ("祥" . "복 상"))
    ("새"
     ("塞" . "변방 새")
     ("灑" . "뿌릴 새, 깜짝 놀랄 새")
     ("璽" . "도장 새")
     ("賽" . "굿할 새")
     ("鰓" . "뿔심 새"))
    ("색"
     ("嗇" . "아낄 색")
     ("塞" . "막힐 색")
     ("穡" . "거둘 색")
     ("索" . "찾을 색")
     ("色" . "빛 색")
     ("薔" . "아낄 색")
     ("塞" . "막힐 색")
     ("愬" . "놀랍고두려울 색")
     ("槭" . "나뭇잎 떨어져 앙상할 색")
     ("濇" . "껄끄러울 색")
     ("瀒" . "濇의 俗字")
     ("賾" . "깊숙할 색"))
    ("생"
     ("牲" . "희생 생")
     ("生" . "날 생")
     ("甥" . "생질 생")
     ("省" . "덜 생")
     ("笙" . "생황 생")
     ("省" . "덜 생")
     ("栍" . "찌 생")
     ("眚" . "눈에백태낄 생")
     ("鉎" . "녹 생"))
    ("샤"
     "仒")
    ("서"
     ("墅" . "농막 서")
     ("壻" . "사위 서")
     ("嶼" . "섬 서")
     ("序" . "차례 서")
     ("庶" . "여러 서")
     ("徐" . "천천할 서")
     ("恕" . "용서할 서")
     ("抒" . "풀 서")
     ("捿" . "깃들일 서")
     ("敍" . "차례 서")
     ("暑" . "더울 서")
     ("曙" . "새벽 서")
     ("書" . "쓸 서")
     ("栖" . "깃들일 서")
     ("棲" . "살 서")
     ("犀" . "무소 서")
     ("瑞" . "상서 서")
     ("筮" . "점대 서")
     ("絮" . "솜 서")
     ("緖" . "실마리 서")
     ("署" . "관청 서")
     ("胥" . "서로 서")
     ("舒" . "펼 서")
     ("薯" . "참마 서")
     ("西" . "서녘 서")
     ("誓" . "맹세할 서")
     ("逝" . "갈 서")
     ("鋤" . "호미 서")
     ("黍" . "기장 서")
     ("鼠" . "쥐 서")
     ("叙" . "敍의 俗字")
     ("噬" . "씹을 서")
     ("婿" . "사위 서")
     ("庻" . "庶의 略字")
     ("揟" . "나무이름 서")
     ("撕" . "들 서, 일깨울 서")
     ("敘" . "敍의 俗字")
     ("湑" . "거를 서")
     ("澨" . "물가 서")
     ("紓" . "느슨할 서")
     ("緒" . "緖의 略字")
     ("耡" . "구실이름 서")
     ("芧" . "상수리 서")
     ("諝" . "슬기 서")
     ("谞" . "諝의 略字")
     ("鉏" . "호미 서")
     ("閪" . "잃을 서"))
    ("석"
     ("夕" . "저녁 석")
     ("奭" . "클 석")
     ("射" . "맞힐 석")
     ("席" . "자리 석")
     ("惜" . "아낄 석")
     ("昔" . "옛 석")
     ("晳" . "밝을 석")
     ("析" . "가를 석")
     ("汐" . "조수 석")
     ("淅" . "쌀일 석")
     ("潟" . "개펄 석")
     ("澤" . "풀 석")
     ("石" . "돌 석")
     ("碩" . "클 석")
     ("蓆" . "자리 석")
     ("釋" . "풀 석")
     ("錫" . "주석 석")
     ("冟" . "고룰 석, 고르지 않을 석, 알맞게 된 밥 석")
     ("晰" . "밝을 석")
     ("沢" . "澤의 略字")
     ("澙" . "潟의 俗字")
     ("矽" . "석비레 석")
     ("腊" . "포 석")
     ("舃" . "신 석")
     ("舄" . "舃의 略字")
     ("蜥" . "도마뱀 석")
     ("釈" . "釋의 俗字")
     ("鉐" . "놋쇠 석")
     ("鼫" . "석서 석"))
    ("선"
     ("亘" . "구할 선")
     ("仙" . "신선 선")
     ("僊" . "춤출 선")
     ("先" . "먼저 선")
     ("善" . "착할 선")
     ("單" . "고을이름 선")
     ("嬋" . "고울 선")
     ("宣" . "베풀 선")
     ("扇" . "사립문 선")
     ("敾" . "글잘쓸 선")
     ("旋" . "돌 선")
     ("洗" . "조촐할 선, 율이름 선")
     ("渲" . "바림 선")
     ("煽" . "부칠 선")
     ("琁" . "옥 선")
     ("瑄" . "도리옥 선")
     ("璇" . "아름다운옥 선")
     ("璿" . "아름다운옥 선")
     ("癬" . "옴 선")
     ("禪" . "봉선 선")
     ("線" . "실 선")
     ("繕" . "기울 선")
     ("羨" . "부러워할 선")
     ("腺" . "샘 선")
     ("膳" . "반찬 선")
     ("船" . "배 선")
     ("蘚" . "이끼 선")
     ("蟬" . "매미 선")
     ("詵" . "많을 선")
     ("跣" . "맨발 선")
     ("選" . "가릴 선")
     ("還" . "돌 선")
     ("銑" . "끌 선")
     ("鐥" . "복자 선")
     ("霰" . "싸락눈 선, 별 선")
     ("饍" . "膳과 同字")
     ("鮮" . "고울 선")
     ("傓" . "매우 성할 선")
     ("僎" . "갖출 선")
     ("单" . "單의 簡體字")
     ("単" . "單의 略字")
     ("墡" . "백토 선")
     ("嫙" . "예쁠 선")
     ("尟" . "尠과 同字")
     ("尠" . "적을 선")
     ("屳" . "날 선")
     ("愃" . "쾌할 선")
     ("歚" . "고을 선")
     ("熯" . "불 이글이글할 선, 태울 선, 공경할 선")
     ("禅" . "禪의 略字")
     ("筅" . "솔 선")
     ("綫" . "線과 同字")
     ("縇" . "선두를 선")
     ("缐" . "線의 簡體字")
     ("羡" . "현이름 선")
     ("脧" . "줄일 선")
     ("蝉" . "蟬의 略字")
     ("譔" . "가르칠 선")
     ("譱" . "善의 古字")
     ("躚" . "춤출 선")
     ("鏇" . "갈이틀 선")
     ("騸" . "불깔 선")
     ("鱓" . "두렁허리 선")
     ("鱔" . "鱓의 俗字")
     ("鱻" . "생선 선"))
    ("설"
     ("卨" . "사람이름 설")
     ("屑" . "가루 설")
     ("楔" . "문설주 설")
     ("泄" . "샐 설")
     ("洩" . "샐 설")
     ("渫" . "칠 설")
     ("舌" . "혀 설")
     ("薛" . "맑은대쑥 설")
     ("褻" . "더러울 설")
     ("設" . "베풀 설")
     ("說" . "말씀 설")
     ("雪" . "눈 설")
     ("齧" . "물 설")
     ("偰" . "맑을 설")
     ("僁" . "소근거릴 설")
     ("囓" . "齧과 同字")
     ("媟" . "깔볼 설")
     ("挈" . "손에들 설")
     ("揲" . "셀 설")
     ("暬" . "설만할 설")
     ("爇" . "불사를 설")
     ("碟" . "가죽다룰 설")
     ("稧" . "볏단 설")
     ("紲" . "고삐 설")
     ("説" . "説의 略字")
     ("鱈" . "대구 설"))
    ("섬"
     ("剡" . "땅이름 섬")
     ("暹" . "해돋을 섬")
     ("殲" . "다죽일 섬")
     ("纖" . "가늘 섬")
     ("蟾" . "두꺼비 섬")
     ("贍" . "넉넉할 섬")
     ("閃" . "번쩍할 섬")
     ("陝" . "고을이름 섬")
     ("孅" . "가늘 섬")
     ("憸" . "간사할 섬")
     ("摻" . "섬섬할 섬")
     ("睒" . "번개빛 섬")
     ("繊" . "가늘 섬")
     ("譫" . "헛소리 섬")
     ("銛" . "가래 섬")
     ("韱" . "산부추 섬"))
    ("섭"
     ("攝" . "몰아 잡을 섭, 끌 섭, 단정하게 할 섭, 겸할 섭, 거둘 섭, 기록할 섭, 항복할 섭")
     ("涉" . "물 건널 섭, 지나칠 섭, 돌아다닐 섭")
     ("燮" . "불에 익힐 섭, 불꽃 섭, 조화로울 섭")
     ("葉" . "고을이름 섭")
     ("葉" . "고을이름 섭")
     ("囁" . "말하려다 멈출 섭, 중얼거릴 섭, 입 다물 섭")
     ("懾" . "무서울 섭, 두려울 섭")
     ("摂" . "懾과 同字")
     ("渉" . "涉과 同字")
     ("灄" . "흠치르르할 섭, 물이름 섭, 떼 섭")
     ("聶" . "소곤거릴 섭, 낄 섭, 성씨 섭")
     ("躞" . "족자 마구리 섭, 저벅저벅 걸을 섭")
     ("躡" . "밟을 섭, 신 신을 섭, 오를 섭")
     ("鑷" . "쪽집게 섭")
     ("顳" . "귀밑 뼈 섭"))
    ("성"
     ("城" . "보루 성, 재 성, 서울 성")
     ("姓" . "일가 성, 아이 낳을 성, 백성 성")
     ("宬" . "사고 성, 도서실 성, 창고 성")
     ("性" . "성품 성, 마음 성, 바탕 성, 색욕 성")
     ("惺" . "깨달을 성, 똑똑할 성, 조용할 성")
     ("成" . "이룰 성, 거듭 성, 마칠 성, 화목할 성")
     ("星" . "별 성, 희뜩희뜩할 성, 세월 성, 성시 성")
     ("晟" . "밝을 성, 햇살 퍼질 성")
     ("猩" . "성성이 성")
     ("珹" . "옥 이름 성, 아름다운 구슬 성")
     ("盛" . "담을 성, 이룰 성, 정제할 성, 많을 성")
     ("省" . "살필 성")
     ("筬" . "바디 성")
     ("聖" . "성인 성, 착할 성, 통할 성, 지극할 성")
     ("聲" . "소리 성, 풍류 성, 명예 성")
     ("腥" . "비린내 성, 더러울 성, 날고기 성")
     ("誠" . "미쁠 성, 공경할 성, 살필 성, 진실 성")
     ("醒" . "술 깰 성, 꿈 깰 성, 깨달을 성")
     ("垩" . "聖과 同字")
     ("声" . "聲의 俗字")
     ("瑆" . "옥빛 성, 빛날 성")
     ("騂" . "붉은 소 성, 누른말 성, 활 물쩡물쩡할 성"))
    ("세"
     ("世" . "세상 세, 평생 세, 백년 세")
     ("勢" . "권세 세, 위엄 세, 불알 세, 기회 세")
     ("彗" . "대빗자루 세")
     ("歲" . "해 세, 곡식 익을 세, 돐 세, 풍년 세")
     ("洗" . "씻을 세, 세수 그릇 세")
     ("稅" . "구실 세, 거둘 세, 놓을 세, 쉴 세")
     ("笹" . "가는 대 세")
     ("細" . "가늘 세, 작을 세, 좀놈 세")
     ("說" . "달랠 세, 쉴 세")
     ("貰" . "빌릴 세, 세 바칠 세")
     ("說" . "달랠 세, 쉴 세")
     ("卋" . "世의 古字")
     ("帨" . "차는 수건 세, 손수건 세")
     ("歳" . "歲와 同字")
     ("洒" . "씻을 세, 설치할 세")
     ("税" . "稅와 同字")
     ("繐" . "가늘고 성긴 베 세")
     ("蛻" . "매미 허물 세")
     ("蜕" . "蛻와 同字")
     ("説" . "說와 同字"))
    ("소"
     ("召" . "부를 소, 청할 소, 과부 소")
     ("哨" . "입술 비뚤어질 소, 잔말할 소")
     ("嘯" . "휘파람 소, 세게 뿜을 소, 읊을 소")
     ("塑" . "허수아비 소")
     ("宵" . "밤 소, 작을 소, 벌레이름 소")
     ("小" . "작을 소, 좁을 소, 적을 소, 어릴 소, 적게 여길 소")
     ("少" . "적을 소, 조금 소, 멸시할 소, 잠깐 소, 젊을 소")
     ("巢" . "새집 소, 집 지을 소, 새 보금자리 소, 적진 망보는 높을 수레 소, 도둑굴 소, 큰 피리 소, 채소이름 소")
     ("所" . "바 소, 곳 소, 쯤 소, 가질 소, 얼마 소")
     ("掃" . "쓸 소, 상투 소")
     ("搔" . "긁을 소, 휘저을 소, 분분할 소")
     ("昭" . "소명할 소, 소목 소, 태평세월 소")
     ("梳" . "얼레빗 소")
     ("沼" . "못 소, 늪 소")
     ("消" . "다할 소, 꺼질 소, 풀릴 소, 해어질 소")
     "涑"
     ("溯" . "거슬러 올라갈 소")
     ("瀟" . "물 맑을 소, 비바람 몰아칠 소, 강이름 소")
     ("炤" . "밝을 소")
     ("燒" . "불 붙을 소, 들불 소, 불 놓을 소")
     ("甦" . "깨어날 소, 숨 쉴 소")
     ("疋" . "밭 소")
     ("疎" . "성길 소, 드물 소")
     ("疏" . "뚫릴 소, 나눌 소, 멀 소, 추할 소, 드물 소")
     ("瘙" . "옴 소, 종기 소")
     ("笑" . "웃음 소")
     ("篠" . "가는 대 소")
     ("簫" . "퉁소 소, 활고지 소")
     ("素" . "흴 소, 생초 소, 빌 소, 바탕 소, 원래 소")
     ("紹" . "이을 소, 얽을 소, 소개할 소")
     ("肖" . "쇠약할 소, 흩어질 소")
     "蓀"
     ("蔬" . "나물 소")
     ("蕭" . "쑥 소, 쓸쓸할 소, 말 우는 소리 소, 바람소리 소")
     ("蘇" . "차조기 소, 나무할 소, 까무러칠 소, 깨어날 소, 성씨 소")
     ("訴" . "하소연할 소, 송사할 소")
     "謖"
     ("逍" . "노닐 소, 거닐 소")
     ("遡" . "거스를 소, 맞이할 소, 하소연할 소")
     ("邵" . "땅이름 소, 성씨 소")
     ("銷" . "녹을 소, 사라질 소")
     ("韶" . "아름다울 소, 이을 소, 순의 풍류 소, 봄 소")
     ("騷" . "근심스러울 소, 흔들릴 소, 급할 소, 처량할 소")
     ("佋" . "소개할 소, 사신 소, 댓수의 차례 소")
     ("俏" . "거문고 뒤치는 소리 소")
     ("傃" . "향할 소, 떳떳할 소")
     ("卲" . "높을 소, 성씨 소")
     ("咲" . "웃을 소")
     ("喿" . "새 때지어 울 소")
     ("嗉" . "멀떠구니 소")
     ("嘨" . "嘯와 同字")
     ("埽" . "쓸 소, 그릴 소, 언덕 소")
     ("塐" . "塑와 同字")
     ("愬" . "고할 소, 참소할 소, 알릴 소")
     ("捎" . "덜 소, 흔들거릴 소, 추릴 소, 버릴 소")
     ("掻" . "搔와 同字")
     ("樔" . "풀막 소, 너스레 소")
     ("泝" . "거슬러 올라갈 소, 흘러갈 소")
     ("焼" . "燒와 同字")
     ("穌" . "깨어날 소, 숨 쉴 소, 기뻐할 소")
     ("筱" . "가는 대 소")
     ("筿" . "篠와 同字")
     ("箾" . "상소 소")
     ("簘" . "簫와 同字")
     ("繅" . "고치 실 뽑을 소")
     ("翛" . "날개치는 소리 소, 모지라질 소")
     ("膆" . "살찔 소, 멀떠구니 소")
     ("艘" . "배 소")
     ("蛸" . "거미알 소, 연가시 알집 소")
     ("螦" . "배좀(穴舟蟲) 소")
     ("踈" . "疎의 譌字")
     ("酥" . "타락죽 소")
     ("霄" . "하늘 소, 진눈깨비 소")
     ("騒" . "騷와 同字")
     ("魈" . "산도깨비 소")
     ("鮹" . "문어 소, 낙지 소")
     ("鰷" . "피라미 소, 뱅어 소")
     ("鰺" . "비린내 소의 譌字"))
    ("속"
     ("俗" . "익을 속, 버릇 속, 풍속 속, 세상 속")
     ("屬" . "무리 속, 좇을 속, 붙이 속, 거느릴 속")
     ("束" . "묶을 속, 단나무 속, 약속할 속, 비단 다섯끝 속")
     ("粟" . "좁쌀 속, 겉곡식 속")
     ("續" . "이을 속")
     ("贖" . "속바칠 속, 무역할 속")
     ("速" . "빠를 속, 부를 속, 더러울 속, 사슴 발자취 속")
     ("属" . "屬의 俗字")
     ("洬" . "비 내릴(降雨) 속")
     ("続" . "續의 略字")
     ("觫" . "곱송거릴 속")
     ("遬" . "공손할 속, 줄어들 속"))
    ("손"
     ("孫" . "손자 손, 움 돋을 손, 순할 손, 피할 손")
     ("巽" . "사양할 손, 낮은체 할 손, 부드러울 손, 괘 이름 손, 동과 남의 사이방향 손")
     ("損" . "덜 손, 잃을 손, 피곤할 손, 삼갈 손, 상할 손, 괘 이름 손")
     ("遜" . "순할 손, 겸손할 손, 도망할 손, 사양할 손")
     ("飡" . "飱과 同字")
     ("餐" . "먹을 손, 물에 만 밥 손")
     ("噀" . "물 뿜을 손")
     ("巺" . "巽과 同字")
     ("飧" . "저녁밥 손, 물에 만 밥 손")
     ("飱" . "飧의 俗字"))
    ("솔"
     ("帥" . "거느릴 솔, 좇을 솔")
     ("率" . "거느릴 솔, 좇을 솔, 쓸 솔, 대강 솔, 공경할 솔, 뱀 이름 솔")
     ("乺" . "솔 솔, 땅이름 솔")
     ("窣" . "느릿느릿 걸을 솔, 우지직거릴 솔, 구멍으로 나올 솔")
     ("蟀" . "귀뚜라미 솔"))
    ("송"
     ("宋" . "송나라 송, 성씨 송")
     ("悚" . "두려울 송, 송구할 송")
     ("松" . "소나무 송, 향풀 송, 땅이름 송")
     ("淞" . "강이름 송")
     ("訟" . "송사할 송, 시비할 송, 꾸짖을 송, 괘 이름 송")
     ("誦" . "풍유할 송, 읽을 송, 말할 송, 원망할 송")
     ("送" . "보낼 송, 가질 송, 활쏘기 능통할 송, 줄 송")
     ("頌" . "기릴 송, 칭송할 송, 찬양하는 노래 송")
     ("凇" . "산유화 송")
     ("柗" . "松과 同字")
     ("竦" . "공경할 송, 두려울 송, 높일 송, 솟을 송")
     ("鬆" . "터럭 더부룩할 송"))
    ("솨"
     ("惢" . "의심낼 솨")
     "曬")
    ("쇄"
     ("刷" . "긁을 쇄, 고칠 쇄, 빗을 쇄, 문지를 쇄")
     ("灑" . "뿌릴 쇄, 깜짝 놀랄 쇄")
     ("碎" . "부술 쇄, 잘 쇄")
     ("鎖" . "자물쇠 쇄, 쇠사슬 쇄, 가둘 쇄, 항쇄 쇄")
     ("殺" . "내릴 쇄, 감할 쇄, 빠를 쇄")
     ("嗩" . "뿔나팔 쇄")
     ("瑣" . "옥가루 쇄, 가늘 쇄, 좀스러울 쇄, 대궐문 아로새길 쇄")
     ("砕" . "碎와 同字")
     ("誶" . "꾸짖을 쇄")
     ("鏁" . "긴 창 쇄"))
    ("쇠"
     "殺"
     ("衰" . "쇠할 쇠, 모손할 쇠, 약할 쇠")
     ("釗" . "사람이름 쇠"))
    ("수"
     ("修" . "닦을 수, 옳게할 수, 정리할 수, 꾸밀 수")
     ("受" . "이을 수, 얻을 수, 담을 수, 받을 수")
     ("嗽" . "기침할 수, 입가실 수")
     ("囚" . "가둘 수, 갇힐 수, 묶일 수")
     ("垂" . "드리울 수, 변방 수, 거의 수, 남길 수")
     ("壽" . "목숨 수, 장수할 수, 나이 수, 축복할 수")
     ("嫂" . "형수 수")
     ("守" . "지킬 수, 보살필 수, 원님 수, 기다릴 수")
     ("宿" . "떼별 수, 성좌 수")
     ("岫" . "바위구멍 수")
     ("峀" . "岫와 同字")
     ("帥" . "주장할 수, 장수 수")
     ("愁" . "근심 수, 염려할 수, 탄식할 수")
     ("戍" . "수자리 수, 막을 수, 집 수")
     ("手" . "손 수, 잡을 수, 칠 수")
     ("授" . "줄 수, 부칠 수")
     ("搜" . "찾을 수, 더듬을 수, 화살 빨리 가는 소리 수, 어지러울 수")
     ("收" . "모을 수, 거둘 수, 잡을 수, 수레바퀴 수")
     ("數" . "헤아릴 수, 수죄할 수, 몇 수, 이치 수")
     ("樹" . "나무 수, 막을 수, 세울 수, 심을 수")
     ("殊" . "죽을 수, 베일 수, 끊어질 수, 지나갈 수")
     ("水" . "물 수, 고를 수")
     ("洙" . "물가 수, 물읾 수")
     ("漱" . "양치질할 수, 빨래할 수")
     "潚"
     ("燧" . "봉화 수, 불 수, 나무 문질러 불낼 수")
     ("狩" . "겨울사냥 수, 순행할 수")
     ("獸" . "짐승 수")
     ("琇" . "귀막이 수, 옥돌 수")
     "琡"
     ("璲" . "서옥 수, 패옥 수")
     "璹"
     ("瘦" . "파리할 수, 가늘 수")
     ("睡" . "졸음 수, 잠 수")
     ("秀" . "빼어날 수, 이삭 수, 벼 패일 수, 아름다울 수")
     ("穗" . "이삭 수")
     ("竪" . "세울 수, 서있을 수, 더벅머리 수")
     ("粹" . "정할 수, 순수할 수")
     ("綏" . "편안할 수, 수레고삐 수, 물러갈 수, 여우모양 수")
     ("綬" . "인끈 수")
     ("繡" . "수놓을 수, 성씨 수")
     ("羞" . "부끄러울 수, 음식 수")
     ("脩" . "포 수, 길 수, 마를 수")
     ("茱" . "수유 수")
     "菽"
     ("蒐" . "꼭두서니 수, 모을 수, 숨을 수, 찾을 수")
     ("蓚" . "기쁠 수, 수산(acid) 수")
     ("藪" . "큰 늪 수, 덤불 수, 똬리 수")
     ("袖" . "소매 수")
     ("誰" . "누구 수, 무엇 수")
     ("讐" . "讎와 同字")
     ("輸" . "떨어뜨릴 수, 쏟을 수, 보낼 수, 짐바리 수")
     ("遂" . "사무칠 수, 나아갈 수, 이룰 수, 마침내 수")
     ("邃" . "깊숙할 수")
     ("酬" . "술 권할 수, 갚을 수")
     ("銖" . "저울눈 수")
     ("銹" . "동록 수")
     ("隋" . "수나라 수")
     ("隧" . "무덤길 수, 구멍 수, 길 수")
     ("隨" . "따를 수, 괘 이름 수, 나라이름 수, 맡길 수")
     ("雖" . "비록 수, 벌레이름 수")
     ("需" . "음식 수, 머뭇거릴 수, 기다릴 수, 찾을 수, 괘 이름 수")
     ("須" . "수염 수, 기다릴 수")
     ("首" . "머리 수, 먼저 수, 비롯할 수, 임금 수, 향할 수, 자백할 수")
     ("髓" . "뼛속 기름 수, 마음속 수")
     ("鬚" . "턱수염 수, 아랫수염 수")
     ("倕" . "무거울 수, 이름 수")
     ("凁" . "싸늘할 수, 얻을 수")
     ("叟" . "어른 수, 쌀 씻는 소리 수")
     ("售" . "팔 수, 갚을 수")
     ("寿" . "壽의 俗字")
     ("廋" . "숨길 수")
     ("数" . "數의 略字")
     ("晬" . "돐 수, 첫 생일 수")
     ("溲" . "오줌 수, 반족할 수, 적실 수")
     ("濉" . "睢와 同字")
     ("獣" . "獸와 同字")
     ("痩" . "瘦와 同字")
     ("睟" . "똑바로 볼 수, 윤택할 수")
     ("睢" . "물이름 수")
     ("瞍" . "소경 수, 장님 수, 판수 수")
     ("祟" . "빌미 수")
     ("籔" . "조리 수, 곡식 세는 단위 휘 수, 또아리 수")
     ("繍" . "繡와 同字")
     ("脺" . "얼굴 윤택할 수, 머리덜미 수")
     ("膄" . "파리할 수")
     ("膸" . "髓와 同字")
     ("誶" . "꾸짖을 수")
     ("讎" . "짝 수, 원수 수, 대거리할 수, 비교할 수, 갚을 수")
     ("豎" . "세울 수, 내시 수, 더벅머리 수")
     ("鏽" . "거울에 녹슬 수")
     ("陲" . "변방 수, 위태할 수")
     ("随" . "隨의 譌字")
     ("颼" . "바람소리 수")
     ("饈" . "드릴 수, 반찬 수"))
    ("숙"
     ("叔" . "아재비 숙, 주울 숙, 어릴 숙, 끝 숙")
     ("塾" . "사랑방 숙, 기숙사 숙")
     ("夙" . "이를 숙, 이미 숙, 빠를 숙, 일찍 일어날 숙")
     ("孰" . "누구 숙, 어느 숙, 살필 숙, 익을 숙")
     ("宿" . "잘 숙, 지킬 숙, 머물 숙")
     ("淑" . "맑을 숙, 착할 숙, 사모할 숙")
     ("熟" . "익힐 숙, 삶을 숙, 풍년들 숙")
     ("肅" . "공손할 숙, 공경할 숙, 경계할 숙")
     ("俶" . "비롯할 숙, 처음 숙, 지을 숙")
     ("倏" . "잠간 숙, 홀연 숙, 개의 빨리 달리는 모양 숙")
     ("倐" . "倏의 俗字")
     ("儵" . "잿빛 숙, 남해 임금 숙, 독화당할 숙, 갑자기 숙")
     ("婌" . "궁녀 벼슬이름 숙")
     ("橚" . "길고 꼿꼿할 숙")
     ("蓿" . "거여목 숙")
     ("驌" . "좋은말 숙, 숙상말 숙")
     ("骕" . "驌과 同字")
     ("鷫" . "숙상새 숙"))
    ("순"
     ("巡" . "돌 순, 순행할 순, 두루 순")
     ("徇" . "조리 돌릴 순, 따라 죽을 순, 빠를 순, 부릴 순")
     ("循" . "좇을 순, 의지할 순, 돌 순, 차례 순, 돌아다닐 순")
     ("恂" . "진실할 순, 믿을 순, 온공스러울 순")
     ("旬" . "열흘 순, 두루할 순, 고를 순, 가득할 순, 요사스런 별 순")
     ("栒" . "경쇠걸이 순, 순나무 순")
     ("楯" . "난간 순, 방패 순, 뺄 순, 상여 순")
     ("橓" . "무궁화나무 순")
     ("殉" . "죽은 사람을 따라 죽을 순, 구할 순, 좇을 순")
     ("洵" . "웅덩이물 순, 소리없이 눈물흘릴 순, 믿을 순")
     ("淳" . "맑을 순, 순박할 순")
     ("珣" . "옥그릇 순, 옥 이름 순")
     ("盾" . "방패 순, 벼슬이름 순")
     ("瞬" . "눈 깜작일 순, 잠깐 순")
     ("筍" . "죽순 순, 대싹 순")
     ("純" . "실 순, 순수할 순, 온전할 순, 부드러울 순")
     ("脣" . "입술 순")
     ("舜" . "순임금 순, 무궁화 순")
     ("荀" . "풀 이름 순, 성씨 순")
     ("蓴" . "순나물 순")
     ("蕣" . "무궁화 순")
     ("詢" . "꾀할 순, 물을 순, 믿을 순")
     ("諄" . "거듭 일러줄 순, 지극할 순")
     ("醇" . "전국술 순, 두터울 순, 삼갈 순, 순수할 순")
     ("錞" . "사발종 순")
     ("順" . "좇을 순, 부드러울 순, 차례 순, 성씨 순")
     ("馴" . "길들일 순, 착할 순")
     ("駿" . "준마 순, 클 순, 빠를 순, 높을 순")
     ("侚" . "좇을 순, 빠를 순, 조리 돌릴 순")
     ("峋" . "후미질 순")
     ("狥" . "徇의 俗字")
     ("盹" . "눈 감을 순, 졸 순")
     ("眴" . "눈짓할 순")
     ("笋" . "초목 성할 순")
     ("紃" . "신에 실선 두를 순, 실 띠 순, 법 순, 좇을 순")
     ("肫" . "광대뼈 순, 정성스러울 순")
     ("駨" . "말이 달려갈 순")
     ("鬊" . "머리 풀어헤칠 순")
     ("鶉" . "메추라기 순, 옷 해질 순"))
    ("술"
     ("戌" . "개 술, 열한째 지지 술, 때려 부술 술")
     ("術" . "재주 술, 심술부릴 술, 술법 술")
     ("述" . "이을 술, 좇을 술, 조회할 술, 밝힐 술")
     ("鉥" . "돗바늘 술, 인도할 술")
     ("噊" . "위태할 술")
     ("絉" . "끈 술, 줄 술"))
    ("숭"
     ("崇" . "높을 숭, 공경할 숭, 마칠 숭, 산이름 숭")
     ("崧" . "산 불끈 솟을 숭, 산 웅장할 숭, 산이름 숭")
     ("嵩" . "높을 숭, 산이름 숭")
     ("菘" . "배추 숭"))
    ("쉬"
     ("倅" . "버금 쉬, 아직 벼슬자리에 오르지 않은 아들 쉬, 원님 쉬")
     ("晬" . "돐 쉬, 첫 생일 쉬")
     "殳"
     "泅"
     ("淬" . "칼 담글 쉬, 물들일 쉬, 범할 쉬")
     ("焠" . "물들일 쉬, 칼날 물에 담글 쉬, 지질 쉬, 태울 쉬"))
    ("슬"
     ("瑟" . "비파 슬, 거문고 슬, 깨끗한체할 슬, 바람소리 슬")
     ("膝" . "무릎 슬, 종지뼈 슬, 치슬말 슬")
     ("蝨" . "이 슬")
     ("厀" . "膝의 本字")
     ("虱" . "蝨과 同字"))
    ("습"
     ("拾" . "주울 습, 거둘 습, 팔찌 습, 벼슬이름 습")
     ("濕" . "젖을 습, 소 귀 벌룩거릴 습, 근심 습")
     ("習" . "익힐 습, 거듭 습")
     ("褶" . "슬갑 습")
     ("襲" . "옷 덧입을 습, 벼슬 대물릴 습, 반복할 습, 합할 습, 염습할 습, 엄습할 습")
     "塍"
     ("慴" . "두려울 습, 겁낼 습")
     ("湿" . "濕과 同字")
     ("熠" . "환할 습, 선명할 습, 반딧불 반짝거릴 습")
     ("隰" . "진펄 습"))
    ("승"
     ("丞" . "이을 승, 도울 승, 벼슬의 이름 승, 향상할 승")
     ("乘" . "오를 승, 곱할 승, 셈하는 단위 승, 같은 물건 네 개 승")
     ("僧" . "중 승")
     ("勝" . "이길 승, 경치가 좋을 승, 가질 승")
     ("升" . "되 승, 오를 승, 피륙의 짜인 날을 세는 단위 새 승, 괘 이름 승")
     ("承" . "받들 승, 이을 승, 도울 승, 차례 승")
     ("昇" . "해 돋을 승, 풍년들 승")
     ("甸" . "다스릴 승, 수레 승")
     ("繩" . "노끈 승, 법 승, 다스릴 승, 이을 승")
     ("蠅" . "파리 승")
     ("陞" . "오를 승, 올릴 승")
     ("乗" . "乘의 俗字")
     ("呏" . "용량의 단위 갤런(gallon) 승")
     ("鬙" . "터럭 더부룩할 승"))
    ("싀"
     "伜")
    ("시"
     ("使" . "부릴 시, 하여금 시, 사신 시")
     ("侍" . "모실 시, 가까울 시, 좇을 시")
     ("匙" . "숟가락 시, 열쇠 시")
     ("嘶" . "말 울 시, 목 쉴 시, 울부짖을 시")
     ("始" . "비로소 시, 처음 시, 시작할 시, 별이름 시")
     ("媤" . "시집 시")
     ("寺" . "내관 시")
     ("尸" . "시동 시, 주검 시")
     ("屍" . "주검 시, 송장 시")
     ("屎" . "똥 시")
     ("市" . "저자 시, 흥정할 시, 집 많은 동리 시")
     ("弑" . "윗사람 죽일 시")
     ("恃" . "믿을 시, 의지할 시, 어머니 시")
     ("提" . "떼지어 날 시, 고을이름 시")
     ("施" . "베풀 시, 쓸 시, 더할 시, 안팎 곱사등이 시, 버릴 시, 줄 시, 은혜 시, 공로 시")
     ("是" . "이 시, 바를 시, 곧을 시")
     ("昰" . "是와 同字")
     ("時" . "때 시, 끼니 시, 이 시, 엿볼 시, 가끔 시")
     ("枾" . "柹의 本字")
     ("柴" . "섶 시, 불 땔 나무 시, 시제지낼 시")
     ("猜" . "의심낼 시, 시기할 시, 두려워할 시, 사나울 시")
     ("矢" . "살 시, 소리살 시, 곧을 시, 베풀 시, 똥 시")
     ("示" . "보일 시, 바칠 시, 가르칠 시")
     ("翅" . "날개 시, 깃 시, 뿐 시")
     ("蒔" . "소회향 시, 모종낼 시")
     ("蓍" . "뺑대쑥 시, 시초 시")
     ("視" . "볼 시, 견줄 시, 본받을 시, 대접 시")
     ("試" . "시험할 시, 더듬을 시, 비교할 시")
     ("詩" . "귀글 시, 풍류가락 시, 받들 시")
     ("諡" . "행장 시, 시호 시")
     ("豕" . "돼지 시, 돝 시")
     ("豺" . "승냥이 시, 늑대 시")
     ("飴" . "기를 시")
     ("乨" . "始의 古字")
     ("偲" . "간절히 책망할 시, 살피고 힘쓸 시, 굳셀 시")
     ("兕" . "외뿔난 소 시")
     ("凘" . "성에 시")
     ("卶" . "크게 경사스러울 시")
     ("厮" . "부릴 시, 마부 시, 나눌 시")
     ("咶" . "핥을 시, 이야기할 시")
     ("啻" . "뿐 시, 쯤 시")
     ("塒" . "홰 시")
     ("廝" . "부릴 시, 천할 시, 마부 시")
     ("弒" . "弑의 本字")
     ("枲" . "수삼 시, 도꼬마리 시")
     ("柹" . "감 시")
     ("柿" . "柹의 俗字")
     ("澌" . "물 잦을 시, 다할 시")
     ("禔" . "복 시, 편안할 시")
     ("緦" . "보름새베 시, 시마복 시, 석달복 시")
     ("翤" . "翅와 同字")
     "茬"
     ("諟" . "이 시, 살필 시, 다스릴 시")
     ("諰" . "눈 휘둥글할 시, 곧은말 시")
     ("豉" . "메주 시, 콩자반 시")
     ("釃" . "술 거를 시")
     ("鍉" . "숟가락 시, 열쇠 시")
     ("顋" . "뺨 시, 볼 시")
     ("鰣" . "준치 시"))
    ("식"
     ("埴" . "찰진흙 식, 흙 이길 식, 더듬어 걸을 식")
     ("寔" . "이 식, 참 식, 뿐 식")
     ("式" . "법 식, 쓸 식, 제도 식, 수레 앞 가로막대 식")
     ("息" . "숨쉴 식, 그칠 식, 자식 식, 기를 식")
     ("拭" . "닦을 식, 다듬을 식")
     ("植" . "심을 식, 세울 식, 초목 식")
     ("殖" . "날 식, 심을 식, 성할 식")
     ("湜" . "물 맑을 식, 엄숙할 식")
     ("熄" . "불 꺼질 식, 없어질 식, 마칠 식")
     "篒"
     ("蝕" . "벌레먹을 식, 일식 식, 월식 식")
     ("識" . "알 식")
     ("軾" . "수레앞 가로막이 나무 식, 수레 안에서 절할 식")
     ("食" . "밥 식, 먹을 식, 씹을 식, 제 식, 헛말할 식")
     ("飾" . "꾸밀 식, 문채날 식, 분 바를 식")
     ("喰" . "먹을 식")
     ("媳" . "며느리 식")
     ("栻" . "점판 식"))
    ("신"
     ("伸" . "펼 신, 다스릴 신, 기지개 신")
     ("侁" . "떼지어 갈 신")
     ("信" . "믿을 신, 밝힐 신, 맏길 신, 이틀 밤을 잘 신, 사신 신")
     ("呻" . "읊조릴 신, 끙끙거릴 신")
     ("娠" . "아이밸 신, 마부 신")
     ("宸" . "집 신, 처마 신, 대궐 신")
     ("愼" . "삼갈 신, 정성스러울 신, 고요할 신")
     ("新" . "새 신, 처음 신, 고울 신")
     ("晨" . "샛별 신, 아침을 아뢸 신")
     "瀋"
     ("燼" . "깜부기불 신, 불똥 신, 재난의 뒤 신")
     ("申" . "펼 신, 기지개켤 신, 거듭 신, 아홉째 지지 신, 원숭이 신")
     ("神" . "천신 신, 영검할 신, 신명 신, 정신 신")
     ("紳" . "큰 띠 신, 벼슬아치 신")
     ("腎" . "콩팥 신, 불알 신, 자지 신")
     ("臣" . "신하 신, 두려울 신")
     ("莘" . "약 이름 신, 많은 모양 신, 나라이름 신")
     ("薪" . "섶 신, 땔나무 신, 월급 신, 성씨 신")
     ("藎" . "갈골 신, 나아갈 신, 남을 신")
     ("蜃" . "큰 조개 신, 이무기 신, 술잔 신")
     ("訊" . "물을 신, 다스릴 신, 죄 조사할 신, 알릴 신, 꾸짖을 신")
     ("身" . "몸 신, 아이 밸 신, 몸소 신")
     ("辛" . "매울 신, 고생 신, 여덟째 천간 신")
     ("辰" . "날 신")
     ("迅" . "빠를 신, 억셀 신")
     ("辰" . "날 신")
     ("伩" . "信과 同字")
     ("兟" . "나아갈 신, 총총 들어설 신")
     ("卂" . "빠를 신, 급히 날 신")
     ("吲" . "비웃을 신")
     ("哂" . "빙그레 웃을 신, 비웃을 신")
     ("噺" . "이야기 신")
     ("囟" . "숨구멍 신, 정수리 신")
     ("姺" . "나라이름 신")
     ("汛" . "물뿌릴 신")
     ("矧" . "하물며 신, 잇속 드러날 신")
     ("脤" . "사직제 지낸 고기 신")
     ("誶" . "물을 신")
     ("贐" . "노자 신, 노수 신")
     ("頣" . "눈들고 볼 신")
     ("顖" . "囟의 俗字")
     ("駪" . "말 우물거릴 신, 빨리 걸을 신")
     ("神" . "천신 신, 영검할 신, 신명 신, 정신 신"))
    ("실"
     ("失" . "잃을 실, 그르칠 실")
     ("室" . "집 실, 아내 실")
     ("實" . "열매 실")
     ("悉" . "모두 실")
     ("実" . "實의 略字")
     ("蟋" . "귀뚜라미 실")
     ("飋" . "쓸쓸한 바람 실"))
    ("심"
     ("審" . "살필 심")
     ("尋" . "찾을 심")
     ("心" . "마음 심")
     ("沁" . "스며들 심")
     ("沈" . "성 심")
     ("深" . "깊을 심")
     ("甚" . "심할 심, 무엇 심")
     ("芯" . "등심초 심")
     ("諶" . "참 심")
     ("沈" . "성 심")
     ("伈" . "두려워할 심")
     ("吢" . "개가 토할 심")
     ("梣" . "물푸레나무 심")
     ("沉" . "沈과 同字")
     ("潯" . "물가 심")
     ("燖" . "삶을 심")
     ("葚" . "뽕나무 열매 심")
     ("諗" . "고할 심, 생각할 심, 꾀할 심")
     ("鐔" . "칼날 아래 코등이 심")
     ("鱏" . "칼철갑상어 심")
     ("鱘" . "심어 심"))
    ("십"
     ("什" . "열 사람 십")
     ("十" . "열 십, 전부 십")
     ("拾" . "十의 갖은자")
     ("拾" . "十의 갖은자")
     ("兙" . "무게의 단위 데카그램 십")
     ("卌" . "사십 십")
     ("辻" . "네거리 십"))
    ("쌍"
     ("雙" . "짝 쌍")
     ("双" . "雙의 略字"))
    ("씨"
     ("氏" . "성 씨"))
    ("아"
     ("亞" . "버금 아")
     ("俄" . "갑자기 아")
     ("兒" . "아이 아")
     ("啞" . "벙어리 아, 놀랄 아")
     ("娥" . "예쁠 아")
     ("峨" . "산 높을 아")
     ("御" . "맞을 아")
     ("我" . "자기 아")
     ("牙" . "어금니 아, 대장 기 아")
     ("芽" . "싹 아")
     ("莪" . "지칭개 아")
     ("蛾" . "누에나방 아")
     ("衙" . "마을 아")
     ("訝" . "맞아들일 아, 의심할 아")
     ("阿" . "언덕 아, 아름다울 아, 알랑거릴 아")
     ("雅" . "아담할 아")
     ("餓" . "주릴 아")
     ("鴉" . "갈가마귀 아, 검을 아")
     ("鵝" . "거위 아")
     ("丫" . "가장귀 아")
     ("亜" . "亞의 略字")
     ("俹" . "기댈 아, 의지할 아, 거만할 아")
     ("児" . "兒의 略字")
     ("厊" . "어긋날 아")
     ("哦" . "놀람의 어조사 아")
     ("唖" . "啞의 略字")
     ("唲" . "선웃음칠 아")
     ("啊" . "사랑할 아, 어조사 아")
     ("娿" . "아리따울 아")
     ("婀" . "娿와 同字")
     ("峩" . "峨와 同字")
     ("猗" . "부드러울 아")
     ("疴" . "앓을 아")
     ("砑" . "갈 아")
     ("笌" . "대싹 아")
     ("迓" . "마중할 아")
     ("錏" . "투구의 목가림 아")
     ("鵞" . "鵝와 同字"))
    ("악"
     ("堊" . "흰 흙 악")
     ("岳" . "큰 산 악")
     ("嶽" . "높은 산 악")
     ("幄" . "장막 악")
     ("惡" . "나쁠 악")
     ("愕" . "놀랄 악")
     ("握" . "잡을 악, 손아귀 악")
     ("樂" . "풍류 악")
     ("渥" . "두터울 악")
     ("葯" . "구리때 잎 악, 동일 악")
     ("鄂" . "나라이름 악")
     ("鍔" . "칼날끝 악")
     ("顎" . "턱 악")
     ("鰐" . "악어 악")
     ("齷" . "악착할 악")
     ("偓" . "거리낄 악")
     ("剭" . "형벌할 악")
     ("卾" . "윗턱 악")
     ("咢" . "놀랄 악")
     ("喔" . "닭 우는 소리 악, 아첨해 웃는 소리 악")
     ("噩" . "놀랄 악")
     ("悪" . "惡의 略字")
     ("腭" . "잇몸 악")
     ("萼" . "꽃받침 악")
     ("覨" . "오래 볼 악")
     ("諤" . "직언할 악")
     ("鶚" . "물수리 악")
     ("齶" . "잇몸 악"))
    ("안"
     "唵"
     ("安" . "편안할 안, 어찌 안")
     ("岸" . "물가 언덕 안")
     ("按" . "살필 안, 어루만질 안")
     ("晏" . "늦을 안, 편안할 안")
     ("案" . "책상 안, 생각할 안")
     ("殷" . "검붉을 안")
     ("眼" . "눈 안")
     ("諺" . "용맹스러울 안, 뻐득뻐득할 안")
     "閼"
     ("雁" . "鴈과 同字")
     ("鞍" . "안장 안")
     ("顔" . "顏과 同字")
     ("鮟" . "아귀 안")
     ("侒" . "편안할 안")
     ("偐" . "거짓 안")
     ("喭" . "추솔할 안")
     ("桉" . "案과 同字")
     ("犴" . "들개 안")
     ("贋" . "가짜 안")
     ("顏" . "얼굴 안, 색채 안")
     ("鴈" . "기러기 안"))
    ("알"
     ("按" . "막을 알")
     ("斡" . "돌릴 알, 주선할 알")
     ("謁" . "아뢸 알, 뵈올 알")
     ("軋" . "수레 삐걱거릴 알")
     ("嘎" . "새소리 알")
     ("嘠" . "嘎의 俗字")
     ("戞" . "창 알")
     ("揠" . "뽑을 알")
     ("歹" . "뼈 앙상할 알, 잔골 알, 살 발린 뼈 알")
     ("穵" . "구멍 알")
     ("訐" . "들추어 낼 알")
     ("遏" . "막을 알")
     ("頞" . "콧마루 알")
     ("鴶" . "뻐꾸기 알"))
    ("암"
     ("岩" . "巖의 俗字")
     ("巖" . "바위 암, 험할 암")
     ("庵" . "초막 암")
     ("暗" . "어두울 암, 몰래 암, 어리석을 암")
     ("癌" . "종양 암")
     ("菴" . "암자 암")
     ("闇" . "어두울 암, 어리석을 암")
     ("啽" . "잠꼬대 암")
     ("媕" . "머뭇거릴 암")
     ("嵒" . "嵓과 同字")
     ("嵓" . "바위 암, 가파를 암")
     ("揜" . "덮을 암")
     ("晻" . "어두울 암")
     ("腤" . "고기 삶을 암")
     ("葊" . "풀이름 암")
     ("蓭" . "암자 암")
     ("諳" . "욀 암")
     ("頷" . "끄덕일 암")
     ("馣" . "향기로울 암")
     ("黯" . "어두울 암"))
    ("압"
     ("壓" . "누를 압")
     ("押" . "수결 둘 압, 누를 압")
     ("狎" . "친근할 압, 업신여길 압")
     ("鴨" . "오리 압")
     ("儑" . "잔피할 압, 용렬할 압")
     ("匎" . "사치스럽지 않을 압, 검약할 압")
     "匼"
     ("压" . "圧과 同字")
     ("唈" . "숨 느껴 쉴 압")
     ("圧" . "壓의 略字"))
    ("앙"
     ("仰" . "우러를 앙")
     ("央" . "가운데 앙")
     ("怏" . "원망할 앙")
     ("昻" . "오를 앙, 밝을 앙")
     ("殃" . "재앙 앙")
     ("秧" . "모 앙")
     ("鴦" . "암원앙새 앙")
     ("佒" . "몸 거북할 앙")
     ("卬" . "자기 앙")
     ("咉" . "목메어 슬피 울 앙")
     ("坱" . "티끌 앙")
     ("昂" . "높을 앙")
     ("泱" . "끝없을 앙")
     ("盎" . "동이 앙")
     ("鞅" . "가슴걸이 앙, 소고삐 앙"))
    ("애"
     ("厓" . "언덕 애, 물가 애")
     ("哀" . "슬플 애, 가여울 애")
     ("喝" . "목 쉴 애")
     ("噫" . "트림할 애")
     ("埃" . "티끌 애, 속세 애")
     ("崖" . "낭떠러지 애")
     ("愛" . "사랑 애")
     ("曖" . "희미할 애")
     ("涯" . "물가 애")
     ("碍" . "礙의 俗字")
     ("艾" . "쑥 애")
     ("隘" . "좁을 애")
     ("靄" . "아지랭이 애")
     ("僾" . "어렴풋할 애")
     ("呃" . "재채기할 애")
     ("哎" . "애통하는 소리 애")
     ("唉" . "대답하는 소리 애")
     ("唲" . "어리광 부릴 애, 응석 부릴 애")
     ("啀" . "물어뜯을 애")
     ("嗄" . "목 쉴 애")
     ("嘊" . "비틀거릴 애")
     ("噯" . "트림할 애")
     ("娭" . "계집종 애")
     ("崕" . "崖와 同字")
     ("挨" . "밀칠 애")
     ("捱" . "막을 애")
     ("欸" . "한숨쉴 애")
     ("漄" . "물가 애")
     ("獃" . "어리석을 애")
     ("皚" . "흴 애")
     ("睚" . "눈흘길 애")
     ("瞹" . "흐릿할 애")
     ("磑" . "맷돌 애")
     ("礙" . "막을 애")
     ("薆" . "숨겨질 애")
     ("藹" . "화기로울 애")
     ("阨" . "隘와 同字")
     ("靉" . "구름낄 애")
     ("騃" . "어리석을 애, 말달릴 애"))
    ("액"
     ("厄" . "재앙 액")
     ("扼" . "움켜쥘 액")
     ("掖" . "겨드랑이에 낄 액")
     ("液" . "즙 액")
     ("縊" . "목 맬 액")
     ("腋" . "겨드랑이 액")
     ("隘" . "阨과 同字")
     ("額" . "이마 액, 수량 액")
     ("呝" . "울 액")
     ("嗌" . "呝과 同字")
     ("戹" . "좁을 액")
     ("搤" . "움켜쥘 액")
     ("阨" . "막힐 액"))
    ("앵"
     ("櫻" . "앵두나무 앵")
     ("罌" . "술병 앵")
     ("鶯" . "꾀꼬리 앵")
     ("鸚" . "앵무새 앵")
     ("嚶" . "새 소리 앵")
     ("嫈" . "예쁠 앵")
     ("桜" . "벚나무 앵")
     ("罃" . "술병 앵")
     ("鷪" . "꾀꼬리 앵"))
    ("야"
     ("也" . "단정의 어조사 야")
     ("倻" . "땅이름 야")
     ("冶" . "단련할 야, 대장장이 야")
     ("夜" . "밤 야")
     ("惹" . "끌릴 야, 어지러울 야")
     ("揶" . "희롱할 야")
     ("斜" . "고을이름 야")
     ("椰" . "야자나무 야")
     ("爺" . "아비 야, 노인 야")
     ("耶" . "의문의 어조야 야, 아비 야")
     ("若" . "땅이름 야, 지혜(범어의 음역) 야")
     "裸"
     ("邪" . "의문의 어조사 야, 희롱할 야")
     ("野" . "들판 야")
     ("若" . "땅이름 야, 지혜(범어의 음역) 야")
     ("亱" . "夜의 俗字")
     ("偌" . "성씨 야, 너무 야")
     ("喏" . "공손히 대답할 야")
     ("埜" . "들판 야"))
    ("약"
     ("弱" . "약할 약, 어릴 약")
     ("約" . "대략 약, 맹세할 약, 간소할 약, 맺을 약")
     ("若" . "같을 약, 자네 약, 만약 약")
     ("葯" . "꽃밥 약")
     ("蒻" . "구약나물 약")
     ("藥" . "약 약")
     ("躍" . "뛸 약")
     ("掠" . "노략질할 약")
     ("略" . "간략할 약, 노략질할 약, 잔꾀 약")
     ("叒" . "동방귀신나무 약")
     ("喲" . "감탄하는 어조사 약")
     ("嫋" . "가냘플 약")
     ("爚" . "스러질 약")
     ("禴" . "종묘의 여름제사 약")
     ("篛" . "죽순 약")
     ("籥" . "피리 약, 잠글 약")
     ("薬" . "藥의 略字")
     ("鑰" . "자물쇠 약")
     ("鰯" . "멸치 약, 정어리 약")
     ("鶸" . "댓닭 약, 투계 약")
     ("龠" . "피리 약"))
    ("양"
     ("佯" . "거짓 양, 어정거릴 양")
     ("壤" . "흙 양, 풍년들 양")
     ("孃" . "계집아이 양")
     ("恙" . "근심 양")
     ("揚" . "드높일 양, 칭찬할 양")
     ("攘" . "물리칠 양, 빼앗을 양")
     ("敭" . "오를 양")
     ("暘" . "해 돋을 양")
     ("楊" . "갯버들 양")
     ("樣" . "모양 양, 모범 양")
     ("洋" . "큰 바다 양, 넘칠 양")
     ("瀁" . "물결 일렁일 양")
     ("煬" . "구울 양")
     ("痒" . "가려울 양, 옴 양")
     ("瘍" . "머리헐 양, 종기 양")
     ("禳" . "푸닥거리할 양")
     ("穰" . "풍년들 양")
     ("羊" . "양 양")
     ("襄" . "오를 양, 장사지낼 양")
     ("詳" . "거짓 양")
     ("讓" . "사양할 양")
     ("釀" . "술 빚을 양")
     ("陽" . "볕 양, 드러낼 양, 시월 양, 거짓 양")
     ("養" . "기를 양, 다스릴 양, 봉양할 양")
     ("亮" . "밝을 량, 임금의 상중 량")
     ("兩" . "두 량")
     ("凉" . "서늘할 량")
     ("梁" . "들보 량, 다리 량")
     ("糧" . "양식 량")
     ("良" . "어질 량, 좋을 량, 남편 량")
     ("諒" . "헤아릴 량")
     ("量" . "헤아릴 량, 용량 량")
     ("勨" . "느즈러질 양, 힘쓸 양, 움직일 양")
     ("勷" . "급할 양")
     ("嚷" . "떠들 양")
     ("壌" . "壤의 略字")
     ("嬢" . "孃의 略字")
     ("徉" . "배회할 양")
     ("漾" . "물결 출렁거릴 양")
     ("瀼" . "이슬 많은 모양 양, 강이름 양")
     ("烊" . "구울 양, 녹일 양")
     ("癢" . "가려울 양")
     ("眻" . "눈 아름다울 양")
     ("蘘" . "양하 양")
     ("輰" . "상여수레 양")
     ("鑲" . "거푸집 속 양")
     ("颺" . "날릴 양, 높일 양")
     ("驤" . "날뛰는 말 양"))
    ("어"
     ("圄" . "가둘 어")
     ("御" . "거느릴 어")
     ("於" . "방향의 어조사 어, 대신할 어")
     ("漁" . "물고기 잡을 어")
     ("瘀" . "어혈질 어")
     ("禦" . "막을 어, 그칠 어")
     ("語" . "말씀 어")
     ("馭" . "말 부릴 어")
     ("魚" . "물고기 어")
     ("齬" . "이 어긋날 어")
     ("唹" . "고요히 웃을 어")
     ("圉" . "마부 어, 변방 어")
     ("敔" . "금할 어, 풍류그칠 어")
     ("淤" . "앙금 어, 진흙 어")
     ("飫" . "먹기 싫을 어, 배부를 어"))
    ("억"
     ("億" . "억 억, 편안할 억, 이바지할 억, 헤아릴 억, 인민 억")
     ("憶" . "생각 억")
     ("抑" . "누를 억, 억울할 억")
     ("檍" . "참죽나무 억, 박달나무 억, 싸리나무 억")
     ("臆" . "가슴 억, 가득할 억")
     ("繶" . "땋은 노 억"))
    ("언"
     ("偃" . "자빠질 언")
     ("堰" . "방죽 언")
     ("彦" . "彥과 同字")
     ("焉" . "어찌 언, 의심쩍을 언")
     ("言" . "말씀 언, 자기 언, 우뚝할 언")
     ("諺" . "상말 언")
     ("這" . "맞이할 언")
     ("傿" . "鄢과 同字")
     ("匽" . "숨길 언, 길 곁 언, 한데 뒷간 언")
     ("唁" . "위문할 언")
     ("喭" . "조문할 언")
     ("嘕" . "기꺼워할 언, 즐거워할 언, 빙그레할 언")
     ("嫣" . "생긋생긋 웃을 언")
     ("彥" . "착한 선비 언, 클 언")
     ("讞" . "죄 의논할 언")
     ("鄢" . "땅이름 언")
     ("鼴" . "두더쥐 언, 소 같은 큰 쥐 언")
     ("鼹" . "鼴과 同字"))
    ("얼"
     ("孼" . "첩자식 얼, 요물 얼")
     ("蘖" . "그루터기 얼")
     ("乻" . "땅이름 얼")
     ("噦" . "재채기할 얼")
     ("孽" . "孼과 同字")
     ("臬" . "법 얼, 문지방 얼, 과녁 얼")
     ("隉" . "위태할 얼"))
    ("엄"
     ("俺" . "자기 엄, 클 엄")
     ("儼" . "공경할 엄")
     ("嚴" . "굳셀 엄, 공경할 엄, 엄할 엄")
     ("奄" . "문득 엄, 가릴 엄, 그칠 엄, 오랠 엄")
     ("巖" . "높을 엄")
     ("掩" . "거둘 엄, 가릴 엄")
     ("淹" . "담글 엄, 오래머물 엄")
     "剦"
     ("厂" . "굴바위 엄, 기슭 엄")
     ("厱" . "언덕 비탈 엄")
     ("厳" . "嚴과 同字")
     ("噞" . "고기 우물거릴 엄")
     ("崦" . "해 지는 산 이름 엄")
     ("广" . "바윗집 엄")
     ("揜" . "찾아가질 엄, 곤박할 엄")
     ("曮" . "해 다니는 길 엄")
     ("欕" . "엄나무 엄")
     ("罨" . "그물 엄")
     ("醃" . "절일 엄, 김치 엄")
     ("閹" . "고자 엄, 내시 엄"))
    ("업"
     ("俺" . "자기 업, 클 업")
     ("嶪" . "산이 높고 웅장할 업")
     ("業" . "일 업, 위태할 업, 씩씩할 업, 벌써 업, 공경할 업")
     ("嶫" . "嶪과 同字")
     ("鄴" . "땅이름 업, 성씨 업"))
    ("엇"
     ("旕" . "땅이름 엇, 엇 엇"))
    ("에"
     ("恚" . "성낼 에, 원망할 에")
     ("曀" . "음산할 에, 가리울 에"))
    ("여"
     ("予" . "자기 여")
     ("余" . "자기 여, 남을 여")
     ("如" . "같을 여, 만약 여, 어떠할 여, 이를 여")
     ("歟" . "그런가할 어조사 여")
     ("汝" . "물 이름 여, 물에 젖을 여")
     ("璵" . "보배옥 여")
     ("礖" . "여돌 여")
     ("絮" . "성씨 여")
     ("與" . "너울너울할 여, 더불어 여, 같을 여, 미칠 여")
     ("艅" . "나룻배 여")
     ("茹" . "띠 뿌리 여, 받을 여, 헤아릴 여")
     ("蘆" . "꼭두서니 려")
     ("輿" . "수레바탕 여, 짐질 여")
     ("轝" . "輿와 同字")
     ("錄" . "사실할 려")
     ("餘" . "남을 여, 나라이름 여")
     ("勵" . "힘쓸 려, 가다듬을 려")
     ("呂" . "풍류 려, 등골뼈 려, 성씨 려")
     ("女" . "계집 녀, 시집보낼 녀")
     ("廬" . "초가 려, 움막 려")
     ("旅" . "나그네 려, 베풀 려")
     ("濾" . "씻을 려, 맑을 려")
     ("礪" . "돌 단단할 려")
     ("閭" . "마을 려")
     ("驪" . "가라말 려, 나라이름 려, 산이름 려")
     ("麗" . "고울 려, 빛날 려, 베풀 려")
     ("黎" . "무리 려, 동틀 려")
     ("与" . "與와 同字")
     ("伃" . "궁녀 벼슬이름 여, 아름다울 여")
     ("侞" . "온순할 여")
     ("玙" . "璵의 簡體字")
     ("舁" . "마주들 여")
     ("録" . "録와 同字"))
    ("역"
     ("亦" . "또 역, 모두 역")
     ("域" . "경계 역, 범위 역")
     ("役" . "부릴 역, 국경 지킬 역")
     ("易" . "바꿀 역")
     ("疫" . "염병 역")
     ("繹" . "삭일 역, 베풀 역, 실 끝 찾을 역")
     ("譯" . "통변할 역, 번역할 역")
     ("逆" . "거스를 역")
     ("驛" . "잇닿을 역, 쌀 뾰족뾰족할 역, 역말집 역")
     ("力" . "힘 력, 부지런할 력")
     ("曆" . "셀 력, 세월 력")
     ("歷" . "지낼 력, 겪을 력")
     ("轢" . "수레바퀴에 치일 력, 서로 부닥칠 력")
     ("伇" . "役의 古字")
     ("圛" . "맴돌 역")
     ("嶧" . "연달아 있는 산 역")
     ("懌" . "기꺼울 역")
     ("淢" . "빨리 흐를 역")
     ("訳" . "譯의 略字")
     ("閾" . "문지방 역")
     ("駅" . "驛의 略字"))
    ("연"
     ("嚥" . "침 삼킬 연, 목구멍 연")
     ("堧" . "빈 땅 연")
     ("姸" . "고을 연, 사랑스러울 연")
     ("娟" . "어여쁠 연, 춤추는 모양 연")
     ("宴" . "잔치할 연, 편안할 연")
     ("延" . "미칠 연, 닿을 연")
     ("挻" . "당길 연, 달아날 연, 손바닥으로 칠 연")
     ("捐" . "버릴 연, 병들어 죽을 연")
     ("揀" . "가릴 련, 분별할 련")
     ("椽" . "서까래 연")
     ("沇" . "물 졸졸 흐를 연")
     ("沿" . "물 따라 내려갈 연, 좇을 연")
     ("涎" . "침 연, 물 졸졸 흐를 연")
     ("涓" . "물방울 떨어질 연, 조촐할 연")
     ("淵" . "못 연, 깊을 연, 북소리 둥둥할 연, 모래톱 연")
     ("演" . "펼칠 연, 긴 물줄기 연, 통할 연, 윤택할 연, 넓힐 연")
     ("烟" . "煙과 同字")
     "焰"
     ("然" . "불사를 연, 그러할 연, 허락할 연, 그러나 연")
     ("煙" . "연기 연")
     ("燃" . "불사를 연, 연등절 연")
     ("燕" . "제비 연, 편안할 연, 잔치 연, 나라이름 연")
     ("硏" . "연마할 연")
     ("硯" . "벼루 연, 돌 연")
     ("筵" . "대자리 연")
     ("緣" . "인연 연, 서두를 연")
     ("縯" . "길 연, 늘일 연")
     ("羨" . "광중길 연")
     ("衍" . "성할 연, 넓을 연, 물이 넘칠 연, 상자 연, 아름다울 연, 흐를 연")
     ("軟" . "부드러울 연")
     ("鉛" . "납 연, 분 연")
     ("鳶" . "솔개 연")
     ("年" . "해 년, 나이 년, 나아갈 년")
     ("憐" . "불쌍할 련, 사랑할 련")
     ("戀" . "생각할 련, 사모할 련")
     ("撚" . "잡을 년, 닦을 년, 밟을 년, 손 끝으로 비빌 년")
     ("漣" . "물 놀이칠 련, 눈물 줄줄 흘릴 련")
     ("煉" . "쇠 불릴 련, 반죽할 련")
     ("璉" . "종묘 제기 련")
     ("秊" . "年의 本字")
     ("練" . "이길 련, 익힐 련, 겪을 련")
     ("聯" . "잇닿을 련, 관계할 련")
     ("輦" . "당길 련, 궁중의 길 련")
     ("蓮" . "연밥 련, 연꽃 련")
     ("連" . "이을 련, 끌릴 련")
     ("鍊" . "불린 쇠 련, 단련할 련")
     ("偄" . "연약할 연, 공손할 연")
     ("兖" . "兗의 俗字")
     ("兗" . "고을이름 연, 믿을 연, 단정할 연")
     ("唌" . "참소할 연")
     ("嘫" . "대답할 연")
     ("噮" . "몹시 달 연")
     ("囦" . "물 깊을 연")
     ("埏" . "땅 가장자리 연")
     ("妍" . "姸과 同字")
     ("姢" . "娟과 同字")
     ("嬿" . "아름다울 연")
     ("悁" . "분할 연, 근심할 연")
     ("掾" . "아전 연, 기인할 연")
     ("曣" . "더울 연, 청명할 연")
     ("櫞" . "연나무 연")
     ("渷" . "물 이름 연")
     "焔"
     ("研" . "硏과 同字")
     ("縁" . "緣과 同字")
     "羡"
     ("臙" . "목구멍 연, 연지 연")
     ("莚" . "만연할 연, 풀 이름 연")
     ("蜵" . "우렁찰 연, 벌레 이름 연")
     ("蠕" . "벌레 기어갈 연")
     ("讌" . "잔치 연, 모여 말할 연")
     ("豣" . "노루 연")
     ("鷰" . "제비 연, 씨름 연"))
    ("열"
     ("咽" . "목 멜 열, 막힐 열")
     ("悅" . "즐거울 열, 복종할 열, 성씨 열")
     ("熱" . "뜨거울 열, 쏠릴 열")
     ("說" . "기꺼울 열")
     ("閱" . "겪을 열, 군대 점호할 열, 용납할 열")
     ("列" . "벌릴 렬, 무리에 들어갈 렬, 항렬 렬, 베풀 렬")
     ("劣" . "용렬할 렬, 못날 렬, 어릴 렬, 서툴 렬")
     ("咽" . "목 멜 열, 막힐 열")
     ("烈" . "불 활활 붙을 렬, 빛날 렬, 업적 렬, 아름다울 렬, 사나울 렬")
     ("裂" . "찢어질 렬, 비단 자투리 렬")
     ("說" . "기꺼울 열")
     ("吶" . "말 느리게 할 열, 함성 지를 열")
     ("呐" . "吶과 同字")
     ("噎" . "목 멜 열")
     ("悦" . "悅의 略字")
     ("説" . "說의 略字")
     ("閲" . "閱의 略字"))
    ("염"
     ("厭" . "넉넉할 염, 아름다울 염, 게으를 염, 만족할 염, 미워할 염")
     ("染" . "꼭두서니 염, 물들일 염")
     ("炎" . "불꽃 염, 임금의 호 염")
     ("琰" . "아름다운 옥 염, 비취옥 염")
     ("稔" . "풍년들 염, 오랠 염, 해 염")
     ("艶" . "고울 염, 얼굴 탐스러울 염")
     ("苒" . "풀 우거질 염, 덧없을 염")
     ("閻" . "마을 염, 항간 염, 저승 염")
     ("髥" . "구레나룻 염")
     ("鹽" . "소금 염, 절일 염, 후렴 염")
     ("廉" . "맑을 렴, 조촐할 렴, 청렴할 렴, 살필 렴")
     ("念" . "생각할 념, 읽을 념, 스물 념, 대단히 짧은시각 념")
     ("捻" . "손가락으로 찍을 념")
     ("殮" . "염할 염")
     ("簾" . "발 렴")
     ("冄" . "冉과 同字")
     ("冉" . "가는 털 늘어질 염, 남생이 등 언저리 염, 침노할 염")
     ("塩" . "鹽의 俗字")
     ("懕" . "편안할 염")
     ("扊" . "문 빗장 염")
     ("檶" . "개수통 염")
     ("檿" . "산뽕나무 염")
     ("灎" . "灩의 俗字")
     ("灧" . "灩의 俗字")
     ("灩" . "물 그득할 염, 물결 출렁거릴 염")
     ("艷" . "艷의 本字")
     ("釅" . "술맛 텁텁할 염")
     ("饜" . "싫을 염, 물릴 염")
     ("髯" . "髥의 俗字")
     ("魘" . "잠꼬대할 염")
     ("黶" . "검은 사마귀 염"))
    ("엽"
     ("厭" . "제사할 엽, 모을 엽, 덜 엽, 누를 엽, 축하할 엽, 괴로울 엽, 숨길 엽")
     ("攝" . "가질 녑, 고요할 녑")
     ("曄" . "빛날 엽, 번개 번쩍거릴 엽")
     ("燁" . "불 이글글할 엽, 번쩍번쩍할 엽")
     ("葉" . "잎 엽, 세대 엽, 성씨 엽")
     ("獵" . "사냥할 렵, 진동할 렵, 어긋날 렵, 바람소리 렵")
     ("偞" . "가벼울 엽, 낮을 엽, 얼굴 예쁠 엽")
     ("僷" . "얼굴 예쁠 엽, 펴지 않을 엽")
     ("喦" . "땅 이름 엽, 다툴 엽")
     ("囁" . "소곤거릴 엽")
     ("摂" . "囁의 略字")
     ("曅" . "曄과 同字")
     ("熀" . "불빛 이글이글할 녑")
     ("爗" . "불 이글글할 엽, 번쩍번쩍할 엽")
     ("靨" . "웃는 볼 옴쏙 들어갈 엽, 얼굴의 검은 사마귀 엽"))
    ("영"
     ("塋" . "무덤 영")
     ("嶸" . "산 높을 영")
     ("影" . "그림자 영, 형상 영")
     ("映" . "비칠 영, 빛날 영")
     ("景" . "그림자 영, 옷 영")
     ("暎" . "비칠 영")
     ("楹" . "기둥 영, 하관들 영")
     ("榮" . "영화로울 영, 오동나무 영, 추녀 영, 꽃다울 영")
     ("永" . "길 영, 오랠 영")
     ("泳" . "헤엄칠 영")
     ("渶" . "물 맑을 영")
     ("潁" . "물 이름 영, 성씨 영")
     ("濚" . "물 돌아나갈 영")
     ("瀛" . "큰 바다 영, 신선 사는 산 영")
     ("瀯" . "물소리 영, 물 돌아나갈 영, 물웅덩이 영")
     ("煐" . "빛날 영")
     ("營" . "지을 영, 헤아릴 영, 다스릴 영, 진 영")
     ("獰" . "모질 녕, 영악할 녕, 삽살개 털 녕")
     ("瑛" . "옥빛 영, 수정 영")
     ("瑩" . "귀막이 옥 영, 밝을 영")
     ("瓔" . "옥돌 영, 구슬 목걸이 영")
     ("盈" . "가득할 영, 넘칠 영, 물 흐를 영")
     ("穎" . "이삭 영, 송곳 끝 영, 빼어날 영")
     ("纓" . "갓끈 영, 말 가슴걸이 영, 얽힐 영")
     ("英" . "꽃부리 영, 영웅 영, 구름 뭉게뭉게 일어날 영, 아름다울 영")
     ("詠" . "읊을 영")
     ("迎" . "맞을 영")
     ("鍈" . "방울소리 영")
     ("霙" . "눈꽃 영, 구름 피어오를 영")
     ("令" . "하여금 령, 시킬 령, 가령 령, 개 목소리 령, 벼슬이름 령")
     ("囹" . "감옥 령")
     ("寧" . "편안할 녕, 차라리 녕, 어찌 녕")
     ("嶺" . "고개 령, 봉우리 령")
     ("怜" . "영리할 령")
     ("玲" . "옥소리 쟁그렁거릴 령, 아롱아롱할 령, 정교할 령")
     ("瑩" . "귀막이 옥 영, 밝을 영")
     ("羚" . "영양 령, 큰 뿔 양 령")
     ("聆" . "들을 령, 깨달을 령")
     ("鈴" . "방울 령")
     ("零" . "부서질 령, 비뚝비뚝 떨어질 령, 셈 나머지 령")
     ("靈" . "신령 령, 혼백 령, 좋을 령")
     ("領" . "옷깃 령, 고개 령, 거느릴 령, 받을 령")
     ("咏" . "노래할 영, 읊을 영")
     ("営" . "榮과 同字")
     ("嬰" . "어릴 영, 더할 영, 머리치장할 영, 물요괴 영")
     ("嬴" . "성씨 영, 풀어낼 영, 가득할 영, 아름다울 영")
     ("栄" . "榮과 同字")
     ("浧" . "잠길 영, 앙금 영")
     ("溁" . "濚과 同字")
     ("濴" . "물 졸졸 흐를 영")
     ("癭" . "목 혹 영")
     ("碤" . "물 속 돌 영")
     ("縈" . "얽힐 영, 맬 영")
     ("蠑" . "도마뱀 영")
     ("贏" . "이문 남길 영, 멜 영, 자랄 영")
     ("郢" . "땅이름 영")
     ("锳" . "鍈과 同字")
     ("韺" . "풍류이름 영"))
    ("예"
     ("乂" . "풀 벨 예, 다스릴 예")
     ("倪" . "어릴 예, 도울 예, 끝 예")
     ("兌" . "날카로울 예")
     ("刈" . "풀 벨 예, 죽일 예")
     ("叡" . "밝을 예, 임금 예, 어질 예")
     ("曳" . "끌 예, 당길 예, 천천히 할 예")
     ("汭" . "물 이름 예, 물 굽이 예")
     ("泄" . "내칠 예, 날개 훨훨칠 예, 흩을 예")
     ("洩" . "퍼질 예, 날개 훨훨칠 예")
     ("濊" . "흐릴 예, 물 넘칠 예")
     ("猊" . "사자 예")
     ("睿" . "슬기로울 예, 밝을 예, 통할 예")
     ("穢" . "더러울 예, 거칠 예")
     ("芮" . "풀 뾰족뾰족할 예, 물가 예, 방패끈 예, 나라이름 예, 성씨 예")
     ("芸" . "藝의 略字")
     ("藝" . "재주 예, 글 예, 가늠할 예, 극진할 예, 심을 예")
     ("蘂" . "蕊와 同字")
     ("裔" . "옷 뒷자락 예, 변방 예, 후손 예")
     ("詣" . "이를 예, 나아갈 예, 학문 통달할 예")
     ("譽" . "칭찬할 예, 이름날 예, 즐길 예")
     ("豫" . "기쁠 예, 편안할 예, 미리 예")
     ("銳" . "날카로울 예, 까끄라기 예")
     ("霓" . "암무지개 예")
     ("預" . "미리 예, 참여할 예")
     ("例" . "본보기 례, 견줄 례, 대부분 례")
     ("禮" . "예도 례, 인사 례")
     ("醴" . "단술 례, 고을이름 례")
     ("隸" . "종 례, 노비 례, 검열할 례")
     ("兑" . "兌와 同字")
     ("勩" . "수고로울 예")
     ("医" . "화살통 예")
     ("呭" . "말 수다스럴 예")
     ("囈" . "잠꼬대할 예, 헛소리할 예")
     ("嫛" . "유순할 예, 갓난아이 예")
     ("拽" . "당길 예")
     ("掜" . "부칠 예, 비길 예, 잡을 예, 당길 예")
     ("枘" . "자루 예")
     ("獩" . "민족이름 예")
     ("睨" . "흘겨볼 예, 해 기울어질 예")
     ("瞖" . "눈에 백태 낄 예")
     ("繄" . "검푸른 비단 예, 탄식하는 소리 예")
     ("翳" . "어조사 예, 깃 일산 예, 가려 숨길 예, 새이름 예")
     ("苅" . "벨 예, 자를 예")
     ("蕊" . "꽃술 예, 꽃 예")
     ("蕋" . "蕊의 俗字")
     ("薉" . "더러울 예")
     ("蚋" . "모기 예")
     ("蜺" . "말매미 예, 암무지개 예")
     ("誉" . "誉와 同字")
     ("鋭" . "鋭와 同字")
     ("鯢" . "암고래 예")
     ("鷖" . "갈매기 예, 봉황 예")
     ("麑" . "아기사슴 예, 사자 예"))
    ("옌"
     "円")
    ("오"
     ("五" . "다섯 오")
     ("伍" . "五의 갖은자, 다섯 사람 오, 무리 오")
     ("俉" . "맞이할 오")
     ("傲" . "업신여길 오, 즐길 오")
     ("午" . "낮 오, 남쪽 오, 말 오")
     ("吳" . "오나라 오, 큰소리 지를 오, 성씨 오")
     ("吾" . "자기 오, 아들 오")
     ("嗚" . "탄식할 오")
     ("塢" . "산 언덕 오, 마을 오")
     ("墺" . "방 구들 오, 물가 언덕 오")
     ("夭" . "끊어 죽일 오, 어릴 오")
     ("奧" . "속 오, 비밀 오, 깊을 오")
     ("娛" . "즐거울 오")
     ("寤" . "잠 깨어날 오, 깨달을 오")
     ("悟" . "깨우칠 오")
     ("惡" . "미워할 오, 부끄러울 오")
     ("懊" . "원망할 오, 번뇌할 오")
     ("敖" . "희롱할 오, 거만할 오")
     ("於" . "오홉다 외칠 오")
     ("旿" . "밝을 오")
     ("晤" . "밝을 오, 만날 오")
     ("梧" . "머귀나무 오, 버틸 오")
     ("汚" . "더러울 오, 웅덩이 오")
     ("澳" . "깊을 오, 물 이름 오")
     ("烏" . "까마귀 오, 검을 오, 어찌 오, 탄식할 오")
     ("熬" . "볶을 오, 애 끓는 소리 오")
     ("獒" . "사나운 개 오")
     ("筽" . "버들 고리 오")
     ("蜈" . "지네 오")
     ("誤" . "그릇할 오")
     ("迂" . "굽을 오, 피할 오")
     ("鰲" . "큰 자라 오")
     ("鼇" . "매우 큰 자라 오")
     ("惡" . "미워할 오, 부끄러울 오")
     ("仵" . "짝 오, 같을 오")
     ("俣" . "갈래질 오")
     ("吴" . "吳와 同字")
     ("呉" . "吳와 同字")
     ("唔" . "글 읽는 소리 오")
     ("啎" . "거스를 오")
     ("嗷" . "여럿이 걱정할 오")
     ("嗸" . "슬픈 소리 오")
     ("噁" . "성낼 오")
     ("圬" . "흙손 오")
     ("奥" . "奧와 同字")
     ("娯" . "娛와 同字")
     ("媪" . "할미 오, 땅귀신 오")
     ("嫯" . "업신여길 오")
     ("忢" . "悟의 古字")
     ("忤" . "거스릴 오, 미워할 오")
     ("悪" . "惡의 略字")
     ("慠" . "거만할 오")
     ("捂" . "부닥칠 오, 거스릴 오")
     ("汙" . "汚와 同字")
     ("污" . "汚와 同字")
     ("窹" . "아궁이 오")
     ("聱" . "못 들은채 할 오, 말 더듬거릴 오")
     ("茣" . "차조기 오")
     ("襖" . "도포 오")
     ("謷" . "중얼거릴 오, 거만할 오")
     ("迃" . "迂의 本字")
     ("迕" . "만날 오, 어길 오")
     ("遨" . "노닐 오")
     ("鄔" . "성 이름 오")
     ("鏊" . "번철 오")
     ("鏖" . "무찌를 오, 구리동이 오")
     ("隩" . "감출 오, 물가 언덕 오")
     ("驁" . "준마 오, 깔볼 오")
     ("鼯" . "날다람쥐 오"))
    ("옥"
     ("墺" . "방 구들 옥, 물가 언덕 옥")
     ("屋" . "집 옥, 지붕 옥, 거북 덮개 옥")
     ("沃" . "기름질 옥, 부드러울 옥, 손 씻을 옥, 아리따울 옥")
     "澳"
     ("獄" . "감옥 옥")
     ("玉" . "구슬 옥, 사랑할 옥, 이룰 옥")
     ("鈺" . "보배 옥")
     ("阿" . "누구 옥")
     ("剭" . "목 벨 옥")
     ("鋈" . "은 올릴 옥"))
    ("온"
     ("溫" . "따뜻할 온, 부드러울 온")
     ("瑥" . "사람이름 온")
     ("瘟" . "염병 온, 온역 온")
     ("穩" . "편안할 온, 곡식 걷어 모을 온")
     ("縕" . "모시 온, 묵은 솜 온")
     ("蘊" . "마름 온, 쌓일 온")
     ("媼" . "할미 온, 노파 온, 땅귀신 온")
     ("愠" . "慍의 俗字")
     ("慍" . "성낼 온, 병 온")
     ("昷" . "어질 온")
     ("氲" . "氳의 俗字")
     ("氳" . "기운 어릴 온, 기운 성할 온")
     ("温" . "溫의 俗字")
     ("熅" . "서린 연기 온, 따뜻할 온, 숯불 온")
     ("稳" . "穩의 俗字")
     ("穏" . "穩과 同字")
     ("緼" . "縕의 俗字")
     ("缊" . "縕과 同字")
     ("蕰" . "薀의 俗字")
     ("薀" . "마름 온, 쌓일 온")
     ("藴" . "蘊의 俗字")
     ("轀" . "온량차 온")
     ("醖" . "醞의 俗字")
     ("醞" . "술 빚을 온")
     "鞰"
     ("韞" . "감출 온, 붉은 빛 온")
     ("饂" . "밀 국수 온")
     ("鰮" . "멸치 온"))
    ("올"
     ("兀" . "우뚝할 올, 움직이지 않을 올")
     "乯"
     ("卼" . "위태할 올")
     ("嗢" . "목 멜 올")
     ("膃" . "해구 올, 살찔 올")
     ("阢" . "험할 올")
     ("兀" . "우뚝할 올, 움직이지 않을 올"))
    ("옹"
     ("壅" . "막을 옹, 북돋울 옹")
     ("擁" . "안을 옹, 품을 옹, 가질 옹")
     ("瓮" . "항아리 옹")
     ("甕" . "항아리 옹, 물장군 옹")
     ("翁" . "늙은이 옹, 새 목털 아래 옹")
     ("邕" . "막힐 옹, 사람이름 옹")
     ("雍" . "조화로울 옹, 학교 옹")
     ("饔" . "아침밥 옹")
     ("喁" . "물고기 입 오물거릴 옹")
     ("嗈" . "기러기 짝지어 울 옹")
     ("嗡" . "소 울음소리 옹, 벌레소리 옹")
     ("噰" . "화한 소리 옹")
     ("廱" . "벽옹 옹")
     ("滃" . "구름 피어 오를 옹, 안개 자욱할 옹")
     ("癕" . "등창 옹")
     ("禺" . "땅 이름 옹")
     ("罋" . "甕과 同字")
     ("蓊" . "옹풀 옹, 우거질 옹")
     ("雝" . "조화로울 옹, 학교 옹")
     ("顒" . "우러를 옹"))
    ("와"
     ("渦" . "소용돌이 와, 시끄러울 와")
     ("瓦" . "질그릇 와, 기와 와")
     ("窩" . "굴 와, 움집 와")
     ("窪" . "도랑 와, 깊을 와")
     ("臥" . "누울 와, 쉴 와")
     ("蛙" . "개구리 와")
     ("蝸" . "달팽이 와")
     ("訛" . "거짓말 와, 어긋날 와")
     ("吪" . "움직일 와, 거짓말 와, 사투리 와")
     ("哇" . "음란한 소리 와, 게울 와")
     "啝"
     ("囮" . "새 후릴 와")
     ("婐" . "정숙할 와, 단정할 와")
     ("枙" . "옹이 와")
     ("洼" . "물 이름 와")
     ("猧" . "와개 와")
     ("窊" . "웅덩이 와")
     ("萵" . "상추 와, 부루 와")
     ("譌" . "거짓 와, 와전될 와, 요사스런 말 와"))
    ("완"
     ("婉" . "순할 완, 예쁠 완, 젊을 완")
     ("完" . "완전할 완, 끝날 완, 지킬 완")
     ("宛" . "어슴푸레할 완, 언덕 위 언덕 완")
     ("梡" . "네 발 도마 완, 토막나무 완")
     ("椀" . "주발 완, 사발 완")
     ("浣" . "옷 빨 완, 씻을 완")
     ("玩" . "희롱할 완, 보배 완")
     "琓"
     ("琬" . "보석 완, 아름다운 옥 완")
     ("碗" . "그릇 완")
     ("緩" . "느즈러질 완, 더딜 완")
     ("翫" . "익숙할 완, 싫을 완, 구경할 완")
     ("脘" . "중완 완")
     ("腕" . "팔뚝 완")
     ("莞" . "빙그레 웃는 모양 완")
     ("豌" . "동부 완, 완두 완")
     ("關" . "화살 먹일 완, 문지방 완, 빗장 완")
     ("阮" . "성씨 완")
     ("頑" . "완고할 완, 완악할 완")
     ("刓" . "깎을 완")
     ("剜" . "깎을 완")
     ("唍" . "방긋 웃을 완")
     ("园" . "둥글게 깎을 완")
     ("垸" . "회 섞어 바를 완")
     ("妧" . "좋을 완, 고울 완")
     ("岏" . "산 뾰족할 완")
     ("忨" . "탐할 완, 사랑할 완")
     ("惋" . "한탄할 완, 놀라 탄식할 완")
     ("涴" . "물 굽이쳐 흐를 완, 진흙 묻을 완")
     ("盌" . "은 바리 완")
     ("関" . "關과 同字")
     ("闗" . "關의 俗字"))
    ("왈"
     ("曰" . "가로되 왈"))
    ("왕"
     ("往" . "갈 왕, 옛 왕, 이따금 왕")
     ("旺" . "고울 왕, 해무리 왕, 성할 왕")
     ("枉" . "굽을 왕, 원통할 왕")
     ("汪" . "물 출렁출렁할 왕, 연못 왕")
     ("王" . "임금 왕, 할아버지 왕")
     ("皇" . "엄숙할 왕")
     ("尫" . "절름발이 왕, 파리할 왕, 천상바라기 왕")
     ("瀇" . "아득할 왕, 넓을 왕, 고인 물 썪어 냄새날 왕")
     ("迋" . "갈 왕, 두려울 왕")
     ("迬" . "往과 同字"))
    ("왜"
     ("倭" . "나라이름 왜")
     ("娃" . "어여쁜 계집 왜, 얼굴 아름다울 왜")
     ("歪" . "기울 왜, 비뚤 왜")
     ("矮" . "난장이 왜")
     ("蛙" . "개구리 왜, 음란한 소리 왜")
     ("媧" . "여자이름 왜"))
    ("외"
     ("外" . "바깥 외, 다를 외, 잃을 외, 아버지 외")
     ("嵬" . "산 뾰족할 외, 산 울뚝질뚝할 외")
     ("巍" . "높을 외, 높고 튼 모양 외")
     ("歪" . "기울 외, 비뚤 외")
     ("猥" . "더러울 외, 굽을 외, 섞일 외, 개 새끼 셋 낳을 외")
     ("畏" . "두려울 외, 겁낼 외")
     ("偎" . "사랑할 외, 가물거릴 외")
     ("崴" . "평평치 아니할 외")
     ("嵔" . "산이름 외, 산 높을 외")
     ("渨" . "더러울 외")
     ("煨" . "불에 묻어 구울 외, 그슬릴 외, 사람이름 외")
     ("碨" . "돌 자갈 땅 외, 바위 옹두라지 외")
     ("磈" . "돌 사닥다리 외")
     ("聵" . "배냇귀머거리 외")
     ("隈" . "모퉁이 외")
     ("隗" . "높을 외, 성씨 외"))
    ("요"
     ("僥" . "거짓 요, 난장이 요")
     ("凹" . "오목할 요")
     ("堯" . "높을 요, 요임금 요")
     ("夭" . "어여쁠 요, 무성할 요, 재앙 요, 일찍 죽을 요, 뱃속에 든 아이 요, 끊어 죽일 요")
     ("妖" . "요괴로울 요, 생긋생긋 웃는 모양 요")
     ("姚" . "어여쁠 요, 날랠 요, 멀 요")
     ("嶢" . "높을 요")
     ("拗" . "고집스러울 요")
     ("搖" . "흔들 요, 회오리 바람 요, 별이름 요")
     ("撓" . "긁을 뇨, 흔들 뇨, 궁할 뇨")
     ("擾" . "길들일 요, 번거로울 요")
     ("曜" . "해 비칠 요, 요일 요")
     ("杳" . "아득할 요, 깊을 요, 고요할 요")
     ("樂" . "좋아할 요")
     ("橈" . "노 요")
     ("燿" . "비칠 요, 빛날 요")
     ("瑤" . "아름다운 옥 요, 못 이름 요")
     ("窈" . "고요할 요, 깊을 요")
     ("窯" . "기와가마 요, 오지그릇 요")
     ("約" . "약속할 요")
     "縟"
     ("繇" . "따를 요, 성할 요")
     ("繞" . "얽힐 요, 둘릴 요")
     ("耀" . "빛날 요")
     ("腰" . "허리 요")
     ("蟯" . "촌백충 요")
     "褥"
     ("要" . "구할 요, 살필 요, 언약할 요, 허리 요, 기다릴 요, 부를 요, 반드시 요")
     ("謠" . "노래 요, 소문 요")
     ("遙" . "멀 요, 노닐 요")
     ("邀" . "맞을 요, 구할 요, 부를 요")
     ("陶" . "화락할 요, 순임금의 신하 요")
     ("饒" . "용서할 요, 배부를 요")
     ("了" . "마칠 료, 깨달을 료")
     ("僚" . "벗 료, 어여쁠 료")
     ("寮" . "동관 료, 관리 료, 중의 집 료")
     ("尿" . "오줌 뇨")
     ("料" . "말질할 료, 헤아릴 료, 대금 료")
     ("樂" . "좋아할 요")
     ("燎" . "뜰에 세운 횃불 료, 풀 태울 료")
     ("療" . "병 나을 료, 병 고칠 료")
     ("蓼" . "병 나을 료")
     ("遼" . "멀 료, 강이름 료, 나라이름 료")
     ("么" . "幺의 俗字")
     ("偠" . "허리 가늘 요")
     ("傜" . "부릴 요, 별이름 요")
     ("匋" . "기오 굽는 가마 요")
     ("吆" . "애통하는 소리 요")
     ("喓" . "벌레소리 요")
     ("嗂" . "기꺼울 요")
     ("坳" . "凹와 同字")
     ("墝" . "메마른 밭 요, 자갈 땅 요")
     ("嬈" . "예쁜체 할 요")
     ("尭" . "堯와 同字")
     ("峣" . "嶢와 同字")
     ("幺" . "작을 요, 어릴 요")
     ("徭" . "부릴 요")
     ("徼" . "돌아다닐 요, 순라 요, 변방 요, 구할 요")
     ("殀" . "단명할 요")
     ("澆" . "걸찰 요, 물 끌어올 요")
     ("瑶" . "瑤와 同字")
     ("祅" . "재앙 요")
     ("穾" . "깊숙할 요, 골방 요")
     ("窅" . "움펑눈 요, 까마득할 요")
     ("蕘" . "나무할 요, 거칠 요")
     ("遶" . "둘릴 요")
     ("鰩" . "날치 요")
     ("鷂" . "장끼 요, 새매 요")
     ("齩" . "뼈 깨물 요"))
    ("욕"
     ("慾" . "욕심낼 욕, 하고자할 욕")
     ("欲" . "욕심낼 욕, 하고자할 욕")
     ("浴" . "깨끗이할 욕, 못 이름 욕")
     ("谷" . "성씨 욕, 나라이름 욕")
     ("辱" . "욕될 욕, 굽힐 욕")
     ("嗕" . "오랑캐 이름 욕")
     ("溽" . "유월 더위 욕, 무더울 욕")
     ("蓐" . "새싹 욕, 가을 맡은 귀신 욕"))
    ("용"
     ("俑" . "시체와 함께 매장하는 허수아비 인형 용")
     ("傭" . "머슴 용, 지을 용, 삯 용")
     ("冗" . "宂과 同字")
     ("勇" . "날랠 용, 용맹할 용")
     ("埇" . "골목길 용, 길 돋울 용")
     ("墉" . "작은 성 용, 담벽 용")
     ("容" . "얼굴 용, 감쌀 용, 용서할 용")
     ("庸" . "쓸 용, 떳떳할 용, 수고로울 용, 어리석을 용, 물도랑 용")
     ("慂" . "권할 용, 거들어 말할 용")
     ("桶" . "곡식 셈하는 단위 휘 용")
     ("榕" . "용나무 용")
     ("涌" . "물 넘칠 용, 날칠 용")
     ("湧" . "涌의 俗字")
     ("溶" . "물 질펀히 흐를 용, 녹일 용")
     ("熔" . "鎔의 俗字")
     ("瑢" . "패옥소리 용")
     ("用" . "쓸 용, 재물 용, 통할 용")
     ("甬" . "물 솟아 오를 용, 골목길 용, 쇠북 꼭지 용, 곡식 셈하는 단위 휘 용")
     "癰"
     ("聳" . "솟을 용, 귀먹을 용, 공경할 용")
     ("茸" . "풀 뾰죽뾰죽 날 용, 못생길 용")
     ("蓉" . "연꽃 용, 약 이름 용")
     ("踊" . "뛸 용, 뒤축 없는 신 용")
     ("鎔" . "불릴 용, 녹일 용, 거푸집 용")
     ("鏞" . "큰 쇠북 용")
     ("頌" . "얼굴 용, 모양 용")
     ("龍" . "용 룡, 임금 룡")
     ("傛" . "혁혁할 용, 몸 굽힐 용")
     ("宂" . "번잡할 용, 바쁠 용, 떠돌아 다닐 용")
     ("嵱" . "봉우리 쭝굿쭝굿할 용")
     ("慵" . "게으를 용")
     ("憃" . "천치 용")
     ("槦" . "병기 얹는 시렁 용")
     ("硧" . "숫돌 용")
     ("舂" . "방아 찧을 용, 쇠북소리 용, 해가 질 용")
     ("蛹" . "번데기 용")
     ("踴" . "뛸 용")
     ("鱅" . "용어 용"))
    ("우"
     ("于" . "갈 우, 여기 우, 만족할 우, 탄식의 어조사 우")
     ("佑" . "도울 우")
     ("偶" . "짝지울 우, 무리 우, 뜻밖에 우")
     ("優" . "넉넉할 우, 부드러울 우, 나을 우, 결단성 없을 우")
     ("區" . "경계 우, 저울 네 눈 우, 숨길 우")
     ("又" . "또 우, 용서할 우")
     ("友" . "벗 우, 합할 우")
     ("右" . "오른쪽 우, 높일 우, 강할 우, 도울 우")
     ("宇" . "집 우, 처마 기슭 우, 하늘 우")
     ("寓" . "살 우, 부탁할 우, 빙자할 우")
     ("尤" . "가장 우, 더욱 우, 탓할 우")
     ("愚" . "어리석을 우, 어두울 우, 업신여길 우")
     ("憂" . "근심 우, 상제될 우, 병 우")
     ("旴" . "해 돋을 우, 새벽 우")
     ("樞" . "느름나무 우")
     ("牛" . "소 우, 별 이름 우")
     ("玗" . "옥돌 우, 우기나무 우")
     ("瑀" . "옥돌 우")
     ("盂" . "바리 우, 사냥하는 진 우")
     ("祐" . "도울 우, 다행할 우")
     "禑"
     ("禹" . "하우씨 우, 성씨 우, 느릴 우")
     ("紆" . "얽힐 우, 굽을 우")
     ("羽" . "깃 우, 오음의 하나 우")
     ("芋" . "토란 우")
     ("藕" . "연뿌리 우")
     ("虞" . "염려할 우, 즐거울 우, 갖출 우, 우제 지낼 우")
     ("迂" . "굽을 우, 피할 우, 멀 우")
     ("遇" . "만날 우, 대접할 우, 뜻밖에 우")
     ("郵" . "역말 우, 지날 우, 우편 우")
     ("釪" . "요령 우, 바리때 우")
     ("隅" . "모퉁이 우, 기슭 우")
     ("雨" . "비 우")
     ("雩" . "기우제 우")
     ("亏" . "于의 本字")
     ("区" . "區와 同字")
     ("吘" . "부를 우")
     ("吽" . "개 싸울 우, 개 짖는 소리 우")
     ("喁" . "서로 부를 우")
     ("噢" . "슬퍼할 우")
     ("噳" . "뭇 사슴 우물거릴 우")
     ("嚘" . "말 얼버무릴 우, 탄식할 우")
     ("竽" . "큰 생황 우")
     ("耦" . "쟁기 우, 겨리 우, 짝 맞을 우")
     ("耰" . "고무래 우, 곰방메 우")
     ("謣" . "망령되게 말할 우")
     ("踽" . "타달거릴 우")
     ("鍝" . "귀고리 우")
     ("麀" . "암사슴 우")
     ("麌" . "숫사슴 우")
     ("齲" . "충치 우")
     ("羽" . "깃 우, 오음의 하나 우"))
    ("욱"
     ("勖" . "힘쓸 욱")
     ("奧" . "따스할 욱, 모퉁이 욱")
     ("彧" . "빛날 욱, 문채날 욱")
     ("旭" . "빛날 욱, 햇살 치밀 욱, 교만할 욱")
     ("昱" . "햇빛 밝을 욱")
     ("栯" . "산앵두 욱")
     ("煜" . "비칠 욱, 불꽃 욱, 성할 욱")
     ("稶" . "서직 무성할 욱")
     ("郁" . "문채날 욱, 자욱할 욱")
     ("頊" . "머리 굽실거릴 욱, 별이름 욱")
     ("勗" . "勖의 譌字")
     ("噢" . "슬퍼할 욱")
     ("奥" . "奧의 俗字")
     ("燠" . "더울 욱"))
    ("운"
     ("云" . "이를 운, 움직일 운, 돌아갈 운")
     ("暈" . "무리 운, 어지러울 운")
     ("橒" . "나무 무늬 운")
     ("殞" . "죽을 운, 떨어질 운")
     ("澐" . "큰 물결 운")
     ("熉" . "누른 빛 운")
     ("耘" . "길 맬 운")
     ("芸" . "향풀 운, 궁궁이 운, 촘촘할 운, 성씨 운")
     ("蕓" . "운풀 운, 평지 운")
     ("運" . "움직일 운, 운수 운")
     ("隕" . "떨어질 운, 곤란할 운")
     ("雲" . "구름 운, 팔대손 운, 하늘 운")
     ("韻" . "울림 운, 소리 맞을 운, 운 운")
     ("暈" . "무리 운, 어지러울 운")
     ("喗" . "입 클 운, 이빨 더러울 운")
     ("囩" . "돌릴 운")
     ("惲" . "의논할 운, 혼후할 운")
     ("沄" . "물 콸콸 흐를 운, 끓을 운")
     ("篔" . "왕대나무 운")
     ("紜" . "얼크러질 운")
     ("霣" . "떨어질 운, 천둥에 비 몰아올 운")
     ("韵" . "韻과 同字"))
    ("울"
     "亐"
     ("尉" . "성씨 울")
     ("蔚" . "고을이름 울")
     ("鬱" . "향기로운 풀 울")
     ("鬰" . "鬱과 同字"))
    ("웅"
     ("熊" . "곰 웅, 빛날 웅")
     ("雄" . "수컷 웅, 영웅 웅, 웅장할 웅"))
    ("원"
     ("元" . "으뜸 원, 착하고 어질 원, 일 년의 첫 날 원, 임금 원, 백성 원, 하늘 원")
     ("円" . "圓의 俗字")
     ("原" . "근본 원, 거듭 원, 언덕 원, 기인할 원, 들판 원")
     ("員" . "관원 원, 둥글 원")
     ("園" . "동산 원, 능 원, 울타리 원")
     ("圓" . "둥글 원, 원만할 원, 화폐의 단위 원")
     ("垣" . "낮은 담 원, 보호하는 사람 원, 별 이름 원")
     ("媛" . "아리따운 여자 원, 여자 벼슬이름 원")
     ("嫄" . "여자이름 원")
     ("宛" . "서쪽 나라이름 원")
     ("寃" . "원통할 원, 굽힐 원, 죄 없을 원")
     ("怨" . "원망할 원, 원수 원, 분낼 원")
     ("愿" . "정성 원, 착할 원, 삼갈 원")
     ("援" . "당길 원, 사다리 원, 구원할 원")
     ("沅" . "물 이름 원")
     ("洹" . "흐를 원, 물 이름 원")
     ("湲" . "물소리 원, 물 졸졸 흐를 원")
     ("源" . "근원 원, 샘 원, 계속할 원")
     ("爰" . "당길 원, 이끌 원, 가로되 원")
     ("猿" . "원숭이 원, 잔나비 원")
     ("瑗" . "도리옥 원, 구멍 큰 둥근 옥 원")
     ("苑" . "나랏동산 원, 큰 바람 원")
     ("袁" . "옷 치렁거릴 원, 성씨 원")
     ("轅" . "진문 원, 멍에 원, 별 이름 원")
     ("遠" . "멀 원, 심오할 원")
     ("阮" . "원나라 원, 성씨 원")
     ("院" . "원집 원, 공해 원, 절 원, 학교 원")
     ("隕" . "폭원 원")
     ("願" . "하고자할 원, 바랄 원, 생각할 원")
     ("鴛" . "숫원앙새 원")
     ("阮" . "원나라 원, 성씨 원")
     ("冤" . "원통할 원, 원한 원")
     ("厵" . "源과 同字")
     ("圎" . "圓의 俗字")
     ("圜" . "옥담 원, 둥글 원, 제단 원")
     ("杬" . "몸 주무를 원, 나무이름 원")
     ("楥" . "떡갈나무 원, 실감개 원, 신골 원")
     "楦"
     ("猨" . "猿과 同字")
     ("綩" . "갓끈 원, 분홍빛 옷 원, 그물 원")
     ("芫" . "고기 잡는 풀 원, 여뀌 원")
     ("薗" . "園과 同字")
     ("蜿" . "굼틀거릴 원")
     ("諢" . "농담 원")
     ("謜" . "천천히 말할 원, 기꺼울 원")
     ("逺" . "遠과 同字")
     ("鋺" . "저울 바탕 원")
     ("騵" . "배 희고 갈기 검은 말 원")
     ("鵷" . "원추새 원")
     ("黿" . "큰 자라 원"))
    ("월"
     ("月" . "달 월")
     ("越" . "넘을 월, 뛸 월, 월나라 월")
     ("鉞" . "도끼 월")
     ("刖" . "발꿈치 자를 월")
     ("粤" . "말 내킬 월, 곰곰히 생각할 월, 나라이름 월")
     ("粵" . "粤과 同字"))
    ("위"
     ("位" . "벼슬 위, 임금의 신분 위, 자리 위, 방위 위")
     ("倭" . "순한 모양 위, 빙글 돌아올 위")
     ("偉" . "클 위, 넉넉할 위, 기특할 위")
     ("僞" . "거짓 위, 속일 위")
     ("危" . "위태할 위, 무너질 위, 상할 위, 높을 위, 별 이름 위")
     ("圍" . "둘레 위, 에워 쌀 위, 한아람 위, 지킬 위")
     ("委" . "맡길 위, 버릴 위, 맘에 든든할 위, 벼이삭 고개 숙일 위")
     ("威" . "위엄 위, 두려울 위")
     ("尉" . "벼슬이름 위, 눌릴 위")
     ("慰" . "위로할 위")
     ("暐" . "햇빛 위, 빛 환할 위")
     ("渭" . "물 이름 위, 속 끓일 위")
     ("爲" . "할 위, 다스릴 위, 하여금 위, 어미원숭이 위, 이룰 위")
     ("瑋" . "위옥 위, 노리개 위")
     ("緯" . "씨줄 위, 별 오른편으로 돌 위")
     ("胃" . "밥통 위, 별 이름 위, 성씨 위")
     ("萎" . "마를 위, 풀 이름 위, 쇠약해질 위")
     ("葦" . "갈대 위, 작은 배 위")
     ("蔚" . "제비쑥 위, 초목 우거진 모양 위, 잔무늬 위")
     ("蔿" . "풀 위, 성씨 위, 고을이름 위")
     ("蝟" . "고슴도치 위")
     ("衛" . "衞와 同字")
     ("褘" . "휘장 위, 아름다울 위")
     ("謂" . "고할 위, 이를 위")
     ("違" . "어길 위, 미적거릴 위, 되돌아올 위")
     ("韋" . "다룬 가죽 위, 훌부들할 위, 군복 위, 성씨 위")
     ("魏" . "위나라 위, 대궐 위, 우뚝할 위")
     ("偽" . "僞의 略字")
     ("厃" . "우러러 볼 위, 평고대 위")
     ("叞" . "안위할 위, 다리미 위")
     ("喟" . "한숨쉴 위")
     ("噅" . "거짓말 위, 곱사등이 위")
     ("噕" . "噅와 同字")
     ("囗" . "圍의 古字")
     ("囲" . "圍의 略字")
     ("幃" . "향낭 위, 홑휘장 위")
     ("為" . "爲와 同字")
     ("煒" . "벌그레할 위, 환할 위")
     ("熨" . "다리미 위, 고약 붙일 위")
     ("痿" . "습병 위, 잘름거릴 위, 음위증 위")
     ("葳" . "초목 성할 위, 위유풀 위")
     ("蒍" . "蔿와 同字")
     ("衞" . "막을 위, 지킬 위, 핏기운 위, 나라이름 위")
     ("袆" . "褘와 同字")
     ("諉" . "핑계할 위, 버릴 위")
     ("逶" . "비틀거릴 위")
     ("闈" . "대궐안의 문 위")
     ("韙" . "옳을 위")
     ("韡" . "꽃 환히 필 위")
     ("餧" . "먹일 위"))
    ("유"
     ("乳" . "젖 유, 종유석 유, 낳을 유, 젖먹일 유, 기를 유")
     ("侑" . "도울 유, 권할 유, 귀인을 모시고 밥먹을 유")
     ("儒" . "선비 유, 나장이 유, 유도 유, 광대 유")
     ("兪" . "그럴 유, 대답할 유, 공손할 유")
     ("唯" . "오직 유, 허락할 유")
     ("喩" . "깨우쳐 줄 유, 알릴 유, 비유할 유")
     "壘"
     ("孺" . "젖먹이 유, 사모할 유, 딸릴 유")
     ("宥" . "너그러울 유, 죄 사할 유, 도울 유")
     ("幼" . "어릴 유, 사랑할 유")
     ("幽" . "숨을 유, 그윽할 유, 적을 유, 어두울 유, 귀신 유, 저승 유")
     ("庾" . "노적 유, 곡식 셈하는 단위 휘 유")
     ("悠" . "멀 유, 생각할 유, 한가할 유, 근심할 유")
     ("惟" . "꾀할 유, 오직 유, 생각할 유")
     ("愈" . "나을 유, 어질 유, 더욱 유, 병 나을 유")
     ("愉" . "기뻐할 유, 즐거울 유")
     ("懦" . "만만할 유, 나약할 유")
     ("揄" . "당길 유, 칭찬할 유, 희롱할 유")
     ("攸" . "곳 유, 휙 달아날 유, 아득할 유, 대롱거릴 유")
     ("有" . "있을 유, 얻을 유, 과연 유, 또 유")
     ("柔" . "부드러울 유, 순할 유, 복종할 유")
     ("柚" . "유자 유")
     ("楡" . "느름나무 유, 서쪽 유")
     ("楢" . "부드러운 나무 유, 홰 유")
     ("油" . "기름 유, 구름 피어오를 유, 공손할 유")
     ("洧" . "물이름 유")
     ("游" . "헤엄칠 유, 노닐 유, 깃발 유")
     ("濡" . "적실 유, 막힐 유, 곱고 윤택할 유")
     ("猶" . "어미 원숭이 유, 같을 유, 오히려 유")
     ("猷" . "꾀 유, 그릴 유, 옳을 유, 탄식할 유")
     ("瑜" . "아름다운 옥 유")
     ("由" . "말미암을 유, 쓸 유, 지날 유")
     ("癒" . "병 나을 유, 병들 유")
     ("綏" . "깃발 늘어질 유")
     ("維" . "벼리 유, 이을 유, 맺을 유, 오직 유")
     ("繆" . "어그러질 류")
     ("肉" . "둘레 유, 저울추 유, 살찔 유")
     ("臾" . "잠간 유, 착할 유, 나라이름 유, 활이 뒤로 젖혀질 유")
     ("萸" . "수유 유")
     ("裕" . "넉넉할 유, 너그러울 유")
     ("誘" . "꾀일 유, 가르칠 유, 당길 유")
     ("諛" . "아첨할 유")
     ("諭" . "고할 유, 비유할 유")
     ("踰" . "넘을 유")
     ("蹂" . "밟을 유, 쌀 씻을 유")
     ("逾" . "갈 유, 지날 유")
     ("遊" . "놀 유, 벗 사귈 유")
     ("遺" . "잃어버릴 유, 남을 유, 끼칠 유")
     ("酉" . "별 유, 열째 지지 유, 나아갈 유")
     ("釉" . "물건 빛날 유")
     ("鍮" . "놋쇠 유")
     ("劉" . "이길 류, 죽일 류, 베풀 류, 성씨 류")
     ("杻" . "싸리 뉴")
     ("柳" . "버들 류, 별 이름 류")
     ("流" . "흐를 류, 번져나갈 류, 구할 류, 내칠 류, 달아날 류, 무리 류, 귀양보낼 류")
     ("溜" . "처마물 류, 낙수물 류, 증류수 류")
     ("琉" . "유리돌 류, 나라이름 류")
     ("留" . "머무를 류, 그칠 류, 오랠 류, 횡사할 류")
     ("硫" . "석류황 류, 유황 류")
     ("紐" . "단추 뉴, 맺을 뉴")
     ("類" . "같을 류, 나눌 류, 착할 류, 무리 류")
     ("丣" . "酉의 古字")
     "亏"
     "亴"
     "俁"
     ("俞" . "兪의 俗字")
     "偊"
     ("冘" . "머뭇거릴 유, 갈 유")
     ("匬" . "곡식 셈하는 단위 휘 유")
     ("卣" . "중술통 유")
     "吁"
     ("呦" . "사슴 우는 소리 유, 새짐승 우는 소리 유")
     ("唀" . "誘와 同字")
     ("喻" . "喩와 同字")
     ("嚅" . "말 머뭇거릴 유, 잔말할 유")
     ("囿" . "엔담 유, 고루할 유")
     "堣"
     ("壝" . "토담 유, 단 둘러쌓은 담 유")
     "嵎"
     ("帷" . "휘장 유")
     "庽"
     ("揉" . "풀 유, 부드럽게 할 유, 희일 유")
     ("斿" . "깃발 유, 깃술 유, 면류관술 유")
     "杅"
     ("榆" . "楡와 同字")
     ("泑" . "물빛이 검을 유, 물이름 유")
     ("牖" . "엇살창 유, 들창 유, 밝을 유, 인도할 유")
     "疣"
     ("瘉" . "癒와 同字")
     ("瘐" . "죄인 주려 죽을 유")
     "盱"
     ("窬" . "판장문 유")
     ("窳" . "이지러질 유, 약할 유, 짐승이름 유")
     ("籲" . "부르짖을 유")
     ("糅" . "섞일 유, 얽힐 유, 잡곡밥 유")
     ("緌" . "관 끈 늘어질 유")
     ("腴" . "아랫배 살찔 유")
     ("莠" . "가라지 유, 추할 유")
     ("蕕" . "냄새나는 풀 유, 유풀 유")
     ("蕤" . "더북할 유")
     ("蚰" . "노래기 유, 땅지네 유")
     ("蚴" . "굼틀거릴 유")
     ("蝤" . "하루살이 유")
     ("蠕" . "굼실거릴 유")
     ("褕" . "꿩의 깃으로 꾸민 옷 유, 쾌자 유")
     ("襦" . "저고리 유, 베쐐기 갓장이 유")
     ("讉" . "성낼 유")
     ("逌" . "빙그레할 유")
     ("逰" . "遊의 俗字")
     ("鞣" . "다룬 가죽 유, 마른 가죽 유")
     ("鮪" . "상어 유")
     ("黝" . "검푸를 유, 검은칠할 유")
     ("鼬" . "청서 유, 족제비 유")
     ("龥" . "부르짖을 유"))
    ("육"
     ("堉" . "기름진 땅 육")
     ("毓" . "기를 육, 어릴 육, 많을 육")
     ("粥" . "팔 육, 북쪽 오랑캐 육")
     ("肉" . "고기 육, 몸 육")
     ("育" . "기를 육, 날 육, 자랄 육")
     ("六" . "여섯 륙, 나라이름 륙")
     ("戮" . "죽일 륙, 육시할 륙, 욕할 륙")
     ("陸" . "뭍 륙, 길 륙, 어긋날 륙, 뛸 륙, 두터울 륙")
     ("儥" . "팔 육, 길 육")
     ("唷" . "소리지를 육")
     ("喅" . "뭇 소리 육"))
    ("윤"
     ("允" . "미쁠 윤, 마땅할 윤, 옳게 여길 윤, 좇을 윤, 허락할 윤")
     ("勻" . "가지런할 윤, 적을 윤")
     ("奫" . "물 깊을 윤, 물이 충충할 윤")
     ("尹" . "다스릴 윤, 바를 윤, 벼슬이름 윤, 믿을 윤")
     ("玧" . "귀막이 구슬 윤")
     ("胤" . "맏아들 윤, 익힐 윤")
     ("論" . "차례 륜")
     ("贇" . "예쁠 윤, 아름다울 윤")
     ("鈗" . "창 윤")
     ("倫" . "인륜 륜, 무리 륜, 조리 륜, 의리 륜, 가릴 륜")
     ("崙" . "곤륜산 륜, 나라이름 륜")
     ("淪" . "빠질 륜, 물놀이칠 륜, 거느릴 륜")
     ("輪" . "바퀴 륜, 땅 길이 륜, 우렁찰 륜, 서릴 륜, 둘레 륜")
     ("匀" . "勻과 同字")
     ("昀" . "햇빛 윤")
     ("赟" . "贇의 簡體字")
     ("鋆" . "금(貴金) 윤"))
    ("율"
     ("聿" . "마침내 율, 지을 율, 오직 율, 스스로 율, 붓 율")
     ("律" . "법 률, 풍률 률, 지을 률, 저울질할 률")
     ("慄" . "두려울 률, 쭈그릴 률, 슬플 률, 떨 률")
     ("栗" . "밤 률, 신주 재목 률, 단단할 률, 무서울 률, 공손할 률")
     ("率" . "헤아릴 률, 과녁 률, 홀 한껏 다릴 률")
     ("凓" . "찬 기운 률")
     ("噊" . "위태할 율")
     ("汩" . "물 흐를 율, 빨리 걸을 율, 환할 율, 북 울릴 율, 걸을 율")
     ("潏" . "물 흐를 율")
     ("矞" . "송곳질할 율, 상서구름 율, 궤휼할 율, 귀신이름 율"))
    ("융"
     ("戎" . "병장기 융, 싸움수레 융, 클 융, 너 융, 도울 융, 서쪽 오랑캐 융")
     ("瀜" . "물 깊을 륭")
     ("絨" . "삶은 실 융, 가는 베 융")
     ("融" . "부드러울 융, 밝을 융, 융통할 융, 불길 위로 오를 융, 귀신이름 융")
     ("隆" . "성할 륭, 높을 륭, 가운데 우뚝할 륭, 괘 이름 륭")
     ("狨" . "원숭이 융"))
    ("윽"
     "厼")
    ("은"
     ("圻" . "언덕 은")
     ("垠" . "언덕 은, 하늘 가장자리 은, 경계 은")
     ("恩" . "은혜 은, 신세 은, 사랑할 은")
     ("慇" . "은근할 은, 공손할 은, 간절할 은")
     ("殷" . "많을 은, 무리 은, 클 은, 가운데 은, 은나라 은, 융성할 은, 천둥소리 은")
     ("言" . "심사 화평할 은")
     ("誾" . "화평할 은")
     ("銀" . "은 은, 돈 은")
     ("隱" . "숨을 은, 아낄 은, 속걱정할 은, 불쌍히 여길 은, 점칠 은, 의지할 은, 쌓을 은")
     ("听" . "벙긋거릴 은, 들을 은, 입이 큰 모양 은")
     ("嚚" . "어리석을 은, 말다툼할 은, 불칙하게 말할 은")
     ("圁" . "물이름 은")
     ("垽" . "해감 은, 찌끼 은")
     ("憖" . "물을 은, 공근할 은, 힘쓸 은, 서러워할 은")
     ("檼" . "집 마룻대 은, 대공 은")
     ("溵" . "물소리 은, 물이름 은")
     ("狺" . "뭇 개 짖는 소리 은")
     ("珢" . "옥돌 은")
     ("癮" . "두드러기 은")
     ("訔" . "시비할 은")
     ("訚" . "誾과 同字")
     ("鄞" . "땅이름 은")
     ("隐" . "隱과 同字")
     ("隠" . "隱의 俗字")
     ("齗" . "잇몸 은, 말다툼할 은, 미워할 은"))
    ("을"
     ("乙" . "새 을, 천간 이름 을, 굽힐 을, 생선의 창자 을, 모모 을")
     ("鳦" . "제비 을"))
    ("음"
     ("吟" . "읊을 음, 끙끙거릴 음, 탄식할 음, 턱 끄덕거릴 음, 노래할 음, 말 더듬을 음, 울 음")
     ("岑" . "기슭 음, 언덕 음, 낭떠러지 음")
     ("淫" . "방탕할 음, 간음할 음, 음란할 음, 넘칠 음, 적실 음, 오랠 음")
     ("蔭" . "덮을 음, 가릴 음, 그늘 음")
     ("陰" . "음기 음, 부인에게 예 가르칠 음, 몰래 음, 세월 음")
     ("音" . "소리 음, 편지 음, 음악 음")
     ("飮" . "마실 음")
     ("吽" . "소 울 음")
     ("喑" . "소리지를 음, 안간힘 쓸 음, 목 쉴 음")
     ("婬" . "간통할 음, 새서방질할 음, 음탕할 음")
     ("崟" . "멧부리 음, 산 높을 음")
     ("廕" . "덮을 음")
     ("愔" . "조용할 음, 화평할 음")
     ("霪" . "장마 음")
     ("飲" . "飮과 同字"))
    ("읍"
     ("揖" . "읍할 읍, 나아갈 읍, 깍지낄 읍, 공손할 읍")
     ("泣" . "눈물 줄줄 흘릴 읍, 부글부글 끓는 소리 읍")
     ("煜" . "비칠 읍, 불꽃 읍, 성할 읍, 불빛 비칠 읍")
     ("邑" . "고을 읍, 답답할 읍")
     ("俋" . "날쌜 읍, 밭 가는 모양 읍")
     ("唈" . "숨 느껴쉴 읍")
     ("悒" . "답답할 읍, 근심할 읍")
     ("挹" . "잡아당길 읍, 잔질할 읍")
     ("浥" . "젖을 읍, 흠치르르할 읍"))
    ("응"
     ("凝" . "엉길 응, 이룰 응, 열중할 응")
     ("應" . "응당 응, 꼭 응, 사랑할 응, 대답할 응")
     ("疑" . "정할 응")
     ("膺" . "가슴 응, 친할 응, 당할 응, 응할 응, 받을 응")
     ("鷹" . "매 응")
     ("応" . "應의 略字"))
    ("의"
     ("依" . "의지할 의, 기댈 의, 비슷할 의, 따를 의, 비유할 의, 병풍 의")
     ("倚" . "기댈 의, 의지할 의, 믿을 의")
     ("儀" . "꼴 의, 모양 의, 법도 의, 좋을 의")
     ("宜" . "옳을 의, 마땅할 의, 유순할 의")
     ("崖" . "언덕 의")
     ("意" . "뜻 의, 생각 의, 의리 의, 형세 의")
     ("懿" . "아름다울 의, 클 의")
     ("擬" . "의논할 의, 헤아릴 의, 흡사할 의")
     ("椅" . "가래나무 의, 교의 의")
     ("毅" . "굳셀 의, 발끈 성낼 의")
     ("涯" . "물가 언덕 의, 물이름 의")
     ("疑" . "의심할 의, 두려워할 의, 그럴듯할 의")
     ("矣" . "말 그칠 의")
     ("縊" . "목 맬 의")
     ("義" . "옳을 의, 의리 의, 뜻 의")
     ("艤" . "배 닿을 의")
     ("薏" . "연밥 의, 율무 의")
     ("蟻" . "왕개미 의, 검을 의, 술구더기 의")
     ("衣" . "옷 의, 입을 의")
     ("誼" . "옳을 의, 다스릴 의")
     ("議" . "말할 의, 의논할 의, 꾀할 의")
     ("醫" . "의원 의, 병 고칠 의")
     ("錡" . "세발 가마 의, 쇠뇌틀 의, 휘뚝거릴 의")
     ("亄" . "탐할 의, 인색할 의, 아낄 의")
     ("偯" . "울음 끝소리 의")
     ("儗" . "서로 못믿을 의, 참람할 의")
     ("冝" . "宜의 俗字")
     ("凒" . "눈서리 쌓일 의")
     ("劓" . "코 베일 의, 베일 의")
     ("医" . "醫의 略字")
     ("吚" . "탄식할 의, 신음할 의")
     ("嶷" . "산이름 의")
     ("欹" . "아름답다할 의, 거룩하다할 의")
     ("漪" . "물놀이칠 의")
     ("猗" . "불 깐 개 의, 탄식할 의, 길 의")
     ("礒" . "바위 의")
     ("螘" . "목 매어 죽는 벌레 의")
     ("锜" . "錡와 同字")
     ("饐" . "밥 쉴 의"))
    ("읫"
     "夞")
    ("이"
     ("二" . "두 이, 풍신 이, 같을 이, 의심할 이")
     ("以" . "써 이, 쓸 이, 까닭 이, 함께 이, 거느릴 이")
     ("伊" . "저 이, 이 이, 오직 이, 답답할 이, 성씨 이")
     ("台" . "자신 이, 기쁠 이, 기를 이")
     ("夷" . "동쪽 오랑캐 이, 평평할 이, 기꺼울 이, 상할 이, 베풀 이, 괘 이름 이")
     ("姨" . "이모 이, 처이모 이")
     ("寅" . "공경할 이, 범 이, 동북 이")
     ("已" . "이미 이, 그칠 이, 버릴 이, 너무 이")
     ("弛" . "늦출 이, 활 부릴 이, 방탕할 이, 해이할 이")
     ("彛" . "彝의 俗字")
     ("怡" . "기쁠 이, 즐거울 이")
     ("施" . "비뚤어질 이, 옮길 이, 잘난체할 이, 벗을 이, 미칠 이")
     ("易" . "쉬울 이, 다스릴 이, 게으를 이, 편할 이")
     ("爾" . "너 이, 가까울 이, 오직 이")
     ("珥" . "귀막이 옥 이, 귀고리 이, 해무리 이")
     ("異" . "다를 이, 괴이할 이, 나눌 이")
     ("痍" . "상할 이, 다칠 이, 흠집 이")
     ("移" . "옮길 이, 모낼 이, 변할 이")
     ("而" . "순접의 어조사 이, 너 이, 말이을 이, 이에 이")
     ("耳" . "귀 이, 조자리 이, 말 그칠 이, 여덟대 손자 이")
     ("肄" . "익힐 이, 수고할 이, 휘추리 이, 곁가지 이")
     ("苡" . "율무 이, 질경이 이")
     ("荑" . "흰 비름 이, 베일 이")
     ("蛇" . "든든할 이")
     ("貳" . "二의 갖은자, 버금 이, 의심낼 이, 마음 변할 이, 이별할 이")
     ("貽" . "끼칠 이, 줄 이")
     ("邇" . "가까울 이")
     ("飴" . "엿 이")
     ("餌" . "미끼 이, 이깝 이, 먹일 이, 흰떡 이")
     ("利" . "날카로울 리, 이로울 리, 탐할 리, 편리할 리, 이자 리")
     ("吏" . "아전 리, 관리 리")
     ("履" . "가죽신 리, 신을 리, 밟을 리")
     ("易" . "쉬울 이, 다스릴 이, 게으를 이, 편할 이")
     ("李" . "오얏 리, 선비 천거리할 리, 역말 리, 보따리 리")
     ("梨" . "배 리, 벌레이름 리")
     ("泥" . "진흙 니, 물이 더러워질 니, 흙손 니, 술취할 니, 이슬 맺힐 니")
     ("理" . "다스릴 리, 바를 리, 누늬낼 리, 성품 리, 이치 리, 고칠 리, 나무결 리")
     ("痢" . "이질 리, 곱똥 리, 설사 리")
     ("罹" . "만날 리, 근심할 리, 걸릴 리")
     ("裏" . "옷 안 리, 속 리")
     ("裡" . "裏의 俗字")
     ("里" . "마을 리, 근심할 리, 잇수 리")
     ("離" . "떠날 리, 베풀 리, 지날 리, 아름다울 리, 둘 리, 외손 리")
     ("佁" . "미련스러울 이")
     ("佴" . "버금 이")
     ("侇" . "무리 이, 주검 이")
     ("刵" . "귀 베일 이")
     ("勩" . "수고로울 이")
     ("匜" . "손대야 이, 술잔 이")
     ("咡" . "입 어귀 이")
     ("咦" . "크게 부를 이, 웃을 이")
     ("咿" . "선웃음칠 이, 책 읽는 소리 이")
     "嗌"
     ("坨" . "땅이름 이")
     ("尓" . "爾와 同字")
     ("尔" . "爾와 同字")
     ("弍" . "二의 古字")
     ("彝" . "떳떳할 이, 법 이, 종묘 제기 이, 술통 이")
     ("彞" . "彛와 同字")
     ("敡" . "업신여길 이, 쉽게 말할 이")
     ("栮" . "버섯 이, 느타리 이")
     ("洟" . "콧물 이, 눈물 이, 못이름 이")
     ("珆" . "옥돌 이")
     ("訑" . "자랑할 이")
     ("詑" . "자랑할 이")
     ("詒" . "줄 이, 느른할 이")
     ("迤" . "든든할 이")
     ("迩" . "邇의 俗字")
     ("隶" . "밑 이")
     ("頉" . "기를 이")
     ("頤" . "턱 이, 턱 끄덕거릴 이, 기를 이, 늙은이 이, 괘 이름 이")
     "骪"
     "骫"
     ("鮞" . "곤이 알 이")
     ("鮧" . "창자젓 이")
     ("黟" . "검을 이, 고을이름 이"))
    ("익"
     ("瀷" . "강이름 익")
     ("益" . "더할 익")
     ("翊" . "도울 익")
     ("翌" . "다음날 익")
     ("翼" . "날개 익")
     ("謚" . "웃을 익")
     ("匿" . "숨을 닉, 숨길 닉, 덮어둘 닉, 몰래 붙을 닉, 쌀 닉, 술 담는 그릇 닉")
     ("溺" . "빠질 닉, 약할 닉, 헤어 나오지 못할 닉")
     ("弋" . "주살 익, 취할 익, 홰 익, 검을 익, 벼슬이름 익, 오랑캐 익")
     ("熤" . "빛날 익, 사람이름 익")
     ("鷁" . "익새 익, 돛대 끝 바람개비 익")
     ("益" . "더할 익"))
    ("인"
     ("人" . "사람 인")
     ("仁" . "어질 인")
     ("刃" . "칼날 인")
     ("印" . "도장 인")
     ("咽" . "목구멍 인")
     ("因" . "인할 인")
     ("姻" . "혼인 인")
     ("寅" . "세째지지 인")
     ("引" . "끌 인")
     ("忍" . "참을 인")
     ("湮" . "잠길 인")
     ("煙" . "김 인, 기운 인, 안개 인, 숯 그을음 인")
     ("絪" . "기운 인")
     ("茵" . "자리 인")
     ("蚓" . "지렁이 인")
     ("認" . "알 인")
     ("靭" . "韌과 同字")
     ("靷" . "가슴걸이 인")
     ("吝" . "아낄 인")
     ("燐" . "도깨비불 인")
     ("璘" . "옥빛 인")
     ("藺" . "골풀 인")
     ("隣" . "鄰의 俗字")
     ("鱗" . "비늘 인")
     ("麟" . "기린 인")
     ("仞" . "길 인")
     ("仭" . "길 인, 잴 인, 찰 인, 깊을 인")
     ("儿" . "어진사람 인")
     ("刄" . "刃의 俗字")
     ("囙" . "因의 俗字")
     ("堙" . "막을 인")
     ("夤" . "조심할 인")
     ("婣" . "姻과 同字")
     ("扨" . "그러하나 인")
     ("氤" . "기운성할 인")
     ("洇" . "湮과 同字")
     ("禋" . "제사지낼 인")
     ("籾" . "벼 인")
     ("芢" . "씨 인")
     ("裀" . "요 인")
     ("魜" . "인어 인"))
    ("일"
     ("一" . "한 일")
     ("佚" . "편안할 일")
     ("佾" . "춤 일")
     ("壹" . "한 일")
     ("尼" . "가까울 닐, 정할 닐, 그칠 닐")
     ("日" . "날 일")
     ("溢" . "넘칠 일")
     ("逸" . "달아날 일")
     ("鎰" . "중량 일")
     ("馹" . "역말 일")
     ("劮" . "기쁠 일")
     ("呹" . "풀 뜯어 먹을 일, 재빠를 일")
     ("壱" . "壹의 略字")
     ("泆" . "끊을 일")
     ("軼" . "앞지를 일")
     ("驲" . "馹의 簡體字")
     ("逸" . "달아날 일"))
    ("임"
     ("任" . "맡길 임")
     ("壬" . "아홉째천간 임")
     ("妊" . "아이밸 임")
     ("姙" . "妊과 同字")
     ("恁" . "생각할 임")
     ("稔" . "곡식익을 임")
     ("荏" . "들깨 임")
     ("賃" . "품팔이 임")
     ("林" . "수풀 림, 더북더북 날 림")
     ("淋" . "지적지적할 림, 축일 림, 번지르르할 림")
     ("臨" . "임할 림, 군림할 림, 여럿이 울 림, 굽힐 림")
     ("乑" . "나란히 설 임, 기어 오를 임")
     ("絍" . "짤 임, 길쌈할 임")
     ("衽" . "옷깃 임")
     ("銋" . "젖을 임")
     ("飪" . "익힐 임")
     ("餁" . "飪과 同字"))
    ("입"
     ("入" . "들 입")
     ("卄" . "스물 입")
     ("立" . "설 입")
     ("笠" . "우리 입")
     ("粒" . "알 입")
     ("叺" . "가마니 입")
     ("廿" . "스물 입")
     ("込" . "담을 입"))
    ("잉"
     ("仍" . "인할 잉")
     ("剩" . "남을 잉")
     ("孕" . "아이밸 잉")
     ("芿" . "새풀싹 잉")
     ("媵" . "보낼 잉"))
    ("자"
     ("仔" . "자세할 자")
     ("做" . "지을 자")
     ("刺" . "찌를 자")
     ("咨" . "물을 자")
     ("姉" . "姊의 俗字")
     ("姿" . "맵시 자")
     ("子" . "아들 자")
     ("字" . "글자 자")
     ("孜" . "힘쓸 자")
     ("恣" . "방자할 자")
     ("慈" . "사랑할 자")
     ("滋" . "불을 자")
     ("炙" . "고기구을 자")
     ("煮" . "삶을 자")
     ("玆" . "이 자")
     ("瓷" . "오지그릇 자")
     ("疵" . "흠 자")
     ("磁" . "자석 자")
     ("積" . "저출할 자")
     ("紫" . "자주빛 자")
     ("者" . "놈 자")
     ("自" . "스스로 자")
     ("茨" . "가시나무 자")
     ("蔗" . "사탕수수 자")
     ("藉" . "깔개 자")
     ("諮" . "물을 자")
     ("資" . "재물 자")
     ("雌" . "암컷 자")
     ("齊" . "상옷 아랫단할 자")
     ("兹" . "무성할 자")
     ("呰" . "주차할 자")
     ("啙" . "약할 자")
     ("嗞" . "탄식할 자")
     ("嬨" . "계집성품너그러고순할 자")
     ("孖" . "쌍둥이 자")
     ("孳" . "孶와 同字")
     ("孶" . "부지런할 자")
     ("柘" . "산뽕나무 자")
     ("榨" . "술주자 자")
     ("橴" . "땅이름 자")
     ("泚" . "맑을 자")
     ("煑" . "煮와 同字")
     ("牸" . "암컷 자")
     ("眥" . "흘길 자")
     ("眦" . "眥와 同字")
     ("粢" . "피 자")
     ("耔" . "복돋을 자")
     ("胾" . "고깃점 자")
     ("茈" . "지치 자")
     ("茲" . "무성할 자")
     ("莿" . "풀가시 자")
     ("虸" . "자방벌레 자")
     ("觜" . "털뿔 자")
     ("訾" . "헐뜯을 자")
     ("貲" . "재물 자")
     ("赭" . "붉은흙 자")
     ("趑" . "머뭇거릴 자")
     ("鎡" . "호미 자")
     ("頿" . "코밑수염 자")
     ("髭" . "코밑수염 자")
     ("鮓" . "젓 자")
     ("鶿" . "가마우지 자")
     ("鷓" . "자고 자"))
    ("작"
     ("作" . "지을 작")
     ("勺" . "구기 작")
     ("嚼" . "씹을 작")
     ("斫" . "벨 작")
     ("昨" . "어제 작")
     ("杓" . "구기 작")
     ("灼" . "사를 작")
     ("炸" . "터질 작")
     ("爵" . "벼슬 작")
     ("綽" . "너그러울 작")
     ("芍" . "작약 작")
     ("酌" . "따를 작")
     ("酢" . "초 작")
     ("醋" . "술잔을 돌릴 작")
     ("雀" . "참새 작")
     ("鵲" . "까치 작")
     ("仢" . "외나무 다리 작")
     ("剒" . "건목칠 작")
     ("妁" . "중매 작")
     ("岝" . "산 높을 작")
     ("怍" . "부끄러울 작")
     ("斱" . "쪼갤 작")
     ("柞" . "나무이름 작")
     ("汋" . "삶을 작")
     ("焯" . "밝을 작")
     ("犳" . "아롱 짐승 작")
     ("碏" . "삼갈 작")
     ("趵" . "차는 소리 작"))
    ("잔"
     ("孱" . "잔약할 잔")
     ("棧" . "잔교 잔")
     ("殘" . "해칠 잔")
     ("潺" . "물이 줄줄 흐르는 모양 잔")
     ("盞" . "작은 술잔 잔")
     ("僝" . "욕할 잔")
     ("剗" . "깍을 잔")
     ("戔" . "쌓일 잔")
     ("残" . "해칠 잔")
     "糤"
     "饊"
     "馓"
     ("驏" . "안장 얹지 않은 말 잔"))
    ("잘"
     ("乲" . "봉호 잘")
     ("囐" . "북소리 잘, 나라이름 잘"))
    ("잠"
     ("岑" . "봉우리 잠")
     ("暫" . "잠시 잠")
     ("潛" . "잠길 잠")
     ("箴" . "바늘 잠")
     ("簪" . "비녀 잠")
     ("蠶" . "누에 잠")
     ("兂" . "簪의 本字")
     ("啿" . "넉넉할 잠")
     ("喒" . "나 잠")
     ("涔" . "괸물 잠")
     ("潜" . "潛의 俗字")
     ("濳" . "潛의 俗字")
     ("蚕" . "누에 잠"))
    ("잡"
     ("雜" . "섞일 잡")
     ("匝" . "돌 잡")
     ("卡" . "관 잡")
     ("咂" . "빨 잡")
     ("啑" . "唼과 同字")
     ("喋" . "오리와 기러기 텁석거려 먹는 소리 잡")
     ("囃" . "장단 잡을 잡")
     ("眨" . "눈 깜작일 잡")
     ("磼" . "산 높을 잡")
     ("襍" . "雜의 本字")
     ("雑" . "雜의 俗字"))
    ("장"
     ("丈" . "어른 장")
     ("仗" . "병장기 장")
     ("匠" . "장인 장")
     ("場" . "마당 장")
     ("墻" . "牆과 同字")
     ("壯" . "씩씩할 장")
     ("奬" . "도울 장")
     ("將" . "장차 장")
     ("帳" . "휘장 장막 장")
     ("庄" . "장중할 장")
     ("張" . "베풀 장")
     ("掌" . "손바닥 장")
     ("暲" . "햇발이 돋아올 장")
     ("杖" . "지팡이 장")
     ("樟" . "녹나무 장")
     ("檣" . "돛대 장")
     ("欌" . "장농 장")
     ("漿" . "미음 장")
     ("牆" . "담 장")
     ("狀" . "모양 형상 장")
     ("獐" . "노루 장")
     ("璋" . "끝의 반을 깎아 뾰족하게 한 홀 장")
     ("章" . "문채 장")
     ("粧" . "단장할 장")
     ("腸" . "창자 장")
     ("臟" . "오장 장")
     ("臧" . "착할 장")
     ("莊" . "엄할 장")
     ("葬" . "장사 지낼 장")
     ("蔣" . "줄 장")
     ("薔" . "물여뀌 장")
     ("藏" . "감출 장")
     ("裝" . "차려 입을 장")
     ("贓" . "장물 장")
     ("醬" . "장 장")
     ("長" . "길 장")
     ("障" . "막을 장")
     ("狀" . "모양 형상 장")
     ("傽" . "놀랄 장")
     ("匞" . "匠의 本字")
     ("壮" . "씩씩할 장")
     ("奘" . "클 장")
     ("奨" . "奬의 略字")
     ("妝" . "꾸밀 장")
     ("嬙" . "궁녀 장")
     ("将" . "將의 略字")
     ("嶂" . "높고 가파른 산 장")
     ("廧" . "담 장")
     ("戕" . "죽일 장")
     ("漳" . "강이름 장")
     ("牂" . "암양 장")
     ("状" . "狀의 俗字")
     ("瘴" . "장기 장")
     ("糚" . "妝과 同字")
     ("羘" . "수양 장")
     ("臓" . "臟의 略字")
     ("荘" . "莊의 俗字")
     ("萇" . "나무 이름 장")
     ("蒋" . "蔣의 略字")
     ("蔵" . "藏의 略字")
     ("装" . "裝의 俗字")
     ("賬" . "치부책 장")
     ("贜" . "贓의 俗字")
     ("鄣" . "나라이름 장")
     ("酱" . "醬의 簡體字")
     ("醤" . "醬의 略字")
     ("鏘" . "금옥 소리 장")
     ("餦" . "산자 장")
     ("髒" . "몸 뚱뚱할 장")
     ("麞" . "노루 장"))
    ("재"
     ("再" . "두 번 재, 거듭 재")
     ("哉" . "비로소 재, 답다 재, 그런가 재")
     ("在" . "있을 재, 살 재, 살필 재, 곳 재")
     ("宰" . "주관할 재, 다스릴 재, 재상 재, 으뜸 재, 삶을 재")
     ("才" . "재주 재, 능할 재, 현인 재, 바탕 재")
     ("材" . "재목 재, 늘미 재, 성품 재, 재주 재")
     ("栽" . "심을 재")
     ("梓" . "가래나무 재, 목수 재, 우러러 볼 재, 고향 재")
     ("渽" . "맑을 재")
     ("滓" . "앙금 재, 찌끼 재")
     ("災" . "재앙 재, 천벌 재, 횡액 재")
     ("縡" . "일 재, 실을 재")
     ("裁" . "마름질할 재, 헤아릴 재, 결단할 재")
     ("財" . "재물 재, 뇌물 재, 보배 재")
     ("載" . "실을 재, 이길 재, 비롯할 재, 가득할 재")
     ("齋" . "재계할 재, 집 재")
     ("齎" . "탄식할 재, 쌀 재, 가질 재")
     ("咦" . "크게 부를 재, 웃을 재")
     ("喍" . "개싸움할 재")
     ("夈" . "齋와 同字")
     ("崽" . "자식 재, 저 재")
     ("扗" . "在의 本字")
     ("榟" . "梓와 同字")
     ("灾" . "災와 同字")
     ("纔" . "겨우 재, 비롯할 재")
     ("齜" . "이 갈 재, 이 드러날 재, 뻐드렁니 재"))
    ("쟁"
     ("槍" . "혜성 쟁")
     ("爭" . "다툴 쟁, 다스릴 쟁, 분별할 쟁")
     ("箏" . "쟁 쟁, 풍경 쟁")
     ("諍" . "간할 쟁")
     ("錚" . "쇳소리 쟁그렁거릴 쟁, 징 쟁")
     ("噌" . "장사꾼 웅성거릴 쟁")
     ("崢" . "가파를 쟁, 산 높을 쟁")
     ("猙" . "밉살스럴 쟁, 짐승이름 쟁")
     ("琤" . "옥소리 쟁")
     ("瞠" . "똑바로 볼 쟁")
     ("鎗" . "금석소리 쟁, 창 쟁, 총 쟁"))
    ("저"
     ("且" . "공손할 저, 파초 저, 많을 저")
     ("佇" . "오래 설 저, 기다릴 저, 잠깐 머물 저")
     ("低" . "낮을 저, 값 쌀 저, 소리 약할 저, 숙일 저, 머뭇거릴 저")
     ("儲" . "쌓을 저, 버금 저, 용납할 저")
     ("咀" . "씹을 저, 깨달을 저, 먹을 저")
     ("姐" . "맏누이 저, 아가씨 저, 교만할 저")
     ("屠" . "흉노왕의 이름 저")
     ("底" . "밑 저, 그칠 저")
     ("抒" . "당길 저, 북 저")
     ("抵" . "밀칠 저, 당할 저, 막을 저, 다달을 저, 씨름할 저")
     ("杵" . "공이 저, 방망이 저, 혜성 저")
     ("楮" . "닥나무 저, 종이돈 저, 감매나무 저")
     ("樗" . "가죽나무 저")
     ("沮" . "그칠 저, 막을 저, 무너질 저, 공갈할 저, 물이 번질 저, 나라이름 저")
     ("渚" . "물가 저, 물 갈라질 저")
     ("狙" . "원숭이 저, 엿볼 저, 살필 저")
     ("猪" . "豬의 俗字")
     ("疽" . "등창 저")
     ("箸" . "젓가락 저")
     ("紵" . "모시 저")
     ("苧" . "모시 저")
     ("菹" . "김치 저, 푸서리 저")
     ("著" . "나타날 저, 널리 알려질 저, 글 지을 저, 옹저 저")
     ("藷" . "마 저, 감자 저")
     ("詛" . "방자할 저, 저주할 저, 맹서할 저")
     ("貯" . "쌓을 저, 감출 저, 둘 저")
     ("躇" . "머뭇거릴 저")
     ("這" . "맞을 저, 이것 저, 여기 저")
     ("邸" . "사처 저, 주막 저, 홀바탕 저, 병풍 저")
     ("雎" . "저구 저, 증경이 저, 원앙 저")
     ("齟" . "이 어긋날 저")
     ("宁" . "조회 받는 곳 저, 멈출 저")
     ("岨" . "돌산에 흙 덮일 저")
     ("杼" . "북 저, 도토리 저")
     ("柢" . "뿌리 저")
     ("氐" . "낮을 저, 오랑캐 이름 저, 이를 저, 근본 저, 별이름 저")
     ("滁" . "물이름 저")
     ("潴" . "瀦와 同字")
     ("瀦" . "물 괼 저, 못 저")
     ("牴" . "찌를 저, 대강 저, 씨름 저, 당할 저")
     ("纻" . "紵와 同字")
     ("罝" . "짐승 그물 저")
     ("羝" . "숫양 저")
     ("苴" . "암삼 저, 꾸러미 저, 대지팡이 저, 신바닥 저")
     ("蛆" . "구더기 저, 지네 저")
     ("袛" . "속적삼 저")
     ("褚" . "주머니 저, 쌓을 저, 옷에 솜 둘 저")
     ("觝" . "찌를 저, 받을 저, 씨름 저")
     ("詆" . "꾸짖을 저, 알소할 저, 비방할 저")
     ("豬" . "돼지 저, 물이 괼 저, 못이름 저")
     ("陼" . "모래섬 저, 둔덕 저, 언덕 저")
     ("骶" . "꽁무니 끝 저")
     ("猪" . "豬의 俗字"))
    ("적"
     ("借" . "빌릴 적, 빚 적, 도울 적, 허락할 적")
     ("勣" . "공적 적, 사업 적")
     ("吊" . "弔의 俗字")
     ("嫡" . "정실 적, 맏아들 적")
     ("寂" . "고요할 적, 쓸쓸할 적")
     ("弔" . "이를 적")
     ("摘" . "딸 적, 돋구어낼 적, 움직일 적")
     ("敵" . "대적할 적, 원수 적, 무리 적, 막을 적")
     ("滴" . "물방울 적, 물 댈 적")
     ("炙" . "고기구이 적, 김 쏘일 적, 냄새 퍼질 적")
     ("狄" . "북방 오랑캐 적, 꿩 그린 옷 적, 멀 적")
     ("的" . "과녁 적, 꼭 그러할 적, 밝을 적")
     ("積" . "포갤 적, 모을 적, 넓이 적, 부피 적")
     ("笛" . "피리 적, 날라리 적")
     ("籍" . "문서 적, 왁자할 적, 호적 적, 압수할 적, 임금이 가는 밭 적")
     ("績" . "길쌈 적, 공 적, 이룰 적, 이을 적")
     ("翟" . "꿩의 깃 적, 황후의 옷 적")
     ("芍" . "연밥 적, 연꽃의 열매 적")
     ("荻" . "갈대 적")
     ("藉" . "어수선할 적, 확자할 적, 임금이 가는 밭 적")
     ("謫" . "귀양갈 적, 꾸짖을 적")
     ("賊" . "도적 적, 해칠 적")
     ("赤" . "붉을 적, 금치 적")
     ("跡" . "자취 적")
     ("蹟" . "행적 적, 자취 적")
     ("躍" . "뛸 적")
     ("迪" . "나아갈 적, 순할 적, 열어줄 적")
     ("迹" . "발자국 적, 자취 적, 뒤따를 적")
     ("逐" . "달리는 모양 적")
     ("適" . "맞갖을 적, 편안할 적, 깨달을 적, 시집갈 적, 좇을 적, 주장할 적")
     ("鏑" . "화살촉 적")
     ("炙" . "고기구이 적, 김 쏘일 적, 냄새 퍼질 적")
     ("乇" . "풀잎 적")
     ("啇" . "나무 뿌리 적, 실과 꼭지 적, 밑둥 적")
     ("戝" . "賊과 同字")
     ("樀" . "추녀 적, 도토마리 적, 방망이 적")
     ("磧" . "돌무더기 적, 모래벌 적")
     ("糴" . "쌀 사들일 적, 빠를 적")
     ("菂" . "연밥 적")
     ("覿" . "볼 적")
     ("逖" . "멀 적")
     ("馰" . "별배기 적, 소태성 적"))
    ("전"
     ("佃" . "밭 맬 전, 머슴꾼 전, 사냥할 전")
     ("佺" . "신선이름 전")
     ("傳" . "전할 전, 펼 전, 이을 전, 주막 전, 책 전")
     ("全" . "온전할 전, 갖출 전")
     ("典" . "책 전, 법 전, 맡을 전, 도덕 전")
     ("前" . "앞 전, 옛 전, 인도할 전")
     ("剪" . "가위 전")
     ("厘" . "전방 전, 터전 전")
     ("塡" . "메일 전, 북소리 전, 순종할 전, 병들 전")
     ("塼" . "벽돌 전")
     ("奠" . "정할 전")
     ("專" . "오로지 전")
     ("展" . "펼칠 전, 열릴 전, 살필 전")
     ("廛" . "전방 전, 터전 전")
     ("悛" . "고칠 전, 차례 전")
     ("戰" . "싸움 전, 경쟁할 전")
     ("栓" . "말뚝 전")
     "棧"
     ("殿" . "대궐 전")
     ("氈" . "단자리 전, 전방석 전")
     ("澱" . "찌끼 전, 물 고일 전")
     ("煎" . "달일 전, 불에 말릴 전")
     ("琠" . "옥 이름 전")
     ("田" . "밭 전, 사냥할 전, 논 전")
     ("甸" . "경기 전")
     ("畑" . "화전 전, 밭 전")
     ("癲" . "미칠 전")
     ("竣" . "일 마칠 전, 물러설 전")
     ("筌" . "통발 전")
     ("箋" . "기록할 전, 글 전")
     ("箭" . "화살 전, 약이름 전")
     ("篆" . "문체이름 전")
     ("纏" . "둘릴 전, 묶을 전, 얽을 전")
     ("詮" . "평론할 전, 갖출 전")
     ("輾" . "돌아 누울 전")
     ("轉" . "구를 전, 변할 전, 굴릴 전")
     ("鈿" . "비녀 전, 보배로 꾸민 그릇 전")
     ("銓" . "사람 가릴 전, 저울질할 전")
     ("錢" . "돈 전, 가래 전")
     ("鐫" . "새길 전")
     ("電" . "번개 전, 전기 전")
     ("顚" . "이마 전, 엎드러질 전")
     ("顫" . "사지 떨릴 전, 머리 비뚤이 전")
     ("餞" . "전별잔치 전, 보낼 전")
     ("伝" . "傳의 略字")
     ("倎" . "두터울 전")
     ("傎" . "엎드러질 전")
     ("剸" . "오로지 전, 저밀 전")
     ("吮" . "빨 전")
     ("唸" . "신음할 전")
     ("囀" . "새 지저귈 전, 후렴 전")
     ("填" . "塼과 同字")
     ("嫥" . "아름다울 전")
     ("専" . "專과 同字")
     ("屇" . "구멍 전")
     ("巓" . "산 꼭대기 전")
     ("巔" . "巓과 同字")
     ("戦" . "戰과 同字")
     ("戩" . "복(福) 전, 다할 전, 멸할 전")
     ("揃" . "가를 전, 자를 전, 가지런히 할 전")
     ("旃" . "기 전, 말 그칠 전")
     ("栴" . "향나무 전")
     ("槙" . "나무 끝 전, 자빠진 나무 전")
     ("湔" . "빨 전, 씻을 전, 물 번질 전")
     ("澶" . "물이름 전")
     ("牋" . "글 전, 표 전, 문체이름 전")
     "猠"
     ("瑱" . "귀막이옥 전, 옥이름 전")
     ("甎" . "벽돌 전, 기와 전")
     ("畋" . "사냥할 전")
     ("畠" . "밭 전")
     ("痊" . "병 나을 전")
     ("癜" . "어루러기 전")
     ("磚" . "벽돌 전, 기와 전")
     ("籛" . "성씨 전")
     ("羶" . "노린내날 전")
     ("翦" . "베어 없앨 전, 멸할 전")
     ("腆" . "두터울 전, 지극할 전, 많이 차려놓을 전")
     ("膞" . "썰 전, 질그릇 만드는 틀 전")
     ("荃" . "향풀 전, 전풀 전")
     ("謭" . "얕을 전")
     ("趁" . "밟을 전")
     ("躔" . "햇길 전, 별자리 전")
     ("転" . "轉과 同字")
     ("輇" . "달 전, 잴 전")
     ("邅" . "머뭇거릴 전")
     ("鄽" . "가게 전")
     ("銭" . "錢의 簡體字")
     ("鋑" . "鐫의 古字")
     ("錪" . "솥 전, 쇠 전")
     ("靛" . "푸른 대 전")
     ("靦" . "무안할 전, 물끄러미 볼 전")
     ("顓" . "어리석을 전, 오로지 전")
     ("顛" . "顚과 同字")
     ("飦" . "범벅 전, 된죽 전")
     ("餰" . "된죽 전")
     ("鬋" . "수염 깎을 전, 귀밑 털 드릴 전")
     ("鱣" . "전어 전")
     ("鸇" . "구진매 전"))
    ("절"
     ("切" . "끊을 절, 저밀 절, 정성스럴 절, 급할 절, 진맥할 절")
     ("姪" . "조카 절, 조카딸 절")
     "帙"
     ("截" . "끊을 절, 말 잘할 절")
     ("折" . "꺾을 절, 자를 절, 휘일 절, 알맞을 절")
     ("浙" . "쌀 씻을 절, 물이름 절")
     ("準" . "코마루 절")
     ("癤" . "멍울 절, 부스럼 절")
     ("窒" . "막을 절, 가득할 절")
     ("竊" . "좀도둑 절, 얕을 절")
     ("節" . "마디 절, 절개 절")
     ("絶" . "絕과 同字")
     ("卩" . "몸기 절, 병부 절")
     ("岊" . "산 모퉁이 우뚝 내밀 절")
     ("晢" . "밝을 절, 비칠 절")
     ("窃" . "竊의 俗字")
     ("絕" . "끊을 절, 으뜸 절, 멸할 절, 그칠 절"))
    ("점"
     ("占" . "점칠 점, 날씨 볼 점, 점령할 점")
     ("岾" . "고개 점")
     ("店" . "가게 점, 주막 점")
     ("漸" . "번질 점, 물 흘러 들어갈 점, 점점 점, 차차 점")
     ("点" . "點의 略字")
     ("粘" . "붙일 점, 끈끈할 점")
     ("霑" . "젖을 점, 비 지정거릴 점")
     ("鮎" . "메기 점")
     ("點" . "더러울 점, 뭉갤 점, 검은 점 점")
     ("佔" . "엿볼 점, 숙일 점")
     ("厃" . "우러러 볼 점")
     ("唸" . "신음할 점")
     ("坫" . "병풍 점, 막을 점, 담 점")
     ("墊" . "빠질 점, 축축할 점")
     ("奌" . "點의 略字")
     ("玷" . "옥의 티 점, 흠각 점")
     ("笘" . "분판 점, 채찍 점")
     ("簟" . "삿자리 점, 대 이름 점")
     ("苫" . "이엉 점, 거적자리 점, 글씨 흘려 쓸 점")
     ("蔪" . "풀 벨 점, 보리 팰 점")
     ("蛅" . "쐐기 점")
     ("覘" . "엿볼 점, 기다려볼 점")
     ("阽" . "낭떠러지 점, 낭비탈 점")
     ("颭" . "펄렁거릴 점")
     ("黏" . "붙일 점, 풀 점"))
    ("접"
     ("接" . "사귈 접, 잇닿을 접")
     ("摺" . "접을 접, 패할 접")
     ("楫" . "노 접")
     ("渫" . "물결 출렁출렁할 접")
     ("蝶" . "들나비 접")
     ("慴" . "두려울 접, 겁낼 접")
     "曡"
     ("椄" . "나무 접붙일 접, 형벌틀 접, 문설주 접")
     ("楪" . "널평상 접")
     ("蜨" . "나비 접")
     ("跕" . "미끄러질 접")
     ("蹀" . "저벅저벅 걸을 접")
     ("鰈" . "가자미 접, 넙치 접"))
    ("정"
     ("丁" . "장정 정, 네째 천간 정")
     ("井" . "우물 정, 단정할 정, 괘 이름 정, 천정 정, 저자 정")
     ("亭" . "정자 정, 여관 정, 고를 정")
     ("停" . "머무를 정, 늦어질 정")
     ("偵" . "엿볼 정, 정탐할 정, 물을 정")
     ("呈" . "보일 정, 드러낼 정")
     ("姃" . "단정할 정")
     ("定" . "정할 정, 편안할 정, 고요할 정")
     ("幀" . "그림족자 정")
     ("庭" . "뜰 정, 곧을 정")
     ("廷" . "조정 정, 바를 정, 곧을 정")
     ("征" . "칠 정, 갈 정")
     ("情" . "뜻 정, 마음속 정")
     ("打" . "칠 정")
     ("挺" . "빼어날 정, 너그러울 정, 향초이름 정")
     ("政" . "정사 정, 바르게 할 정, 조세 정")
     ("整" . "가지런할 정")
     ("旌" . "장목기 정, 표시할 정")
     ("晶" . "수정 정, 맑을 정, 빛날 정")
     ("晸" . "햇발 불그레하게 비칠 정")
     ("柾" . "나무결 바를 정")
     ("楨" . "담틀 마구리대 정, 단단한 나무 정")
     ("檉" . "능수버들 정")
     ("正" . "바를 정, 과녁 정, 남쪽으로 난 창 정, 어른 정, 분별할 정")
     ("汀" . "물가 정, 수렁 정")
     ("淀" . "얕은 물 정, 배 댈 정")
     ("淨" . "맑을 정, 조촐할 정")
     ("渟" . "물 고일 정, 도랑 정, 물가 정")
     ("湞" . "물이름 정")
     ("瀞" . "맑을 정, 정결할 정")
     ("炡" . "데칠 정, 불 번쩍거릴 정")
     ("玎" . "옥소리 정")
     ("珽" . "옥 이름 정")
     ("町" . "밭 두덕 정, 정보 정, 시가 정")
     ("睛" . "눈 검은자위 정, 눈동자 정")
     ("碇" . "닻돌 정, 배 멈출 정")
     ("禎" . "상서로울 정")
     ("程" . "법 정, 한정 정, 과정 정, 품수 정, 헤아릴 정, 길 정")
     ("穽" . "구덩이 정, 함정 정")
     ("精" . "정교할 정, 세밀할 정, 정할 정, 성실할 정, 신령 정")
     ("綎" . "띠술 정")
     ("艇" . "거룻배 정, 작은 배 정")
     ("訂" . "바로잡을 정, 의논할 정")
     ("諪" . "고를 정")
     ("貞" . "곧을 정, 굳을 정")
     ("鄭" . "나라이름 정, 성씨 정")
     ("酊" . "비틀거릴 정")
     ("釘" . "창 정, 못 정")
     ("鉦" . "징 정")
     ("鋌" . "화살촉 정, 달음박질할 정, 쇳덩이 정")
     ("錠" . "촛대 정")
     ("霆" . "벼락 정, 번개 정")
     ("靖" . "다스릴 정, 편안할 정, 생각할 정")
     ("靜" . "고요할 정, 조용할 정, 쉴 정, 편안할 정")
     ("頂" . "이마 정, 꼭대기 정, 관 꼭대기 치장하는 장식 정")
     ("鼎" . "솥 정, 바야흐로 정, 새로울 정")
     ("丼" . "우물 정, 샘 정")
     ("佂" . "두려워할 정")
     ("侹" . "평평할 정, 멀쑥할 정")
     ("凈" . "찰 정")
     ("叮" . "단단히 부탁할 정, 정성스러울 정")
     ("婧" . "조촐할 정, 가냘플 정")
     ("婷" . "아리따울 정, 쌀쌀할 정")
     ("怔" . "황겁할 정, 가슴 두근두근할 정")
     ("掟" . "둘러칠 정")
     ("桯" . "서안 정, 걸상 정")
     ("梃" . "외줄기 정, 막대 정, 꼿꼿할 정")
     ("棖" . "문설주 정, 막대 정")
     ("灯" . "불꽃 정")
     ("珵" . "노리개 정, 패옥 정")
     "甼"
     ("疔" . "헌데 정")
     ("筳" . "대쪽 정")
     ("莛" . "풀 줄거리 정, 들보 정")
     ("証" . "간할 정")
     ("遉" . "순라군 정, 염탐할 정")
     ("酲" . "술병 정, 술 깰 정")
     ("鋥" . "칼날세울 정")
     ("阱" . "함정 정")
     ("靚" . "단장할 정, 밝을 정")
     ("飣" . "굄새 정, 음식 괼 정")
     ("饤" . "飣과 同字")
     ("靖" . "다스릴 정, 편안할 정, 생각할 정")
     ("精" . "정교할 정, 세밀할 정, 정할 정, 성실할 정, 신령 정"))
    ("제"
     ("制" . "억제할 제")
     ("劑" . "약 지을 제")
     ("啼" . "울 제")
     ("堤" . "둑 제")
     ("帝" . "임금 제")
     ("弟" . "아우 제")
     ("悌" . "공경할 제")
     ("折" . "천천히 할 제")
     ("提" . "끌 제")
     ("梯" . "사다리 제")
     ("濟" . "나루 제")
     ("祭" . "제사 제")
     ("第" . "집 제")
     ("臍" . "배꼽 제")
     ("荑" . "띠싹 제")
     ("薺" . "냉이 제")
     ("製" . "만들 제")
     ("諸" . "모든 제")
     ("蹄" . "굽 제")
     ("醍" . "맑은 술 제")
     ("除" . "섬돌 제")
     ("際" . "사이 제")
     ("霽" . "갤 제")
     ("題" . "이마 제")
     ("齊" . "가지런할 제")
     ("亝" . "재계할 제")
     ("俤" . "용모 제")
     ("傺" . "묵을 제")
     ("儕" . "동배 제")
     ("呧" . "꾸짖을 제, 비방할 제")
     ("嗁" . "啼와 同字")
     ("嚌" . "맛볼 제")
     ("娣" . "여동생 제")
     ("擠" . "물리칠 제")
     ("晢" . "별이 반짝반짝 할 제")
     ("済" . "濟의 略字")
     ("猘" . "미친개 제")
     ("瑅" . "제당 제")
     ("睇" . "흘끗 볼 제")
     ("禔" . "복 제")
     ("稊" . "강아지풀 제")
     ("緹" . "붉은 비단 제")
     ("踶" . "찰 제")
     ("蹏" . "蹄와 同字")
     ("躋" . "오를 제")
     ("鍗" . "큰 가마 제")
     ("隄" . "堤와 同字")
     ("鞮" . "가죽신 제")
     ("韲" . "양념할 제")
     ("骶" . "궁둥이 제")
     ("鮧" . "복 제")
     ("鯷" . "메기 제")
     ("鱭" . "갈치 제")
     ("鵜" . "접동새 제")
     ("齏" . "회 제")
     ("諸" . "모든 제"))
    ("조"
     ("俎" . "도마 조")
     ("兆" . "조짐 조")
     ("凋" . "시들 조")
     ("助" . "도울 조")
     ("召" . "대추 조")
     ("嘲" . "조롱할 조")
     ("弔" . "위문할 조")
     ("彫" . "새길 조")
     ("挑" . "돋울 조")
     ("措" . "둘 조")
     ("操" . "잡을 조")
     ("早" . "새벽 조")
     ("昭" . "밝을 조")
     ("晁" . "朝의 古字")
     ("曹" . "무리 조")
     ("曺" . "성 조")
     ("朝" . "아침 조")
     ("條" . "가지 조")
     ("棗" . "대추나무 조")
     ("槽" . "구유 조")
     ("漕" . "배로 실어 나를 조")
     ("潮" . "조수 조")
     ("炤" . "照와 同字")
     ("照" . "비출 조")
     ("燥" . "마를 조")
     ("爪" . "손톱 조")
     ("璪" . "면루관 드림 옥 조")
     ("眺" . "바라볼 조")
     ("祖" . "조상 조")
     ("祚" . "복 조")
     ("租" . "구실 조")
     ("稠" . "빽빽할 조")
     ("窕" . "정숙할 조")
     ("粗" . "거칠 조")
     ("糟" . "지게미 조")
     ("組" . "끈 조")
     ("繰" . "야청 통견 조")
     ("肇" . "비롯할 조")
     ("蓚" . "기쁠 조")
     ("藻" . "조류 조")
     ("蚤" . "벼룩 조")
     ("詔" . "고할 조")
     ("調" . "고를 조")
     ("趙" . "조나라 조")
     ("跳" . "뛸 조")
     ("躁" . "떠들 조")
     ("造" . "지을 조")
     ("遭" . "만날 조")
     ("釣" . "낚시 조")
     ("錯" . "措와 同字")
     ("鑿" . "뚫을 조")
     ("阻" . "험할 조")
     ("雕" . "독수리 조")
     ("鳥" . "새 조")
     ("佻" . "방정맞을 조")
     ("傮" . "마칠 조")
     ("刁" . "바라 조")
     ("劋" . "끊을 조")
     ("厝" . "措와 同字")
     ("唕" . "지저귈 조")
     ("啁" . "비웃을 조")
     ("嘈" . "지껄일 조")
     ("噪" . "떠들썩할 조")
     ("嬥" . "날씬할 조")
     ("弴" . "그림 그린 활 조")
     ("徂" . "갈 조")
     ("懆" . "근심할 조")
     ("找" . "채울 조")
     ("抓" . "긁을 조")
     ("条" . "條의 略字")
     ("殂" . "죽을 조")
     ("澡" . "씻을 조")
     ("琱" . "옥 다듬을 조, 아로새길 조")
     ("皁" . "하인 조")
     ("祧" . "조묘 조")
     ("竈" . "부엌 조")
     ("笊" . "조리 조")
     ("糙" . "매조미쌀 조")
     ("糶" . "쌀 내어 팔 조")
     ("絛" . "끈 조")
     ("絩" . "견직물 날실 수 조")
     ("胙" . "복 조")
     ("臊" . "누릴 조")
     ("艚" . "거룻배 조")
     ("蔦" . "담쟁이 조")
     ("蜩" . "매미 조")
     ("誂" . "꾈 조")
     ("譟" . "시끄러울 조")
     ("鈟" . "낚시 조")
     ("銚" . "쟁개비 조")
     ("鋽" . "불리지 않은 쇠 조")
     ("阼" . "동편 층계 조")
     ("鯛" . "도미 조")
     ("鰷" . "피라미 조")
     ("鵰" . "수리 조")
     ("鼂" . "朝와 同字"))
    ("족"
     ("族" . "겨레 족")
     ("簇" . "모일 족")
     ("足" . "발 족")
     ("鏃" . "화살촉 족")
     ("哫" . "아첨할 족")
     ("瘯" . "피부병 이름 족"))
    ("존"
     ("存" . "있을 존")
     ("尊" . "존귀할 존")
     ("拵" . "꽂을 존"))
    ("졸"
     ("卒" . "군사 졸")
     ("拙" . "서툴 졸")
     ("猝" . "갑자기 졸")
     ("卆" . "卒과 同字"))
    ("종"
     ("倧" . "상고 신인 종")
     ("宗" . "마루 종")
     ("從" . "좇을 종")
     ("悰" . "즐길 종")
     ("慫" . "권할 종")
     ("棕" . "종려나무 종")
     ("淙" . "물 소리 종")
     ("琮" . "옥홀 종")
     ("種" . "씨 종")
     ("終" . "끝낼 종")
     ("綜" . "모을 종")
     ("縱" . "늘어질 종")
     ("腫" . "부스럼 종")
     ("踪" . "자취 종")
     ("踵" . "발꿈치 종")
     ("鍾" . "술병 종")
     ("鐘" . "쇠북 종")
     ("从" . "從의 古字")
     ("伀" . "두려워할 종")
     ("喠" . "말 못할 종")
     ("従" . "從의 略字")
     ("慒" . "생각할 종")
     ("柊" . "방망이 종")
     ("椶" . "棕과 同字")
     ("樅" . "전나무 종")
     ("瑽" . "패옥소리 종")
     ("瘇" . "수종 종")
     ("粽" . "주악 종")
     ("縦" . "세로 종")
     ("螽" . "누리 종")
     ("蹤" . "자취 종")
     ("锺" . "술병 종"))
    ("좌"
     ("佐" . "도울 좌")
     ("坐" . "앉을 좌")
     ("左" . "왼 좌")
     ("座" . "자리 좌")
     ("挫" . "꺽을 좌")
     ("侳" . "욕보일 좌")
     ("剉" . "꺽을 좌")
     ("痤" . "뾰루지 좌")
     ("莝" . "여물 좌")
     ("髽" . "북상투 좌"))
    ("죄"
     ("罪" . "허물 죄"))
    ("주"
     ("主" . "주인 주")
     ("住" . "살 주")
     ("作" . "원망할 주")
     ("侏" . "난쟁이 주")
     ("做" . "지을 주")
     ("周" . "두루 주")
     ("呪" . "빌 주")
     ("嗾" . "부추길 주")
     ("奏" . "아뢸 주")
     ("姝" . "예쁠 주")
     ("宙" . "집 주")
     ("州" . "고을 주")
     ("廚" . "부엌 주")
     ("族" . "풍류가락 주")
     ("晝" . "낮 주")
     ("朱" . "붉을 주")
     ("柱" . "기둥 주")
     ("株" . "그루 주")
     ("注" . "물댈 주")
     ("洲" . "섬 주")
     ("湊" . "모일 주")
     ("澍" . "단비 주")
     ("炷" . "심지 주")
     ("珠" . "구슬 주")
     ("疇" . "밭두둑 주")
     ("祝" . "축문 주")
     ("稠" . "빽빽할 주")
     ("籌" . "투호 살 주")
     ("紂" . "껑거리끈 주")
     ("紬" . "명주 주")
     ("綢" . "얽힐 주")
     ("胄" . "후사 주")
     ("舟" . "배 주")
     ("蛛" . "거미 주")
     ("註" . "주낼 주")
     ("誅" . "벨 주")
     ("調" . "아침 주")
     ("走" . "달릴 주")
     ("足" . "지날 주")
     ("躊" . "머뭇거릴 주")
     ("輳" . "모일 주")
     ("週" . "돌 주")
     ("酎" . "세 번 빚은 술 주")
     ("酒" . "술 주")
     ("鑄" . "쇠 부어 만들 주")
     ("駐" . "머무를 주")
     ("丟" . "갈 주")
     ("丢" . "잃어버릴 주")
     ("丶" . "심지 주")
     ("侜" . "속일 주")
     ("儔" . "무리 주")
     ("冑" . "투구 주")
     ("凑" . "모일 주")
     ("厨" . "廚의 俗字")
     ("咒" . "呪와 同字")
     ("咮" . "부리 주")
     ("啁" . "새소리 주")
     ("喌" . "닭 부르는 소리 주")
     ("噣" . "부리 주")
     ("尌" . "세울 주")
     ("幬" . "휘장 주")
     ("拄" . "떠받칠 주")
     ("昼" . "晝의 略字")
     ("硃" . "주사 주")
     ("籒" . "주문 주")
     ("肘" . "팔꿈치 주")
     ("腠" . "살결 주")
     ("蔟" . "태주 주")
     ("蛀" . "나무좀 주")
     ("裯" . "홑이불 주")
     ("詋" . "呪와 同字")
     ("賙" . "진휼할 주")
     ("赒" . "賙의 古字")
     ("趎" . "사람이름 주")
     ("蹰" . "머뭇거릴 주")
     ("輈" . "끌채 주")
     ("遒" . "다가설 주")
     ("邾" . "나라이름 주")
     ("鉒" . "쇳돌 주")
     ("霌" . "운우 모양 주")
     ("霔" . "장마 주")
     ("麈" . "큰사슴 주")
     ("鼄" . "거미 주"))
    ("죽"
     ("竹" . "대 죽")
     ("粥" . "죽 죽")
     "喌")
    ("준"
     ("俊" . "준걸 준")
     ("儁" . "雋·俊과 同字")
     ("准" . "승인할 준")
     ("埈" . "가파를 준")
     ("寯" . "모일 준")
     ("尊" . "樽·罇과 同字")
     ("屯" . "어려울 준")
     ("峻" . "높을 준")
     ("恂" . "갑자기 준")
     ("晙" . "밝을 준")
     ("樽" . "술그릇 준")
     ("浚" . "깊을 준")
     ("準" . "수준기 준")
     ("濬" . "칠 준")
     ("焌" . "굽을 준")
     ("畯" . "俊과 同字")
     ("竣" . "마칠 준")
     ("純" . "선으로 두를 준")
     ("蠢" . "꿈틀거릴 준")
     ("逡" . "뒷걸음칠 준")
     ("遵" . "좇을 준")
     ("雋" . "儁·俊과 同字")
     ("駿" . "준마 준")
     ("僎" . "향음 주인 돕는 사람 준")
     ("僔" . "모을 준")
     ("凖" . "準의 俗字")
     ("噂" . "수군거릴 준")
     ("埻" . "과녘 준")
     ("墫" . "樽·罇과 同字")
     ("惷" . "어수선할 준")
     ("撙" . "누를 준")
     ("皴" . "주름 준")
     ("綧" . "피륙의 폭의 넓이 준")
     ("罇" . "樽·尊과 同字")
     ("踆" . "그칠 준")
     ("蹲" . "걸터앉을 준")
     ("鐏" . "창고달 준")
     ("隼" . "새매 준")
     ("餕" . "대궁 준")
     ("鱒" . "송어 준")
     ("鵔" . "금계 준"))
    ("줄"
     ("茁" . "풀 처음 나는 모양 줄")
     ("乼" . "줄 줄")
     ("啐" . "지껄일 줄")
     ("誶" . "몰아 세울 줄, 꾸짖을 줄"))
    ("중"
     ("中" . "가운데 중")
     ("仲" . "버금 중")
     ("衆" . "무리 중")
     ("重" . "무거울 중")
     ("眾" . "衆의 本字"))
    ("즉"
     ("卽" . "곧 즉")
     ("即" . "卽의 俗字")
     ("鯽" . "붕어 즉"))
    ("즐"
     ("櫛" . "빗 즐")
     ("喞" . "두런거릴 즐")
     ("騭" . "수말 즐"))
    ("즙"
     ("揖" . "모을 즙")
     ("楫" . "노 즙")
     ("汁" . "즙 즙")
     ("緝" . "자을 즙")
     ("葺" . "기울 즙")
     ("檝" . "楫과 同字")
     ("蕺" . "삼백초 즙"))
    ("증"
     ("增" . "불을 증")
     ("憎" . "미워할 증")
     ("拯" . "건질 증")
     ("曾" . "일찍 증")
     ("橙" . "귤 증")
     ("烝" . "김 오를 증")
     ("甑" . "시루 증")
     ("症" . "증세 증")
     ("繒" . "비단 증")
     ("蒸" . "찔 증")
     ("證" . "증거 증")
     ("贈" . "보낼 증")
     ("噌" . "시끄러울 증")
     ("増" . "더할 증")
     ("嶒" . "산 높고 험할 증")
     ("矰" . "주살 증")
     ("罾" . "어망 증"))
    ("지"
     ("之" . "갈 지")
     ("只" . "다만 지")
     ("咫" . "길이 지")
     ("地" . "땅 지")
     ("址" . "터 지")
     ("底" . "이룰 지, 정할 지, 이를 지")
     ("志" . "뜻 지")
     ("抵" . "칠 지")
     ("持" . "가질 지")
     ("指" . "손가락 지")
     ("摯" . "잡을 지")
     ("支" . "가를 지")
     ("旨" . "맛있을 지")
     ("智" . "슬기 지")
     ("枝" . "가지 지")
     ("枳" . "탱자나무 지")
     ("止" . "발 지")
     ("氏" . "나라이름 지")
     ("池" . "못 지")
     ("沚" . "물가 지")
     ("漬" . "담글 지")
     ("知" . "알 지")
     ("砥" . "숫돌 지")
     ("祇" . "마침 지")
     ("祉" . "복 지")
     ("祗" . "공경할 지")
     ("紙" . "종이 지")
     ("肢" . "사지 지")
     ("脂" . "기름 지")
     ("至" . "이를 지")
     ("芝" . "지초 지")
     ("芷" . "구리때 지")
     ("蜘" . "거미 지")
     ("誌" . "기록할 지")
     ("識" . "표할 지")
     ("質" . "贄와 同字")
     ("贄" . "폐백 지")
     ("趾" . "발 지")
     ("遲" . "늦을 지")
     ("識" . "표할 지")
     ("凪" . "바람이 자고 파도 그칠 지")
     ("厎" . "숫돌 지")
     ("吱" . "가는 소리 지")
     ("坻" . "모래섬 지")
     ("墀" . "계단 위의 공지 지")
     ("扺" . "손바닥 지")
     ("榰" . "주춧돌 지")
     ("泜" . "강 이름 지")
     ("痣" . "사마귀 지")
     ("秖" . "마침 지")
     ("秪" . "벼 처음 익을 지")
     ("篪" . "저 이름 지")
     ("舐" . "핥을 지")
     ("踟" . "머뭇거릴 지")
     ("躓" . "넘어질 지")
     ("軹" . "굴대 머리 지")
     ("逇" . "구덩이 지")
     ("遅" . "더딜 지")
     ("遟" . "더딜 지")
     ("阯" . "터 지")
     ("鮨" . "젓갈 지")
     ("鷙" . "맹금 지"))
    ("직"
     ("直" . "곧을 직")
     ("稙" . "올벼 직")
     ("稷" . "기장 직")
     ("織" . "짤 직")
     ("職" . "벼슬 직")
     ("喞" . "찍찍거릴 직")
     ("禝" . "사람 이름 직"))
    ("진"
     ("唇" . "놀랄 진")
     ("嗔" . "성낼 진")
     ("塡" . "누를 진")
     ("塵" . "띠끌 진")
     ("振" . "떨칠 진")
     ("搢" . "꽂을 진")
     ("晉" . "進과 同字")
     ("晋" . "晉의 俗字")
     ("桭" . "평고대 진")
     ("榛" . "개암나무 진")
     ("殄" . "끊어질 진")
     ("津" . "나루 진")
     ("溱" . "많을 진")
     ("珍" . "보배 진")
     ("瑨" . "아름다운 돌 진")
     ("璡" . "옥돌 진")
     ("甄" . "질그릇 구울 진")
     ("畛" . "두렁길 진")
     ("疹" . "홍역 진")
     ("盡" . "다할 진")
     ("眞" . "참 진")
     ("瞋" . "부릅뜰 진")
     ("秦" . "벼 이름 진")
     ("縉" . "搢과 同字")
     ("縝" . "삼실 진")
     ("臻" . "이를 진")
     ("蔯" . "더워지기 진")
     ("袗" . "홑옷 진")
     ("診" . "볼 진")
     ("賑" . "구휼할 진")
     ("軫" . "수레 뒤턱 나무 진")
     ("辰" . "다섯째지지 진")
     ("進" . "나아갈 진")
     ("鎭" . "누를 진")
     ("陣" . "줄 진")
     ("陳" . "늘어놓을 진")
     ("震" . "벼락 진")
     ("侲" . "동자 진")
     ("儘" . "盡과 同字")
     ("嚍" . "화낼 진")
     ("填" . "塡의 俗字")
     ("尽" . "盡의 俗字")
     ("珒" . "옥 이름 진")
     ("琎" . "옥돌 진")
     ("稹" . "떨기로 날 진")
     ("蓁" . "우거질 진")
     ("螴" . "설렐 진")
     ("趁" . "좇을 진")
     ("鉁" . "보배 진")
     ("鎮" . "鎭의 俗字")
     ("鬒" . "숱 많을 진"))
    ("질"
     ("佚" . "흐릴 질")
     ("侄" . "어리석을 질")
     ("叱" . "꾸짖을 질")
     ("姪" . "조카 질")
     ("嫉" . "미워할 질")
     ("帙" . "책갑 질")
     ("桎" . "차꼬 질")
     ("瓆" . "사람 이름 질")
     ("疾" . "병 질")
     ("秩" . "차례 질")
     ("窒" . "막을 질")
     ("膣" . "새살 날 질")
     ("蛭" . "거머리 질")
     ("質" . "바탕 질")
     ("跌" . "넘어질 질")
     ("迭" . "갈마들 질")
     ("儨" . "바를 질")
     ("厔" . "막을 질")
     ("呹" . "소리 질")
     ("垤" . "개밋둑 질")
     ("絰" . "질 질")
     ("腟" . "膣과 同字")
     ("蒺" . "납가새 질")
     ("郅" . "고을 이름 질")
     ("鑕" . "모루 질"))
    ("짐"
     ("斟" . "술 따를 짐")
     ("朕" . "나 짐")
     ("鴆" . "짐새 짐"))
    ("집"
     ("什" . "세간 집")
     ("執" . "잡을 집")
     ("汁" . "진액 집, 진눈깨비 집, 국 집")
     ("潗" . "샘솟을 집")
     ("緝" . "낳을 집")
     ("輯" . "모을 집")
     ("鏶" . "판금 집")
     ("集" . "모일 집")
     ("什" . "세간 집")
     ("卙" . "많을 집")
     ("咠" . "참소할 집")
     ("戢" . "그칠 집"))
    ("짓"
     ("嗭" . "땅 이름 짓"))
    ("징"
     ("徵" . "부를 징")
     ("懲" . "혼날 징")
     ("澄" . "맑을 징")
     ("徴" . "부를 징")
     ("澂" . "澄과 同字")
     ("瀓" . "맑을 징")
     ("癥" . "적취 징")
     ("瞪" . "바로 볼 징"))
    ("차"
     ("且" . "또 차")
     ("侘" . "실의할 차")
     ("借" . "빌 차")
     ("叉" . "깍지낄 차")
     ("嗟" . "탄식할 차")
     ("嵯" . "우뚝 솟을 차")
     ("差" . "어긋날 차")
     ("次" . "버금 차")
     ("此" . "이 차")
     ("磋" . "윤낼 차")
     ("箚" . "차자 차")
     ("茶" . "차 차")
     ("蹉" . "넘어질 차")
     ("車" . "수레 차")
     ("遮" . "막을 차")
     ("釵" . "비녀 차")
     ("茶" . "차 차")
     ("仛" . "위탁할 차")
     ("佽" . "도울 차")
     ("偖" . "찢을 차")
     ("剳" . "낫 차")
     ("劄" . "차자 차")
     ("咱" . "우리 차")
     ("唶" . "탄식할 차")
     ("嗻" . "말 많을 차")
     ("奓" . "오만할 차")
     ("岔" . "갈림길 차")
     ("徣" . "빌릴 차")
     ("扯" . "찢어버릴 차")
     ("搓" . "비빌 차")
     ("搽" . "칠할 차")
     ("槎" . "뗏목 차")
     ("瑳" . "깨끗할 차")
     ("硨" . "조개 이름 차")
     ("齄" . "코가 붉게 부을 차")
     ("齜" . "이를 갈 차"))
    ("착"
     ("捉" . "잡을 착")
     ("搾" . "짤 착")
     ("昔" . "옛 착")
     ("着" . "붙을 착")
     ("窄" . "좁을 착")
     ("著" . "분명할 착")
     ("躇" . "머뭇거릴 착")
     ("錯" . "섞일 착")
     ("鑿" . "뚫을 착")
     ("齪" . "악착할 착")
     ("丵" . "풀이 우거질 착")
     ("剒" . "벨 착")
     ("戳" . "창으로 찌를 착")
     ("擉" . "찌를 착")
     ("斲" . "깎을 착")
     ("諑" . "헐뜯을 착"))
    ("찬"
     ("撰" . "지을 찬")
     ("澯" . "맑을 찬")
     ("燦" . "빛날 찬")
     ("璨" . "빛날 찬")
     ("瓚" . "제기 찬")
     ("竄" . "숨을 찬")
     ("簒" . "빼앗을 찬")
     ("粲" . "정미 찬")
     ("纂" . "모을 찬")
     ("纘" . "이을 찬")
     ("讚" . "기릴 찬")
     ("贊" . "도울 찬")
     ("鑽" . "끌 찬")
     ("餐" . "먹을 찬")
     ("饌" . "반찬 찬")
     ("丳" . "꼬챙이 찬")
     ("儧" . "모일 찬")
     ("儹" . "모을 찬")
     ("兓" . "도울 찬, 기릴 찬")
     ("劗" . "끊을 찬")
     ("囋" . "기릴 찬")
     ("巑" . "높이 솟을 찬")
     ("攢" . "모일 찬")
     ("欑" . "모일 찬")
     ("爨" . "불땔 찬")
     ("篡" . "빼앗을 찬")
     ("繤" . "지을 찬")
     ("纉" . "이을 찬")
     ("讃" . "기릴 찬")
     ("賛" . "도울 찬")
     ("趲" . "놀라 흩어질 찬"))
    ("찰"
     ("刹" . "절 찰")
     ("察" . "살필 찰")
     ("擦" . "뿌릴 찰")
     ("札" . "패 찰")
     ("獺" . "수달 찰")
     ("紮" . "감을 찰")
     ("剎" . "절 찰")
     ("咱" . "나 찰")
     ("哳" . "새소리 찰")
     ("囋" . "기릴 찰")
     ("扎" . "뺄 찰")
     ("拶" . "핍박할 찰"))
    ("참"
     ("僭" . "참람할 참")
     ("參" . "간여할 참")
     ("塹" . "구덩이 참")
     ("慘" . "참혹할 참")
     ("慙" . "부끄러울 참")
     ("懺" . "뉘우칠 참")
     ("斬" . "벨 참")
     ("渗" . "스밀 참")
     ("漸" . "점점 참")
     ("站" . "우두커니 설 참")
     ("讒" . "참소할 참")
     ("讖" . "참서 참")
     ("僣" . "교활할 참")
     ("儳" . "어긋날 참")
     ("劖" . "새길 참")
     ("厽" . "흙을 쌓아서 담 쌀 참")
     ("参" . "간여할 참")
     ("叄" . "간여할 참")
     ("叅" . "의논할 참")
     ("噆" . "깨물 참")
     ("嶄" . "높을 참")
     ("巉" . "가파를 참")
     ("惨" . "참혹할 참")
     ("慚" . "부끄러울 참")
     ("憯" . "슬퍼할 참")
     ("攙" . "찌를 참")
     ("槧" . "판 참")
     ("欃" . "살별 참")
     ("毚" . "토끼 참")
     ("滲" . "스밀 참")
     ("譖" . "참소할 참")
     ("鏨" . "끌 참")
     ("鑱" . "보습 참")
     ("饞" . "탐할 참")
     ("驂" . "곁마 참")
     ("黲" . "검푸르죽죽할 참"))
    ("창"
     ("倉" . "곳집 창")
     ("倡" . "여광대 창")
     ("創" . "비롯할 창")
     ("唱" . "노래 창")
     ("娼" . "몸 파는 여자 창")
     ("廠" . "헛간 창")
     ("彰" . "밝을 창")
     ("愴" . "슬퍼할 창")
     ("敞" . "높을 창")
     ("昌" . "창성할 창")
     ("昶" . "밝을 창")
     ("暢" . "펼 창")
     ("槍" . "창 창")
     ("滄" . "찰 창")
     ("漲" . "불을 창")
     ("猖" . "미쳐 날뛸 창")
     ("瘡" . "부스럼 창")
     ("窓" . "창 창")
     ("脹" . "배부를 창")
     ("艙" . "선창 창")
     ("菖" . "창포 창")
     ("蒼" . "푸를 창")
     ("倀" . "미칠 창")
     ("傖" . "천할 창")
     ("凔" . "찰 창")
     ("刅" . "해칠 창")
     ("刱" . "비롯할 창")
     ("剏" . "비롯할 창")
     ("剙" . "비롯할 창")
     ("嗆" . "새 먹을 창")
     ("囪" . "굴뚝 창")
     ("囱" . "천장 창")
     ("悵" . "슬퍼할 창")
     ("惝" . "멍할 창")
     ("戧" . "다칠 창")
     ("搶" . "닿을 창")
     ("椙" . "삼나무 창")
     ("氅" . "새털 창")
     ("瑲" . "옥 소리 창")
     ("窗" . "창 창")
     ("窻" . "창 창")
     ("蹌" . "추창할 창")
     ("鯧" . "병어 창"))
    ("채"
     ("債" . "빚 채")
     ("埰" . "영지 채")
     ("寀" . "녹봉 채")
     ("寨" . "울짱 채")
     ("彩" . "무늬 채")
     ("採" . "캘 채")
     ("柴" . "섶 채")
     ("砦" . "울타리 채")
     ("祭" . "제사 채")
     ("綵" . "비단 채")
     ("菜" . "나물 채")
     ("蔡" . "거북 채")
     ("責" . "꾸짖을 채")
     ("采" . "캘 채")
     ("釵" . "비녀 채")
     ("囆" . "사람 이름 채")
     ("棌" . "참나무 채")
     ("睬" . "주목할 채")
     ("茝" . "구리때 채")
     ("踩" . "뛸 채"))
    ("책"
     ("冊" . "책 책")
     ("措" . "둘 책")
     ("柵" . "울짱 책")
     ("策" . "채찍 책")
     ("翟" . "꿩 책")
     ("責" . "꾸짖을 책")
     ("册" . "책 책")
     ("厇" . "찢을 책")
     ("唶" . "부르짖을 책")
     ("嘖" . "외칠 책")
     ("幘" . "건 책")
     ("柞" . "나무 이름 책")
     ("栅" . "울짱 책")
     ("磔" . "찢을 책")
     ("笧" . "책 상자 책")
     ("簀" . "살평상 책")
     ("蚱" . "벼메뚜기 책"))
    ("처"
     ("凄" . "쓸쓸할 처")
     ("妻" . "아내 처")
     ("悽" . "슬퍼할 처")
     ("狙" . "원숭이 처")
     ("處" . "살 처")
     ("処" . "위치할 처")
     ("淒" . "쓸쓸할 처")
     ("萋" . "풀 성하게 우거진 모양 처")
     ("褄" . "깃의 가 처")
     ("覷" . "엿볼 처")
     ("郪" . "고을 이름 처"))
    ("척"
     ("倜" . "대범할 척")
     ("刺" . "찌를 척")
     ("剔" . "바를 척")
     ("尺" . "자 척")
     ("慽" . "근심할 척")
     ("戚" . "겨레 척")
     ("拓" . "주울 척")
     ("擲" . "던질 척")
     ("斥" . "물리칠 척")
     ("滌" . "씻을 척")
     ("瘠" . "파리할 척")
     ("脊" . "등성마루 척")
     ("蹠" . "밟을 척")
     ("適" . "갈 척")
     ("陟" . "오를 척")
     ("隻" . "새 한 마리 척")
     ("刺" . "찌를 척")
     ("俶" . "시작할 척")
     ("呎" . "길이 단위 척")
     ("坧" . "기지 척")
     ("塉" . "메마른 땅 척")
     ("惕" . "두려워할 척")
     ("惖" . "존경할 척")
     ("慼" . "근심할 척")
     ("捗" . "거둘 척")
     ("摭" . "주울 척")
     ("蜴" . "도마뱀 척")
     ("跖" . "발바닥 척")
     ("躑" . "머뭇거릴 척")
     ("齣" . "단락 척"))
    ("천"
     ("串" . "꿸 천")
     ("仟" . "일천 천")
     ("千" . "일천 천")
     ("喘" . "헐떡거릴 천")
     ("天" . "하늘 천")
     ("川" . "내 천")
     ("撰" . "지을 천, 가질 천, 모을 천, 고를 천")
     ("擅" . "멋대로 천")
     ("泉" . "샘 천")
     ("淺" . "얕을 천")
     ("玔" . "옥고리 천")
     ("穿" . "뚫을 천")
     ("舛" . "어그러질 천")
     ("薦" . "천거할 천")
     ("賤" . "천할 천")
     ("踐" . "밟을 천")
     ("遷" . "옮길 천")
     ("釧" . "팔찌 천")
     ("闡" . "열 천")
     ("阡" . "두렁 천")
     ("韆" . "그네 천")
     ("俴" . "엷을 천")
     ("倩" . "예쁠 천")
     ("僢" . "어그러질 천")
     ("儃" . "머뭇거릴 천")
     ("兛" . "킬로그램 천")
     ("刋" . "끊을 천")
     ("嘽" . "많을 천")
     ("囅" . "웃는 모양 천")
     ("圌" . "둥근 대그릇 천")
     ("洊" . "이를 천")
     ("浅" . "얕을 천")
     ("濺" . "흩뿌릴 천")
     ("瓩" . "킬로그램 천")
     ("祆" . "하늘 천")
     ("粁" . "킬로메트르 천")
     ("臶" . "거듭 천")
     ("芊" . "풀 무성할 천")
     ("茜" . "꼭두서니 천")
     ("荐" . "거듭할 천")
     "莤"
     ("蒨" . "대가 우거질 천")
     ("蕆" . "경계할 천")
     ("蚕" . "지렁이 천")
     ("践" . "밟을 천")
     ("辿" . "천천히 걸을 천")
     ("靝" . "하늘 천")
     ("韉" . "언치 천"))
    ("철"
     ("凸" . "볼록할 철")
     ("哲" . "밝을 철")
     ("喆" . "哲과 同字")
     ("徹" . "통할 철")
     ("撤" . "거둘 철")
     ("澈" . "물 맑을 철")
     ("綴" . "꿰맬 철")
     ("輟" . "그칠 철")
     ("轍" . "바퀴 자국 철")
     ("鐵" . "쇠 철")
     ("剟" . "깎을 철")
     ("勶" . "버릴 철, 일으킬 철, 사무칠 철")
     ("叕" . "이을 철, 잇댈 철")
     ("啜" . "마실 철")
     ("囅" . "껄껄 웃을 철")
     ("埑" . "밝을 철")
     ("惙" . "근심할 철")
     ("掇" . "주울 철")
     ("掣" . "끌 철")
     ("歠" . "마실 철")
     ("鉄" . "쇠 철")
     ("銕" . "鐵의 古字")
     ("錣" . "물미 철")
     ("飻" . "탐할 철")
     ("餮" . "탐할 철"))
    ("첨"
     ("僉" . "다 첨")
     ("尖" . "뾰족할 첨")
     ("沾" . "더할 첨")
     ("添" . "더할 첨")
     ("甛" . "달 첨")
     ("瞻" . "볼 첨")
     ("簽" . "농 첨")
     ("籤" . "제비 첨")
     ("詹" . "이를 첨")
     ("諂" . "아첨할 첨")
     ("幨" . "휘장 첨")
     ("忝" . "더럽힐 첨")
     ("惉" . "팰 첨")
     ("槧" . "편지 첨")
     ("檐" . "처마 첨")
     ("櫼" . "쐐기 첨")
     ("瀸" . "적실 첨")
     ("甜" . "달 첨")
     ("簷" . "처마 첨")
     ("襜" . "행주치마 첨"))
    ("첩"
     ("堞" . "성가퀴 첩")
     ("妾" . "첩 첩")
     ("帖" . "표제 첩")
     ("捷" . "이길 첩")
     ("牒" . "글씨판 첩")
     ("疊" . "거듭 첩, 포갤 첩")
     ("睫" . "속눈썹 첩")
     ("褶" . "덧옷 첩, 겹옷 첩")
     ("諜" . "염탐할 첩")
     ("貼" . "붙을 첩")
     ("輒" . "문득 첩")
     ("倢" . "빠를 첩")
     ("呫" . "맛 볼 첩, 귀에 대고 소근거릴 첩, 앙징할 첩")
     ("喋" . "재잘거릴 첩")
     ("怗" . "고요할 첩")
     ("褺" . "겹옷 첩"))
    ("청"
     ("廳" . "관청 청")
     ("晴" . "갤 청")
     ("淸" . "맑을 청")
     ("聽" . "들을 청")
     ("菁" . "부추꽃 청")
     ("請" . "청할 청")
     ("靑" . "푸를 청")
     ("鯖" . "청어 청")
     ("凊" . "서늘할 청")
     ("圊" . "뒷간 청")
     ("庁" . "관청 청")
     ("清" . "맑을 청")
     ("聴" . "들을 청")
     ("聼" . "들을 청")
     ("蜻" . "귀뚜라미 청")
     ("鋹" . "날카로울 청")
     ("錆" . "자세할 청")
     ("閶" . "천문 청")
     ("青" . "푸를 청")
     ("鬯" . "울창주 청")
     ("鶄" . "교청새 청")
     ("鶬" . "왜가리 청")
     ("晴" . "갤 청"))
    ("체"
     ("切" . "온통 체")
     ("剃" . "머리 깎을 체")
     ("帖" . "표제 체")
     ("替" . "바꿀 체")
     ("涕" . "눈물 체")
     ("滯" . "막힐 체")
     ("綴" . "꿰멜 체")
     ("締" . "맺을 체")
     ("諦" . "살필 체")
     ("逮" . "미칠 체")
     ("遞" . "갈마들 체")
     ("體" . "몸 체")
     ("切" . "자를 체")
     ("体" . "몸 체")
     ("啑" . "콧김 불 체")
     ("嚏" . "재채기 할 체")
     ("嚔" . "재채기 할 체")
     ("彘" . "돼지 체")
     ("掣" . "끌어당길 체")
     ("棣" . "산앵두나무 체")
     ("殢" . "나른할 체")
     ("砌" . "섬돌 체")
     ("蒂" . "작은 가시 체")
     ("蔕" . "작은 가시 체")
     ("蕞" . "작은 모양 체")
     ("軆" . "몸 체")
     ("靆" . "구름 낄 체")
     ("髰" . "머리깎을 체, 땋은머리 체"))
    ("초"
     ("初" . "처음 초")
     ("剿" . "죽일 초")
     ("哨" . "망 볼 초")
     ("憔" . "수척할 초")
     ("抄" . "베낄 초")
     ("招" . "부를 초")
     ("梢" . "나무 끝 초")
     ("椒" . "산초나무 초")
     ("楚" . "회초리 초")
     ("樵" . "땔나무 초")
     ("炒" . "볶을 초")
     ("焦" . "그슬릴 초")
     ("硝" . "초석 초")
     ("礁" . "암초 초")
     ("礎" . "주춧돌 초")
     ("秒" . "시간 단위 초")
     ("稍" . "벼 줄기 끝 초")
     ("肖" . "닮을 초")
     ("艸" . "풀 초")
     ("苕" . "능소화 초")
     ("草" . "풀 초")
     ("蕉" . "파초 초")
     ("貂" . "담비 초")
     ("超" . "뛰어넘을 초")
     ("酢" . "초 초")
     ("醋" . "초산 초")
     ("醮" . "초례 초")
     ("偢" . "얼이 빠져 있을 초")
     ("僬" . "밝게 살필 초")
     ("劭" . "힘쓸 초")
     ("勦" . "수고롭게 할 초")
     ("吵" . "지저궐 초")
     ("嘮" . "이야기할 초")
     ("噍" . "먹을 초")
     ("嫶" . "수척할 초")
     ("岧" . "산이 높을 초")
     ("峭" . "가파를 초")
     ("嶕" . "높을 초")
     ("怊" . "슬퍼할 초")
     ("悄" . "근심할 초")
     ("愀" . "정색할 초")
     ("杪" . "끝 초")
     ("燋" . "홰 초")
     ("綃" . "생명주실 초")
     ("耖" . "밭 거듭 갈 초")
     ("誚" . "꾸짖을 초")
     ("譙" . "꾸짖을 초")
     ("趠" . "멀 초")
     ("軺" . "수레 초")
     ("迢" . "멀 초")
     ("鈔" . "노략질할 초")
     ("鍫" . "가래 초")
     ("鍬" . "가래 초")
     ("鞘" . "칼집 초")
     ("顦" . "야윌 초")
     ("髫" . "다박머리 초")
     ("鷦" . "뱁새 초")
     ("齠" . "이를 갈 초"))
    ("촉"
     ("促" . "핍박할 촉, 촉박할 촉, 좁을 촉, 빠를 촉, 짧을 촉")
     ("囑" . "부탁할 촉")
     ("屬" . "이을 촉, 닿을 촉, 부탁할 촉, 모을 촉, 조심할 촉")
     ("燭" . "爥의 俗字")
     ("矗" . "곧을 촉, 우뚝 솟을 촉")
     ("蜀" . "촉규화벌레 촉, 큰 닭 촉")
     ("觸" . "받을 촉, 느낄 촉, 지날 촉, 범할 촉")
     ("趨" . "빠를 촉")
     ("亍" . "자축거릴 촉, 겨우 디딜 촉")
     ("劚" . "깎을 촉")
     ("嘱" . "囑의 俗字")
     ("属" . "屬의 俗字")
     ("数" . "빽빽할 촉")
     ("曯" . "비칠 촉")
     ("爥" . "비칠 촉")
     ("矚" . "볼 촉")
     ("薥" . "촉규화 촉, 자귀밥 촉")
     ("触" . "觸의 俗字")
     ("躅" . "자취 촉, 강동강동 뛸 촉, 철쭉꽃 촉")
     ("髑" . "해골 촉"))
    ("촌"
     ("寸" . "치 촌, 마디 촌, 헤아릴 촌, 조금 촌")
     ("忖" . "헤아릴 촌, 짐작할 촌")
     ("村" . "마을 촌, 밭집 촌, 시골 촌")
     ("邨" . "村과 同字")
     ("刌" . "끊을 촌")
     ("吋" . "인치(inch) 촌"))
    ("촐"
     "伜")
    ("총"
     ("叢" . "떨기 총, 모을 총, 번잡할 총")
     ("塚" . "冢의 俗字")
     ("寵" . "사랑할 총, 임금께 총애받을 총, 은혜 총, 첩 총")
     ("悤" . "바쁠 총, 덤빌 총")
     ("憁" . "실심할 총, 뜻 같지 않을 총")
     ("摠" . "거느릴 총, 모을 총, 무리 총, 장수 총")
     ("縱" . "바쁠 총")
     ("總" . "꿰맬 총, 거느릴 총, 합할 총, 끄덩이 잡을 총")
     ("聰" . "귀 밝을 총, 민첩할 총")
     ("蔥" . "파 총, 파 뿌리 총, 푸를 총")
     ("銃" . "도끼 구멍 총, 총 총")
     ("偬" . "傯의 俗字")
     ("傯" . "바쁠 총, 곤궁할 총")
     ("冢" . "무덤 총")
     ("匆" . "바쁠 총")
     ("囪" . "囱과 同字")
     ("囱" . "굴뚝 총")
     ("怱" . "悤의 俗字")
     ("惣" . "摠의 譌字")
     ("総" . "總과 同字")
     ("縂" . "総과 同字")
     ("縦" . "縱과 同字")
     ("葱" . "풀 더북할 총")
     ("蓯" . "풀 더북할 총")
     ("鏦" . "창 총, 찌를 총")
     ("騘" . "驄과 同字")
     ("驄" . "총이말 총")
     ("塚" . "冢의 俗字"))
    ("촬"
     ("撮" . "머리 끄덩이 잡을 촬, 당길 촬, 비칠 촬"))
    ("쵀"
     ("啐" . "부를 쵀, 놀랄 쵀, 맛 볼 쵀"))
    ("최"
     ("催" . "재촉할 최, 핍박할 최, 일어날 최")
     ("崔" . "산 우뚝할 최, 높고 가파를 최, 성씨 최")
     ("最" . "가장 최, 우뚝할 최, 넉넉할 최")
     ("衰" . "상복 최")
     ("凗" . "눈서리 쌓일 최")
     ("嗺" . "입 옴칠 최, 급히 마실 최")
     ("嘬" . "물 최, 산적 한 입에 넣을 최")
     ("摧" . "꺾을 최, 망할 최, 저지할 최")
     ("榱" . "서까래 최")
     ("漼" . "깊을 최, 고을 최, 눈물 줄줄 흘릴 최, 눈서리 쌓일 최")
     ("璀" . "옥빛 찬란할 최, 구슬 주렁주렁 달릴 최")
     ("磪" . "험하고 높을 최")
     ("縗" . "상복 최, 상옷 최")
     ("脧" . "어린아이 불알 최, 덜릴 최, 덜 최"))
    ("추"
     ("丑" . "수갑 추, 사람이름 추")
     ("出" . "내보낼 추")
     ("墜" . "떨어질 추, 잃을 추")
     ("抽" . "뺄 추, 뽑을 추, 당길 추, 거둘 추")
     ("推" . "옮길 추, 가릴 추, 궁구할 추")
     ("杻" . "수갑 추, 조막손이 추")
     ("椎" . "쇠몽둥이 추, 칠 추, 짓찧을 추, 참나무 추")
     ("楸" . "가래나무 추, 노나무 추, 산유자 추, 바둑판 추")
     ("槌" . "칠 추")
     ("樞" . "밑둥 추, 지두리 추, 고동 추, 북두 첫째 별 추, 긴요할 추, 달 추, 가운데 추")
     ("湫" . "늪 추, 폭포 추, 찌푸릴 추, 서늘할 추")
     ("皺" . "쭈그러질 추")
     ("秋" . "가을 추, 세월 추, 때 추, 말이 뛰놀 추, 성씨 추")
     ("芻" . "꼴 추, 짐승먹이 추")
     ("萩" . "맑은 대쑥 추, 가래나무 추")
     ("諏" . "꾀할 추, 물을 추")
     ("趨" . "달아날 추, 추창할 추")
     ("追" . "쫓을 추, 따를 추")
     ("鄒" . "추나라 추")
     ("酋" . "괴수 추, 두목 추, 숙 익을 추, 끝날 추")
     ("醜" . "추할 추, 같을 추, 무리 추, 자라똥구멍 추, 부끄러울 추")
     ("錐" . "송곳 추")
     ("錘" . "저울눈 추, 마치 추, 저울 추")
     ("鎚" . "쇠마치 추, 저울 추")
     ("雛" . "새 새끼 추, 병아리 추, 어린아이 추")
     ("騶" . "거덜 추, 마부 추, 짐승이름 추")
     ("鰍" . "미꾸라지 추")
     ("僦" . "임금 추, 고용할 추")
     ("僽" . "몹시 욕할 추")
     ("啾" . "두런거릴 추, 찍찍거릴 추")
     ("娵" . "젊을 추, 물고기 추, 예쁜 여자 추")
     ("岀" . "出와 同字")
     ("帚" . "비 추, 털 추")
     ("惆" . "실심할 추, 섭섭할 추")
     ("捶" . "종아리 칠 추, 짓찧을 추")
     ("揫" . "묶을 추, 거둘 추, 모을 추")
     ("搥" . "북 칠 추")
     ("甃" . "우물 벽돌 추")
     ("瘳" . "병 나을 추, 덜릴 추")
     ("穐" . "秋의 古字")
     ("箒" . "비 추")
     ("箠" . "채찍 추, 볼기채 추")
     ("簉" . "버금 추, 가지런히 날 추")
     ("縋" . "줄에 달릴 추")
     ("縐" . "주름 추, 구길 추")
     ("蒭" . "芻와 同字")
     ("陬" . "벼루 추, 정월 추, 부끄러울 추, 마을 추")
     ("隹" . "새 추")
     ("鞦" . "그네 추, 말고들개 추")
     ("騅" . "청부루말 추")
     ("魋" . "북상투 추")
     ("鯫" . "송사리 추, 따라지 추")
     ("鰌" . "미꾸라지 추, 빙자할 추, 해추 추")
     ("鵻" . "아롱비둘기 추")
     ("鶖" . "두루미 추")
     ("鶵" . "새 새끼 추, 새 이름 추, 병아리 추, 어린아이 추")
     ("鹙" . "鶖의 簡體字")
     ("麄" . "麤의 俗字")
     ("麤" . "성길 추, 클 추, 거칠 추")
     ("龝" . "秋의 古字"))
    ("축"
     ("丑" . "소 축, 축시 축, 북동쪽 축")
     ("柚" . "북 축")
     ("畜" . "가축 축, 쌓을 축, 그칠 축")
     ("祝" . "빌 축, 끊을 축, 비로소 축")
     ("竺" . "나라이름 축")
     ("筑" . "비파 축")
     ("築" . "다질 축, 쌓을 축")
     ("縮" . "줄어들 축, 물러갈 축, 거둘 축, 모자랄 축")
     ("蓄" . "쌓을 축, 모을 축, 감출 축")
     "趣"
     ("蹙" . "찡그릴 축, 쭈그러질 축")
     ("蹴" . "찰 축, 밟을 축")
     ("軸" . "바디집 축, 질책 축, 속바퀴 축, 얇을 축")
     ("逐" . "쫓을 축, 물리칠 축")
     ("噈" . "입맞출 축")
     ("妯" . "동서 축")
     ("柷" . "축풍류 축")
     ("槭" . "단풍나무 축")
     ("舳" . "고물 축, 배 꼬리 축")
     ("豖" . "발 얽은 돼지걸음 축")
     ("蹜" . "발 끌어 디딜 축")
     ("閦" . "무리 축, 아축부처 축")
     ("鼀" . "두꺼비 축"))
    ("춘"
     ("春" . "봄 춘, 남녀의 정 춘, 술 춘, 온화할 춘")
     ("椿" . "참죽나무 춘, 대춘나무 춘, 어르신네 춘")
     ("瑃" . "옥 이름 춘")
     ("偆" . "가멸할 춘, 두터울 춘")
     ("萅" . "春의 本字"))
    ("출"
     ("出" . "날 출, 게울 출, 도망할 출, 보일 출, 낳을 출, 물러갈 출, 생질 출")
     ("朮" . "삽주뿌리 출")
     ("黜" . "내칠 출, 물리칠 출")
     ("岀" . "出과 同字")
     "术"
     ("秫" . "차조 출"))
    ("충"
     ("傭" . "고를 충, 가지런할 충")
     ("充" . "가득찰 충, 막을 충, 당할 충")
     ("忠" . "충성 충, 곧을 충")
     ("沖" . "깊을 충, 온화할 충, 어릴 충")
     ("蟲" . "벌레 충, 김 오를 충")
     ("衝" . "충돌할 충, 찌를 충, 거리 충, 돌파할 충")
     ("衷" . "가운데 충, 정성 충, 착할 충, 속곳 충, 마음 충")
     ("冲" . "깊을 충, 온화할 충, 어릴 충")
     ("忡" . "근심할 충")
     ("珫" . "귀 옥고리 충")
     ("种" . "어릴 충")
     ("虫" . "벌레 충"))
    ("췌"
     ("悴" . "근심할 췌, 파리할 췌, 피폐할 췌")
     ("膵" . "첩육경 췌, 지라 췌")
     ("萃" . "모을 췌, 괘 이름 췌")
     ("贅" . "붙일 췌, 데릴사위 췌, 혹 췌, 군더더기 췌")
     ("惴" . "두려워할 췌"))
    ("취"
     ("取" . "거둘 취, 찾을 취, 받을 취, 빼앗을 취, 장가들 취")
     ("吹" . "불 취, 숨쉴 취, 악기 불 취, 부를 취, 충동할 취")
     ("嘴" . "부리 취")
     ("娶" . "장가들 취, 중개인 취")
     ("就" . "좇을 취, 이룰 취, 곧 취, 가령 취, 능할 취, 저자 취")
     ("炊" . "불 지필 취, 밥 지을 취")
     ("翠" . "비취 취, 푸를 취")
     ("聚" . "모을 취, 고을 취, 걷을 취, 쌓을 취")
     ("脆" . "연할 취, 약할 취")
     ("臭" . "냄새 취, 향기 취, 썪을 취, 고약한 이름 취")
     ("趣" . "추창할 취, 뜻 취")
     ("醉" . "술취할 취, 궤란할 취")
     ("驟" . "몰아갈 취, 달릴 취, 별안간 취")
     ("鷲" . "독수리 취")
     ("冣" . "쌓을 취, 모을 취")
     ("揣" . "잴 취, 시험할 취, 요량할 취")
     ("橇" . "진흙 썰매 취")
     ("毳" . "솜털 취, 연하고 부드러울 취")
     "疩"
     ("瘁" . "병들 취, 수고로울 취, 파리할 취")
     ("觜" . "부리 취")
     ("顇" . "파리할 취, 병들 취")
     ("龡" . "불 취"))
    ("측"
     ("仄" . "기울 측, 성조 측, 물이 괄괄 흐를 측, 희미할 측, 옆 측, 돈 이름 측")
     ("側" . "곁 측, 기울어질 측, 저물 측, 배반할 측, 가까울 측, 미천할 측, 아플 측")
     ("則" . "법칙 측, 본받을 측, 모범 측, 때 측")
     ("厠" . "뒷간 측, 평상 가장자리 측, 섞일 측")
     ("惻" . "슬플 측, 감창할 측, 아플 측, 불쌍할 측")
     ("測" . "측량할 측, 깊을 측, 맑을 측, 날카로울 측")
     "嘁")
    ("츤"
     ("儭" . "속옷 츤"))
    ("츰"
     ("闖" . "엿볼 츰, 머리 넘성거리는 모양 츰, 왈칵거릴 츰"))
    ("층"
     ("層" . "겹 층, 거듭 층, 층층대 층")
     ("蹭" . "어정거릴 층"))
    ("치"
     ("侈" . "사치할 치, 넓을 치, 많을 치, 풍부할 치")
     ("値" . "값 치, 가치있을 치, 만날 치, 당할 치")
     ("嗤" . "비웃을 치, 냉소 치")
     ("埴" . "찰진흙 치, 흙 이길 치")
     ("峙" . "산이 우뚝 솟을 치, 갖출 치, 쌓을 치")
     ("嵯" . "산 울뚝질뚝할 치")
     ("差" . "어긋날 치, 오르락 내리락할 치, 구분지을 치")
     ("幟" . "깃대 치")
     ("徵" . "치성 치")
     ("恥" . "부끄럼 치, 욕될 치")
     ("梔" . "치자 치")
     ("植" . "방망이 치, 심을 치, 세울 치, 달굿대 치, 두목 치")
     ("治" . "다스릴 치, 다듬을 치, 익을 치, 치료할 치")
     ("淄" . "물이름 치, 검을 치")
     ("熾" . "불 활활 붙을 치")
     ("痔" . "치질 치")
     ("痴" . "癡의 俗字")
     ("癡" . "어리석을 치, 미련할 치, 미치광이 치, 주근깨 치")
     ("稚" . "어린 벼 치, 어릴 치, 늦을 치")
     ("穉" . "稚와 同字")
     ("緇" . "검을 치")
     ("緻" . "톡톡할 치, 빽빽할 치, 헌 옷 기울 치")
     ("置" . "베풀 치, 버릴 치, 역말 치, 안치할 치")
     "耆"
     ("致" . "이를 치, 극진할 치, 버릴 치, 불러올 치, 풍치 치, 드릴 치, 보낼 치, 연구할 치")
     ("蚩" . "치벌레 치, 어리석을 치, 업신여길 치")
     ("輜" . "짐수레 치, 휘장 친 수레 치")
     ("雉" . "꿩 치, 폐백 치, 성 윗담 치, 목맬 치")
     ("馳" . "달릴 치, 거동길 치, 전할 치")
     ("齒" . "이 치, 나이 치, 같을 치")
     ("值" . "値와 同字")
     ("偨" . "가지런하지 않을 치, 오르락 내리락할 치")
     ("偫" . "기다릴 치, 갖출 치")
     ("卮" . "술잔 치, 연지 치")
     ("哆" . "입 딱 벌일 치")
     ("寘" . "둘 치, 폐할 치, 쉴 치")
     ("巵" . "잔 치, 연지 치")
     ("廁" . "뒷간 치, 평상 가장자리 치, 섞일 치, 버금 치")
     ("徴" . "徵의 略字")
     "昃"
     "樨"
     ("歯" . "齒의 俗字")
     ("畤" . "제터 치")
     ("痓" . "풍병 치, 악할 치")
     ("絺" . "가는 칡베 치, 가는 갈포 치")
     ("耻" . "恥의 俗字")
     ("菑" . "따비밭 치")
     ("薙" . "풀 깎을 치")
     ("袳" . "옷 펼칠 치")
     ("褫" . "옷 빼앗을 치, 벗을 치, 넋 잃을 치")
     ("觶" . "잔 치, 벌술잔 치")
     ("豸" . "발 없는 벌레 치, 풀 치, 해치양 치")
     ("跱" . "머뭇거릴 치, 주저할 치, 갖출 치")
     ("錙" . "저울눈 치, 조금 치")
     ("阤" . "떨어질 치, 헐릴 치, 언덕 치, 사태날 치")
     ("鯔" . "숭어 치")
     ("鴙" . "雉와 同字")
     ("鴟" . "솔개 치, 수알치 치, 부엉이 치, 말똥구리 치, 토란 치, 마음대로 날릴 치, 올빼미 치")
     ("鵄" . "솔개 치"))
    ("칙"
     ("則" . "법칙 칙, 본받을 칙, 모범 칙, 조목 칙")
     ("勅" . "신칙할 칙, 칙령 칙")
     ("飭" . "갖출 칙, 닦을 칙, 부지런할 칙")
     ("侙" . "두려워할 칙")
     ("勑" . "바를 칙, 다스릴 칙")
     ("敕" . "경계할 칙, 다스릴 칙, 삼갈 칙, 바를 칙, 칙서 칙, 기릴 칙, 신칙할 칙"))
    ("친"
     ("親" . "사랑할 친, 친할 친, 몸소 친, 일가 친, 사돈 친")
     ("嚫" . "베풀 친")
     ("櫬" . "관 친, 무궁화나무 친, 땔나무 친")
     ("藽" . "무궁화 친")
     ("襯" . "속옷 친, 접근할 친, 베풀 친")
     ("齔" . "이 갈 친, 어릴 친"))
    ("칠"
     ("七" . "일곱 칠, 글체이름 칠")
     ("柒" . "漆의 俗字")
     ("漆" . "옻나무 칠, 물이름 칠"))
    ("침"
     ("侵" . "범할 침, 침노할 침, 습격할 침, 흉작 침")
     ("寢" . "잠잘 침, 쉴 침, 방 침, 못생길 침")
     "慘"
     ("枕" . "베개 침, 수레뒤 가로댄 나무 침, 소말뚝 침")
     ("沈" . "장마물 침, 진펄 침, 잠길 침, 채색할 침, 고요할 침")
     ("浸" . "적실 침, 불릴 침, 번질 침, 빠질 침")
     ("湛" . "빠질 침, 잠길 침")
     ("琛" . "보배 침")
     ("砧" . "방칫돌 침, 다듬잇돌 침")
     ("針" . "바늘 침, 침 침, 바느질할 침, 찌를 침")
     ("鍼" . "바늘 침, 침 침")
     ("伈" . "두려워할 침")
     ("兓" . "날카로울 침")
     ("唚" . "입맞출 침")
     ("寖" . "젖을 침, 점점 침")
     ("寝" . "寢과 同字")
     ("忱" . "믿을 침, 정성 침")
     "惨"
     ("椹" . "모탕 침, 도끼바탕 침, 토막 침")
     ("沉" . "沈의 俗字")
     ("郴" . "땅이름 침")
     ("鋟" . "새길 침")
     ("駸" . "말 몰아 달릴 침"))
    ("칩"
     ("蟄" . "벌레 움츠릴 칩, 우물거릴 칩"))
    ("칭"
     ("秤" . "저울 칭, 백 근 칭")
     ("稱" . "저울질할 칭, 일컬을 칭, 헤아릴 칭, 같을 칭")
     ("偁" . "稱의 本字")
     ("称" . "稱과 同字"))
    ("쾌"
     ("快" . "기분이 좋을 쾌, 시원할 쾌, 빠를 쾌")
     ("獪" . "간교할 쾌, 교활할 쾌")
     ("噲" . "목구멍 쾌, 훨할 쾌")
     ("夬" . "결단할 쾌, 나누어 정할 쾌, 괘 이름 쾌"))
    ("타"
     ("他" . "다를 타, 저 타, 간사할 타")
     ("咤" . "꾸짖을 타, 슬플 타, 뿜을 타, 쩍쩍 씹는소리 타")
     ("唾" . "침 타, 버릴 타")
     ("墮" . "떨어질 타, 상투 타, 잃을 타")
     ("妥" . "편안할 타, 일 없을 타, 타협할 타, 떨어질 타")
     ("惰" . "게으를 타, 태만할 타")
     ("打" . "때릴 타")
     ("拖" . "拕와 同字")
     ("朶" . "나무가지 휘늘어질 타, 떨기 타, 움킬 타")
     ("楕" . "橢의 略字")
     ("池" . "물이름 타")
     ("舵" . "키 타")
     ("陀" . "비탈 타, 땅이름 타")
     ("馱" . "탈 타, 짐 실을 타")
     ("駝" . "약대 타, 곱사등이 타")
     ("佗" . "다를 타, 저 타, 마음에 든든할 타, 더할 타, 입을 타, 짊어질 타")
     ("刴" . "찍을 타, 꺾을 타")
     ("吒" . "咤와 同字")
     ("咜" . "咤의 譌字")
     ("嚲" . "휘늘어질 타")
     ("垞" . "언덕 타")
     ("堕" . "墮와 同字")
     ("拕" . "끌 타, 당길 타")
     ("揣" . "헤아릴 타")
     ("朵" . "朶와 同字")
     ("柁" . "키 타")
     ("橢" . "둥글길죽할 타, 수레통 가운데그릇 타, 길죽한 그릇 타")
     ("沱" . "물이 갈래질 타, 큰 비 타, 눈물이 흐를 타")
     ("詫" . "자랑할 타, 풍칠 타, 신통할 타")
     ("跎" . "미끄러질 타")
     ("躱" . "피할 타")
     ("迤" . "어정거릴 타")
     ("駄" . "馱의 俗字")
     "駘"
     ("駞" . "駞와 同字")
     ("鮀" . "모래무지 타")
     ("鴕" . "타조 타")
     ("鼉" . "자라 타"))
    ("탁"
     ("倬" . "환할 탁, 클 탁")
     ("卓" . "높을 탁, 뛰어날 탁, 책상 탁, 성씨 탁")
     ("啄" . "쪼을 탁, 문 두드릴 탁")
     ("坼" . "찢을 탁, 터질 탁, 난산할 탁, 싹 트일 탁")
     ("度" . "꾀할 탁, 헤아릴 탁, 벼슬이름 탁")
     ("托" . "밀칠 탁, 떡국 탁, 차반 탁")
     ("拓" . "물리칠 탁, 헤칠 탁, 밀칠 탁")
     ("擢" . "뽑을 탁, 뺄 탁, 솟을 탁, 이길 탁")
     ("晫" . "환할 탁, 밝을 탁")
     ("柝" . "쪼갤 탁, 조두 탁, 목탁 탁")
     ("濁" . "흐릴 탁, 더러울 탁, 물이름 탁")
     ("濯" . "씻을 탁, 빨래할 탁, 적실 탁, 클 탁, 빛날 탁, 산 민둥민둥할 탁, 살찔 탁, 놀 탁")
     ("琢" . "옥 쪼을 탁, 옥 다듬을 탁, 가릴 탁")
     ("琸" . "사람이름 탁")
     ("託" . "맡길 탁, 부탁할 탁, 핑계할 탁")
     ("鐸" . "요령 탁, 목탁 탁")
     ("度" . "꾀할 탁, 헤아릴 탁, 벼슬이름 탁")
     ("拓" . "물리칠 탁, 헤칠 탁, 밀칠 탁")
     ("仛" . "부칠 탁, 다를 탁")
     ("侂" . "부칠 탁, 부탁할 탁")
     ("剫" . "쪼갤 탁, 건목칠 탁")
     ("吒" . "조롱할 탁")
     ("啅" . "啄과 同字")
     ("噣" . "쪼을 탁")
     ("拆" . "터질 탁, 찢어질 탁, 열릴 탁")
     ("橐" . "전대 탁, 자루 탁, 도가니 탁, 공잇소리 탁, 짐승이름 탁")
     ("沰" . "떨어뜨릴 탁, 돌 던질 탁, 떨어질 탁")
     ("涿" . "물방울 떨어질 탁, 칠 탁, 물이름 탁, 땅이름 탁")
     ("矺" . "나무이름 탁")
     ("籜" . "대 껍질 탁")
     ("蘀" . "떨어질 탁, 마를 탁")
     ("讬" . "託과 同字")
     ("踔" . "우뚝 설 탁, 앙감질 탁")
     ("踱" . "맨발로 걸을 탁, 아금막기할 탁")
     ("逴" . "멀 탁, 절름거릴 탁, 뛰어날 탁"))
    ("탄"
     ("呑" . "삼킬 탄, 휩쌀 탄, 감출 탄, 멸할 탄")
     ("嘆" . "한숨쉴 탄")
     ("坦" . "너그러울 탄, 평평할 탄, 넓을 탄")
     ("彈" . "쏠 탄, 악기부릴 탄, 탄알 탄, 탄핵할 탄")
     ("憚" . "수고로울 탄, 꺼릴 탄")
     ("歎" . "탄식할 탄, 아름답다 할 탄, 화답할 탄")
     ("灘" . "여울 탄, 해 이름 탄")
     ("炭" . "숯 탄, 불똥 탄, 볶일 탄")
     ("綻" . "옷 터질 탄, 나타날 탄, 파할 탄")
     ("袒" . "솔기 터질 탄")
     ("誕" . "기를 탄, 클 탄, 속일 탄, 넓을 탄, 탄생할 탄, 방탕할 탄")
     ("僤" . "도타울 탄, 빠를 탄")
     ("吞" . "呑과 同字")
     ("嘽" . "헐떡거릴 탄, 기꺼워할 탄, 많을 탄")
     ("弹" . "彈과 同字")
     ("弾" . "彈의 略字")
     ("憻" . "坦과 同字")
     ("攤" . "열 탄, 펼칠 탄")
     ("殫" . "다할 탄")
     ("氽" . "뜰 탄, 헤엄칠 탄")
     ("癱" . "중풍증 탄, 사지 틀릴 탄")
     ("驒" . "돈짝무늬총이말 탄"))
    ("탈"
     ("奪" . "빼앗을 탈, 잃어버릴 탈, 좁은 길 탈, 깎을 탈")
     ("稅" . "풀 탈, 끌를 탈")
     ("脫" . "벗어날 탈, 간략할 탈, 뼈 바를 탈, 그르칠 탈")
     ("侻" . "간사할 탈, 가벼울 탈, 간략할 탈")
     ("税" . "稅과 同字")
     ("脱" . "脫과 同字"))
    ("탐"
     ("探" . "더듬을 탐, 찾을 탐, 취할 탐, 염탐할 탐")
     ("眈" . "노려볼 탐, 즐길 탐")
     ("耽" . "즐길 탐, 귀 축 늘어질 탐, 웅크리고 볼 탐, 즐거울 탐, 깊고 멀 탐")
     ("貪" . "탐할 탐, 욕심낼 탐")
     ("僋" . "늘어날 탐, 어리석을 탐")
     ("嗿" . "여럿이 먹는 소리 탐")
     ("忐" . "마음 허전할 탐")
     ("酖" . "술 즐길 탐"))
    ("탑"
     ("塔" . "탑 탑")
     ("搭" . "모뜰 탑, 박을 탑")
     ("榻" . "평상 탑, 모직 탑, 자리 탑")
     ("傝" . "답답할 탑, 불안할 탑, 어리석을 탑, 용렬할 탑")
     ("嗒" . "우두먼할 탑")
     ("嚃" . "훅 들어마실 탑")
     ("塌" . "낮은 땅 탑, 초벌갈 탑, 떨어질 탑")
     ("搨" . "비문 박을 탑, 베낄 탑")
     ("撘" . "搭과 同字")
     ("鰨" . "큰 배 탑"))
    ("탕"
     ("宕" . "골집 탕, 방탕할 탕, 석수 탕")
     ("帑" . "나라 곳집 탕")
     ("湯" . "물 끓일 탕, 물이름 탕, 씻을 탕")
     ("糖" . "엿 탕, 사탕 탕")
     ("蕩" . "넓고 클 탕, 없어질 탕, 방탕할 탕, 소탕할 탕")
     ("糖" . "엿 탕, 사탕 탕")
     ("偒" . "헌걸찰 탕")
     ("燙" . "씻을 탕, 불에 델 탕")
     ("盪" . "씻을 탕, 움직일 탕, 진동할 탕, 그릇 부실 탕, 뭍 배질할 탕")
     ("碭" . "무늬진 돌 탕, 흰 기운 탕, 넘칠 탕, 산이름 탕")
     ("蘯" . "盪과 同字"))
    ("태"
     ("兌" . "기쁠 태, 지름길 태, 모일 태, 통할 태, 곧을 태, 구멍 태, 바꿀 태, 괘 이름 태")
     ("台" . "별 태, 늙을 태")
     ("大" . "클 태, 굵을 태")
     ("太" . "클 태, 굵을 태, 심할 태, 처음 태, 콩 태")
     ("怠" . "게으를 태, 느릴 태, 거만할 태")
     ("態" . "모양 태, 뜻 태")
     ("殆" . "위태할 태, 가까이할 태, 비롯할 태")
     ("汰" . "미끄러울 태, 넘칠 태, 씻길 태, 사치할 태")
     ("泰" . "클 태, 통할 태, 너그러울 태, 편안할 태, 괘 이름 태")
     ("笞" . "볼기칠 태")
     ("胎" . "아이 밸 태, 시작 태")
     ("脫" . "천천할 태, 더딜 태")
     ("苔" . "이끼 태")
     ("跆" . "밟을 태")
     ("逮" . "미칠 태, 쫓을 태")
     ("邰" . "태나라 태")
     ("銳" . "창 태")
     ("颱" . "몹시 부는 바람 태")
     ("兊" . "兌의 俗字")
     ("兑" . "兌와 同字")
     "呆"
     ("埭" . "보뚝 태")
     ("娧" . "기뻐할 태, 더딜 태")
     ("孡" . "아이 밸 태")
     ("抬" . "칠 태")
     ("脱" . "脫와 同字")
     ("詒" . "속일 태")
     ("迨" . "미칠 태")
     ("鋭" . "銳와 同字")
     ("鮐" . "복 태, 늙은이 등에 복 무늬 날 태"))
    ("택"
     ("宅" . "집 택, 자리 택, 살 택, 정할 택, 묘 구덩이 택")
     ("擇" . "가릴 택, 추릴 택, 차별할 택")
     ("澤" . "못 택, 진펄 택, 진액 택, 윤택할 택, 비와 이슬 택")
     ("宅" . "집 택, 자리 택, 살 택, 정할 택, 묘 구덩이 택")
     ("択" . "擇의 略字")
     ("沢" . "澤의 略字"))
    ("탱"
     "幀"
     ("撑" . "撐의 俗字")
     ("撐" . "버틸 탱, 취할 탱, 헤칠 탱")
     ("牚" . "버틸 탱, 버팀목 탱"))
    ("터"
     ("攄" . "펼칠 터, 흩을 터, 날칠 터, 비길 터"))
    ("토"
     ("兎" . "兔의 俗字")
     ("吐" . "토할 토, 나올 토, 펼 토")
     ("土" . "흙 토, 뿌리 토, 나라 토, 뭍 토")
     ("套" . "장대할 토, 씌울 토, 캐캐묵을 토, 껍질 토, 땅이 굽어진 곳 토")
     ("討" . "다스릴 토, 칠 토, 찾을 토, 벨 토, 꾸짖을 토")
     ("兔" . "토끼 토"))
    ("톤"
     ("啍" . "입김 톤, 느럭느럭할 톤")
     ("噋" . "啍과 同字")
     "噸"
     ("瓲" . "단위 톤(ton) 톤"))
    ("통"
     ("慟" . "서러울 통")
     ("桶" . "엿되들이 통 통")
     ("洞" . "구렁 통, 깊을 통, 빌 통, 밝을 통")
     ("痛" . "아플 통, 상할 통, 심할 통, 몹시 통")
     ("筒" . "사통대 통, 통 통")
     ("統" . "거느릴 통, 벼리 통, 실마디 통, 근본 통, 이을 통")
     ("通" . "뚫릴 통, 사무칠 통, 형통할 통, 사귈 통, 다닐 통, 간음할 통")
     ("洞" . "구렁 통, 깊을 통, 빌 통, 밝을 통")
     ("恫" . "슬플 통, 아플 통, 앓을 통")
     ("樋" . "대 홈 통, 어름나무 통")
     ("筩" . "대나무통 통, 낚시 통"))
    ("퇴"
     ("堆" . "흙무더기 퇴 놓을 퇴, 언덕 퇴")
     ("推" . "밀 퇴")
     ("敦" . "쪼을 퇴, 모을 퇴, 다스릴 퇴, 끊을 퇴, 곱송거릴 퇴, 성낼 퇴")
     ("槌" . "몽둥이 퇴, 너스레 퇴, 누에시렁 퇴, 던질 퇴")
     ("腿" . "넓적다리 퇴")
     ("褪" . "옷 벗을 퇴, 꽃빛 옅어질 퇴")
     ("追" . "옥 다듬을 퇴, 쇠북 꼭지 퇴")
     ("退" . "물러갈 퇴, 겸양할 퇴, 물리칠 퇴")
     ("鎚" . "옥 다듬을 퇴")
     ("頹" . "기울어질 퇴, 사나운 바람 퇴, 쇠할 퇴, 무너질 퇴, 대머리 퇴")
     ("隤" . "무너질 퇴, 미끄러질 퇴, 부드러울 퇴, 땅이름 퇴")
     ("頽" . "頹와 同字"))
    ("투"
     ("偸" . "훔칠 투, 엷을 투, 구차할 투, 인정머리없을 투")
     ("套" . "전례 투")
     ("妬" . "투기할 투, 자식 없는 계집 투")
     ("投" . "던질 투, 버릴 투, 줄 투, 의탁할 투")
     ("透" . "통할 투, 사무칠 투, 지나칠 투")
     ("鬪" . "싸움 투")
     ("偷" . "偸와 同字")
     ("妒" . "투기할 투, 미워할 투, 강샘할 투, 부러워할 투")
     ("渝" . "빛 변할 투, 더러워질 투, 고을이름 투")
     ("骰" . "주사위 투"))
    ("특"
     ("慝" . "간악할 특, 간사할 특, 더러울 특")
     ("特" . "우뚝할 특, 숫소 특, 뛰어날 특, 다만 특, 세 살 먹은 짐승 특")
     ("貸" . "빌릴 특")
     ("忒" . "변할 특, 의심할 특, 어기어질 특"))
    ("파"
     ("坡" . "언덕 파, 제방 파")
     ("婆" . "할머니 파, 너풀너풀 춤출 파")
     ("巴" . "꼬리 파, 뱀 파, 땅이름 파")
     ("把" . "잡을 파, 헤칠 파")
     ("播" . "심을 파, 펼칠 파, 버릴 파, 까불 파, 달아날 파")
     ("擺" . "열 파, 헤칠 파, 제거할 파, 손뼉칠 파")
     ("杷" . "비파나무 파, 써레 파, 칼자루 파, 악기이름 파")
     ("波" . "물결 파, 물 젖을 파, 눈 광채 파, 움직일 파, 달빛 파")
     ("派" . "물 갈래 파, 보낼 파, 나눌 파, 파벌 파")
     ("爬" . "긁을 파, 기어다닐 파")
     ("琶" . "비파 파")
     ("破" . "깨뜨릴 파, 다할 파, 갈라질 파")
     ("罷" . "파할 파, 내칠 파")
     ("芭" . "파초 파")
     ("跛" . "절뚝발이 파")
     ("頗" . "비뚤어질 파, 자못 파")
     ("叵" . "못할 파, 드디어 파, 술잔 파")
     ("吧" . "아이 다툴 파")
     ("壩" . "방죽 파, 둑 파")
     ("妑" . "새앙머리 파, 갈래머리 파")
     ("岥" . "산 비알질 파")
     ("帕" . "머리 동이수건 파")
     ("怕" . "두려울 파")
     "朳"
     "汃"
     "汴"
     ("灞" . "물이름 파")
     ("爸" . "아비 파")
     ("玻" . "파려옥 파, 유리옥 파")
     ("疤" . "흉터 파")
     ("皤" . "흴 파, 배 불룩할 파, 귀 밑에 희끗희끗할 파")
     ("笆" . "가시 대 파, 울타리 파")
     ("簸" . "까부를 파, 키 파")
     ("耙" . "쇠시랑 파")
     ("菠" . "시금치 파")
     ("葩" . "꽃봉오리 파")
     ("鄱" . "땅이름 파")
     ("靶" . "고삐 파"))
    ("판"
     ("判" . "판단할 판, 쪼갤 판, 맡을 판")
     ("坂" . "언덕 판, 산비탈 판, 순나라 서울이름 판")
     ("板" . "널조각 판, 널기와 판, 풍류이름 판")
     ("版" . "조각 판, 호적 판, 국경 판, 한 길 판, 인쇄할 판")
     ("瓣" . "외씨 판, 실과씨 판, 꽃잎 판")
     ("販" . "장사 판, 팔 판")
     ("辦" . "힘들일 판, 갖출 판")
     ("鈑" . "불린 금 판")
     ("阪" . "산비탈 판, 언덕 판"))
    ("팔"
     ("八" . "여덟 팔")
     ("叭" . "나팔 팔, 입 벌릴 팔")
     ("捌" . "깨뜨릴 팔, 나눌 팔, 칠 팔"))
    ("팟"
     ("巼" . "땅이름 팟"))
    ("패"
     ("伯" . "우두머리 패, 으뜸 패")
     ("佩" . "패옥 패, 찰 패, 마음에 먹을 패, 물이 흘러서 합할 패")
     ("倍" . "어길 패, 떨어질 패, 암송할 패")
     ("唄" . "염불소리 패, 노래부를 패")
     ("悖" . "거스를 패, 어지러울 패")
     ("拔" . "밋밋할 패, 휘어 꺾을 패")
     ("敗" . "헐어질 패, 무너질 패, 깨어질 패, 썪을 패")
     ("沛" . "둥둥 뜰 패, 비 쏟아질 패, 넉넉할 패")
     ("浿" . "물이름 패, 물가 패")
     ("牌" . "방 붙일 패, 호패 패, 방패 패")
     ("狽" . "이리 패")
     ("稗" . "돌피 패, 조그마할 패")
     ("肺" . "성할 패")
     ("背" . "버릴 패, 배반할 패")
     ("覇" . "霸의 俗字")
     ("貝" . "조개 패, 재물 패, 비단 패")
     ("孛" . "혜성 패")
     ("抜" . "拔와 同字")
     "拨"
     ("旆" . "기 패, 깃발 날릴 패")
     ("珮" . "노리개 패, 찰 패")
     ("邶" . "패나라 패")
     ("霈" . "비 쏟아질 패")
     ("霸" . "으뜸 패, 패왕 패"))
    ("팽"
     ("亨" . "삶을 팽")
     ("傍" . "마지못할 팽")
     ("彭" . "성씨 팽, 땅이름 팽, 방패 팽, 총소리 팽, 북소리 팽")
     ("旁" . "휘몰아갈 팽")
     ("澎" . "물소리 팽, 물결 부딛는 형세 팽")
     ("烹" . "삶을 팽, 요리 팽")
     ("膨" . "배 불룩할 팽")
     ("伻" . "부릴 팽, 좇을 팽")
     ("砰" . "여울 물소리 팽")
     ("祊" . "사당문 제사 팽")
     ("蟚" . "蟛과 同字")
     ("蟛" . "방게 팽"))
    ("퍅"
     ("愎" . "사나울 퍅, 고집할 퍅"))
    ("편"
     ("便" . "편할 편, 소식 편, 익힐 편, 오줌 편")
     ("偏" . "치우칠 편, 무리 편, 오십명 편, 간사한 모양 편")
     ("平" . "편편할 편")
     ("扁" . "특별할 편, 거룻배 편")
     ("片" . "조각 편, 쪼갤 편, 성씨 편")
     ("篇" . "책 편, 편차할 편")
     ("編" . "책편 편, 기록할 편, 첩지 편, 벌릴 편")
     ("翩" . "훌쩍 날 편, 오락가락할 편")
     ("遍" . "두루 편")
     ("鞭" . "채찍 편, 볼기채 편, 태장 편")
     ("騙" . "속일 편, 말에 뛰어 오를 편")
     ("匾" . "엷은 그릇 편, 모가 진 모양 편")
     ("徧" . "두루 편, 널리 편, 치우칠 편")
     ("惼" . "조급할 편, 편협할 편")
     ("緶" . "꿰맬 편")
     ("艑" . "거룻배 편")
     ("萹" . "마디 풀 편")
     ("蝙" . "박쥐 편")
     ("褊" . "좁을 편, 급할 편, 옷이 몸에 낄 편")
     ("諞" . "공교한 말 편")
     ("蹁" . "돌쳐갈 편, 잘름거릴 편")
     ("鯿" . "병어 편"))
    ("폄"
     ("貶" . "떨어질 폄, 덜릴 폄, 꺾을 폄, 귀양보낼 폄")
     ("砭" . "돌침 폄")
     ("窆" . "하관할 폄, 광중 폄"))
    ("평"
     ("坪" . "벌판 평, 평평할 평")
     ("平" . "평탄할 평, 바를 평, 고를 평, 다스릴 평, 쉬울 평, 풍년 평, 화친할 평, 재관관 평")
     ("枰" . "장기판 평, 바둑판 평, 회양목 평")
     ("硼" . "평돌 평")
     ("萍" . "마름 평, 머구리밥 평, 개구리밥 평")
     ("評" . "평론할 평, 헤아릴 평, 고칠 평, 기롱할 평")
     ("匉" . "크게 소리지를 평")
     ("怦" . "맘 급할 평, 칼칼할 평")
     ("抨" . "탄핵할 평")
     ("拼" . "좇을 평")
     ("泙" . "물소리 평, 물결 셀 평")
     ("苹" . "맑은 대쑥 평, 사과 평")
     ("蓱" . "마름 평, 머구리밥 평, 개구리밥 평")
     ("鮃" . "가자미 평"))
    ("폐"
     ("吠" . "짖을 폐, 땅이름 폐")
     ("嬖" . "사랑할 폐, 윗사람으로부터 사랑받을 폐, 벼슬이름 폐")
     ("幣" . "폐백 폐, 예물 폐, 재물 폐, 돈 폐")
     ("廢" . "폐할 폐, 내칠 폐, 집 쏠릴 폐, 떨어질 폐")
     ("弊" . "해질 폐, 폐단 폐, 곤할 폐, 곰곰 궁리할 폐, 결단할 폐, 엎드릴 폐")
     ("斃" . "죽을 폐, 엎드러질 폐")
     ("肺" . "허파 폐, 부아 폐, 친할 폐, 마음속 폐")
     ("蔽" . "가리울 폐, 다할 폐, 정할 폐")
     ("閉" . "닫을 폐, 마칠 폐, 가릴 폐")
     ("陛" . "대궐 섬돌 폐")
     ("廃" . "廢의 略字")
     ("敝" . "옷 해질 폐, 버릴 폐, 무너질 폐, 실패할 폐, 활줌통 폐")
     ("杮" . "대패밥 폐")
     ("狴" . "짐승이름 폐, 옥 폐, 들개 폐")
     ("獘" . "곤할 폐, 폐단 폐, 죽을 폐, 엎드러질 폐")
     ("癈" . "고질병 폐")
     ("薜" . "승검초 폐, 돌삼 폐")
     ("髀" . "볼기짝 폐"))
    ("포"
     ("佈" . "펼칠 포")
     ("包" . "꾸릴 포, 용납할 포, 더부룩히 날 포, 보따리 포")
     ("匍" . "엉금엉금 길 포, 엎드러질 포")
     ("匏" . "박 포, 바가지 포, 퉁소 포")
     ("咆" . "고함지를 포, 짐승소리 포, 불끈 성낼 포")
     ("哺" . "씹어 먹을 포, 먹일 포")
     ("圃" . "채마밭 포, 밭 갈 포, 곳 포, 산이름 포")
     ("布" . "베 포, 피륙 포, 벌릴 포, 돈 포, 베풀 포")
     ("怖" . "두려울 포, 놀래킬 포")
     ("抛" . "拋와 同字")
     ("抱" . "안을 포, 품을 포, 낄 포")
     ("捕" . "사로잡을 포")
     ("暴" . "사나울 포, 급할 포, 맨손으로 칠 포, 불끈 일어날 포, 마를 포, 상할 포")
     ("曝" . "볕 쬘 포, 볕 쏘일 포")
     ("泡" . "물거품 포, 물이 솟아날 포, 물 흐를 포, 성할 포")
     ("浦" . "물가 포, 갯가 포")
     ("瀑" . "소나기 포, 물거품 포")
     ("疱" . "부풀 포, 부르틀 포")
     ("砲" . "큰 대포 포, 돌쇠뇌 포, 돌 튀기는 화살 포")
     ("胞" . "태보 포, 한 배 포, 동포 포")
     ("脯" . "포 포")
     ("苞" . "그령풀 포, 밑둥 포, 초목이 다복히 날 포, 꾸러피 포")
     ("葡" . "포도 포, 들머리 포, 나라이름 포")
     ("蒲" . "부들풀 포, 창포 포, 개버들 포")
     ("袍" . "도포 포, 관디 포, 앞섶 포")
     ("褒" . "포장할 포, 옷 뒤길 포, 도포 포, 고을이름 포")
     ("逋" . "달아날 포, 포흠할 포")
     ("鋪" . "전방 포, 베풀 포, 문고리 포, 펼 포, 아플 포")
     ("飽" . "배부를 포, 물릴 포, 먹기 싫을 포, 흡족할 포")
     ("鮑" . "절인 생선 포, 성씨 포")
     ("暴" . "사나울 포, 급할 포, 맨손으로 칠 포, 불끈 일어날 포, 마를 포, 상할 포")
     ("儤" . "번(官府宿直) 들 포, 넘을 포, 건널 포, 곧을 포")
     ("刨" . "깎을 포")
     ("勹" . "꾸릴 포, 쌀 포")
     ("庖" . "푸줏간 포, 부엌 포")
     ("拋" . "던질 포, 버릴 포, 돌소뇌 포")
     ("晡" . "신시 포, 해질 포")
     ("曓" . "급할 포, 창졸 포")
     ("炮" . "그슬릴 포, 싸서 구울 포, 형벌 포")
     ("炰" . "그슬 포, 까불거릴 포")
     ("舖" . "鋪의 俗字")
     ("誧" . "꾀할 포, 클 포, 도울 포, 간할 포")
     ("鉋" . "대패 포")
     ("鞄" . "가방 포, 가죽 다로는 장인 포")
     ("餔" . "저녁 곁두리 포, 먹을 포")
     ("鯆" . "매가리 포, 물아지 포")
     ("齙" . "이 드러날 포"))
    ("폭"
     ("幅" . "폭 폭, 겉치레할 폭")
     ("暴" . "햇빛 쪼일 폭, 나타날 폭, 드러날 폭")
     ("曝" . "햇볕에 말릴 폭")
     ("瀑" . "폭포수 폭")
     ("爆" . "불터질 폭")
     ("輻" . "바퀴살통 폭")
     ("輻" . "바퀴살통 폭"))
    ("폴"
     ("乶" . "땅이름 폴"))
    ("폿"
     ("喸" . "땅이름 폿"))
    ("표"
     ("俵" . "나누어 줄 표, 흩어질 표, 가마니 표")
     ("剽" . "표독할 표, 긁을 표, 겁박할 표, 끝 표, 찌를 표, 빠를 표")
     ("彪" . "칡범 표, 문채 표, 작은 범 표")
     ("慓" . "급할 표")
     ("杓" . "북두자루 표")
     ("標" . "표시할 표, 높은 가지 표, 적을 표, 나무 끝 표")
     ("漂" . "뜰 표, 움직일 표, 으스스할 표, 높이 훨훨 날 표")
     ("瓢" . "표주박 표")
     ("票" . "쪽지 표, 문서 표, 불날릴 표, 훌쩍 날 표, 날랠 표")
     ("莩" . "굶어죽을 표")
     ("表" . "겉 표, 윗옷 표, 밝을 표")
     ("豹" . "표범 표, 아롱범 표")
     ("飄" . "회오리바람 표, 나부낄 표, 떨어질 표")
     ("飇" . "회오리바람 표")
     ("驃" . "날쌜 표, 누런 말 표")
     ("僄" . "몸이 가벼울 표, 진중치 못할 표")
     ("儦" . "떼지어 걷는 모양 표, 많을 표")
     ("勡" . "겁탈할 표, 겁박할 표")
     ("嘌" . "휙 불 표, 몰아갈 표")
     ("嫖" . "가벼울 표, 날랠 표, 색에 빠질 표")
     ("摽" . "칠 표, 두를 표, 찔러 밀칠 표, 가슴 만질 표")
     ("殍" . "굶어 죽을 표")
     ("熛" . "불똥 튈 표, 성낼 표, 붉을 표, 빛날 표")
     ("縹" . "옥빛 표, 훌쩍 날 표")
     ("膘" . "허구리살 표, 소 볼기 표, 부레 표")
     ("裱" . "목수건 표")
     ("鏢" . "칼날 표, 비수 표")
     ("鑣" . "말 재갈 표, 성할 표")
     ("飆" . "飇와 同字")
     ("髟" . "머리털 희뜩희뜩할 표, 깃발 날릴 표, 머리 늘일 표")
     ("鰾" . "부레 표"))
    ("푼"
     ("分" . "세는 단위 푼"))
    ("품"
     ("品" . "뭇 품, 품수 품, 가지 품, 벼슬 차례 품")
     ("稟" . "여쭐 품, 줄 품, 받을 품, 성품 품")
     ("禀" . "여쭐 품, 사뢸 품, 받을 품, 성품 품"))
    ("풍"
     ("楓" . "단풍나무 풍, 신나무 풍")
     ("諷" . "비유로 간할 풍, 외울 풍")
     ("豊" . "豐의 略字")
     ("風" . "바람 풍, 흘레할 풍, 울릴 풍, 풍속 풍, 경치 풍, 위엄 풍, 병풍 풍, 모양 풍")
     ("馮" . "벼슬이름 풍, 성씨 풍, 물귀신이름 풍, 고을이름 풍")
     ("凨" . "風과 同字")
     ("凮" . "風의 譌字")
     ("瘋" . "두풍 풍, 미치광이 풍")
     ("葑" . "무 풍")
     ("豐" . "풍년 풍, 두터울 풍, 왕콩 풍, 괘 이름 풍")
     "闏")
    ("피"
     ("僻" . "피할 피")
     ("彼" . "저 피")
     ("披" . "헤칠 피, 흩어질 피, 찢어질 피")
     ("疲" . "피곤할 피, 나른할 피")
     ("皮" . "가죽 피, 껍질 피, 성씨 피")
     ("罷" . "느른할 피, 고달플 피, 잔병 피")
     ("被" . "이불 피, 덥힐 피, 미칠 피, 나타날 피, 창피할 피")
     ("跛" . "기울어 지게 설 피")
     ("避" . "숨을 피, 어길 피, 싫어할 피")
     ("陂" . "기울어질 피, 치우칠 피")
     ("佊" . "간사할 피")
     ("詖" . "말 잘할 피, 간사할 피, 알소할 피")
     ("辟" . "피할 피")
     ("鞁" . "말 가슴걸이 피, 안갑 피")
     ("髲" . "머리쓰개 피, 첩지 피"))
    ("픽"
     ("腷" . "뜩 막힐 픽, 답답할 픽, 닭 홰치는 소리 픽"))
    ("필"
     ("佛" . "흥할 필, 도울 필")
     ("匹" . "짝 필, 둘 필, 한마리 필, 벗 필, 무리 필")
     ("弼" . "도울 필, 도지개 필, 거듭 필")
     ("必" . "반드시 필, 오로지 필, 살필 필, 기약 필")
     ("拂" . "도울 필")
     ("泌" . "도랑물 필, 개천물 필")
     ("珌" . "칼 장식 옥 필")
     ("畢" . "마칠 필, 토끼그물 필, 다할 필, 편지 필, 책 필, 고기 꿰 다는 나무 필")
     ("疋" . "짝 필, 끝 필")
     ("筆" . "붓 필, 오랑캐 이름 필")
     ("苾" . "필추풀 필, 향기로울 필, 오랑캐의 부락 필")
     ("馝" . "향내날 필")
     ("佖" . "점잔피울 필, 가득할 필")
     ("吡" . "새소리 필")
     ("咇" . "향기날 필")
     ("嗶" . "울 필, 잔말할 필")
     ("払" . "拂의 略字")
     ("滭" . "샘 끓어 솟을 필")
     ("篳" . "대 사립문 필, 나무 실은 수레 필")
     ("罼" . "토끼그물 필")
     ("蓽" . "휘추리 필, 약이름 필")
     ("觱" . "바람이 쌀쌀할 필, 대평수 필")
     ("蹕" . "길 치울 필")
     ("鞸" . "슬갑 필")
     ("韠" . "슬갑 필")
     ("駜" . "살찐 말 필")
     ("鵯" . "갈가마귀 필"))
    ("핍"
     ("乏" . "없을 핍, 옹색할 핍, 다할 핍")
     ("逼" . "가까울 핍, 궁핍할 핍, 핍박학 핍")
     ("偪" . "핍박할 핍, 가까울 핍"))
    ("하"
     ("下" . "아래 하")
     ("何" . "어찌 하")
     ("假" . "거짓 하")
     ("厦" . "큰 집 하")
     ("夏" . "여름 하")
     ("廈" . "큰 집 하")
     ("昰" . "是와 同字")
     ("河" . "물 하")
     ("瑕" . "티 하")
     ("緞" . "신발 하")
     ("荷" . "연 하")
     ("蝦" . "새우 하")
     ("賀" . "축하할 하")
     ("遐" . "멀 하")
     ("霞" . "놀 하")
     ("鰕" . "새우 하")
     ("丅" . "下의 簡體字")
     ("丷" . "구결 하")
     ("呀" . "입 벌릴 하")
     ("哬" . "꾸짖을 하")
     ("嘏" . "복 하")
     ("嚇" . "놀라게 할 하")
     ("岈" . "휑뎅그렁할 하")
     ("懗" . "속일 하")
     ("煆" . "불사를 하")
     ("瘕" . "이질 하")
     ("罅" . "틈 하")
     ("鍜" . "목투구 하"))
    ("학"
     ("壑" . "골짜기 학")
     ("奭" . "성대할 학")
     ("學" . "배울 학")
     ("虐" . "사나울 학")
     ("謔" . "희롱할 학")
     ("鶴" . "두루미 학")
     ("嗀" . "게울 학")
     ("嗃" . "꾸짖을 학")
     ("嚛" . "매울 학")
     ("学" . "學의 略字")
     ("斈" . "學의 略字")
     ("涸" . "마를 학")
     ("狢" . "오소리 학")
     ("瘧" . "학질 학")
     ("皬" . "흴 학")
     ("确" . "확실할 학")
     ("郝" . "고을 이름 학")
     ("鷽" . "메까치 학")
     ("鶴" . "두루미 학"))
    ("한"
     ("寒" . "찰 한")
     ("恨" . "한탄할 한")
     ("悍" . "사나울 한")
     ("旱" . "가물 한")
     ("桿" . "막대기 한")
     ("汗" . "땀 한")
     ("漢" . "한수 한")
     ("澣" . "빨 한")
     ("瀚" . "넓고 큰 한")
     ("罕" . "드물 한")
     ("翰" . "날개 한")
     ("邯" . "고을 이름 한")
     ("閑" . "한가할 한")
     ("閒" . "한가할 한")
     ("限" . "한정할 한")
     ("韓" . "나라 이름 한")
     ("佷" . "잔인할 한")
     ("僩" . "노할 한")
     ("厂" . "사람 이름 한")
     ("嫺" . "우아할 한")
     ("嫻" . "우아할 한")
     ("扞" . "막을 한")
     ("捍" . "막을 한")
     ("暵" . "말릴 한")
     ("邗" . "고을 이름 한")
     ("閈" . "마을 문 한")
     ("駻" . "사나운 말 한")
     ("鷳" . "소리개 한")
     ("鼾" . "코골 한"))
    ("할"
     ("割" . "벨 할")
     ("害" . "손해 할")
     ("轄" . "다스릴 할")
     ("乤" . "고을 이름 할")
     ("劼" . "삼갈 할")
     ("嗐" . "감탄사 할")
     ("瞎" . "애꾸눈 할"))
    ("함"
     ("函" . "상자 함")
     ("含" . "머금을 함")
     ("咸" . "모두 함")
     ("啣" . "재갈 함")
     ("喊" . "소리 함")
     ("檻" . "우리 함")
     ("涵" . "젖을 함")
     ("濫" . "넘쳐흐를 함")
     ("緘" . "봉할 함")
     ("艦" . "싸움배 함")
     ("邯" . "고을 이름 함")
     ("銜" . "재갈 함")
     ("陷" . "빠질 함")
     ("鹹" . "짤 함")
     ("凾" . "상자 함")
     ("唅" . "머금을 함")
     ("圅" . "담을 함")
     ("莟" . "꽃봉오리 함")
     ("菡" . "연봉오리 함")
     ("諴" . "화할 함")
     ("轞" . "함거 함")
     ("闞" . "범 소리 함")
     ("陥" . "빠질 함"))
    ("합"
     ("合" . "합할 합, 같을 합, 짝 합, 대답할 합")
     ("哈" . "한 모금 합")
     ("盒" . "소반 뚜껑 합, 합 합")
     ("盖" . "蓋과 同字")
     ("蓋" . "이엉 덮을 합")
     ("蛤" . "조개 합")
     ("閤" . "도장 합, 침방 합, 개구리소리 합")
     ("闔" . "문짝 합, 닫을 합")
     ("陜" . "땅이름 합")
     ("匌" . "기운 답답할 합")
     ("呷" . "빨아 마실 합, 떠들썩할 합, 벌릴 합, 집오리 우는 소리 합")
     ("嗑" . "잔말할 합, 웃는 소리 합, 입 다물 합, 괘 이름 합")
     ("柙" . "우리 합, 향나무 합")
     ("榼" . "술그릇 합, 물통 합, 뚜껑 합")
     ("溘" . "문득 합, 이를 합, 의지할 합")
     ("盍" . "덮을 합, 합할 합, 어찌 아니할 합")
     ("郃" . "땅이름 합"))
    ("항"
     ("亢" . "목 항, 높을 항, 별이름 항, 기둥 항, 가릴 항")
     ("伉" . "강직할 항, 우뚝할 항, 배필 항, 겨룰 항")
     ("姮" . "항아 항, 달에 사는 미녀 항, 달 부르는 다른 이름 항")
     ("嫦" . "姮과 同字")
     ("巷" . "거리 항, 마을 항, 복도 항, 내시 항")
     ("恒" . "늘 항, 옛 항")
     ("抗" . "막을 항, 들 항, 겨룰 항")
     ("杭" . "건널 항, 거루 항, 고을이름 항")
     ("桁" . "수갑 항, 배다리 항, 횃대 항")
     ("沆" . "큰 물 항, 진펀할 항, 이슬 항")
     ("港" . "물 갈라질 항, 항구 항, 뱃길 항")
     ("缸" . "항아리 항")
     ("肛" . "똥구멍 항, 배 뚱뚱할 항")
     ("航" . "쌍배 항, 배질할 항")
     ("行" . "시장 항, 항렬 항, 굳셀 항")
     ("降" . "항복할 항")
     ("項" . "목덜미 항, 클 항, 항목 항")
     ("行" . "시장 항, 항렬 항, 굳셀 항")
     ("降" . "항복할 항")
     ("佷" . "돌아올 항, 고을이름 항")
     ("吭" . "목구멍 항, 새 목구멍 항")
     ("夯" . "멜 항, 다질 항")
     ("恆" . "恒의 本字")
     ("炕" . "마를 항, 구울 항, 구들 항")
     ("缿" . "항통 항, 문서함 항, 벙어리 항")
     ("頏" . "목 항, 오르락 내리락할 항")
     ("骯" . "꼿꼿할 항")
     ("鬨" . "싸움소리 항"))
    ("해"
     ("亥" . "열 둘째 지지 해, 서북쪽과 북쪽의 사이 방향 해, 음력 시월 해, 돼지 해")
     ("偕" . "함께할 해, 굳셀 해")
     ("劾" . "안찰할 해, 힘쓸 해")
     ("咳" . "기침 해, 침 뱉을 해, 방글방글 웃을 해")
     ("垓" . "땅 가장자리 해, 햇수 해, 계단 해")
     ("奚" . "어찌 해, 종 해, 큰 배 해")
     ("孩" . "어린아이 해, 방글방글 웃을 해")
     ("害" . "해할 해, 시기할 해, 죽일 해")
     ("懈" . "게으를 해")
     ("楷" . "해나무 해, 본뜰 해, 해자 해, 법 해")
     ("海" . "바다 해, 많을 해, 세계 해")
     ("瀣" . "찬이슬 해, 이슬 기운 해")
     ("蟹" . "게 해")
     ("解" . "쪼갤 해, 꺠우칠 해, 풀 해, 괘 이름 해, 벗을 해")
     ("該" . "갖출 해, 모두 해, 겸할 해, 마땅할 해")
     ("諧" . "조화할 해, 글 해, 기롱지거리할 해, 고를 해")
     ("邂" . "우연히 만날 해")
     ("駭" . "놀랄 해, 북 울릴 해")
     ("骸" . "뼈 해")
     ("侅" . "이상할 해")
     ("咍" . "비웃을 해")
     ("嗐" . "하품할 해")
     ("夥" . "많을 해, 동무 해")
     ("嶰" . "골짝 사이 해, 골 이름 해")
     ("廨" . "관청 해, 공해 해")
     ("欬" . "기침할 해, 크게 부를 해, 일깨울 해")
     ("獬" . "신통한 양 해, 해갓 해")
     ("瑎" . "검은 옥돌 해")
     ("痎" . "학질 해, 하루거리 해")
     ("薤" . "염교 해, 부추 해")
     ("醢" . "젓 해, 젓 담글 해, 젓 담그는 형벌 해")
     ("陔" . "층 뜰 해, 언덕 해, 변방 해")
     ("頦" . "턱 해")
     ("鮭" . "어채 해, 복 해")
     ("龤" . "노래의 가락이 조화될 해"))
    ("핵"
     ("劾" . "캐물을 핵, 핵실할 핵")
     ("核" . "실과 핵, 자세할 핵")
     ("輅" . "수레앞 가로막이 나무 핵, 맞을 핵")
     ("翮" . "깃촉 핵, 쭉지 핵, 칼 갓 핵")
     ("覈" . "핵실할 핵, 겨무거리 핵, 씨 핵, 액색할 핵"))
    ("행"
     ("倖" . "요행 행, 괴일 행, 아당할 행, 친할 행")
     ("幸" . "다행할 행, 바랄 행")
     ("杏" . "살구 행, 은행 행")
     ("荇" . "마름풀 행, 조아기 행")
     ("行" . "다닐 행, 길귀신 행, 오행 행, 그릇 얄긋거릴 행, 행서 행, 행실 행")
     ("悻" . "발끈 성낼 행"))
    ("향"
     ("享" . "드릴 향, 제사지낼 향, 잔치 향, 흠향할 향")
     ("向" . "향할 향, 나아갈 향, 북쪽 창 향, 기울어질 향")
     ("嚮" . "향할 향, 누릴 향, 울릴 향, 받을 향")
     ("珦" . "옥 이름 향")
     ("鄕" . "시골 향, 고향 향")
     ("響" . "소리 울릴 향, 소리 마주칠 향, 악기 향")
     ("餉" . "먹일 향, 군량 향, 점심 향")
     ("饗" . "잔치할 향, 흠향할 향")
     ("香" . "향내 향, 약이름 향")
     ("薌" . "곡기 향, 향기 향, 기장 향")
     ("郷" . "鄕과 同字")
     ("鄉" . "鄕과 同字"))
    ("허"
     ("噓" . "불 허, 뿜을 허")
     ("墟" . "옛 터 허, 장 허, 큰 두덕 허")
     ("虛" . "빌 허, 헛될 허, 다할 허, 약할 허, 거짓 허, 하늘 허")
     ("許" . "허락할 허, 나아갈 허, 기약할 허, 여럿이 힘쓰는 소리 허")
     ("嘘" . "噓의 俗字")
     ("歔" . "한숨 쉴 허, 흑흑 느껴 울 허, 코로 숨 내쉴 허")
     ("虚" . "虛의 俗字"))
    ("헌"
     ("憲" . "법 헌, 표준될 헌, 고시할 헌, 기뻐할 헌")
     "櫶"
     ("獻" . "바칠 헌, 음식 헌, 어진이 헌")
     ("軒" . "초헌 헌, 껄껄 웃을 헌, 주적댈 헌, 추녀끝 헌, 고기 굵게 저밀 헌")
     ("仚" . "날듯할 헌")
     ("巚" . "봉우리 헌, 시루봉 헌")
     ("幰" . "수레 안장 헌, 휘장 헌")
     ("攇" . "비길 헌, 물건 맬 헌")
     ("献" . "獻의 俗字"))
    ("헐"
     ("歇" . "쉴 헐, 나른할 헐, 다할 헐, 으슥할 헐, 스러질 헐, 흩어질 헐"))
    ("험"
     ("險" . "험할 험")
     ("驗" . "시험할 험, 중험할 험, 보람 험")
     ("崄" . "嶮과 同字")
     ("嶮" . "산 가파를 험")
     ("獫" . "험윤 오랑캐 험")
     ("玁" . "獫과 同字")
     ("険" . "險의 略字")
     ("験" . "驗의 略字"))
    ("혀"
     "暳")
    ("혁"
     ("奕" . "아름다울 혁, 클 혁, 차례 혁, 바둑 혁, 빛날 혁, 근심할 혁")
     ("爀" . "불빛 혁, 빛날 혁")
     ("赫" . "불 이글이글할 혁, 빛날 혁, 성할 혁")
     ("革" . "가죽 혁, 고칠 혁, 갑주 혁")
     ("侐" . "고요할 혁")
     ("嚇" . "노할 혁, 꾸짖을 혁")
     ("弈" . "바둑둘 혁")
     ("洫" . "넘칠 혁, 빌 혁, 봇도랑 혁")
     ("焱" . "불꽃 혁")
     ("鬩" . "송사할 혁, 싸울 혁"))
    ("현"
     ("俔" . "연탐할 현, 풍세보는 깃 현")
     ("峴" . "고개 현, 산이름 현")
     ("弦" . "시위 현, 반달 현, 맥박 잦을 현, 땅이름 현")
     ("懸" . "매달 현, 멀 현")
     ("晛" . "햇발 현")
     ("泫" . "물 깊을 현, 이슬 맺힐 현, 눈물 줄줄 흘릴 현")
     ("洵" . "멀 현")
     ("炫" . "밝을 현, 불빛 현")
     ("玄" . "검을 현, 검붉을 현, 하늘 현, 아득할 현, 고요할 현")
     ("現" . "나타날 현, 지금 현, 옥빛 현")
     ("眩" . "아찔할 현, 현혹할 현")
     ("睍" . "물끄러미 볼 현, 고울 현")
     ("絃" . "줄풍류 현")
     ("絢" . "채색무늬 현")
     ("縣" . "매달릴 현, 끊어질 현")
     ("舷" . "뱃전 현")
     ("衒" . "자랑할 현, 팔릴 현")
     ("見" . "나타날 현, 드러날 현, 있을 현, 보일 현")
     ("賢" . "어질 현, 좋을 현, 구멍 현")
     ("鉉" . "솥귀 현")
     ("顯" . "나타날 현, 밝을 현, 통달할 현, 높을 현")
     ("見" . "나타날 현, 드러날 현, 있을 현, 보일 현")
     ("伣" . "俔과 同字")
     ("儇" . "영리할 현, 빠를 현")
     ("吅" . "부르짖을 현")
     ("呟" . "소리 현")
     ("哯" . "아이 젖 토할 현")
     ("嬛" . "산뜻할 현")
     ("昡" . "햇빛 현")
     ("琄" . "패옥 늘어질 현")
     ("痃" . "힘줄 당기는 병 현, 적병 현")
     ("県" . "고을 현, 지방 현")
     ("繯" . "얽힐 현, 둘릴 현, 맬 현")
     ("翾" . "파뜩파뜩 날 현, 경박할 현, 영리할 현, 급할 현")
     ("蜆" . "가막조개 현, 호수이름 현")
     ("誢" . "간하는 말 현")
     ("鋗" . "노구솥 현, 퉁노구 현")
     ("顕" . "顯의 略字")
     ("駽" . "돗총이 현, 철총이 현"))
    ("혈"
     ("孑" . "외로울 혈, 나머지 혈, 창갈구리 혈")
     ("穴" . "굴 혈, 움 혈, 틈 혈, 굿 혈")
     ("血" . "피 혈, 피붙이 혈, 씩씩할 혈")
     ("頁" . "머리 혈, 마리 혈, 페이지(page) 혈")
     ("吷" . "마실 혈, 새소리 혈, 작은소리 혈")
     ("絜" . "헤아릴 혈, 묶을 혈")
     ("趐" . "새가 떼로 날 혈, 나아갈 혈"))
    ("혐"
     ("嫌" . "싫어할 혐, 의심할 혐, 유쾌하지 않을 혐"))
    ("협"
     ("俠" . "의기 협, 사이에 낄 협")
     ("協" . "조화할 협, 맞을 협, 도울 협")
     ("夾" . "곁 협, 낄 협, 잡을 협, 성씨 협, 가까울 협")
     ("峽" . "물 낀 두메 협, 산이름 협")
     ("慊" . "족할 협")
     ("挾" . "낄 협, 도울 협, 품을 협")
     ("浹" . "사무칠 협, 둘릴 협")
     ("狹" . "좁을 협")
     ("脅" . "갈빗대 협, 위협할 협")
     ("脇" . "脅과 同字")
     ("莢" . "콩 꼬투리 협, 명협 협")
     ("鋏" . "칼 손잡이 협, 집개 협")
     ("陜" . "좁을 협")
     ("頰" . "뺨 협, 천천히 말할 협")
     ("侠" . "俠과 同字")
     ("劦" . "힘을 합할 협")
     ("勰" . "생각할 협, 조화할 협")
     ("匧" . "옷상자 협, 꿰맬 협")
     ("叶" . "화합할 협")
     ("嗋" . "들이마실 협")
     ("埉" . "물가 협")
     ("恊" . "겁낼 협, 위협할 협")
     ("悏" . "생각할 협")
     ("愜" . "쾌할 협, 뜻에 맞을 협")
     ("篋" . "상자 협, 행담 협")
     ("頬" . "頰과 同字"))
    ("형"
     ("亨" . "형통할 형, 제사 형")
     ("兄" . "맏이 형")
     ("刑" . "형벌 형, 죽일 형")
     ("型" . "거푸집 형, 본보기 형")
     ("形" . "모양 형, 몸 형")
     ("桁" . "시렁 형, 마개 형")
     ("泂" . "멀 형, 깊고 넓은 모양 형, 차가운 형")
     ("滎" . "실개천 형, 물결 일 형")
     ("瀅" . "맑을 형, 개천 형")
     ("灐" . "물 이름 형")
     ("炯" . "빛날 형, 밝을 형")
     ("熒" . "등불 형")
     ("營" . "별이름 형")
     "玹"
     ("珩" . "노리개 형, 갓끈 형")
     ("瑩" . "밝을 형")
     ("荊" . "모형나무 형, 곤장 형")
     ("螢" . "개똥벌레 형")
     ("衡" . "저울대 형")
     ("逈" . "멀 형, 빛날 형")
     ("邢" . "나라 이름 형, 땅 이름 형")
     ("鎣" . "줄 형, 꾸밀 형")
     ("馨" . "향기 형")
     ("侀" . "이룰 형, 모일 형")
     ("哼" . "겁낼 형")
     ("夐" . "멀 형, 바라보는 모양 형")
     ("娙" . "여관 이름 형, 예쁠 형")
     ("荆" . "광대싸리 형, 가시 형")
     ("蛍" . "螢과 同字")
     ("詗" . "염탐할 형, 구할 형")
     ("迥" . "막을 형, 차단할 형")
     ("陘" . "지레목 형, 비탈 형"))
    ("혜"
     ("偕" . "같을 혜, 화할 혜")
     ("兮" . "어조사 혜")
     ("彗" . "비 혜, 꼬리별 혜")
     ("惠" . "은혜 혜, 사랑할 혜")
     ("慧" . "슬기로울 혜, 총명할 혜")
     ("蕙" . "혜초 혜")
     ("蹊" . "지름길 혜, 건널 혜")
     ("醯" . "초 혜, 위대로울 혜")
     ("鞋" . "신 혜")
     ("傒" . "묶을 혜")
     ("儶" . "빠를 혜, 잴 혜")
     ("匸" . "감출 혜, 덮을 혜")
     ("嘒" . "가냘플 혜")
     ("寭" . "밝힐 혜, 깨달을 혜")
     ("徯" . "기다릴 혜, 사잇길 혜")
     ("恵" . "惠의 略字")
     ("槥" . "널 혜, 작은 관 혜")
     ("盻" . "흘겨볼 혜, 돌아볼 혜")
     ("謑" . "창피줄 혜")
     ("譿" . "슬기로울 혜")
     ("鼷" . "새앙쥐 혜"))
    ("호"
     ("乎" . "인가 호")
     ("互" . "서로 호, 함께 호")
     "吳"
     ("呼" . "부를 호, 숨 내쉴 호")
     ("壕" . "해자 호")
     ("壺" . "병 호, 단지 호")
     ("好" . "좋을 호, 옳을 호")
     ("岵" . "산 호")
     ("弧" . "활 호")
     ("戶" . "지게 호")
     ("扈" . "뒤따를 호")
     ("昊" . "하늘 호, 큰 모양 호")
     ("晧" . "밝을 호, 빛날 호")
     ("暠" . "흴 호")
     ("毫" . "가는 털 호")
     ("浩" . "클 호")
     ("淏" . "맑을 호")
     ("湖" . "호수 호")
     ("滸" . "물가 호")
     ("澔" . "浩와 同字")
     ("濠" . "해자 호, 강 이름 호")
     ("濩" . "퍼질 호")
     ("灝" . "넓을 호, 콩 삶은 물 호")
     ("狐" . "여우 호")
     ("琥" . "호박 호")
     ("瑚" . "산호 호")
     ("瓠" . "표주박 호, 단지 호")
     ("皐" . "부를 호")
     ("皓" . "흴 호, 깨끗할 호")
     ("祜" . "복 호")
     ("穫" . "땅 이름 호")
     ("糊" . "풀 호, 끈끈할 호")
     ("縞" . "명주 호, 흴 호")
     ("胡" . "턱밑살 호")
     ("芦" . "芐와 同字, 蔖의 俗字")
     ("葫" . "마늘 호, 조롱박 호")
     ("蒿" . "쑥 호, 향기날 호, 지칠 호")
     ("虎" . "범 호")
     ("號" . "울부짖을 호")
     ("許" . "이영차 호")
     ("護" . "보호할 호, 감쌀 호")
     ("豪" . "호걸 호, 귀인 호")
     ("鎬" . "호경 호")
     ("雇" . "새 이름 호")
     ("頀" . "구할 호, 지킬 호")
     ("顥" . "클 호, 빛나는 모양 호")
     ("儫" . "영웅 호")
     ("冱" . "찰 호, 얼 호, 막을 호")
     ("冴" . "冱의 俗字")
     ("号" . "號의 略字")
     "呉"
     ("呺" . "큰체할 호")
     ("唬" . "범이 울 호, 외칠 호")
     ("嘑" . "부르짖을 호, 거칠게 말할 호")
     ("嘷" . "짖을 호, 외칠 호")
     ("嚎" . "울부짖을 호")
     "壼"
     ("嫭" . "嫮와 同字")
     ("嫮" . "아름다울 호, 시기할 호")
     ("怙" . "믿을 호")
     ("户" . "戶와 同字")
     ("戸" . "戶와 同字")
     ("沍" . "冱의 譌字")
     ("滈" . "장마 호")
     ("滬" . "강 이름 호")
     ("犒" . "호궤할 호")
     ("猢" . "원숭이 호")
     ("皜" . "흴 호, 흰 모양 호")
     ("皞" . "밝을 호, 흴 호")
     ("箎" . "긴 대 호")
     ("聕" . "들릴 호, 긴 귀 호")
     ("醐" . "제호 호")
     ("餬" . "기식할 호")
     ("鬍" . "수염 호"))
    ("혹"
     ("惑" . "미혹할 혹")
     ("或" . "혹 혹")
     ("酷" . "독할 혹")
     ("鵠" . "고니 혹")
     ("熇" . "뜨거울 혹"))
    ("혼"
     ("婚" . "혼인할 혼")
     ("昆" . "덩어리 혼, 서쪽 오랑캐 이름 혼")
     ("昏" . "어두울 혼")
     ("棍" . "묶을 혼")
     ("混" . "섞을 혼")
     ("渾" . "흐릴 혼")
     ("魂" . "넋 혼")
     ("倱" . "흐릿할 혼")
     ("圂" . "뒷간 혼")
     ("惛" . "흐릴 혼")
     ("溷" . "어지러울 혼")
     ("焜" . "빛날 혼")
     ("閽" . "문지기 혼")
     ("鯇" . "산천어 혼"))
    ("홀"
     ("忽" . "소흘히 할 홀")
     ("惚" . "황홀할 홀")
     ("核" . "씨 홀")
     ("笏" . "홀 홀")
     ("唿" . "근심할 홀")
     ("囫" . "온전할 홀"))
    ("홍"
     ("哄" . "떠들썩할 홍")
     ("弘" . "넓을 홍")
     ("汞" . "수은 홍")
     ("泓" . "깊을 홍")
     ("洪" . "큰물 홍")
     ("烘" . "횃불 홍")
     ("紅" . "붉을 홍")
     ("虹" . "무지개 홍")
     ("訌" . "무너질 홍")
     ("鴻" . "큰 기러기 홍")
     ("嗊" . "노래 홍")
     ("晎" . "날 밝으려 할 홍")
     ("澒" . "수은 홍")
     ("篊" . "홈통 홍")
     ("鉷" . "돌쇠뇌 홍")
     ("閧" . "싸우는 소리 홍")
     ("鬨" . "싸울 홍"))
    ("화"
     ("化" . "될 화")
     ("和" . "화할 화")
     ("嬅" . "여자 이름 화")
     ("樺" . "자작나무 화")
     ("火" . "불 화")
     ("畵" . "그림 화")
     ("禍" . "재화 화")
     ("禾" . "벼 화")
     ("花" . "꽃 화")
     ("華" . "꽃 화")
     ("話" . "말할 화")
     ("譁" . "시끄러울 화")
     ("貨" . "재화 화")
     ("靴" . "신 화")
     ("伙" . "세간 화")
     ("俰" . "화할 화")
     ("划" . "삿대 화")
     ("咊" . "순할 화")
     ("嘩" . "譁와 同字")
     ("婲" . "예쁠 화")
     ("擭" . "덫 화, 함정 화")
     ("画" . "畫의 略字")
     ("畫" . "그림 화")
     ("驊" . "준마 화")
     ("髁" . "넓적다리뼈 화")
     ("龢" . "풍류 조화될 화"))
    ("확"
     ("廓" . "클 확")
     ("擴" . "넓힐 확")
     ("攫" . "붙잡을 확")
     ("獲" . "낙심할 확")
     ("確" . "굳을 확")
     ("碻" . "굳을 확")
     ("穫" . "벼 벨 확")
     ("廓" . "둘레 확")
     ("劐" . "끊을 확")
     ("拡" . "擴의 略字")
     ("矍" . "두리번거릴 확")
     ("矡" . "호미 확")
     ("礭" . "회초리 확")
     ("鑊" . "가마 확"))
    ("환"
     ("丸" . "알 환")
     ("亘" . "굳셀 환")
     ("喚" . "부를 환")
     ("奐" . "빛날 환")
     ("宦" . "벼슬 환")
     ("幻" . "변할 환")
     ("患" . "근심 환")
     ("換" . "바꿀 환")
     ("晥" . "환할 환")
     ("桓" . "푯말 환")
     ("歡" . "기뻐할 환")
     ("渙" . "흩어질 환")
     ("湲" . "물소리 환, 물 졸졸 흐를 환")
     ("煥" . "불꽃 환")
     ("環" . "고리 환")
     ("眩" . "요술 환")
     ("紈" . "흰 비단 환")
     ("還" . "돌아올 환")
     ("驩" . "기뻐할 환")
     ("鰥" . "환어 환")
     ("唤" . "喚과 同字")
     ("喛" . "성낼 환, 근심할 환")
     ("嚾" . "지껄일 환")
     ("圜" . "두를 환")
     ("寰" . "기내 환")
     ("懽" . "기뻐할 환")
     ("换" . "換과 同字")
     ("擐" . "입을 환")
     ("歓" . "歡과 同字")
     ("涣" . "渙과 同字")
     ("烉" . "煥의 俗字")
     ("焕" . "빛날 환")
     ("瓛" . "옥홀 환")
     ("皖" . "샛별 환")
     ("睆" . "가득 차 있는 모양 환")
     ("絙" . "끈목 환")
     ("讙" . "시끄러울 환")
     ("豢" . "기를 환")
     ("轘" . "환형 환")
     ("鍰" . "무게 단위 환")
     ("鐶" . "고리 환")
     ("鬟" . "쪽찐 머리 환")
     ("鯇" . "잉어 환"))
    ("활"
     ("活" . "살 활")
     ("滑" . "미끄러울 활")
     ("猾" . "교활할 활")
     ("豁" . "뚫린 골 활")
     ("越" . "부들자리 활")
     ("闊" . "트일 활")
     ("咶" . "핥을 활, 이야기할 활")
     ("蛞" . "괄태충 활"))
    ("황"
     ("凰" . "봉황새 황")
     ("幌" . "휘장 황")
     ("徨" . "노닐 황")
     ("恍" . "황홀할 황")
     ("惶" . "두려워할 황")
     "惺"
     ("愰" . "밝을 황")
     ("慌" . "어렴풋할 황")
     ("晃" . "밝을 황")
     ("晄" . "晃과 同字")
     ("榥" . "책상 황")
     ("況" . "하물며 황")
     ("湟" . "해자 황")
     ("滉" . "물 깊고 넓을 황")
     ("潢" . "웅덩이 황")
     ("煌" . "빛날 황")
     ("璜" . "서옥 황")
     ("皇" . "임금 황")
     ("篁" . "대숲 황")
     ("簧" . "혀 황")
     ("荒" . "거칠 황")
     ("蝗" . "누리 황")
     ("遑" . "허둥거릴 황")
     ("隍" . "해자 황")
     ("黃" . "누를 황")
     ("偟" . "노닐 황")
     ("况" . "況의 俗字")
     ("喤" . "어린아이 울음 황")
     ("媓" . "어머니 황")
     ("怳" . "멍할 황")
     ("瑝" . "옥 소리 황")
     ("礦" . "쇳돌 황")
     ("肓" . "명치 끝 황")
     ("貺" . "줄 황")
     ("鎤" . "종소리 황")
     ("鰉" . "용상어 황")
     ("黄" . "누를 황"))
    ("홰"
     ("噦" . "새소리 홰")
     ("噧" . "기운 높여 떠들 홰"))
    ("회"
     ("匯" . "물돌 회")
     ("回" . "돌 회")
     ("壞" . "혹 회")
     ("廻" . "돌 회")
     ("徊" . "노닐 회")
     ("恢" . "넓을 회")
     ("悔" . "뉘우칠 회")
     ("懷" . "품을 회")
     ("晦" . "그믐 회")
     ("會" . "모일 회")
     "樑"
     ("檜" . "노송나무 회")
     ("淮" . "강 이름 회")
     ("澮" . "봇도랑 회")
     ("灰" . "재 회")
     ("獪" . "교활할 회")
     ("繪" . "그림 회")
     ("膾" . "회 회")
     ("茴" . "회향풀 회")
     ("蛔" . "회충 회, 거위(腹中蟲) 회")
     ("誨" . "가르칠 회")
     ("賄" . "뇌물 회")
     ("会" . "會의 俗字")
     ("佪" . "어정거릴 회")
     ("劊" . "끊을 회")
     ("囬" . "回의 俗字")
     ("廽" . "돌 회")
     ("栃" . "상수리나무 회")
     ("桧" . "檜의 簡體字")
     ("洄" . "거슬러 올라 갈 회")
     ("滙" . "匯와 同字")
     ("烣" . "넓힐 회")
     ("盔" . "바리 회")
     ("蜖" . "蛔의 簡體字")
     ("詼" . "조롱할 회")
     ("迴" . "回와 同字")
     ("逥" . "迴의 簡體字")
     ("鄶" . "나라이름 회")
     ("頮" . "세수할 회")
     ("鱠" . "회 회"))
    ("획"
     ("劃" . "쪼갤 획")
     ("獲" . "얻을 획")
     ("畵" . "畫의 俗字")
     ("嚄" . "외칠 획")
     ("画" . "畫의 略字")
     ("畫" . "그을 획"))
    ("횡"
     ("宖" . "집 울릴 횡")
     ("橫" . "가로 횡")
     ("薨" . "많을 횡")
     ("衡" . "가로 횡")
     ("鐄" . "종 횡")
     ("横" . "비낄 횡")
     ("澋" . "물이 빙 돌 횡")
     ("鈜" . "쇳소리 횡")
     ("黌" . "글방 횡"))
    ("효"
     ("哮" . "으르렁거릴 효")
     ("嚆" . "울릴 효")
     ("孝" . "효도 효")
     ("效" . "본받을 효")
     ("斅" . "가르칠 효")
     ("曉" . "새벽 효")
     ("校" . "학궁 효")
     ("梟" . "올배미 효")
     ("涍" . "성 효")
     ("淆" . "뒤섞일 효")
     ("烋" . "거들거릴 효")
     ("爻" . "효 효")
     ("肴" . "안주 효")
     ("酵" . "술밑 효")
     ("驍" . "날랠 효")
     ("驕" . "부리 짧은 사냥개 효")
     ("俲" . "본받을 효, 닮을 효, 배울 효")
     ("倄" . "찌를 효, 끙끙 앓을 효, 한탄할 효")
     ("傚" . "본받을 효")
     ("効" . "效의 俗字")
     ("呺" . "큰체할 효")
     ("啋" . "움직일 효, 시끄러울 효")
     ("嗃" . "성낸 소리 효")
     ("嘵" . "두려워할 효")
     ("嚻" . "한가할 효")
     ("囂" . "시끄럽다 효")
     ("崤" . "산 이름 효")
     ("敩" . "斆의 略字")
     ("斆" . "斅와 同字")
     ("暁" . "曉와 同字")
     ("殽" . "섞일 효")
     ("熇" . "불김 효")
     ("皛" . "나타날 효")
     ("虓" . "울부짖을 효")
     ("餚" . "반찬 효")
     ("骹" . "발회목뼈 효"))
    ("후"
     ("侯" . "과녁 후")
     ("候" . "물을 후")
     ("厚" . "두터울 후")
     ("后" . "임금 후")
     ("吼" . "소 우는소리 후, 사자 우는소리 후, 원성 후, 범 성낸소리 후")
     ("喉" . "목구멍 후")
     ("嗅" . "맡을 후")
     ("嘔" . "기쁠 후")
     ("帿" . "과녁 후")
     ("後" . "뒤 후")
     ("朽" . "섞을 후")
     ("煦" . "따뜻하게 할 후")
     ("珝" . "옥 이름 후")
     ("芋" . "클 후")
     "蝴"
     ("逅" . "만날 후")
     ("冔" . "관 후")
     ("吽" . "吼와 同字")
     ("喣" . "불 후")
     ("垕" . "厚의 古字")
     ("堠" . "봉화대 후")
     ("涸" . "물 마를 후")
     ("猴" . "원숭이 후")
     ("篌" . "공후 후")
     ("詡" . "자랑할 후")
     ("譃" . "망녕된 말 후")
     ("酗" . "주정할 후")
     ("餱" . "건량 후")
     ("鱟" . "참게 후"))
    ("훈"
     ("勛" . "勳의 古字")
     ("勳" . "공 훈")
     ("塤" . "壎과 同字")
     ("壎" . "진나팔 훈")
     ("暈" . "무리 훈")
     ("焄" . "연기에 그을릴 훈")
     ("煇" . "지질 훈")
     ("熏" . "연기 낄 훈")
     ("燻" . "연기 낄 훈")
     ("薰" . "향불 훈")
     ("訓" . "가르칠 훈")
     ("馴" . "가르칠 훈")
     ("勲" . "勳의 俗字")
     ("曛" . "삭양 빛 훈")
     ("爋" . "불에 말릴 훈")
     ("獯" . "오랑캐 이름 훈")
     ("纁" . "분홍빛 훈")
     ("葷" . "매운 채소 훈")
     ("薫" . "향내 훈")
     ("鑂" . "금빛 투색할 훈"))
    ("훌"
     ("欻" . "문득 훌"))
    ("훙"
     ("薨" . "죽을 훙"))
    ("훤"
     ("喧" . "의젓할 훤")
     ("暄" . "따뜻할 훤")
     ("暖" . "부드러울 훤")
     ("煊" . "따뜻할 훤")
     ("萱" . "원추리 훤")
     ("咺" . "섧게 울 훤")
     ("嚾" . "지껄일 훤")
     ("烜" . "마를 훤")
     ("諠" . "잊을 훤")
     ("諼" . "속일 훤")
     ("讙" . "시끄러울 훤"))
    ("훼"
     ("卉" . "풀 훼")
     ("喙" . "부리 훼")
     ("毁" . "毀의 俗字")
     ("毀" . "헐 훼")
     ("燬" . "불 훼")
     ("芔" . "풀 훼")
     ("虫" . "벌레 훼")
     ("虺" . "살무사 훼"))
    ("휘"
     ("彙" . "무리 휘")
     ("徽" . "아름다울 휘")
     ("戱" . "기 휘, 대장 깃발 휘")
     ("揮" . "휘두를 휘")
     ("暉" . "빛 휘")
     ("煇" . "빛날 휘")
     ("諱" . "꺼릴 휘")
     ("輝" . "빛날 휘")
     ("麾" . "대장기 휘")
     ("彚" . "彙와 同字")
     ("戯" . "戱의 俗字")
     ("撝" . "찣을 휘")
     ("翚" . "翬의 簡體字")
     ("翬" . "훨훨날 휘"))
    ("휴"
     ("休" . "쉴 휴")
     ("携" . "끌 휴, 가질 휴, 떠날 휴, 나눌 휴, 연속할 휴")
     ("烋" . "경사로울 휴")
     ("畦" . "밭두둑 휴")
     ("虧" . "이지러질 휴")
     ("倠" . "추할 휴")
     ("儶" . "끝 휴")
     ("咻" . "떠들 휴")
     ("嘼" . "쌓을 휴")
     ("堕" . "무너뜨릴 휴, 게으를 휴")
     ("擕" . "携와 同字")
     ("貅" . "비휴 휴")
     ("隳" . "무너뜨릴 휴")
     ("髹" . "옻칠할 휴")
     ("鵂" . "수리부엉이 휴"))
    ("휵"
     ("畜" . "기를 휵, 용납할 휵")
     ("搐" . "당길 휵"))
    ("휼"
     ("恤" . "구휼할 휼")
     ("譎" . "속일 휼")
     ("卹" . "가엾이 여길 휼"))
    ("흉"
     ("兇" . "흉악할 흉")
     ("凶" . "흉할 흉")
     ("洶" . "물살세찰 흉")
     ("胸" . "가슴 흉")
     ("哅" . "떠들 흉")
     ("忷" . "恟과 同字")
     ("恟" . "두려워할 흉")
     ("胷" . "胸과 同字"))
    ("흑"
     ("黑" . "검을 흑")
     ("黒" . "黑과 同字"))
    ("흔"
     ("昕" . "아침 흔")
     ("欣" . "기뻐할 흔")
     ("炘" . "화끈거릴 흔")
     "琿"
     ("痕" . "흉터 흔")
     ("俒" . "완전할 흔")
     ("很" . "패려궂을 흔")
     ("忻" . "기뻐할 흔")
     ("掀" . "치켜들 흔")
     ("焮" . "불사를 흔")
     ("衅" . "釁과 同字")
     ("訢" . "기뻐할 흔")
     ("釁" . "피바를 흔"))
    ("흘"
     ("吃" . "말더듬을 흘")
     ("屹" . "산 우뚝솟을 흘")
     ("汽" . "汔과 同字")
     ("紇" . "질 낮은 명주실 흘")
     ("訖" . "이를 흘")
     "鷸"
     ("仡" . "날랠 흘")
     ("汔" . "거의 흘")
     ("疙" . "쥐부스럼 흘")
     ("迄" . "이를 흘")
     ("齕" . "깨물 흘"))
    ("흠"
     ("欠" . "하품 흠")
     ("欽" . "공경할 흠")
     ("歆" . "받을 흠")
     ("廞" . "진열할 흠"))
    ("흡"
     ("吸" . "숨 들이쉴 흡")
     ("恰" . "마치 흡")
     ("洽" . "윤태하게 할 흡")
     ("翕" . "합할 흡")
     ("噏" . "숨 들이쉴 흡")
     ("歙" . "줄일 흡")
     ("潝" . "빨리 흐르는 소리 흡")
     ("翖" . "翕과 同字"))
    ("흥"
     "匈"
     ("興" . "일 흥"))
    ("희"
     ("僖" . "기쁠 희")
     ("凞" . "빛날 희")
     ("喜" . "기뻐할 희")
     ("噫" . "탄식할 희")
     ("囍" . "쌍희 희")
     ("姬" . "성 희")
     ("嬉" . "즐길 희")
     ("希" . "바랄 희")
     ("愾" . "한숨 희")
     ("憘" . "憙의 古字")
     ("憙" . "성할 희")
     ("戱" . "戲의 俗字")
     ("晞" . "마를 희")
     ("曦" . "햇빛 희")
     ("熙" . "빛날 희")
     ("熹" . "성할 희")
     ("熺" . "熹와 同字")
     ("犧" . "희생 희")
     ("禧" . "복 희")
     ("稀" . "드물 희")
     ("羲" . "숨 희")
     ("釐" . "제사 지내는 고기 희")
     ("俙" . "비슷할 희, 어슴프레할 희, 희미할 희")
     ("呬" . "쉴 희")
     ("咥" . "허허 웃을 희")
     ("唏" . "슬퍼할 희")
     ("嘻" . "웃을 희")
     ("嚱" . "소리낼 희, 아아 경탄하는 소리 희")
     ("姫" . "姬의 俗字")
     ("悕" . "슬퍼할 희")
     ("戯" . "戲의 俗字")
     ("戲" . "탄식할 희")
     ("暿" . "웃을 희")
     ("欷" . "흐느낄 희")
     ("煕" . "熙와 同字")
     ("熈" . "熙와 同字")
     ("燹" . "들불 희")
     ("爔" . "불 희")
     ("誒" . "탄식할 희")
     ("豨" . "멧돼지 희")
     ("餼" . "꾸밀 희")
     ("凞" . "凞와 同字"))
    ("힁"
     ("卝" . "쇠뭉치 힁, 금옥덩어리 힁"))
    ("히"
     ("呬" . "숨 쉴 히"))
    ("힐"
     ("詰" . "물을 힐")
     ("犵" . "오랑캐이름 힐")
     ("纈" . "홀치기염색 힐")
     ("襭" . "옷자락 꽂을 힐")
     ("頡" . "곧은목 힐")
     ("黠" . "약을 힐"))))
