#!/bin/sh

# Build script template [20060202]

### Configurations (edit below):

PREFIX=/usr
DOCPREFIX=${DOCPREFIX:-/usr/share/doc}

SHORTNAME=honoka
ORIGVER=0.8.2
PKGVER=P1
PACKAGE=$SHORTNAME-${ORIGVER/-/_}-i386-$PKGVER.tgz
SRCPKG=$SHORTNAME-${ORIGVER/-/_}-i386-$PKGVER-Plamosrc.tar.gz

SRCURL1=http://nop.net-p.org/files/honoka/honoka-0.8.2.tar.gz
SRC1=honoka-$ORIGVER.tar.gz
SRCDIR1=honoka-$ORIGVER
PATCH11=patches/honoka-0.8.2-toggle.patch
PATCH12=patches/honoka-0.8.2-halfpunct.patch
PATCH13=patches/honoka-0.8.2-rktable.patch
PATCH14=patches/honoka-0.8.2-rktable-plamo.patch
PATCH15=patches/honoka-0.8.2-wnndicsave.patch

SRCURL2=ftp://ftp.omronsoft.co.jp/pub/Wnn7/sdk_source/Wnn7SDK.tgz
SRC2=Wnn7SDK.tgz
PATCH21=patches/Wnn7SDK-build.patch

INITSCRIPTS=

if [ ! -f $SRC1 ]; then
    wget -O $SRC1 $SRCURL1
fi
if [ ! -f $SRC2 ]; then
    wget -O $SRC2 $SRCURL2
fi

### Common preparations:

TMPDIR=`pwd`
SRCROOT=`pwd`
BUILDROOT=$TMPDIR/.work
PKGROOT=$BUILDROOT/pkgroot
mkdir -p $BUILDROOT
chown 0.0 $BUILDROOT
chmod 0755 $BUILDROOT

### Build and install (edit below):

cd $BUILDROOT
tar zxf $SRCROOT/$SRC2

cd src
cat $SRCROOT/$PATCH21 | patch -sp1
make World -f Makefile.ini
rm -f Wnn/jlib/libwnn.so*

cd $BUILDROOT
tar zxf $SRCROOT/$SRC1

cd $SRCDIR1
cat $SRCROOT/$PATCH11 | patch -sp1
cat $SRCROOT/$PATCH12 | patch -sp1
cat $SRCROOT/$PATCH13 | patch -sp1
cat $SRCROOT/$PATCH14 | patch -sp1
cat $SRCROOT/$PATCH15 | patch -sp1
PKG_CONFIG_PATH=/usr/X11R6/lib/pkgconfig LIBS="-L$BUILDROOT/src/Wnn/jlib" ./configure --prefix=$PREFIX || exit 1
make || exit 1
make install DESTDIR=$PKGROOT || exit 1

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1
cp ABOUT-NLS AUTHORS COPYING ChangeLog INSTALL NEWS README* $PKGROOT$DOCPREFIX/$SRCDIR1
cp $BUILDROOT/src/README $PKGROOT$DOCPREFIX/$SRCDIR1/README.Wnn7SDK

## Common packaging sequence:

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build
cp $SRCROOT/$0 $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build
if [ -d $SRCROOT/patches ]; then
    mkdir $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build/patches
    cp $SRCROOT/patches/* $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build/patches
fi

if [ -d $PKGROOT$PREFIX/bin ]; then
    strip $PKGROOT$PREFIX/bin/*
fi
if [ -d $PKGROOT$PREFIX/sbin ]; then
    strip $PKGROOT$PREFIX/sbin/*
fi
if [ -d $PKGROOT$PREFIX/libexec ]; then
    find $PKGROOT$PREFIX/libexec -type f -exec strip {} ';'
fi
if [ -d $PKGROOT$PREFIX/lib ]; then
    find $PKGROOT$PREFIX/lib -type f -name '*.so*' -exec strip -g {} ';'
    find $PKGROOT$PREFIX/lib -mindepth 2 '(' -name '*.a' -o -name '*.la' ')' -exec rm {} ';'
fi
for docdir in $PKGROOT$DOCPREFIX/*; do
    if [ -d $docdir ]; then
	gzip $docdir/*
    fi
done
if [ -d $PKGROOT$PREFIX/man ]; then
    if [ ! -d $PKGROOT$PREFIX/share ]; then
	mkdir $PKGROOT$PREFIX/share
    fi
    ( cd $PKGROOT$PREFIX; tar cf - man ) | ( cd $PKGROOT$PREFIX/share; tar xfp - )
    rm -rf $PKGROOT$PREFIX/man
fi
if [ -d $PKGROOT$PREFIX/share/man ]; then
    symlinks=
    for l in `find $PKGROOT$PREFIX/share/man -type l -print`; do
	symlinks="$symlinks $l:`perl -e "print readlink '$l';"`"
	rm -f $l
    done
    gzip $PKGROOT$PREFIX/share/man/man?/*
    for l in $symlinks; do
	ln -s ${l#*:}.gz ${l%%:*}.gz
    done
fi

if [ -r $PKGROOT$PREFIX/info/dir ]; then
    rm -f $PKGROOT$PREFIX/info/dir
    echo "if [ -x /usr/bin/install-info ]; then" >> $BUILDROOT/initpkg
    echo "  ( cd $PREFIX/info" >> $BUILDROOT/initpkg
    for infofile in $PKGROOT$PREFIX/info/*.info; do
	echo "    /usr/bin/install-info ${infofile##*/} dir" >> $BUILDROOT/initpkg
    done
    echo "  )" >> $BUILDROOT/initpkg
    echo "fi" >> $BUILDROOT/initpkg
fi
for i in $INITSCRIPTS; do
    cat $SRCROOT/$i >> $BUILDROOT/initpkg
done
if [ -s $BUILDROOT/initpkg ]; then
    mkdir $PKGROOT/install
    mv -f $BUILDROOT/initpkg $PKGROOT/install
fi

cd $PKGROOT
echo y | makepkg $PACKAGE
cp -f $PACKAGE $SRCROOT

cd $PKGROOT$DOCPREFIX/$SRCDIR1
tar zcf $SRCPKG $SHORTNAME-build
cp -f $SRCPKG $SRCROOT

cd $SRCROOT
rm -rf $BUILDROOT
