/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /usr/local/src/Plamo/GNOME/firefox/.work/mozilla/toolkit/components/downloads/public/nsIDownloadManager.idl
 */

#ifndef __gen_nsIDownloadManager_h__
#define __gen_nsIDownloadManager_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDOMWindow; /* forward declaration */

class nsIURI; /* forward declaration */

class nsILocalFile; /* forward declaration */

class nsIDownload; /* forward declaration */

class nsIWebBrowserPersist; /* forward declaration */

class nsIMIMEInfo; /* forward declaration */

class nsIRDFDataSource; /* forward declaration */

class nsIDownloadProgressListener; /* forward declaration */

class nsISupportsArray; /* forward declaration */


/* starting interface:    nsIDownloadManager */
#define NS_IDOWNLOADMANAGER_IID_STR "9be66cc0-1dd1-11b2-8617-e3a3ed26e3b0"

#define NS_IDOWNLOADMANAGER_IID \
  {0x9be66cc0, 0x1dd1, 0x11b2, \
    { 0x86, 0x17, 0xe3, 0xa3, 0xed, 0x26, 0xe3, 0xb0 }}

class NS_NO_VTABLE nsIDownloadManager : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IDOWNLOADMANAGER_IID)

  enum { DOWNLOAD_NOTSTARTED = -1 };

  enum { DOWNLOAD_DOWNLOADING = 0 };

  enum { DOWNLOAD_FINISHED = 1 };

  enum { DOWNLOAD_FAILED = 2 };

  enum { DOWNLOAD_CANCELED = 3 };

  enum { DOWNLOAD_PAUSED = 4 };

  enum { DOWNLOAD_TYPE_DOWNLOAD = 0 };

  /**
   * Creates an nsIDownload and adds it to be managed by the download manager.
   *
   * @param aSource The source (nsIURI) of the download.
   *
   * @param aTarget The local file to which the download is being saved.
   *
   * @param aDisplayName The user-readable description of the download.
   *
   * @param aPersist The "persist" used to transfer the download.  If set,
   *                 the manager will set its listener to the download item
   *                 and use it for cancellation.  If not set, the client
   *                 is expected to set the download item as the listener on
   *                 whatever transfer component is being used, and to
   *                 set an observer on the download item that listens for
   *                 the "oncancel" topic and cancels the download.
   *
   * @return The newly created download item with the passed-in properties.
   */
  /* nsIDownload addDownload (in short aDownloadType, in nsIURI aSource, in nsIURI aTarget, in wstring aDisplayName, in wstring aIconURL, in nsIMIMEInfo aMIMEInfo, in long long aStartTime, in nsIWebBrowserPersist aPersist); */
  NS_IMETHOD AddDownload(PRInt16 aDownloadType, nsIURI *aSource, nsIURI *aTarget, const PRUnichar *aDisplayName, const PRUnichar *aIconURL, nsIMIMEInfo *aMIMEInfo, PRInt64 aStartTime, nsIWebBrowserPersist *aPersist, nsIDownload **_retval) = 0;

  /**
   *  Retrieves an in-progress download managed by the download manager.
   *
   *  @param aPersistentDescriptor The unique identifier used to describe a
   *                               a download, and an attribute of nsILocalFile.
   *                               On Windows and Linux, this is just the path
   *                               of the target, but on Mac this is guaranteed
   *                               to be unique.
   *
   *  @return The download with the specified persistent descriptor.
   */
  /* nsIDownload getDownload (in wstring aPersistentDescriptor); */
  NS_IMETHOD GetDownload(const PRUnichar *aPersistentDescriptor, nsIDownload **_retval) = 0;

  /**
   * Cancels the download with the specified persistent descriptor if it's
   * currently in progress.  If a "persist" was specified for the download,
   * nsIWebBrowserPersist::CancelSave will be called.  If an observer was set
   * on the nsIDownload, it will be notified with the "oncancel" topic.  Clients
   * that don't provide a "persist" must listen for this topic and cancel the
   * download. 
   *
   * @param aPersistentDescriptor The persistent descriptor of the download to
   *                              be cancelled.
   */
  /* void cancelDownload (in wstring aPersistentDescriptor); */
  NS_IMETHOD CancelDownload(const PRUnichar *aPersistentDescriptor) = 0;

  /**
   * Removes the download with the specified persistent descriptor if it's not
   * currently in progress.  Whereas cancelDownload simply cancels the transfer
   * but retains information about it, removeDownload removes all knowledge of it.
   *
   * @param aPersistentDescriptor The persistent descriptor of the download to
   *                              be removed.
   */
  /* void removeDownload (in wstring aPersistentDescriptor); */
  NS_IMETHOD RemoveDownload(const PRUnichar *aPersistentDescriptor) = 0;

  /**
   * Pause the specified download.
   */
  /* void pauseDownload (in wstring aPersistentDescriptor); */
  NS_IMETHOD PauseDownload(const PRUnichar *aPersistentDescriptor) = 0;

  /**
   * Resume the specified download.
   */
  /* void resumeDownload (in wstring aPersistentDescriptor); */
  NS_IMETHOD ResumeDownload(const PRUnichar *aPersistentDescriptor) = 0;

  /** 
   * Opens the Download Manager front end.
   * 
   * @param aParent   The parent, or opener, of the front end (optional).
   * @param aDownload A download to pass to the manager widnow. Useful if,
   *                  for example, you want the window to select a certain
   *                  download (optional).
   */
  /* void open (in nsIDOMWindow aParent, in wstring aPersistentDescriptor); */
  NS_IMETHOD Open(nsIDOMWindow *aParent, const PRUnichar *aPersistentDescriptor) = 0;

  /** 
   * The Download Manager's progress listener.
   */
  /* attribute nsIDownloadProgressListener listener; */
  NS_IMETHOD GetListener(nsIDownloadProgressListener * *aListener) = 0;
  NS_IMETHOD SetListener(nsIDownloadProgressListener * aListener) = 0;

  /**
  * Indicate that a batch update (e.g. mass removal) is about to start.
  */
  /* void startBatchUpdate (); */
  NS_IMETHOD StartBatchUpdate(void) = 0;

  /**
  * Indicate that a batch update is ending.
  */
  /* void endBatchUpdate (); */
  NS_IMETHOD EndBatchUpdate(void) = 0;

  /** 
   * Whether or not there are downloads that can be cleaned up (removed)
   * i.e. downloads that have completed, have failed or have been canceled. 
   */
  /* readonly attribute boolean canCleanUp; */
  NS_IMETHOD GetCanCleanUp(PRBool *aCanCleanUp) = 0;

  /** 
   * Removes completed, failed, and canceled downloads from the list. 
   */
  /* void cleanUp (); */
  NS_IMETHOD CleanUp(void) = 0;

  /** 
   * The number of files currently being downloaded.
   */
  /* readonly attribute long activeDownloadCount; */
  NS_IMETHOD GetActiveDownloadCount(PRInt32 *aActiveDownloadCount) = 0;

  /**
   * An enumeration of active downloads.
   */
  /* readonly attribute nsISupportsArray activeDownloads; */
  NS_IMETHOD GetActiveDownloads(nsISupportsArray * *aActiveDownloads) = 0;

  /** 
   * Update the download datasource. 
   */
  /* void saveState (); */
  NS_IMETHOD SaveState(void) = 0;

  /** 
   * Flush the download datasource to disk.
   */
  /* void flush (); */
  NS_IMETHOD Flush(void) = 0;

  /* readonly attribute nsIRDFDataSource datasource; */
  NS_IMETHOD GetDatasource(nsIRDFDataSource * *aDatasource) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIDOWNLOADMANAGER \
  NS_IMETHOD AddDownload(PRInt16 aDownloadType, nsIURI *aSource, nsIURI *aTarget, const PRUnichar *aDisplayName, const PRUnichar *aIconURL, nsIMIMEInfo *aMIMEInfo, PRInt64 aStartTime, nsIWebBrowserPersist *aPersist, nsIDownload **_retval); \
  NS_IMETHOD GetDownload(const PRUnichar *aPersistentDescriptor, nsIDownload **_retval); \
  NS_IMETHOD CancelDownload(const PRUnichar *aPersistentDescriptor); \
  NS_IMETHOD RemoveDownload(const PRUnichar *aPersistentDescriptor); \
  NS_IMETHOD PauseDownload(const PRUnichar *aPersistentDescriptor); \
  NS_IMETHOD ResumeDownload(const PRUnichar *aPersistentDescriptor); \
  NS_IMETHOD Open(nsIDOMWindow *aParent, const PRUnichar *aPersistentDescriptor); \
  NS_IMETHOD GetListener(nsIDownloadProgressListener * *aListener); \
  NS_IMETHOD SetListener(nsIDownloadProgressListener * aListener); \
  NS_IMETHOD StartBatchUpdate(void); \
  NS_IMETHOD EndBatchUpdate(void); \
  NS_IMETHOD GetCanCleanUp(PRBool *aCanCleanUp); \
  NS_IMETHOD CleanUp(void); \
  NS_IMETHOD GetActiveDownloadCount(PRInt32 *aActiveDownloadCount); \
  NS_IMETHOD GetActiveDownloads(nsISupportsArray * *aActiveDownloads); \
  NS_IMETHOD SaveState(void); \
  NS_IMETHOD Flush(void); \
  NS_IMETHOD GetDatasource(nsIRDFDataSource * *aDatasource); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIDOWNLOADMANAGER(_to) \
  NS_IMETHOD AddDownload(PRInt16 aDownloadType, nsIURI *aSource, nsIURI *aTarget, const PRUnichar *aDisplayName, const PRUnichar *aIconURL, nsIMIMEInfo *aMIMEInfo, PRInt64 aStartTime, nsIWebBrowserPersist *aPersist, nsIDownload **_retval) { return _to AddDownload(aDownloadType, aSource, aTarget, aDisplayName, aIconURL, aMIMEInfo, aStartTime, aPersist, _retval); } \
  NS_IMETHOD GetDownload(const PRUnichar *aPersistentDescriptor, nsIDownload **_retval) { return _to GetDownload(aPersistentDescriptor, _retval); } \
  NS_IMETHOD CancelDownload(const PRUnichar *aPersistentDescriptor) { return _to CancelDownload(aPersistentDescriptor); } \
  NS_IMETHOD RemoveDownload(const PRUnichar *aPersistentDescriptor) { return _to RemoveDownload(aPersistentDescriptor); } \
  NS_IMETHOD PauseDownload(const PRUnichar *aPersistentDescriptor) { return _to PauseDownload(aPersistentDescriptor); } \
  NS_IMETHOD ResumeDownload(const PRUnichar *aPersistentDescriptor) { return _to ResumeDownload(aPersistentDescriptor); } \
  NS_IMETHOD Open(nsIDOMWindow *aParent, const PRUnichar *aPersistentDescriptor) { return _to Open(aParent, aPersistentDescriptor); } \
  NS_IMETHOD GetListener(nsIDownloadProgressListener * *aListener) { return _to GetListener(aListener); } \
  NS_IMETHOD SetListener(nsIDownloadProgressListener * aListener) { return _to SetListener(aListener); } \
  NS_IMETHOD StartBatchUpdate(void) { return _to StartBatchUpdate(); } \
  NS_IMETHOD EndBatchUpdate(void) { return _to EndBatchUpdate(); } \
  NS_IMETHOD GetCanCleanUp(PRBool *aCanCleanUp) { return _to GetCanCleanUp(aCanCleanUp); } \
  NS_IMETHOD CleanUp(void) { return _to CleanUp(); } \
  NS_IMETHOD GetActiveDownloadCount(PRInt32 *aActiveDownloadCount) { return _to GetActiveDownloadCount(aActiveDownloadCount); } \
  NS_IMETHOD GetActiveDownloads(nsISupportsArray * *aActiveDownloads) { return _to GetActiveDownloads(aActiveDownloads); } \
  NS_IMETHOD SaveState(void) { return _to SaveState(); } \
  NS_IMETHOD Flush(void) { return _to Flush(); } \
  NS_IMETHOD GetDatasource(nsIRDFDataSource * *aDatasource) { return _to GetDatasource(aDatasource); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIDOWNLOADMANAGER(_to) \
  NS_IMETHOD AddDownload(PRInt16 aDownloadType, nsIURI *aSource, nsIURI *aTarget, const PRUnichar *aDisplayName, const PRUnichar *aIconURL, nsIMIMEInfo *aMIMEInfo, PRInt64 aStartTime, nsIWebBrowserPersist *aPersist, nsIDownload **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddDownload(aDownloadType, aSource, aTarget, aDisplayName, aIconURL, aMIMEInfo, aStartTime, aPersist, _retval); } \
  NS_IMETHOD GetDownload(const PRUnichar *aPersistentDescriptor, nsIDownload **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDownload(aPersistentDescriptor, _retval); } \
  NS_IMETHOD CancelDownload(const PRUnichar *aPersistentDescriptor) { return !_to ? NS_ERROR_NULL_POINTER : _to->CancelDownload(aPersistentDescriptor); } \
  NS_IMETHOD RemoveDownload(const PRUnichar *aPersistentDescriptor) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveDownload(aPersistentDescriptor); } \
  NS_IMETHOD PauseDownload(const PRUnichar *aPersistentDescriptor) { return !_to ? NS_ERROR_NULL_POINTER : _to->PauseDownload(aPersistentDescriptor); } \
  NS_IMETHOD ResumeDownload(const PRUnichar *aPersistentDescriptor) { return !_to ? NS_ERROR_NULL_POINTER : _to->ResumeDownload(aPersistentDescriptor); } \
  NS_IMETHOD Open(nsIDOMWindow *aParent, const PRUnichar *aPersistentDescriptor) { return !_to ? NS_ERROR_NULL_POINTER : _to->Open(aParent, aPersistentDescriptor); } \
  NS_IMETHOD GetListener(nsIDownloadProgressListener * *aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetListener(aListener); } \
  NS_IMETHOD SetListener(nsIDownloadProgressListener * aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetListener(aListener); } \
  NS_IMETHOD StartBatchUpdate(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->StartBatchUpdate(); } \
  NS_IMETHOD EndBatchUpdate(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->EndBatchUpdate(); } \
  NS_IMETHOD GetCanCleanUp(PRBool *aCanCleanUp) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanCleanUp(aCanCleanUp); } \
  NS_IMETHOD CleanUp(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->CleanUp(); } \
  NS_IMETHOD GetActiveDownloadCount(PRInt32 *aActiveDownloadCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetActiveDownloadCount(aActiveDownloadCount); } \
  NS_IMETHOD GetActiveDownloads(nsISupportsArray * *aActiveDownloads) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetActiveDownloads(aActiveDownloads); } \
  NS_IMETHOD SaveState(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->SaveState(); } \
  NS_IMETHOD Flush(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Flush(); } \
  NS_IMETHOD GetDatasource(nsIRDFDataSource * *aDatasource) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDatasource(aDatasource); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsDownloadManager : public nsIDownloadManager
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIDOWNLOADMANAGER

  nsDownloadManager();

private:
  ~nsDownloadManager();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsDownloadManager, nsIDownloadManager)

nsDownloadManager::nsDownloadManager()
{
  /* member initializers and constructor code */
}

nsDownloadManager::~nsDownloadManager()
{
  /* destructor code */
}

/* nsIDownload addDownload (in short aDownloadType, in nsIURI aSource, in nsIURI aTarget, in wstring aDisplayName, in wstring aIconURL, in nsIMIMEInfo aMIMEInfo, in long long aStartTime, in nsIWebBrowserPersist aPersist); */
NS_IMETHODIMP nsDownloadManager::AddDownload(PRInt16 aDownloadType, nsIURI *aSource, nsIURI *aTarget, const PRUnichar *aDisplayName, const PRUnichar *aIconURL, nsIMIMEInfo *aMIMEInfo, PRInt64 aStartTime, nsIWebBrowserPersist *aPersist, nsIDownload **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDownload getDownload (in wstring aPersistentDescriptor); */
NS_IMETHODIMP nsDownloadManager::GetDownload(const PRUnichar *aPersistentDescriptor, nsIDownload **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void cancelDownload (in wstring aPersistentDescriptor); */
NS_IMETHODIMP nsDownloadManager::CancelDownload(const PRUnichar *aPersistentDescriptor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeDownload (in wstring aPersistentDescriptor); */
NS_IMETHODIMP nsDownloadManager::RemoveDownload(const PRUnichar *aPersistentDescriptor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void pauseDownload (in wstring aPersistentDescriptor); */
NS_IMETHODIMP nsDownloadManager::PauseDownload(const PRUnichar *aPersistentDescriptor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void resumeDownload (in wstring aPersistentDescriptor); */
NS_IMETHODIMP nsDownloadManager::ResumeDownload(const PRUnichar *aPersistentDescriptor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void open (in nsIDOMWindow aParent, in wstring aPersistentDescriptor); */
NS_IMETHODIMP nsDownloadManager::Open(nsIDOMWindow *aParent, const PRUnichar *aPersistentDescriptor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIDownloadProgressListener listener; */
NS_IMETHODIMP nsDownloadManager::GetListener(nsIDownloadProgressListener * *aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsDownloadManager::SetListener(nsIDownloadProgressListener * aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void startBatchUpdate (); */
NS_IMETHODIMP nsDownloadManager::StartBatchUpdate()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void endBatchUpdate (); */
NS_IMETHODIMP nsDownloadManager::EndBatchUpdate()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canCleanUp; */
NS_IMETHODIMP nsDownloadManager::GetCanCleanUp(PRBool *aCanCleanUp)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void cleanUp (); */
NS_IMETHODIMP nsDownloadManager::CleanUp()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long activeDownloadCount; */
NS_IMETHODIMP nsDownloadManager::GetActiveDownloadCount(PRInt32 *aActiveDownloadCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISupportsArray activeDownloads; */
NS_IMETHODIMP nsDownloadManager::GetActiveDownloads(nsISupportsArray * *aActiveDownloads)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void saveState (); */
NS_IMETHODIMP nsDownloadManager::SaveState()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void flush (); */
NS_IMETHODIMP nsDownloadManager::Flush()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIRDFDataSource datasource; */
NS_IMETHODIMP nsDownloadManager::GetDatasource(nsIRDFDataSource * *aDatasource)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIDownloadManager_h__ */
