# cpufreq tools
#  Copyright (C) 2005 Yuuki Harano
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: cpufreq-tools.m4 329 2005-07-10 16:54:16Z masm $

AC_DEFUN([CPUFREQ_TOOLS_CHECK],[
AC_CHECK_HEADERS([stdint.h])

AC_PATH_PROG([CPUFREQ_TOOLS_CONFIG], [cpufreq-tools-config], [no])
if test "x$CPUFREQ_TOOLS_CONFIG" = "xno"; then
  AC_MSG_ERROR([cpufreq-tools-config not found.])
fi

AC_MSG_CHECKING([for cpufreq-tools cflags])
CPUFREQ_CFLAGS="`$CPUFREQ_TOOLS_CONFIG --cflags`"
AC_MSG_RESULT($CPUFREQ_CFLAGS)
AC_SUBST(CPUFREQ_CFLAGS)

AC_MSG_CHECKING([for cpufreq-tools libs])
CPUFREQ_LIBS="`$CPUFREQ_TOOLS_CONFIG --libs`"
AC_MSG_RESULT($CPUFREQ_LIBS)
AC_SUBST(CPUFREQ_LIBS)
])
