# icon.tcl --
#
# This demonstration script creates a toplevel window containing
# buttons that display bitmaps instead of text.
#
# RCS: @(#) $Id: icon.tcl,v 1.1 1999/03/31 15:08:32 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .icon
catch {destroy $w}
toplevel $w
wm title $w "Iconic Button Demonstration"
wm iconname $w "icon"
positionWindow $w

label $w.msg -font $font -wraplength 5i -justify left -text [langSel \
"This window shows three ways of using bitmaps or images in radiobuttons and checkbuttons.  On the left are two radiobuttons, each of which displays a bitmap and an indicator.  In the middle is a checkbutton that displays a different image depending on whether it is selected or not.  On the right is a checkbutton that displays a single bitmap but changes its background color to indicate whether or not it is selected." \
"$B$3$N%&%#%s%I%&$K$O%i%8%*%\%?%s$H%A%'%C%/%\%?%s>e$K%S%C%H%^%C%W$d2hA|$rI=<($9$k(B 3 $B$D$NJ}K!$r<($7$F$$$^$9!#:8$K$"$k$N$O(B2$B$D$N%i%8%*%\%?%s$G!"$=$l$>$l$,!"%S%C%H%^%C%W$HA*Br$r<($9%$%s%8%1!<%?$G$G$-$F$$$^$9!#Cf1{$K$"$k$N$O!"A*Br:Q$_$+$I$&$+$K$h$C$F0[$J$k2hA|$rI=<($9$k%A%'%C%/%\%?%s$G$9!#1&B&$K$"$k$N$OA*Br:Q$_$+$I$&$+$K$h$C$FGX7J?'$,JQ$o$k%S%C%H%^%C%W$rI=<($9$k%A%'%C%/%\%?%s$G$9!#(B"]
pack $w.msg -side top

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

image create bitmap flagup \
	-file [file join $tk_library demos.jp images flagup.bmp] \
	-maskfile [file join $tk_library demos.jp images flagup.bmp]
image create bitmap flagdown \
	-file [file join $tk_library demos.jp images flagdown.bmp] \
	-maskfile [file join $tk_library demos.jp images flagdown.bmp]
frame $w.frame -borderwidth 10
pack $w.frame -side top

checkbutton $w.frame.b1 -image flagdown -selectimage flagup \
	-indicatoron 0
$w.frame.b1 configure -selectcolor [$w.frame.b1 cget -background]
checkbutton $w.frame.b2 \
	-bitmap @[file join $tk_library demos.jp images letters.bmp] \
	-indicatoron 0 -selectcolor SeaGreen1
frame $w.frame.left
pack $w.frame.left $w.frame.b1 $w.frame.b2 -side left -expand yes -padx 5m

radiobutton $w.frame.left.b3 \
	-bitmap @[file join $tk_library demos.jp images letters.bmp] \
	-variable letters -value full
radiobutton $w.frame.left.b4 \
	-bitmap @[file join $tk_library demos.jp images noletter.bmp] \
	-variable letters -value empty
pack $w.frame.left.b3 $w.frame.left.b4 -side top -expand yes
