# cfont.tcl --
#
# This demonstration script shows how to use compound founts.
#

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .cfont
catch {destroy $w}
toplevel $w
wm title $w "Compound Font Demonstration"
wm iconname $w "cfont"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left -text [langSel \
"Choose the family, styles and size of both ASCII and KANJI fonts.  Then press the \"Show Sample\" button to see a sample label of the compound font." \
"ASCII $B%U%)%s%H$H4A;z%U%)%s%H$=$l$>$l$N%U%!%_%j!"%9%?%$%k!"Bg$-$5$rA*$s$G!V8+K\$rI=<(!W%\%?%s$r2!$7$F$/$@$5$$!#;XDj$7$?%3%s%Q%&%s%I%U%)%s%H$N8+K\%i%Y%k$,I=<($5$l$^$9!#(B"]
pack $w.msg -side top

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
button $w.buttons.sample -text [langSel "Show Sample" "$B8+K\$rI=<((B"] \
	-command "$B8+K\I=<((B $w $w.dialog"
pack $w.buttons.dismiss $w.buttons.code $w.buttons.sample -side left -expand 1

# set default settings
if {$tcl_platform(platform) == "windows"} {
    set $B%U%!%_%j(B(ascii) {Courier}
    set $B%U%!%_%j(B($B4A;z(B) {$B#M#S(B $B#P%4%7%C%/(B}
    # In Windows, charset are ignored
    set $BJ8;z%;%C%H(B(ascii) {deault}
    set $BJ8;z%;%C%H(B($B4A;z(B) {shiftjis}
} else {
    set $B%U%!%_%j(B(ascii) fixed
    set $B%U%!%_%j(B($B4A;z(B) fixed
    set $BJ8;z%;%C%H(B(ascii) iso8859
    set $BJ8;z%;%C%H(B($B4A;z(B) jisx0208.1983
}
foreach type {ascii $B4A;z(B} {
    set $BBg$-$5(B($type) 14
    set $BB@$5(B($type) normal
    set $B79$-(B($type) roman
}

foreach type {ascii $B4A;z(B} {
    frame $w.$type
    pack $w.$type -side top -expand yes -padx 10 -pady 10 -fill both

    label $w.$type.label -font {Helvetica14} \
	    -text "[kstring toupper $type]:" -width 8
    pack $w.$type.label -side left

    frame $w.$type.family
    label $w.$type.family.label -text [langSel "Family:" "$B%U%!%_%j(B:"]
    pack $w.$type.family.label -side top -anchor w
    scrollbar $w.$type.family.scroll -command "$w.$type.family.list yview"
    listbox $w.$type.family.list -yscroll "$w.$type.family.scroll set" \
	    -height 8 -setgrid 1 -exportselection false
    pack $w.$type.family.list $w.$type.family.scroll -side left -fill y \
	    -expand yes
    eval $w.$type.family.list insert 0 [font families]
    set index [lsearch -exact [font families] $$B%U%!%_%j(B($type)]
    $w.$type.family.list activate $index
    $w.$type.family.list see $index
    $w.$type.family.list selection set $index

    frame $w.$type.style
    foreach {label var values} [list \
	    [langSel "Weight" "$BB@$5(B"] $BB@$5(B {normal bold} \
	    [langSel "Slant" "$B79$-(B"] $B79$-(B {roman italic}] {
	label $w.$type.style.$var -text "$label:"
	pack $w.$type.style.$var -side top -anchor w
	foreach value $values {
	    radiobutton $w.$type.style.$var$value -text $value \
		    -variable ${var}($type) -value $value
	    pack $w.$type.style.$var$value -side top -anchor w
	}
    }

    frame $w.$type.size
    label $w.$type.size.label -text [langSel "Size:" "$BBg$-$5(B:"]
    pack $w.$type.size.label -side top -anchor w
    scale $w.$type.size.scale -orient vertical -from 8 -to 32 \
	    -variable $BBg$-$5(B($type)
    pack $w.$type.size.scale -side left -fill y

    pack $w.$type.family $w.$type.style $w.$type.size -side left \
	    -fill y -padx 15
}

proc $B8+K\I=<((B {w dialog} {
    global $B%U%!%_%j(B $BBg$-$5(B $BB@$5(B $B79$-(B $BJ8;z%;%C%H(B

    if {![winfo exists $dialog]} {
	set sample "The quick brown fox jumps over the lazy dog.\n$BAGAa$$Cc?'$N%-%D%M$,$&$9$N$m%$%L$N>e$rHt$S1[$($?!#(B\nThis is just a $B%5%s%W%k(B Text."
	toplevel $dialog
	wm title $dialog "Compound Sample"
	label $dialog.sample -relief sunken -text $sample
	pack $dialog.sample -side top -padx 5 -pady 5
	button $dialog.ok -text OK -command "destroy $dialog" -default active
	bind $dialog <Return> "tkButtonInvoke $dialog.ok"
	pack $dialog.ok -side bottom -pady 2
    }

    # set back to default font
    $dialog.sample configure -font [lindex [$dialog.sample config -font] 3]

    catch {font delete $B%3%s%Q%&%s%I%U%)%s%H(B}
    catch {font delete ascii$B%U%)%s%H(B}
    catch {font delete $B4A;z%U%)%s%H(B}

    # create descendant fonts
    foreach type {ascii $B4A;z(B} {
	set $B%U%!%_%j(B($type) [$w.$type.family.list get [$w.$type.family.list curselection]]
	font create ${type}$B%U%)%s%H(B \
		-family $$B%U%!%_%j(B($type) -size $$BBg$-$5(B($type) \
		-weight $$BB@$5(B($type) -slant $$B79$-(B($type) \
		-charset $$BJ8;z%;%C%H(B($type)
    }
    # create compound font
    font create $B%3%s%Q%&%s%I%U%)%s%H(B -compound {ascii$B%U%)%s%H(B $B4A;z%U%)%s%H(B}

    $dialog.sample configure -font $B%3%s%Q%&%s%I%U%)%s%H(B
}
