#ifndef _LINUX_TTY_FLIP_H
#define _LINUX_TTY_FLIP_H

#ifdef INCLUDE_INLINE_FUNCS
#define _INLINE_ extern
#else
#define _INLINE_ static __inline__
#endif

#ifdef CONFIG_UNICON
extern int (*Unicon_fnKeyHook) (struct tty_struct *tty,
                                unsigned char ch, char flag);
#endif

_INLINE_ void tty_insert_flip_char(struct tty_struct *tty,
				   unsigned char ch, char flag)
{
#ifdef CONFIG_UNICON
       if (Unicon_fnKeyHook != NULL)
       {
            /* return 1 ==> processed by kernel
               return 0 ==> processed by app */
            if ((*Unicon_fnKeyHook) (tty, ch, flag) == 1)
               return;
        }
#endif
			
	if (tty->flip.count < TTY_FLIPBUF_SIZE) {
		tty->flip.count++;
		*tty->flip.flag_buf_ptr++ = flag;
		*tty->flip.char_buf_ptr++ = ch;
	}
}

_INLINE_ void tty_schedule_flip(struct tty_struct *tty)
{
	queue_task(&tty->flip.tqueue, &tq_timer);
}

#undef _INLINE_


#endif /* _LINUX_TTY_FLIP_H */







