/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_VIEW_BASE_H_
#define _COASTER_VIEW_BASE_H_

#include <gtkmm/box.h>

#include "cstr-enums.h"
#include "sharedptr.h"

namespace Gtk
{
class Menu;
class Action;
class ActionGroup;
} // namespace Gtk

namespace Coaster
{

class UndoManager;

namespace Widgets
{

class Layout_Base;
class DiscInfo_Base;

class View_Base : public Gtk::VBox
{
public:
  View_Base();
  virtual ~View_Base();

  typedef View_Base type_base;;
  typedef sigc::signal<void,bool> type_signal_modified;
  typedef sigc::signal<void,bool> type_signal_sensitive;

  virtual void init();

  virtual void create_store();
  virtual void create_layout();
  virtual void create_disc_info();

  virtual Glib::ustring get_document_title() const;

  // Member Methods
  virtual Glib::ustring get_ui_location() const;
  virtual Glib::RefPtr<Gtk::ActionGroup> get_ui_action_group() const;
  
  virtual void set_popup_menu(Gtk::Menu* popup_menu);
  virtual void popup(guint button,
                     guint32 activate_time);

  virtual void set_modified(bool modified = true);
  virtual bool get_modified() const;

  virtual LayoutType get_layout_type() const;
  
  virtual Glib::ustring get_contents() const = 0;
  virtual bool load_contents(const Glib::ustring& contents) = 0;
  virtual void prepare_for_revert() = 0;

  inline Gtk::Window& get_win()
  {
    return reinterpret_cast<Gtk::Window&>(*get_toplevel());
  }

  // Signal accessors
  type_signal_modified& signal_modified();
  type_signal_sensitive& signal_sensitive();

protected:
  virtual void on_edit_undo();
  virtual void on_edit_redo();

  // Override these:
  virtual void on_disc_burn() = 0;
  virtual bool set_properties() = 0;

  virtual void on_layout_properties();
  virtual void on_store_modified(bool modified);
  virtual void on_layout_selection_changed(int number_selected);

  virtual void on_undo_manager_changed();

  virtual void enable_selection_actions(bool enable = true) = 0;
  virtual void enable_layout_item_actions(bool enable = true);

  SharedPtr<UndoManager> undo_manager;
  
  // Widgets
  Gtk::Menu* m_pMenu_Popup;
  Widgets::Layout_Base* m_pLayout;
  Widgets::DiscInfo_Base* m_pDiscInfo;

  // Action group
  Glib::RefPtr<Gtk::ActionGroup> m_refViewActionGroup;

  bool m_bModified;
  Glib::ustring m_strDocTitle;

  // Undo Actions
  Glib::RefPtr<Gtk::Action> m_refUndo;
  Glib::RefPtr<Gtk::Action> m_refRedo;

  // Disc Actions
  Glib::RefPtr<Gtk::Action> m_refBurn;

  // Signals
  type_signal_modified m_signal_modified;
  type_signal_sensitive m_signal_sensitive;
};

} // namespace Widgets

} // namespace Coaster

#endif // _COASTER_VIEW_BASE_H_
