/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_TREE_COLUMN_NAME_H_
#define _COASTER_TREE_COLUMN_NAME_H_

#include <gtkmm/treeviewcolumn.h>

namespace Gtk
{
class CellRendererPixbuf;
class CellRendererText;
} // namespace Gtk

namespace Coaster
{

namespace Widgets
{

class TreeColumnName : public Gtk::TreeViewColumn
{
public:
  TreeColumnName();
  virtual ~TreeColumnName();

  Glib::PropertyProxy<bool> property_editable();
  Glib::SignalProxy2<void,const Glib::ustring&,const Glib::ustring&> signal_edited();
  Glib::SignalProxy0<void> signal_editing_canceled();

  void add_attribute(const Gtk::TreeModelColumn<Glib::ustring>& name_col);
  void add_attribute(const Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> >& pixbuf_col);

protected:
private:
  Gtk::CellRendererPixbuf* m_pCellPixbuf;
  Gtk::CellRendererText*   m_pCellText;
};

} // namespace Widgets

} // namespace Coaster

#endif // _COASTER_TREE_COLUMN_NAME_H_
