/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "widgets/treecolumn-name.h"

#include "cstr-intl.h"

#include <gtkmm/cellrendererpixbuf.h>
#include <gtkmm/cellrenderertext.h>

namespace Coaster
{

namespace Widgets
{

TreeColumnName::TreeColumnName()
: TreeViewColumn(_("Name")),
  m_pCellPixbuf(0), m_pCellText(0)
{
  using namespace Gtk;

  set_spacing(2);
  set_resizable(true);

  m_pCellPixbuf = new CellRendererPixbuf();
  m_pCellText   = new CellRendererText();

  m_pCellText->property_editable() = false;

  pack_start(*manage(m_pCellPixbuf));
  pack_start(*manage(m_pCellText));
}

TreeColumnName::~TreeColumnName()
{}

Glib::PropertyProxy<bool> TreeColumnName::property_editable()
{
  return m_pCellText->property_editable();
}

Glib::SignalProxy2<void,const Glib::ustring&,const Glib::ustring&> TreeColumnName::signal_edited()
{
  return m_pCellText->signal_edited();
}

Glib::SignalProxy0<void> TreeColumnName::signal_editing_canceled()
{
  return m_pCellText->signal_editing_canceled();
}

void TreeColumnName::add_attribute(const Gtk::TreeModelColumn<Glib::ustring>& name_col)
{
  TreeViewColumn::add_attribute(m_pCellText->property_text(), name_col);
}

void TreeColumnName::add_attribute(const Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> >& pixbuf_col)
{
  TreeViewColumn::add_attribute(m_pCellPixbuf->property_pixbuf(), pixbuf_col);
}

} // namespace Widgets

} // namespace Coaster
