/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_TRAY_ICON_H_
#define _COASTER_TRAY_ICON_H_

#include <gtkmm/plug.h>
#include <gtkmm/tooltips.h>

#include <gdk/gdkx.h>

typedef Window C_X_Window;

namespace Gdk
{
class Pixbuf;
} // namespace Gdk

namespace Gtk
{
class EventBox;
class Image;
} // namespace Gtk

namespace Coaster
{

namespace Widgets
{

class TrayIcon : public Gtk::Plug
{
public:
  TrayIcon();
  virtual ~TrayIcon();

  typedef enum
  {
    REQUEST_DOCK = 0,
    BEGIN_MESSAGE = 1,
    CANCEL_MESSAGE = 2
  } SystemTrayMessage;

  typedef enum
  {
    ORIENTATION_HORZ = 0,
    ORIENTATION_VERT = 1
  } SystemTrayOrientation;

  void set(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf,
           const Glib::ustring& tip,
           const Glib::ustring& private_tip = Glib::ustring());
  void set(const Glib::ustring& tip,
           const Glib::ustring& private_tip = Glib::ustring());

  void unset();

  Atom get_manager_atom() const;
  Atom get_selection_atom() const;
  Atom get_orientation_atom() const;
  C_X_Window get_manager_window() const;

  void update_manager_window();
  void get_orientation_property();

protected:
  // overrides
  void on_realize();
  void on_unrealize();
  bool on_delete_event(GdkEventAny* event);

  // signal handlers
  bool on_eb_button_press_event(GdkEventButton* event);

  // utilities
  void send_dock_request();
  void send_manager_message(SystemTrayMessage message,
                            C_X_Window window,
                            long data1,
                            long data2,
                            long data3);
  int send_message(int timeout,
                   const Glib::ustring& message);
  void cancel_message(int id);

  //Gdk::FilterReturn manager_filter(GdkXEvent* xevent,
  //                                 GdkEvent* event);

private:
  unsigned int stamp;
  Gtk::Orientation orientation;

  Atom selection_atom;
  Atom manager_atom;
  Atom system_tray_opcode_atom;
  Atom orientation_atom;
  C_X_Window manager_window;
  Gtk::EventBox* m_pEventBox;
  Gtk::Image*    m_pImage;
  Gtk::Tooltips  m_Tooltips;
};

} // namespace Widgets

} // namespace Coaster

#endif // _COASTER_TRAY_ICON_H_
