/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_LAYOUT_BASE_H_
#define _COASTER_LAYOUT_BASE_H_

#include "cstr-types.h"

#include <gtkmm/treeview.h>
#include <gtkmm/notebook.h>

namespace Coaster
{

namespace Widgets
{

class Layout_Base : public Gtk::TreeView
{
public:
  Layout_Base();
  virtual ~Layout_Base();

  typedef sigc::signal<void,int> type_signal_selection_changed;
  typedef sigc::signal<void,bool> type_signal_modified;

  type_signal_selection_changed& signal_selection_changed();
  type_signal_modified& signal_modified();

  virtual int get_number_selected() const;
  virtual void select_all();
  virtual void unselect_all();
  virtual void select(const Gtk::TreeIter& iter);
  virtual void rename_selected(); // override this

  inline Gtk::Window& get_win()
  {
    return reinterpret_cast<Gtk::Window&>(*get_toplevel());
  }

protected:
  // member methods
  virtual void init();
  virtual void init_columns(); // override this
  virtual void init_drag_n_drop(); //override this

  virtual void on_tree_selection_changed();
  
  // member variables
  Glib::RefPtr<Gtk::TreeModel> m_refStore; // redefine this
  Glib::RefPtr<Gtk::TreeSelection> m_refSelection;

  // Signals
  type_signal_modified m_signal_modified;
  type_signal_selection_changed m_signal_selection_changed;
};

} // namespace Widgets
  
} // namespace Coaster

#endif // _COASTER_LAYOUT_BASE_H_
