/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "widgets/layout-base.h"

namespace Coaster
{

namespace Widgets
{

Layout_Base::Layout_Base()
{
  using namespace Gtk;

  m_refSelection = get_selection();
  m_refSelection->set_mode(SELECTION_MULTIPLE);

  set_reorderable();
  set_rules_hint();
  set_enable_search(false);
  set_headers_visible(true);
}

Layout_Base::~Layout_Base()
{}

Layout_Base::type_signal_selection_changed& Layout_Base::signal_selection_changed()
{
  return m_signal_selection_changed;
}

Layout_Base::type_signal_modified& Layout_Base::signal_modified()
{
  return m_signal_modified;
}

int Layout_Base::get_number_selected() const
{
  return m_refSelection->count_selected_rows();
}

void Layout_Base::select_all()
{
  m_refSelection->select_all();
}

void Layout_Base::unselect_all()
{
  m_refSelection->unselect_all();
}

void Layout_Base::select(const Gtk::TreeIter& iter)
{
  m_refSelection->select(iter);
}

void Layout_Base::rename_selected()
{}

void Layout_Base::init()
{
  init_columns();
  init_drag_n_drop();

  m_refSelection->signal_changed().connect(
         sigc::mem_fun(*this, &Layout_Base::on_tree_selection_changed));
}

void Layout_Base::init_columns()
{}

void Layout_Base::init_drag_n_drop()
{}

void Layout_Base::on_tree_selection_changed()
{
  m_signal_selection_changed.emit(m_refSelection->count_selected_rows());
}

} // namespace Widgets

} // namespace Coaster
