/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_DISC_PROGRESS_H_
#define _COASTER_DISC_PROGRESS_H_

#include <gtkmm/eventbox.h>

#include <gtkmm/tooltips.h>

namespace Gtk
{
class HBox;
class Image;
class ProgressBar;
} // namespace Gtk

namespace Coaster
{

namespace Widgets
{

class DiscProgress : public Gtk::EventBox
{
public:
  DiscProgress();
  virtual ~DiscProgress();

  void set_fraction(double fraction);
  void set_text(const Glib::ustring& text);

protected:
  void show_warning(bool show = true);

private:
  Gtk::HBox*        m_pHBox;
  Gtk::Image*       m_pWarning;
  Gtk::ProgressBar* m_pProgress;

  Gtk::Tooltips     m_Tooltips;

  bool m_bWarningShown;
};

} // namespace Widgets

} // namespace Coaster

#endif // _COASTER_DISC_PROGRESS_H_
